/*
 * Decompiled with CFR 0.152.
 */
package org.drools.time.impl;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Date;
import org.drools.WorkingMemory;
import org.drools.common.InternalWorkingMemory;
import org.drools.spi.Activation;
import org.drools.time.Trigger;
import org.drools.time.impl.IntervalTrigger;
import org.drools.time.impl.Timer;
import org.kie.runtime.Calendars;

public class IntervalTimer
implements Timer,
Externalizable {
    private Date startTime;
    private Date endTime;
    private int repeatLimit;
    private long delay;
    private long period;

    public IntervalTimer() {
    }

    public IntervalTimer(Date startTime, Date endTime, int repeatLimit, long delay, long period) {
        this.startTime = startTime;
        this.endTime = endTime;
        this.repeatLimit = repeatLimit;
        this.delay = delay;
        this.period = period;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.startTime);
        out.writeObject(this.endTime);
        out.writeInt(this.repeatLimit);
        out.writeLong(this.delay);
        out.writeLong(this.period);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.startTime = (Date)in.readObject();
        this.endTime = (Date)in.readObject();
        this.repeatLimit = in.readInt();
        this.delay = in.readLong();
        this.period = in.readLong();
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public long getDelay() {
        return this.delay;
    }

    public long getPeriod() {
        return this.period;
    }

    @Override
    public Trigger createTrigger(Activation item, WorkingMemory wm) {
        long timestamp = ((InternalWorkingMemory)wm).getTimerService().getCurrentTime();
        String[] calendarNames = item.getRule().getCalendars();
        Calendars calendars = ((InternalWorkingMemory)wm).getCalendars();
        return this.createTrigger(timestamp, calendarNames, calendars);
    }

    @Override
    public Trigger createTrigger(long timestamp, String[] calendarNames, Calendars calendars) {
        return new IntervalTrigger(timestamp, this.startTime, this.endTime, this.repeatLimit, this.delay, this.period, calendarNames, calendars);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.delay ^ this.delay >>> 32);
        result = 31 * result + (this.endTime == null ? 0 : this.endTime.hashCode());
        result = 31 * result + (int)(this.period ^ this.period >>> 32);
        result = 31 * result + this.repeatLimit;
        result = 31 * result + (this.startTime == null ? 0 : this.startTime.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IntervalTimer other = (IntervalTimer)obj;
        if (this.delay != other.delay) {
            return false;
        }
        if (this.repeatLimit != other.repeatLimit) {
            return false;
        }
        if (this.endTime == null ? other.endTime != null : !this.endTime.equals(other.endTime)) {
            return false;
        }
        if (this.period != other.period) {
            return false;
        }
        return !(this.startTime == null ? other.startTime != null : !this.startTime.equals(other.startTime));
    }
}

