/*
 * Decompiled with CFR 0.152.
 */
package org.drools.decisiontable;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import org.drools.compiler.DecisionTableProvider;
import org.drools.core.util.StringUtils;
import org.drools.decisiontable.InputType;
import org.drools.decisiontable.SpreadsheetCompiler;
import org.kie.builder.DecisionTableConfiguration;
import org.kie.builder.DecisionTableInputType;
import org.kie.builder.KnowledgeBuilderFactory;

public class DecisionTableProviderImpl
implements DecisionTableProvider {
    @Override
    public String loadFromInputStream(InputStream is, DecisionTableConfiguration configuration) {
        return this.compileStream(is, configuration);
    }

    private String compileStream(InputStream is, DecisionTableConfiguration configuration) {
        SpreadsheetCompiler compiler = new SpreadsheetCompiler();
        if (configuration == null) {
            configuration = KnowledgeBuilderFactory.newDecisionTableConfiguration();
            configuration.setInputType(DecisionTableInputType.XLS);
        }
        switch (configuration.getInputType()) {
            case XLS: {
                if (StringUtils.isEmpty(configuration.getWorksheetName())) {
                    return compiler.compile(is, InputType.XLS);
                }
                return compiler.compile(is, configuration.getWorksheetName());
            }
            case CSV: {
                return compiler.compile(is, InputType.CSV);
            }
        }
        return null;
    }

    public static class ReaderInputStream
    extends InputStream {
        private Reader in;
        private String encoding = System.getProperty("file.encoding");
        private byte[] slack;
        private int begin;

        public ReaderInputStream(Reader reader) {
            this.in = reader;
        }

        public ReaderInputStream(Reader reader, String encoding) {
            this(reader);
            if (encoding == null) {
                throw new IllegalArgumentException("encoding must not be null");
            }
            this.encoding = encoding;
        }

        @Override
        public synchronized int read() throws IOException {
            int result;
            if (this.in == null) {
                throw new IOException("Stream Closed");
            }
            if (this.slack != null && this.begin < this.slack.length) {
                result = this.slack[this.begin];
                if (++this.begin == this.slack.length) {
                    this.slack = null;
                }
            } else {
                byte[] buf = new byte[1];
                if (this.read(buf, 0, 1) <= 0) {
                    result = -1;
                }
                result = buf[0];
            }
            if (result < -1) {
                result = (byte)(result + 256);
            }
            return result;
        }

        @Override
        public synchronized int read(byte[] b, int off, int len) throws IOException {
            if (this.in == null) {
                throw new IOException("Stream Closed");
            }
            while (this.slack == null) {
                char[] buf = new char[len];
                int n = this.in.read(buf);
                if (n == -1) {
                    return -1;
                }
                if (n <= 0) continue;
                this.slack = new String(buf, 0, n).getBytes(this.encoding);
                this.begin = 0;
            }
            if (len > this.slack.length - this.begin) {
                len = this.slack.length - this.begin;
            }
            System.arraycopy(this.slack, this.begin, b, off, len);
            if ((this.begin += len) >= this.slack.length) {
                this.slack = null;
            }
            return len;
        }

        @Override
        public synchronized void mark(int limit) {
            try {
                this.in.mark(limit);
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe.getMessage());
            }
        }

        @Override
        public synchronized int available() throws IOException {
            if (this.in == null) {
                throw new IOException("Stream Closed");
            }
            if (this.slack != null) {
                return this.slack.length - this.begin;
            }
            if (this.in.ready()) {
                return 1;
            }
            return 0;
        }

        @Override
        public boolean markSupported() {
            return false;
        }

        @Override
        public synchronized void reset() throws IOException {
            if (this.in == null) {
                throw new IOException("Stream Closed");
            }
            this.slack = null;
            this.in.reset();
        }

        @Override
        public synchronized void close() throws IOException {
            if (this.in != null) {
                this.in.close();
                this.slack = null;
                this.in = null;
            }
        }
    }
}

