/*
 * Decompiled with CFR 0.152.
 */
package org.drools.cdi;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.Dependent;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.Default;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.ProcessInjectionTarget;
import javax.enterprise.util.AnnotationLiteral;
import javax.inject.Named;
import org.drools.core.util.StringUtils;
import org.drools.kproject.models.KieSessionModelImpl;
import org.kie.KieBase;
import org.kie.KieServices;
import org.kie.builder.ReleaseId;
import org.kie.builder.impl.InternalKieModule;
import org.kie.builder.impl.KieContainerImpl;
import org.kie.builder.impl.KieProject;
import org.kie.builder.model.KieBaseModel;
import org.kie.builder.model.KieSessionModel;
import org.kie.cdi.KBase;
import org.kie.cdi.KReleaseId;
import org.kie.cdi.KSession;
import org.kie.runtime.KieContainer;
import org.kie.runtime.KieSession;
import org.kie.runtime.StatefulKnowledgeSession;
import org.kie.runtime.StatelessKieSession;
import org.kie.runtime.StatelessKnowledgeSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KieCDIExtension
implements Extension {
    private static final Logger log = LoggerFactory.getLogger(KieCDIExtension.class);
    private Map<KieCDIEntry, KieCDIEntry> kContainerNames;
    private Map<KieCDIEntry, KieCDIEntry> kBaseNames;
    private Map<KieCDIEntry, KieCDIEntry> kSessionNames;
    private Map<ReleaseId, KieContainer> gavs;
    private Map<String, KieCDIEntry> named;
    private KieContainerImpl classpathKContainer;
    private static final AnnotationLiteral<Default> defaultAnnLit = new AnnotationLiteral<Default>(){};
    private static final AnnotationLiteral<Any> anyAnnLit = new AnnotationLiteral<Any>(){};

    public void init() {
        KieServices ks = KieServices.Factory.get();
        this.gavs = new HashMap<ReleaseId, KieContainer>();
        this.classpathKContainer = (KieContainerImpl)ks.getKieClasspathContainer();
        this.named = new HashMap<String, KieCDIEntry>();
    }

    public <Object> void processInjectionTarget(@Observes ProcessInjectionTarget<Object> pit, BeanManager beanManager) {
        if (this.classpathKContainer == null) {
            this.init();
        }
        KieServices ks = KieServices.Factory.get();
        if (!pit.getInjectionTarget().getInjectionPoints().isEmpty()) {
            for (InjectionPoint ip : pit.getInjectionTarget().getInjectionPoints()) {
                boolean kBaseExists = false;
                boolean kSessionExists = false;
                boolean kContainerExists = false;
                KBase kBase = null;
                KSession kSession = null;
                if (ip.getType() instanceof Class && (KieSession.class.isAssignableFrom((Class)ip.getType()) || StatelessKieSession.class.isAssignableFrom((Class)ip.getType()))) {
                    kSession = (KSession)ip.getAnnotated().getAnnotation(KSession.class);
                    kSessionExists = true;
                } else if (ip.getType() instanceof Class && KieBase.class.isAssignableFrom((Class)ip.getType())) {
                    kBaseExists = true;
                    kBase = (KBase)ip.getAnnotated().getAnnotation(KBase.class);
                } else if (ip.getType() instanceof Class && KieContainer.class.isAssignableFrom((Class)ip.getType())) {
                    kContainerExists = true;
                }
                if (!kSessionExists && !kBaseExists && !kContainerExists) continue;
                KReleaseId kReleaseId = (KReleaseId)ip.getAnnotated().getAnnotation(KReleaseId.class);
                ReleaseId releaseId = null;
                if (kReleaseId != null) {
                    releaseId = ks.newReleaseId(kReleaseId.groupId(), kReleaseId.artifactId(), kReleaseId.version());
                    this.gavs.put(releaseId, null);
                }
                Class<ApplicationScoped> scope = ApplicationScoped.class;
                if (kBaseExists) {
                    this.addKBaseInjectionPoint(ip, kBase, scope, releaseId, kReleaseId);
                    continue;
                }
                if (kSessionExists) {
                    this.addKSessionInjectionPoint(ip, kSession, scope, releaseId, kReleaseId);
                    continue;
                }
                if (!kContainerExists) continue;
                this.addKContainerInjectionPoint(ip, null, scope, releaseId, kReleaseId);
            }
        }
    }

    public void addKBaseInjectionPoint(InjectionPoint ip, KBase kBase, Class<? extends Annotation> scope, ReleaseId releaseId, KReleaseId kReleaseId) {
        String namedStr;
        KieCDIEntry newEntry;
        KieCDIEntry existingEntry;
        if (this.kBaseNames == null) {
            this.kBaseNames = new HashMap<KieCDIEntry, KieCDIEntry>();
        }
        if ((existingEntry = this.kBaseNames.remove(newEntry = new KieCDIEntry(kBase == null ? null : kBase.value(), KieBase.class, scope, releaseId, kReleaseId, namedStr = kBase == null ? null : kBase.name()))) != null) {
            existingEntry.addInjectionPoint(ip);
            this.kBaseNames.put(existingEntry, existingEntry);
        }
        if (!StringUtils.isEmpty(namedStr)) {
            existingEntry = this.named.get(namedStr);
            if (existingEntry == null) {
                this.named.put(namedStr, newEntry);
                this.kBaseNames.put(newEntry, newEntry);
            } else {
                log.error("name={} declaration used ambiguiously existing: {} new: {}", (Object[])new String[]{namedStr, existingEntry.toString(), newEntry.toString()});
            }
        } else {
            this.kBaseNames.put(newEntry, newEntry);
        }
    }

    public void addKSessionInjectionPoint(InjectionPoint ip, KSession kSession, Class<? extends Annotation> scope, ReleaseId releaseId, KReleaseId kReleaseId) {
        if (this.kSessionNames == null) {
            this.kSessionNames = new HashMap<KieCDIEntry, KieCDIEntry>();
        }
        String namedStr = kSession == null ? null : kSession.name();
        KieCDIEntry newEntry = new KieCDIEntry(kSession == null ? null : kSession.value(), (Class)ip.getType(), scope, releaseId, kReleaseId, namedStr);
        KieCDIEntry existingEntry = this.kSessionNames.remove(newEntry);
        if (existingEntry != null) {
            existingEntry.addInjectionPoint(ip);
            this.kSessionNames.put(existingEntry, existingEntry);
        }
        if (!StringUtils.isEmpty(namedStr)) {
            existingEntry = this.named.get(namedStr);
            if (existingEntry == null) {
                this.named.put(namedStr, newEntry);
                this.kSessionNames.put(newEntry, newEntry);
            } else {
                log.error("name={} declaration used ambiguiously existing: {} new: {}", (Object[])new String[]{namedStr, existingEntry.toString(), newEntry.toString()});
            }
        } else {
            this.kSessionNames.put(newEntry, newEntry);
        }
    }

    public void addKContainerInjectionPoint(InjectionPoint ip, String namedStr, Class<? extends Annotation> scope, ReleaseId releaseId, KReleaseId kReleaseId) {
        KieCDIEntry newEntry;
        KieCDIEntry existingEntry;
        if (this.kContainerNames == null) {
            this.kContainerNames = new HashMap<KieCDIEntry, KieCDIEntry>();
        }
        if ((existingEntry = this.kContainerNames.remove(newEntry = new KieCDIEntry(null, KieContainer.class, scope, releaseId, kReleaseId, namedStr))) != null) {
            existingEntry.addInjectionPoint(ip);
            this.kContainerNames.put(existingEntry, existingEntry);
        }
        if (!StringUtils.isEmpty(namedStr)) {
            existingEntry = this.named.get(namedStr);
            if (existingEntry == null) {
                this.named.put(namedStr, newEntry);
                this.kContainerNames.put(newEntry, newEntry);
            } else {
                log.error("name={} declaration used ambiguiously existing: {} new: {}", (Object[])new String[]{namedStr, existingEntry.toString(), newEntry.toString()});
            }
        } else {
            this.kContainerNames.put(newEntry, newEntry);
        }
    }

    public void afterBeanDiscovery(@Observes AfterBeanDiscovery abd, BeanManager bm) {
        if (this.classpathKContainer != null) {
            KieServices ks = KieServices.Factory.get();
            if (!this.gavs.isEmpty()) {
                for (ReleaseId releaseId : this.gavs.keySet().toArray(new ReleaseId[this.gavs.size()])) {
                    KieContainer kContainer = ks.newKieContainer(releaseId);
                    if (kContainer == null) {
                        log.error("Unable to retrieve KieContainer for @ReleaseId({})", (Object)releaseId.toString());
                    } else {
                        log.debug("KieContainer retrieved for @ReleaseId({})", (Object)releaseId.toString());
                    }
                    this.gavs.put(releaseId, kContainer);
                }
            }
            if (this.kContainerNames != null) {
                for (KieCDIEntry entry : this.kContainerNames.keySet()) {
                    this.addKContainerBean(abd, entry);
                }
            }
            if (this.kBaseNames != null) {
                for (KieCDIEntry entry : this.kBaseNames.keySet()) {
                    this.addKBaseBean(abd, entry);
                }
            }
            this.kBaseNames = null;
            if (this.kSessionNames != null) {
                for (KieCDIEntry entry : this.kSessionNames.keySet()) {
                    this.addKSessionBean(abd, entry);
                }
            }
            this.kSessionNames = null;
        }
    }

    public void addKContainerBean(AfterBeanDiscovery abd, KieCDIEntry entry) {
        ReleaseId releaseId = entry.getReleaseId();
        KieContainerImpl kieContainer = this.classpathKContainer;
        if (releaseId != null && (kieContainer = (KieContainerImpl)this.gavs.get(releaseId)) == null) {
            log.error("Could not retrieve KieContainer for ReleaseId {}", (Object)entry.getValue(), (Object)releaseId.toString());
            return;
        }
        KContainerBean bean = new KContainerBean((KieContainer)kieContainer, entry.getKReleaseId(), entry.getName(), entry.getInjectionPoints());
        if (log.isDebugEnabled()) {
            log.debug("Added Bean for @KContainer({})", (Object)releaseId);
        }
        abd.addBean((Bean)bean);
    }

    public void addKBaseBean(AfterBeanDiscovery abd, KieCDIEntry entry) {
        ReleaseId releaseId = entry.getReleaseId();
        KieContainerImpl kieContainer = this.classpathKContainer;
        if (releaseId != null && (kieContainer = (KieContainerImpl)this.gavs.get(releaseId)) == null) {
            log.error("Unable to create @KBase({}), could not retrieve KieContainer for ReleaseId {}", (Object)entry.getValue(), (Object)releaseId.toString());
            return;
        }
        KieProject kProject = kieContainer.getKieProject();
        KieBaseModel kBaseModel = null;
        String kBaseQName = entry.getValue();
        kBaseModel = StringUtils.isEmpty(kBaseQName) ? kProject.getDefaultKieBaseModel() : kProject.getKieBaseModel(kBaseQName);
        if (kBaseModel == null) {
            log.error("Annotation @KBase({}) found, but no KieBaseModel exist.\nEither the required kproject.xml does not exist, was corrupted, or mising the KieBase entry", (Object)kBaseQName);
            return;
        }
        if (!kBaseModel.getScope().trim().equals(entry.getScope().getClass().getName())) {
            try {
                if (kBaseModel.getScope().indexOf(46) >= 0) {
                    entry.setScope(Class.forName(kBaseModel.getScope()));
                } else {
                    entry.setScope(Class.forName("javax.enterprise.context." + kBaseModel.getScope()));
                }
            }
            catch (ClassNotFoundException e) {
                log.error("KieBaseModule {} overrides default annotation, but it was not able to find it {}\n{}", (Object[])new String[]{kBaseQName, kBaseModel.getScope(), e.getMessage()});
            }
        }
        KBaseBean bean = new KBaseBean(kBaseModel, (KieContainer)kieContainer, entry.getKReleaseId(), entry.getScope(), entry.getName(), entry.getInjectionPoints());
        if (log.isDebugEnabled()) {
            InternalKieModule kModule = kProject.getKieModuleForKBase(kBaseQName);
            log.debug("Added Bean for @KBase({})", (Object)kBaseQName, (Object)kModule);
        }
        abd.addBean((Bean)bean);
    }

    public void addKSessionBean(AfterBeanDiscovery abd, KieCDIEntry entry) {
        ReleaseId releaseId = entry.getReleaseId();
        KieContainerImpl kieContainer = this.classpathKContainer;
        if (releaseId != null && (kieContainer = (KieContainerImpl)this.gavs.get(releaseId)) == null) {
            log.error("Unable to create KSession({}), could not retrieve KieContainer for ReleaseId {}", (Object)entry.getValue(), (Object)releaseId.toString());
            return;
        }
        KieProject kProject = kieContainer.getKieProject();
        String kSessionName = entry.getValue();
        KieSessionModel kSessionModel = null;
        kSessionModel = StringUtils.isEmpty(kSessionName) ? (entry.getType() == KieSession.class ? kProject.getDefaultKieSession() : kProject.getDefaultStatelessKieSession()) : kProject.getKieSessionModel(kSessionName);
        if (kSessionModel == null) {
            log.error("Annotation @KSession({}) found, but no KieSessioneModel exist.\nEither the required kproject.xml does not exist, was corrupted, or mising the KieBase entry", (Object)kSessionName);
            return;
        }
        if (!kSessionModel.getScope().trim().equals(entry.getScope().getClass().getName())) {
            try {
                if (kSessionModel.getScope().indexOf(46) >= 0) {
                    entry.setScope(Class.forName(kSessionModel.getScope()));
                } else {
                    entry.setScope(Class.forName("javax.enterprise.context." + kSessionModel.getScope()));
                }
            }
            catch (ClassNotFoundException e) {
                log.error("KieBaseModule {} overrides default annotation, but it was not able to find it {}\n{}", (Object[])new String[]{kSessionName, kSessionModel.getScope(), e.getMessage()});
            }
        }
        if (KieSessionModel.KieSessionType.STATELESS.equals((Object)kSessionModel.getType())) {
            if (log.isDebugEnabled()) {
                InternalKieModule kModule = kProject.getKieModuleForKBase(((KieSessionModelImpl)kSessionModel).getKieBaseModel().getName());
                log.debug("Added Bean for Stateless @KSession({}) from: {}", (Object)kSessionName, (Object)kModule);
            }
            abd.addBean((Bean)new StatelessKSessionBean(kSessionModel, (KieContainer)kieContainer, entry.getKReleaseId(), entry.getScope(), entry.getName(), entry.getInjectionPoints()));
        } else {
            InternalKieModule kModule = kProject.getKieModuleForKBase(((KieSessionModelImpl)kSessionModel).getKieBaseModel().getName());
            log.debug("Added Bean for Stateful @KSession({})  from: {}", (Object)kSessionName, (Object)kModule);
            abd.addBean((Bean)new StatefulKSessionBean(kSessionModel, (KieContainer)kieContainer, entry.getKReleaseId(), entry.getScope(), entry.getName(), entry.getInjectionPoints()));
        }
    }

    public static class KieCDIEntry {
        private String value;
        private Class type;
        private Class<? extends Annotation> scope;
        private ReleaseId releaseId;
        private KReleaseId kReleaseId;
        private String name;
        private Set<InjectionPoint> injectionPoints;

        public KieCDIEntry(String value, Class type, Class<? extends Annotation> scope, ReleaseId releaseId, KReleaseId kReleaseId, String named) {
            this.value = value;
            this.type = type;
            this.scope = scope;
            this.releaseId = releaseId;
            this.kReleaseId = kReleaseId;
            this.name = named;
            this.injectionPoints = new HashSet<InjectionPoint>();
        }

        public KieCDIEntry(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public Class getType() {
            return this.type;
        }

        public void setType(Class type) {
            this.type = type;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String named) {
            this.name = named;
        }

        public void setScope(Class<? extends Annotation> scope) {
            this.scope = scope;
        }

        public Class<? extends Annotation> getScope() {
            return this.scope;
        }

        public ReleaseId getReleaseId() {
            return this.releaseId;
        }

        public void setReleaseId(ReleaseId releaseId) {
            this.releaseId = releaseId;
        }

        public KReleaseId getKReleaseId() {
            return this.kReleaseId;
        }

        public void setKReleaseId(KReleaseId kReleaseId) {
            this.kReleaseId = kReleaseId;
        }

        public void addInjectionPoint(InjectionPoint ip) {
            this.injectionPoints.add(ip);
        }

        public Set<InjectionPoint> getInjectionPoints() {
            return this.injectionPoints;
        }

        public void setInjectionPoints(Set<InjectionPoint> injectionPoints) {
            this.injectionPoints = injectionPoints;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.releaseId == null ? 0 : this.releaseId.hashCode());
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            result = 31 * result + (this.scope == null ? 0 : this.scope.hashCode());
            result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
            result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            KieCDIEntry other = (KieCDIEntry)obj;
            if (this.releaseId == null ? other.releaseId != null : !this.releaseId.equals(other.releaseId)) {
                return false;
            }
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            if (this.scope == null ? other.scope != null : !this.scope.equals(other.scope)) {
                return false;
            }
            if (this.type == null ? other.type != null : !this.type.equals(other.type)) {
                return false;
            }
            return !(this.value == null ? other.value != null : !this.value.equals(other.value));
        }
    }

    public static class StatefulKSessionBean
    implements Bean<KieSession> {
        static final Set<Type> types = Collections.unmodifiableSet(new HashSet<Class>(Arrays.asList(KieSession.class, Object.class)));
        private final Set<Annotation> qualifiers;
        private final KieSessionModel kSessionModel;
        private final KieContainer kContainer;
        private final Class<? extends Annotation> scope;
        private final String named;
        private final Set<InjectionPoint> injectionPoints;

        public StatefulKSessionBean(KieSessionModel kieSessionModelModel, KieContainer kContainer, KReleaseId kReleaseId, Class<? extends Annotation> scope, final String named, Set<InjectionPoint> injectionPoints) {
            this.kSessionModel = kieSessionModelModel;
            this.kContainer = kContainer;
            this.scope = scope;
            this.named = StringUtils.isEmpty(named) ? null : named;
            this.injectionPoints = injectionPoints;
            HashSet<Object> set = new HashSet<Object>();
            if (kieSessionModelModel.isDefault() && kReleaseId == null) {
                set.add(defaultAnnLit);
            }
            set.add(anyAnnLit);
            set.add(new KSession(){

                public Class<? extends Annotation> annotationType() {
                    return KSession.class;
                }

                public String value() {
                    return StatefulKSessionBean.this.kSessionModel.getName();
                }

                public String name() {
                    return named;
                }
            });
            if (kReleaseId != null) {
                set.add(kReleaseId);
            }
            this.qualifiers = Collections.unmodifiableSet(set);
        }

        public KieSession create(CreationalContext ctx) {
            return this.kContainer.newKieSession(this.kSessionModel.getName());
        }

        public void destroy(KieSession kBase, CreationalContext ctx) {
            ctx.release();
        }

        public Class getBeanClass() {
            return StatefulKnowledgeSession.class;
        }

        public Set<InjectionPoint> getInjectionPoints() {
            return this.injectionPoints;
        }

        public String getName() {
            return this.named;
        }

        public Set<Annotation> getQualifiers() {
            return this.qualifiers;
        }

        public Class<? extends Annotation> getScope() {
            return this.scope;
        }

        public Set<Class<? extends Annotation>> getStereotypes() {
            return Collections.emptySet();
        }

        public Set<Type> getTypes() {
            return types;
        }

        public boolean isAlternative() {
            return false;
        }

        public boolean isNullable() {
            return false;
        }
    }

    public static class StatelessKSessionBean
    implements Bean<StatelessKieSession> {
        static final Set<Type> types = Collections.unmodifiableSet(new HashSet<Class>(Arrays.asList(StatelessKieSession.class, Object.class)));
        private final Set<Annotation> qualifiers;
        private final KieSessionModel kSessionModel;
        private final KieContainer kContainer;
        private final Class<? extends Annotation> scope;
        private final String named;
        private final Set<InjectionPoint> injectionPoints;

        public StatelessKSessionBean(KieSessionModel kieSessionModelModel, KieContainer kContainer, KReleaseId kReleaseId, Class<? extends Annotation> scope, final String named, Set<InjectionPoint> injectionPoints) {
            this.kSessionModel = kieSessionModelModel;
            this.kContainer = kContainer;
            this.scope = scope;
            this.named = StringUtils.isEmpty(named) ? null : named;
            this.injectionPoints = injectionPoints;
            HashSet<Object> set = new HashSet<Object>();
            if (kieSessionModelModel.isDefault() && kReleaseId == null) {
                set.add(defaultAnnLit);
            }
            set.add(anyAnnLit);
            set.add(new KSession(){

                public Class<? extends Annotation> annotationType() {
                    return KSession.class;
                }

                public String value() {
                    return StatelessKSessionBean.this.kSessionModel.getName();
                }

                public String name() {
                    return named;
                }
            });
            if (kReleaseId != null) {
                set.add(kReleaseId);
            }
            this.qualifiers = Collections.unmodifiableSet(set);
        }

        public StatelessKieSession create(CreationalContext ctx) {
            return this.kContainer.newStatelessKieSession(this.kSessionModel.getName());
        }

        public void destroy(StatelessKieSession kSession, CreationalContext ctx) {
            ctx.release();
        }

        public Class getBeanClass() {
            return StatelessKnowledgeSession.class;
        }

        public Set<InjectionPoint> getInjectionPoints() {
            return this.injectionPoints;
        }

        public String getName() {
            return this.named;
        }

        public Set<Annotation> getQualifiers() {
            return this.qualifiers;
        }

        public Class<? extends Annotation> getScope() {
            return this.scope;
        }

        public Set<Class<? extends Annotation>> getStereotypes() {
            return Collections.emptySet();
        }

        public Set<Type> getTypes() {
            return types;
        }

        public boolean isAlternative() {
            return false;
        }

        public boolean isNullable() {
            return false;
        }
    }

    public static class KBaseBean
    implements Bean<KieBase> {
        static final Set<Type> types = Collections.unmodifiableSet(new HashSet<Class>(Arrays.asList(KieBase.class, Object.class)));
        private final Set<Annotation> qualifiers;
        private KieContainer kContainer;
        private final KieBaseModel kBaseModel;
        private final Class<? extends Annotation> scope;
        private final String named;
        private final Set<InjectionPoint> injectionPoints;

        public KBaseBean(final KieBaseModel kBaseModel, KieContainer kContainer, KReleaseId kReleaseId, Class<? extends Annotation> scope, final String named, Set<InjectionPoint> injectionPoints) {
            this.kBaseModel = kBaseModel;
            this.kContainer = kContainer;
            this.scope = scope;
            this.named = StringUtils.isEmpty(named) ? null : named;
            this.injectionPoints = injectionPoints;
            HashSet<Object> set = new HashSet<Object>();
            if (kBaseModel.isDefault() && kReleaseId == null) {
                set.add(defaultAnnLit);
            }
            set.add(anyAnnLit);
            set.add(new KBase(){

                public Class<? extends Annotation> annotationType() {
                    return KBase.class;
                }

                public String value() {
                    return kBaseModel.getName();
                }

                public String name() {
                    return named;
                }
            });
            if (kReleaseId != null) {
                set.add(kReleaseId);
            }
            this.qualifiers = Collections.unmodifiableSet(set);
        }

        public KieBase create(CreationalContext ctx) {
            return this.kContainer.getKieBase(this.kBaseModel.getName());
        }

        public void destroy(KieBase kBase, CreationalContext ctx) {
            this.kContainer = null;
            ctx.release();
        }

        public Class getBeanClass() {
            return KieBase.class;
        }

        public Set<InjectionPoint> getInjectionPoints() {
            return this.injectionPoints;
        }

        public String getName() {
            return this.named;
        }

        public Set<Annotation> getQualifiers() {
            return this.qualifiers;
        }

        public Class<? extends Annotation> getScope() {
            return this.scope;
        }

        public Set<Class<? extends Annotation>> getStereotypes() {
            return Collections.emptySet();
        }

        public Set<Type> getTypes() {
            return types;
        }

        public boolean isAlternative() {
            return false;
        }

        public boolean isNullable() {
            return false;
        }

        public String toString() {
            return "KBaseBean [kBase=" + this.kBaseModel.getName() + ", qualifiers=" + this.qualifiers + "]";
        }
    }

    public static class KContainerBean
    implements Bean<KieContainer> {
        static final Set<Type> types = Collections.unmodifiableSet(new HashSet<Class>(Arrays.asList(KieContainer.class, Object.class)));
        private final Set<Annotation> qualifiers;
        private KieContainer kContainer;
        private final String named;
        private final Set<InjectionPoint> injectionPoints;

        public KContainerBean(KieContainer kContainer, KReleaseId kReleaseId, final String named, Set<InjectionPoint> injectionPoints) {
            this.kContainer = kContainer;
            this.named = named;
            this.injectionPoints = injectionPoints;
            HashSet<Object> set = new HashSet<Object>();
            if (kReleaseId == null) {
                set.add(defaultAnnLit);
            }
            set.add(anyAnnLit);
            if (named != null) {
                set.add(new Named(){

                    public Class<? extends Annotation> annotationType() {
                        return Named.class;
                    }

                    public String value() {
                        return named;
                    }

                    public String toString() {
                        return "Named[" + named + "]";
                    }
                });
            }
            if (kReleaseId != null) {
                set.add(kReleaseId);
            }
            this.qualifiers = Collections.unmodifiableSet(set);
        }

        public KieContainer create(CreationalContext ctx) {
            return this.kContainer;
        }

        public void destroy(KieContainer kContainer, CreationalContext ctx) {
            this.kContainer = null;
            ctx.release();
        }

        public Class getBeanClass() {
            return KieContainer.class;
        }

        public Set<InjectionPoint> getInjectionPoints() {
            return this.injectionPoints;
        }

        public String getName() {
            return this.named;
        }

        public Set<Annotation> getQualifiers() {
            return this.qualifiers;
        }

        public Class<? extends Annotation> getScope() {
            return Dependent.class;
        }

        public Set<Class<? extends Annotation>> getStereotypes() {
            return Collections.emptySet();
        }

        public Set<Type> getTypes() {
            return types;
        }

        public boolean isAlternative() {
            return false;
        }

        public boolean isNullable() {
            return false;
        }

        public String toString() {
            return "KieContainer [qualifiers=" + this.qualifiers + "]";
        }
    }
}

