/*
 * Decompiled with CFR 0.152.
 */
package org.drools.decisiontable.parser;

import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import org.drools.decisiontable.model.Global;
import org.drools.decisiontable.model.Import;
import org.drools.decisiontable.parser.DecisionTableParseException;

public class RuleSheetParserUtil {
    private RuleSheetParserUtil() {
    }

    public static String getRuleName(String string) {
        int n = string.indexOf("RuleTable");
        if (string.indexOf(40) > -1 || string.indexOf(41) > -1) {
            RuleSheetParserUtil.invalidRuleTableDef(string);
        }
        return string.substring(n + "RuleTable".length()).trim();
    }

    private static void invalidRuleTableDef(String string) {
        throw new IllegalArgumentException("Invalid rule table header cell. Should be in the format of 'RuleTable YourRuleName'. It was: \n [" + string + "] \n");
    }

    public static List getImportList(String string) {
        LinkedList<Import> linkedList = new LinkedList<Import>();
        if (string == null) {
            return linkedList;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            Import import_ = new Import();
            import_.setClassName(stringTokenizer.nextToken().trim());
            linkedList.add(import_);
        }
        return linkedList;
    }

    public static List getVariableList(String string) {
        LinkedList<Global> linkedList = new LinkedList<Global>();
        if (string == null) {
            return linkedList;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            Global global = new Global();
            StringTokenizer stringTokenizer2 = new StringTokenizer(string2, " ");
            global.setClassName(stringTokenizer2.nextToken());
            if (!stringTokenizer2.hasMoreTokens()) {
                throw new DecisionTableParseException("The format for global variables is incorrect. It should be: [Class name, Class otherName]. But it was: [" + string + "]");
            }
            global.setIdentifier(stringTokenizer2.nextToken());
            linkedList.add(global);
        }
        return linkedList;
    }

    public static boolean isStringMeaningTrue(String string) {
        if (string == null) {
            return false;
        }
        if ((string = string.trim()).equalsIgnoreCase("true")) {
            return true;
        }
        if (string.startsWith("Y")) {
            return true;
        }
        if (string.startsWith("y")) {
            return true;
        }
        return string.equalsIgnoreCase("on");
    }
}

