/*
 * Decompiled with CFR 0.152.
 */
package org.drools.decisiontable.model;

public class SnippetBuilder {
    private static final String PARAM_PREFIX = "$";
    private static final String PARAM = "$param";
    private String _template;

    public SnippetBuilder(String string) {
        this._template = string;
    }

    public String build(String string) {
        if (this._template == null) {
            throw new RuntimeException("Script template is null - check for missing script definition.");
        }
        if (this._template.indexOf("$1") > 0) {
            return this.buildMulti(string);
        }
        return this.buildSingle(string);
    }

    private String buildMulti(String string) {
        String[] stringArray = string.split(",");
        String string2 = this._template;
        for (int i = 0; i < stringArray.length; ++i) {
            String string3 = PARAM_PREFIX + (i + 1);
            string2 = this.replace(string2, string3, stringArray[i].trim(), 256);
        }
        return string2;
    }

    private String buildSingle(String string) {
        return this.replace(this._template, PARAM, string, 256);
    }

    private String replace(String string, String string2, String string3, int n) {
        if (string == null || string2 == null || string2.equals("") || string3 == null || n == 0) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(string.length());
        int n2 = 0;
        int n3 = 0;
        while ((n3 = string.indexOf(string2, n2)) != -1) {
            stringBuffer.append(string.substring(n2, n3)).append(string3);
            n2 = n3 + string2.length();
            if (--n != 0) continue;
        }
        stringBuffer.append(string.substring(n2));
        return stringBuffer.toString();
    }
}

