/*
 * Decompiled with CFR 0.152.
 */
package org.drools.decisiontable.parser.csv;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.List;
import org.drools.decisiontable.parser.DecisionTableParseException;
import org.drools.decisiontable.parser.DecisionTableParser;
import org.drools.decisiontable.parser.SheetListener;
import org.drools.decisiontable.parser.csv.CsvLineParser;

public class CsvParser
implements DecisionTableParser {
    private SheetListener _listener;
    private CsvLineParser _lineParser;

    public CsvParser(SheetListener listener, CsvLineParser lineParser) {
        this._listener = listener;
        this._lineParser = lineParser;
    }

    public void parseFile(InputStream inStream) {
        BufferedReader reader = new BufferedReader(new InputStreamReader(inStream));
        try {
            this._listener.startSheet("csv");
            this.processRows(reader);
            this._listener.finishSheet();
        }
        catch (IOException e) {
            throw new DecisionTableParseException("An error occurred reading the CSV data.", e);
        }
    }

    private void processRows(BufferedReader reader) throws IOException {
        String line = reader.readLine();
        int row = 0;
        while (line != null) {
            List cells = this._lineParser.parse(line);
            this._listener.newRow(row, cells.size());
            for (int col = 0; col < cells.size(); ++col) {
                String cell = (String)cells.get(col);
                this._listener.newCell(row, col, cell);
            }
            ++row;
            line = reader.readLine();
        }
    }

    private void trimCells(List cells) {
        for (int i = cells.size() - 1; i > 0; --i) {
            String cell = (String)cells.get(i);
            if (!cell.trim().equals("")) {
                return;
            }
            cells.remove(i);
        }
    }
}

