/*
 * Decompiled with CFR 0.152.
 */
package org.drools.decisiontable;

import java.io.InputStream;
import java.util.HashMap;
import org.drools.decisiontable.InputType;
import org.drools.decisiontable.model.DRLOutput;
import org.drools.decisiontable.model.Package;
import org.drools.decisiontable.parser.DecisionTableParser;
import org.drools.decisiontable.parser.RuleSheetListener;
import org.drools.decisiontable.parser.xls.ExcelParser;

public class SpreadsheetCompiler {
    public String compile(InputStream xlsStream, InputType type) {
        RuleSheetListener listener = this.getRuleSheetListener(xlsStream, type);
        Package rulePackage = listener.getRuleSet();
        DRLOutput out = new DRLOutput();
        rulePackage.renderDRL(out);
        return out.getDRL();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String compile(String classPathResource, InputType inputType) {
        InputStream stream = this.getClass().getResourceAsStream(classPathResource);
        try {
            String drl;
            String string = drl = this.compile(stream, inputType);
            return string;
        }
        finally {
            this.closeStream(stream);
        }
    }

    public String compile(InputStream stream, String worksheetName) {
        RuleSheetListener listener = this.getRuleSheetListener(stream, worksheetName);
        Package rulePackage = listener.getRuleSet();
        DRLOutput out = new DRLOutput();
        rulePackage.renderDRL(out);
        return out.getDRL();
    }

    private RuleSheetListener getRuleSheetListener(InputStream stream, InputType type) {
        RuleSheetListener listener = new RuleSheetListener();
        DecisionTableParser parser = type.createParser(listener);
        parser.parseFile(stream);
        return listener;
    }

    private RuleSheetListener getRuleSheetListener(InputStream stream, String worksheetName) {
        RuleSheetListener listener = new RuleSheetListener();
        HashMap<String, RuleSheetListener> listeners = new HashMap<String, RuleSheetListener>();
        listeners.put(worksheetName, listener);
        ExcelParser parser = new ExcelParser(listeners);
        parser.parseFile(stream);
        return listener;
    }

    private void closeStream(InputStream stream) {
        try {
            stream.close();
        }
        catch (Exception e) {
            System.err.print("WARNING: Wasn't able to correctly close stream for decision table. " + e.getMessage());
        }
    }
}

