/*
 * Decompiled with CFR 0.152.
 */
package org.drools.decisiontable.parser.csv;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class CsvLineParser {
    private static final char DELIMITER = ',';

    public List<String> parse(CharSequence input) {
        String line = input != null ? input.toString() : "";
        ArrayList<String> fields = new ArrayList<String>();
        if (line.isEmpty()) {
            return Collections.singletonList("");
        }
        StringBuilder currentField = new StringBuilder();
        boolean insideQuotes = false;
        for (int i = 0; i < line.length(); ++i) {
            char currentChar = line.charAt(i);
            if (currentChar == '\"') {
                if (insideQuotes && i + 1 < line.length() && line.charAt(i + 1) == '\"') {
                    currentField.append('\"');
                    ++i;
                    continue;
                }
                insideQuotes = !insideQuotes;
                continue;
            }
            if (currentChar == ',' && !insideQuotes) {
                fields.add(currentField.toString());
                currentField.setLength(0);
                continue;
            }
            currentField.append(currentChar);
        }
        fields.add(currentField.toString());
        return fields;
    }
}

