/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.util.index;

import org.drools.base.rule.ContextEntry;
import org.drools.base.rule.constraint.BetaConstraint;
import org.drools.base.util.index.ConstraintTypeOperator;
import org.drools.core.RuleBaseConfiguration;
import org.drools.core.reteoo.BetaMemory;
import org.drools.core.reteoo.TupleMemory;
import org.drools.core.util.index.IndexMemory;
import org.drools.core.util.index.IndexSpec;
import org.drools.core.util.index.TupleList;

public interface IndexFactory {
    public static BetaMemory createBetaMemory(RuleBaseConfiguration config, int nodeType, BetaConstraint ... constraints) {
        if (config.getCompositeKeyDepth() < 1) {
            return new BetaMemory<Object>(config.isSequential() ? null : new TupleList(), new TupleList(), IndexFactory.createContext(constraints), nodeType);
        }
        IndexSpec indexSpec = new IndexSpec(nodeType, constraints, config);
        return new BetaMemory<Object>(IndexFactory.createLeftMemory(config, indexSpec), IndexFactory.createRightMemory(config, indexSpec), IndexFactory.createContext(constraints), nodeType);
    }

    private static TupleMemory createRightMemory(RuleBaseConfiguration config, IndexSpec indexSpec) {
        if (!config.isIndexRightBetaMemory() || !indexSpec.getConstraintType().isIndexable() || indexSpec.getIndexes().length == 0) {
            return new TupleList();
        }
        if (indexSpec.getConstraintType() == ConstraintTypeOperator.EQUAL) {
            return IndexMemory.createEqualityMemory(indexSpec, false);
        }
        if (indexSpec.getConstraintType().isComparison()) {
            return IndexMemory.createComparisonMemory(indexSpec, false);
        }
        return new TupleList();
    }

    private static TupleMemory createLeftMemory(RuleBaseConfiguration config, IndexSpec indexSpec) {
        if (config.isSequential()) {
            return null;
        }
        if (!config.isIndexLeftBetaMemory() || !indexSpec.getConstraintType().isIndexable() || indexSpec.getIndexes().length == 0) {
            return new TupleList();
        }
        if (indexSpec.getConstraintType() == ConstraintTypeOperator.EQUAL) {
            return IndexMemory.createEqualityMemory(indexSpec, true);
        }
        if (indexSpec.getConstraintType().isComparison()) {
            return IndexMemory.createComparisonMemory(indexSpec, true);
        }
        return new TupleList();
    }

    private static Object createContext(BetaConstraint ... constraints) {
        if (constraints.length == 1) {
            return constraints[0].createContext();
        }
        ContextEntry[] entries = new ContextEntry[constraints.length];
        for (int i = 0; i < constraints.length; ++i) {
            entries[i] = constraints[i].createContext();
        }
        return entries;
    }
}

