/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.reteoo;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.drools.core.common.BaseNode;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.PropagationContext;
import org.drools.core.common.ReteEvaluator;
import org.drools.core.reteoo.AccumulateNode;
import org.drools.core.reteoo.AccumulateRight;
import org.drools.core.reteoo.BetaMemory;
import org.drools.core.reteoo.BetaNode;
import org.drools.core.reteoo.CompositeObjectSinkAdapter;
import org.drools.core.reteoo.EmptyObjectSinkAdapter;
import org.drools.core.reteoo.LeftTupleSource;
import org.drools.core.reteoo.ModifyPreviousTuples;
import org.drools.core.reteoo.ObjectSink;
import org.drools.core.reteoo.ObjectSinkPropagator;
import org.drools.core.reteoo.RightInputAdapterNode;

public class SingleObjectSinkAdapter
implements ObjectSinkPropagator {
    private static final long serialVersionUID = 510L;
    private ObjectSink sink;
    private ObjectSink[] sinks;

    public SingleObjectSinkAdapter() {
    }

    public SingleObjectSinkAdapter(ObjectSink sink) {
        this.sink = sink;
        this.sinks = new ObjectSink[]{this.sink};
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.sink = (ObjectSink)in.readObject();
        this.sinks = new ObjectSink[]{this.sink};
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.sink);
    }

    @Override
    public ObjectSinkPropagator addObjectSink(ObjectSink sink, int alphaNodeHashingThreshold, int alphaNodeRangeIndexThreshold) {
        CompositeObjectSinkAdapter sinkAdapter = new CompositeObjectSinkAdapter(alphaNodeHashingThreshold, alphaNodeRangeIndexThreshold);
        sinkAdapter.addObjectSink(this.sink, alphaNodeHashingThreshold, alphaNodeRangeIndexThreshold);
        sinkAdapter.addObjectSink(sink, alphaNodeHashingThreshold, alphaNodeRangeIndexThreshold);
        return sinkAdapter;
    }

    @Override
    public ObjectSinkPropagator removeObjectSink(ObjectSink sink) {
        if (this.sink.equals(sink)) {
            return EmptyObjectSinkAdapter.getInstance();
        }
        throw new IllegalArgumentException("Cannot remove " + sink + " when this sink propagator only contains " + this.sink);
    }

    @Override
    public void propagateAssertObject(InternalFactHandle factHandle, PropagationContext context, ReteEvaluator reteEvaluator) {
        this.sink.assertObject(factHandle, context, reteEvaluator);
    }

    @Override
    public void propagateModifyObject(InternalFactHandle factHandle, ModifyPreviousTuples modifyPreviousTuples, PropagationContext context, ReteEvaluator reteEvaluator) {
        this.sink.modifyObject(factHandle, modifyPreviousTuples, context, reteEvaluator);
    }

    @Override
    public void byPassModifyToBetaNode(InternalFactHandle factHandle, ModifyPreviousTuples modifyPreviousTuples, PropagationContext context, ReteEvaluator reteEvaluator) {
        this.sink.byPassModifyToBetaNode(factHandle, modifyPreviousTuples, context, reteEvaluator);
    }

    @Override
    public void doLinkSubnetwork(ReteEvaluator reteEvaluator) {
        SingleObjectSinkAdapter.staticDoLinkSubnetwork(this.sink, reteEvaluator);
    }

    public static void staticDoLinkSubnetwork(ObjectSink sink, ReteEvaluator reteEvaluator) {
        BetaMemory bm;
        Object betaNode;
        if (sink.getType() == 5506056) {
            AccumulateRight accnode = (AccumulateRight)sink;
            betaNode = accnode.getBetaNode();
            AccumulateNode.AccumulateMemory accMem = (AccumulateNode.AccumulateMemory)reteEvaluator.getNodeMemory(betaNode);
            bm = accMem.getBetaMemory();
        } else {
            RightInputAdapterNode betaRight = (RightInputAdapterNode)sink;
            betaNode = betaRight.getBetaNode();
            bm = RightInputAdapterNode.getBetaMemoryFromRightInput(betaNode, reteEvaluator);
        }
        if (bm.getStagedRightTuples().isEmpty()) {
            if (bm.getRightTupleMemory().size() == 0) {
                bm.linkNode((LeftTupleSource)betaNode, reteEvaluator);
            } else {
                bm.setNodeDirty((LeftTupleSource)betaNode, reteEvaluator);
            }
        }
    }

    @Override
    public void doUnlinkSubnetwork(ReteEvaluator reteEvaluator) {
        SingleObjectSinkAdapter.staticDoUnlinkSubnetwork(this.sink, reteEvaluator);
    }

    public static void staticDoUnlinkSubnetwork(ObjectSink sink, ReteEvaluator reteEvaluator) {
        BetaMemory bm;
        if (sink.getType() == 5506056) {
            AccumulateNode accnode = (AccumulateNode)((AccumulateRight)sink).getBetaNode();
            AccumulateNode.AccumulateMemory accMem = (AccumulateNode.AccumulateMemory)reteEvaluator.getNodeMemory(accnode);
            bm = accMem.getBetaMemory();
        } else {
            Object betaNode = ((RightInputAdapterNode)sink).getBetaNode();
            bm = RightInputAdapterNode.getBetaMemoryFromRightInput(betaNode, reteEvaluator);
        }
        if (sink.getType() == 11143732) {
            bm.linkNode((BetaNode)((Object)sink), reteEvaluator);
        } else {
            bm.unlinkNode(reteEvaluator);
        }
    }

    @Override
    public BaseNode getMatchingNode(BaseNode candidate) {
        return this.sink.equals(candidate) ? (BaseNode)((Object)this.sink) : null;
    }

    @Override
    public ObjectSink[] getSinks() {
        return this.sinks;
    }

    @Override
    public int size() {
        return 1;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }
}

