/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.reteoo;

import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.PropagationContext;
import org.drools.core.common.ReteEvaluator;
import org.drools.core.common.SuperCacheFixer;
import org.drools.core.reteoo.LeftTuple;
import org.drools.core.reteoo.ObjectTypeNodeId;
import org.drools.core.reteoo.RightTupleSink;
import org.drools.core.reteoo.Sink;
import org.drools.core.reteoo.TupleImpl;

public class RightTuple
extends TupleImpl {
    private LeftTuple blocked;
    private RightTuple tempNextRightTuple;
    private LeftTuple tempBlocked;
    private boolean retracted;

    public RightTuple() {
    }

    public RightTuple(InternalFactHandle handle) {
        this.handle = handle;
    }

    public RightTuple(InternalFactHandle handle, RightTupleSink sink) {
        this.setSink(sink);
        this.handle = handle;
        handle.addLastRightTuple(this);
    }

    public RightTuple(InternalFactHandle factHandle, Sink sink, boolean leftTupleMemoryEnabled) {
        super(factHandle, sink, leftTupleMemoryEnabled);
    }

    public RightTuple(InternalFactHandle factHandle, TupleImpl leftTuple, Sink sink) {
        super(factHandle, leftTuple, sink);
    }

    public RightTuple(TupleImpl leftTuple, Sink sink, PropagationContext pctx, boolean leftTupleMemoryEnabled) {
        super(leftTuple, sink, pctx, leftTupleMemoryEnabled);
    }

    public RightTuple(TupleImpl leftTuple, TupleImpl rightTuple, Sink sink) {
        super(leftTuple, rightTuple, sink);
    }

    public RightTuple(TupleImpl leftTuple, TupleImpl rightTuple, Sink sink, boolean leftTupleMemoryEnabled) {
        super(leftTuple, rightTuple, null, null, sink, leftTupleMemoryEnabled);
    }

    public RightTuple(TupleImpl leftTuple, TupleImpl rightTuple, TupleImpl currentLeftChild, TupleImpl currentRightChild, Sink sink, boolean leftTupleMemoryEnabled) {
        super(leftTuple, rightTuple, currentLeftChild, currentRightChild, sink, leftTupleMemoryEnabled);
    }

    @Override
    public void reAdd() {
        this.getFactHandle().addLastRightTuple(this);
    }

    @Override
    public void unlinkFromRightParent() {
        this.getFactHandle().removeRightTuple(this);
        this.setFactHandle(null);
        this.handlePrevious = null;
        this.handleNext = null;
        this.blocked = null;
        this.setPrevious((TupleImpl)null);
        this.setNext((TupleImpl)null);
        this.memory = null;
        this.firstChild = null;
        this.lastChild = null;
        this.setSink(null);
    }

    public LeftTuple getBlocked() {
        return this.blocked;
    }

    public void setBlocked(LeftTuple leftTuple) {
        this.blocked = leftTuple;
    }

    public void addBlocked(LeftTuple leftTuple) {
        if (this.blocked != null && leftTuple != null) {
            leftTuple.setBlockedNext(this.blocked);
            this.blocked.setBlockedPrevious(leftTuple);
        }
        this.blocked = leftTuple;
    }

    public void removeBlocked(LeftTuple leftTuple) {
        LeftTuple previous = leftTuple.getBlockedPrevious();
        LeftTuple next = leftTuple.getBlockedNext();
        if (previous != null && next != null) {
            previous.setBlockedNext(next);
            next.setBlockedPrevious(previous);
        } else if (next != null) {
            this.blocked = next;
            next.setBlockedPrevious(null);
        } else if (previous != null) {
            previous.setBlockedNext(null);
        } else {
            this.blocked = null;
        }
        leftTuple.clearBlocker();
    }

    public LeftTuple getTempBlocked() {
        return this.tempBlocked;
    }

    public void setTempBlocked(LeftTuple tempBlocked) {
        this.tempBlocked = tempBlocked;
    }

    public RightTuple getTempNextRightTuple() {
        return this.tempNextRightTuple;
    }

    public void setTempNextRightTuple(RightTuple tempNextRightTuple) {
        this.tempNextRightTuple = tempNextRightTuple;
    }

    @Override
    public void clearStaged() {
        super.clearStaged();
        this.tempNextRightTuple = null;
        this.tempBlocked = null;
    }

    @Override
    public ObjectTypeNodeId getInputOtnId() {
        return SuperCacheFixer.getRightInputOtnId(this);
    }

    public void retractTuple(PropagationContext context, ReteEvaluator reteEvaluator) {
        if (!this.retracted) {
            SuperCacheFixer.getRightTupleSink(this).retractRightTuple(this, context, reteEvaluator);
            this.retracted = true;
        }
    }

    public void setExpired(ReteEvaluator reteEvaluator, PropagationContext pctx) {
        super.setExpired();
        if (this.getSink().getType() == 5506056) {
            this.retractTuple(pctx, reteEvaluator);
        }
    }

    @Override
    public InternalFactHandle getFactHandleForEvaluation() {
        return this.handle;
    }

    @Override
    public boolean isLeftTuple() {
        return false;
    }
}

