/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.reteoo;

import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.drools.base.common.NetworkNode;
import org.drools.base.reteoo.NodeTypeEnums;
import org.drools.core.common.BaseNode;
import org.drools.core.impl.InternalRuleBase;
import org.drools.core.reteoo.AccumulateNode;
import org.drools.core.reteoo.BetaNode;
import org.drools.core.reteoo.EntryPointNode;
import org.drools.core.reteoo.FromNode;
import org.drools.core.reteoo.Rete;
import org.kie.api.KieBase;
import org.kie.api.definition.rule.Rule;
import org.kie.api.runtime.KieRuntime;
import org.kie.api.runtime.KieSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReteDumper {
    private static Logger logger = LoggerFactory.getLogger(ReteDumper.class);
    private PrintWriter writer;
    private StringBuilder sb;
    private Predicate<BaseNode> nodesFilter;
    private boolean nodeInfoOnly = false;

    public ReteDumper() {
        this((BaseNode node) -> true);
    }

    public ReteDumper(Predicate<BaseNode> nodesFilter) {
        this.nodesFilter = nodesFilter;
    }

    public ReteDumper(String ruleName) {
        this((BaseNode node) -> Stream.of(node.getAssociatedRules()).anyMatch(rule -> rule.getName().equals(ruleName)));
    }

    public PrintWriter getWriter() {
        return this.writer;
    }

    public void setWriter(PrintWriter writer) {
        this.writer = writer;
    }

    public boolean isNodeInfoOnly() {
        return this.nodeInfoOnly;
    }

    public void setNodeInfoOnly(boolean nodeInfoOnly) {
        this.nodeInfoOnly = nodeInfoOnly;
    }

    public static void dumpRete(KieBase kbase) {
        new ReteDumper().dump((InternalRuleBase)kbase);
    }

    public static void dumpRete(KieRuntime session) {
        new ReteDumper().dump((InternalRuleBase)session.getKieBase());
    }

    public static void dumpRete(KieSession session) {
        new ReteDumper().dump((InternalRuleBase)session.getKieBase());
    }

    public static void dumpRete(InternalRuleBase kBase) {
        new ReteDumper().dump(kBase.getRete());
    }

    public static void dumpRete(Rete rete) {
        new ReteDumper().dump(rete);
    }

    public void dump(KieBase kbase) {
        this.dump((InternalRuleBase)kbase);
    }

    public void dump(KieRuntime session) {
        this.dump((InternalRuleBase)session.getKieBase());
    }

    public void dump(KieSession session) {
        this.dump((InternalRuleBase)session.getKieBase());
    }

    public void dump(InternalRuleBase kBase) {
        this.dump(kBase.getRete());
    }

    public void dump(Rete rete) {
        this.sb = new StringBuilder();
        this.traverseRete(rete, this::dumpNode);
        this.printResults();
    }

    private void printResults() {
        if (this.writer == null) {
            System.out.print(this.sb.toString());
        } else {
            this.writer.print(this.sb.toString());
        }
    }

    public static Set<BaseNode> collectRete(KieBase kbase) {
        return new ReteDumper().collect((InternalRuleBase)kbase);
    }

    public static Set<BaseNode> collectRete(KieRuntime session) {
        return new ReteDumper().collect((InternalRuleBase)session.getKieBase());
    }

    public static Set<BaseNode> collectRete(KieSession session) {
        return new ReteDumper().collect((InternalRuleBase)session.getKieBase());
    }

    public static Set<BaseNode> collectRete(InternalRuleBase kBase) {
        return new ReteDumper().collect(kBase.getRete());
    }

    public static Set<BaseNode> collectRete(Rete rete) {
        return new ReteDumper().collect(rete);
    }

    public Set<BaseNode> collect(KieBase kbase) {
        return this.collect((InternalRuleBase)kbase);
    }

    public Set<BaseNode> collect(KieRuntime session) {
        return this.collect((InternalRuleBase)session.getKieBase());
    }

    public Set<BaseNode> collect(KieSession session) {
        return this.collect((InternalRuleBase)session.getKieBase());
    }

    public Set<BaseNode> collect(InternalRuleBase kBase) {
        return this.collect(kBase.getRete());
    }

    public Set<BaseNode> collect(Rete rete) {
        Set<BaseNode> nodes = this.createIdentitySet();
        this.traverseRete(rete, (node, s) -> nodes.add((BaseNode)node));
        return nodes;
    }

    public void traverseRete(Rete rete, BiConsumer<BaseNode, String> consumer) {
        for (EntryPointNode entryPointNode : rete.getEntryPointNodes().values()) {
            this.dumpNode(entryPointNode, "", this.createIdentitySet(), consumer);
        }
    }

    private <T> Set<T> createIdentitySet() {
        return Collections.newSetFromMap(new IdentityHashMap());
    }

    private void dumpNode(BaseNode node, String ident, Set<BaseNode> visitedNodes, BiConsumer<BaseNode, String> consumer) {
        consumer.accept(node, ident);
        if (!visitedNodes.add(node)) {
            return;
        }
        NetworkNode[] sinks = node.getSinks();
        if (sinks != null) {
            for (NetworkNode sink : sinks) {
                BaseNode sinkNode = (BaseNode)sink;
                if (!this.nodesFilter.test(sinkNode)) continue;
                this.dumpNode(sinkNode, ident + "  ", visitedNodes, consumer);
            }
        }
    }

    private void dumpNode(BaseNode node, String ident) {
        this.sb.append(ident + this.formatNode(node));
        if (!this.nodeInfoOnly) {
            Object inferreddMask;
            Object declaredMask;
            this.sb.append(" on " + node.getPartitionId());
            try {
                declaredMask = node.getClass().getMethod("getDeclaredMask", new Class[0]).invoke((Object)node, new Object[0]);
                inferreddMask = node.getClass().getMethod("getInferredMask", new Class[0]).invoke((Object)node, new Object[0]);
                this.sb.append(" d " + declaredMask + " i " + inferreddMask);
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                logger.trace("failed to log mask values", (Throwable)e);
            }
            try {
                declaredMask = node.getClass().getMethod("getLeftDeclaredMask", new Class[0]).invoke((Object)node, new Object[0]);
                inferreddMask = node.getClass().getMethod("getLeftInferredMask", new Class[0]).invoke((Object)node, new Object[0]);
                this.sb.append(" Ld " + declaredMask + " Li " + inferreddMask);
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                logger.trace("failed to log left mask values", (Throwable)e);
            }
            try {
                declaredMask = node.getClass().getMethod("getRightDeclaredMask", new Class[0]).invoke((Object)node, new Object[0]);
                inferreddMask = node.getClass().getMethod("getRightInferredMask", new Class[0]).invoke((Object)node, new Object[0]);
                this.sb.append(" Rd " + declaredMask + " Ri " + inferreddMask);
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                logger.trace("failed to log right mask values", (Throwable)e);
            }
        }
        this.sb.append("\n");
    }

    public String formatNode(BaseNode node) {
        StringBuilder additionalInfo = new StringBuilder();
        if (NodeTypeEnums.isBetaNode((NetworkNode)node)) {
            BetaNode betaNode = (BetaNode)node;
            additionalInfo.append("contraints=");
            if (betaNode.getRawConstraints() != null) {
                additionalInfo.append(Arrays.toString(betaNode.getConstraints()));
            }
            if (node.getType() == 11799092) {
                AccumulateNode accNode = (AccumulateNode)node;
                additionalInfo.append(", resultConstraints=" + Arrays.toString(accNode.getResultConstraints()));
                additionalInfo.append(", resultBinder=" + Arrays.toString(accNode.getResultBinder().getConstraints()));
            }
        } else if (node.getType() == 8849460) {
            FromNode fromNode = (FromNode)node;
            additionalInfo.append("result=" + fromNode.getResultClass().getName());
            additionalInfo.append(", alphaConstraints=" + Arrays.toString(fromNode.getAlphaConstraints()));
            additionalInfo.append(", betaConstraints=" + Arrays.toString(fromNode.getBetaConstraints().getConstraints()));
        }
        if (additionalInfo.length() > 0) {
            return node + " <" + additionalInfo.toString() + "> ";
        }
        return node.toString();
    }

    public static void dumpAssociatedRulesRete(KieBase kieBase) {
        new ReteDumper().dumpAssociatedRules(((InternalRuleBase)kieBase).getRete());
    }

    public void dumpAssociatedRules(KieBase kieBase) {
        this.dumpAssociatedRules(((InternalRuleBase)kieBase).getRete());
    }

    public void dumpAssociatedRules(Rete rete) {
        this.sb = new StringBuilder();
        Set<BaseNode> nodes = this.collect(rete);
        for (BaseNode node : nodes) {
            String ruleNames = Arrays.stream(node.getAssociatedRules()).map(Rule::getName).collect(Collectors.joining(", "));
            this.sb.append(node + " : [" + ruleNames + "]\n");
        }
        this.printResults();
    }
}

