/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.reteoo;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.phreak.ReactiveObjectUtil;
import org.drools.core.reteoo.LeftTuple;
import org.drools.core.reteoo.Sink;
import org.drools.core.reteoo.TupleImpl;
import org.kie.api.runtime.rule.FactHandle;

public class ReactiveFromNodeLeftTuple
extends LeftTuple {
    private Map<Object, ReactiveObjectUtil.ModificationType> modificationTypeMap = new HashMap<Object, ReactiveObjectUtil.ModificationType>();
    private Object[] objects;
    private int hash;
    private int peerIndex;

    public ReactiveFromNodeLeftTuple() {
    }

    public ReactiveFromNodeLeftTuple(TupleImpl leftTuple, TupleImpl rightTuple, TupleImpl currentLeftChild, TupleImpl currentRightChild, Sink sink, boolean leftTupleMemoryEnabled) {
        super(leftTuple, rightTuple, currentLeftChild, currentRightChild, sink, leftTupleMemoryEnabled);
        this.storeTupleObjects(leftTuple, rightTuple.getFactHandle());
    }

    public ReactiveFromNodeLeftTuple(InternalFactHandle factHandle, TupleImpl leftTuple, Sink sink) {
        super(factHandle, leftTuple, sink);
        this.storeTupleObjects(leftTuple, factHandle);
    }

    public ReactiveFromNodeLeftTuple(FactHandle factHandle, Sink sink, boolean leftTupleMemoryEnabled) {
        super((InternalFactHandle)factHandle, sink, leftTupleMemoryEnabled);
        this.objects = new Object[]{factHandle.getObject()};
        this.hash = Arrays.hashCode(this.objects);
    }

    private void storeTupleObjects(TupleImpl leftTuple, FactHandle factHandle) {
        Object[] leftObjects = leftTuple.toObjects();
        this.objects = new Object[leftObjects.length + 1];
        System.arraycopy(leftObjects, 0, this.objects, 0, leftObjects.length);
        this.objects[leftObjects.length] = factHandle.getObject();
        this.hash = Arrays.hashCode(this.objects);
    }

    @Override
    public void initPeer(TupleImpl original, Sink sink) {
        super.initPeer(original, sink);
        if (original instanceof ReactiveFromNodeLeftTuple) {
            ReactiveFromNodeLeftTuple reactiveTuple = (ReactiveFromNodeLeftTuple)original;
            this.objects = reactiveTuple.objects;
            this.peerIndex = reactiveTuple.peerIndex + 1;
            this.hash = Arrays.hashCode(this.objects) + this.peerIndex;
        }
    }

    @Override
    public int hashCode() {
        return this.hash;
    }

    @Override
    public boolean equals(Object other) {
        return other instanceof ReactiveFromNodeLeftTuple && Arrays.equals(this.objects, ((ReactiveFromNodeLeftTuple)other).objects) && this.peerIndex == ((ReactiveFromNodeLeftTuple)other).peerIndex;
    }

    public boolean updateModificationState(Object object, ReactiveObjectUtil.ModificationType newState) {
        ReactiveObjectUtil.ModificationType modificationType = this.modificationTypeMap.computeIfAbsent(object, k -> ReactiveObjectUtil.ModificationType.NONE);
        switch (modificationType) {
            case NONE: {
                modificationType = newState;
                this.modificationTypeMap.put(object, modificationType);
                return true;
            }
            case ADD: {
                if (newState != ReactiveObjectUtil.ModificationType.REMOVE) break;
                modificationType = ReactiveObjectUtil.ModificationType.NONE;
                break;
            }
            case MODIFY: {
                if (newState != ReactiveObjectUtil.ModificationType.REMOVE) break;
                modificationType = ReactiveObjectUtil.ModificationType.REMOVE;
            }
        }
        this.modificationTypeMap.put(object, modificationType);
        return false;
    }

    public ReactiveObjectUtil.ModificationType resetModificationState(Object object) {
        return this.modificationTypeMap.remove(object);
    }
}

