/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.reteoo;

import java.beans.PropertyChangeListener;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import org.drools.base.base.ClassObjectType;
import org.drools.base.base.ObjectType;
import org.drools.base.base.ValueResolver;
import org.drools.base.rule.EntryPointId;
import org.drools.base.rule.TypeDeclaration;
import org.drools.base.util.TimeIntervalParser;
import org.drools.core.WorkingMemoryEntryPoint;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.ReteEvaluator;
import org.drools.core.impl.InternalRuleBase;
import org.drools.core.reteoo.ObjectTypeConf;
import org.drools.core.reteoo.ObjectTypeNode;
import org.drools.core.reteoo.Rete;
import org.drools.core.rule.accessor.FactHandleFactory;
import org.drools.core.rule.consequence.InternalMatch;
import org.kie.api.definition.type.Expires;
import org.kie.api.definition.type.Role;

public class ClassObjectTypeConf
implements ObjectTypeConf,
Externalizable {
    protected static final Class<?>[] ADD_REMOVE_PROPERTY_CHANGE_LISTENER_ARG_TYPES = new Class[]{PropertyChangeListener.class};
    private static final long serialVersionUID = 510L;
    private Class<?> cls;
    private Rete rete;
    private ObjectTypeNode[] objectTypeNodes;
    private ObjectType objectType;
    private ObjectTypeNode concreteObjectTypeNode;
    private EntryPointId entryPoint;
    private TypeDeclaration typeDecl;
    private boolean tmsEnabled;
    private boolean isEvent;
    private long expirationOffset = -1L;
    private static final ObjectTypeNodeComparator OBJECT_TYPE_NODE_COMPARATOR = new ObjectTypeNodeComparator();

    public ClassObjectTypeConf() {
    }

    public ClassObjectTypeConf(EntryPointId entryPoint, Class<?> clazz, InternalRuleBase ruleBase) {
        this.cls = InternalMatch.class.isAssignableFrom(clazz) ? ClassObjectType.Match_ObjectType.getClassType() : clazz;
        this.entryPoint = entryPoint;
        this.typeDecl = ruleBase.getTypeDeclaration(clazz);
        if (this.typeDecl != null) {
            boolean bl = this.isEvent = this.typeDecl.getRole() == Role.Type.EVENT;
            if (this.isEvent) {
                this.expirationOffset = this.typeDecl.getExpirationOffset();
            }
        } else {
            Role role = clazz.getAnnotation(Role.class);
            if (role != null) {
                Expires expires;
                boolean bl = this.isEvent = role.value() == Role.Type.EVENT;
                if (this.isEvent && (expires = clazz.getAnnotation(Expires.class)) != null) {
                    this.expirationOffset = TimeIntervalParser.parseSingle((String)expires.value());
                }
            }
        }
        this.objectType = ruleBase.getClassFieldAccessorCache().getClassObjectType(new ClassObjectType(clazz, this.isEvent), false);
        this.rete = ruleBase.getRete();
        this.concreteObjectTypeNode = this.rete.getObjectTypeNodes(entryPoint).get(this.objectType);
    }

    @Override
    public void readExternal(ObjectInput stream) throws IOException, ClassNotFoundException {
        this.rete = (Rete)stream.readObject();
        this.cls = (Class)stream.readObject();
        this.objectTypeNodes = (ObjectTypeNode[])stream.readObject();
        this.objectType = (ObjectType)stream.readObject();
        this.concreteObjectTypeNode = (ObjectTypeNode)stream.readObject();
        this.entryPoint = (EntryPointId)stream.readObject();
        this.tmsEnabled = stream.readBoolean();
        this.isEvent = stream.readBoolean();
        this.expirationOffset = stream.readLong();
    }

    @Override
    public void writeExternal(ObjectOutput stream) throws IOException {
        stream.writeObject(this.rete);
        stream.writeObject(this.cls);
        stream.writeObject(this.objectTypeNodes);
        stream.writeObject(this.objectType);
        stream.writeObject(this.concreteObjectTypeNode);
        stream.writeObject(this.entryPoint);
        stream.writeBoolean(this.tmsEnabled);
        stream.writeBoolean(this.isEvent);
        stream.writeLong(this.expirationOffset);
    }

    @Override
    public InternalFactHandle createFactHandle(FactHandleFactory factHandleFactory, long id, Object object, long recency, ReteEvaluator reteEvaluator, WorkingMemoryEntryPoint entryPoint) {
        if (this.isEvent()) {
            TypeDeclaration type = this.getTypeDeclaration();
            long timestamp = type != null && type.getTimestampExtractor() != null ? type.getTimestampExtractor().getWholeNumberValue((ValueResolver)reteEvaluator, object) : reteEvaluator.getTimerService().getCurrentTime();
            long duration = type != null && type.getDurationExtractor() != null ? type.getDurationExtractor().getWholeNumberValue((ValueResolver)reteEvaluator, object) : 0L;
            return factHandleFactory.createEventFactHandle(id, object, recency, entryPoint, timestamp, duration);
        }
        return factHandleFactory.createDefaultFactHandle(id, object, recency, entryPoint);
    }

    @Override
    public boolean isAssignableFrom(Object object) {
        return this.cls.isAssignableFrom((Class)object);
    }

    public long getExpirationOffset() {
        return this.expirationOffset;
    }

    public void setExpirationOffset(long expirationOffset) {
        this.expirationOffset = expirationOffset;
    }

    @Override
    public ObjectTypeNode getConcreteObjectTypeNode() {
        if (this.concreteObjectTypeNode == null) {
            this.concreteObjectTypeNode = this.rete.getObjectTypeNodes(this.entryPoint).get(this.objectType);
        }
        return this.concreteObjectTypeNode;
    }

    public static String getPackageName(Class<?> clazz, Package pkg) {
        String pkgName = "";
        if (pkg == null) {
            int index = clazz.getName().lastIndexOf(46);
            if (index != -1) {
                pkgName = clazz.getName().substring(0, index);
            }
        } else {
            pkgName = pkg.getName();
        }
        return pkgName;
    }

    @Override
    public void resetCache() {
        this.objectTypeNodes = null;
    }

    @Override
    public ObjectTypeNode[] getObjectTypeNodes() {
        if (this.objectTypeNodes == null) {
            this.objectTypeNodes = this.getMatchingObjectTypes(this.cls);
        }
        return this.objectTypeNodes;
    }

    private ObjectTypeNode[] getMatchingObjectTypes(Class<?> clazz) {
        ArrayList<ObjectTypeNode> cache = new ArrayList<ObjectTypeNode>();
        for (ObjectTypeNode node : this.rete.getObjectTypeNodes(this.entryPoint).values()) {
            if (!node.isAssignableFrom((ObjectType)new ClassObjectType(clazz))) continue;
            cache.add(node);
        }
        Collections.sort(cache, OBJECT_TYPE_NODE_COMPARATOR);
        return cache.toArray(new ObjectTypeNode[cache.size()]);
    }

    @Override
    public boolean isActive() {
        ObjectTypeNode otn = this.getConcreteObjectTypeNode();
        return otn != null && otn.getObjectSinkPropagator().getSinks().length > 0;
    }

    @Override
    public boolean isEvent() {
        return this.isEvent;
    }

    @Override
    public TypeDeclaration getTypeDeclaration() {
        return this.typeDecl;
    }

    @Override
    public boolean isDynamic() {
        return this.typeDecl != null && this.typeDecl.isDynamic();
    }

    @Override
    public boolean isPrototype() {
        return false;
    }

    @Override
    public boolean isTMSEnabled() {
        return this.tmsEnabled;
    }

    @Override
    public void enableTMS() {
        this.tmsEnabled = true;
    }

    @Override
    public EntryPointId getEntryPoint() {
        return this.entryPoint;
    }

    public String getClassName() {
        return this.cls != null ? this.cls.getName() : "";
    }

    @Override
    public String getTypeName() {
        return this.getClassName();
    }

    public String toString() {
        return "Class " + this.cls + " from entry-point " + this.entryPoint;
    }

    private static final class ObjectTypeNodeComparator
    implements Comparator<ObjectTypeNode> {
        private ObjectTypeNodeComparator() {
        }

        @Override
        public int compare(ObjectTypeNode o1, ObjectTypeNode o2) {
            return o1.getId() - o2.getId();
        }
    }
}

