/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.reteoo;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.drools.base.common.NetworkNode;
import org.drools.base.common.RuleBasePartitionId;
import org.drools.base.reteoo.BaseTerminalNode;
import org.drools.base.reteoo.NodeTypeEnums;
import org.drools.base.rule.IndexableConstraint;
import org.drools.base.rule.constraint.BetaConstraint;
import org.drools.base.util.index.IndexUtil;
import org.drools.core.RuleBaseConfiguration;
import org.drools.core.common.BetaConstraints;
import org.drools.core.common.DefaultFactHandle;
import org.drools.core.common.DoubleBetaConstraints;
import org.drools.core.common.DoubleNonIndexSkipBetaConstraints;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.Memory;
import org.drools.core.common.MemoryFactory;
import org.drools.core.common.PropagationContext;
import org.drools.core.common.QuadroupleBetaConstraints;
import org.drools.core.common.QuadroupleNonIndexSkipBetaConstraints;
import org.drools.core.common.ReteEvaluator;
import org.drools.core.common.SingleBetaConstraints;
import org.drools.core.common.SingleNonIndexSkipBetaConstraints;
import org.drools.core.common.TripleBetaConstraints;
import org.drools.core.common.TripleNonIndexSkipBetaConstraints;
import org.drools.core.common.UpdateContext;
import org.drools.core.phreak.DetachedTuple;
import org.drools.core.reteoo.AccumulateNode;
import org.drools.core.reteoo.BetaMemory;
import org.drools.core.reteoo.LeftTupleSink;
import org.drools.core.reteoo.LeftTupleSinkNode;
import org.drools.core.reteoo.LeftTupleSource;
import org.drools.core.reteoo.ModifyPreviousTuples;
import org.drools.core.reteoo.ObjectSink;
import org.drools.core.reteoo.ObjectTypeNode;
import org.drools.core.reteoo.ObjectTypeNodeId;
import org.drools.core.reteoo.ReteooBuilder;
import org.drools.core.reteoo.RightInputAdapterNode;
import org.drools.core.reteoo.RightTuple;
import org.drools.core.reteoo.RuleRemovalContext;
import org.drools.core.reteoo.RuleTerminalNode;
import org.drools.core.reteoo.TupleImpl;
import org.drools.core.reteoo.TupleMemory;
import org.drools.core.reteoo.TupleToObjectNode;
import org.drools.core.reteoo.builder.BuildContext;
import org.drools.core.util.FastIterator;
import org.kie.api.KieBaseConfiguration;
import org.kie.api.definition.rule.Rule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BetaNode
extends LeftTupleSource
implements LeftTupleSinkNode,
MemoryFactory {
    protected static final Logger log = LoggerFactory.getLogger(BetaNode.class);
    protected static final boolean isLogTraceEnabled = log.isTraceEnabled();
    protected RightInputAdapterNode rightInput;
    protected BetaConstraints constraints;
    private LeftTupleSinkNode previousTupleSinkNode;
    private LeftTupleSinkNode nextTupleSinkNode;
    protected boolean objectMemory = true;
    protected boolean tupleMemoryEnabled;
    protected boolean indexedUnificationJoin;
    private Collection<String> leftListenedProperties;
    private boolean indexable;

    public BetaNode() {
    }

    protected BetaNode(int id, LeftTupleSource leftInput, RightInputAdapterNode rightInput, BetaConstraints constraints, BuildContext context) {
        super(id, context);
        rightInput.setBetaNode(this);
        this.setLeftTupleSource(leftInput);
        this.rightInput = rightInput;
        this.setConstraints(constraints);
        if (this.constraints == null) {
            throw new RuntimeException("cannot have null constraints, must at least be an instance of EmptyBetaConstraints");
        }
        this.constraints.init(context, this.getType());
        this.constraints.registerEvaluationContext(context);
        this.initMasks(context);
        this.setStreamMode(context.isStreamMode() && this.getObjectTypeNode(context).getObjectType().isEvent());
        this.hashcode = this.calculateHashCode();
        this.indexable = this.constraints.getConstraints().length > 0 && IndexUtil.isIndexable((BetaConstraint)this.constraints.getConstraints()[0], (int)this.getType(), (KieBaseConfiguration)context.getRuleBase().getConfiguration());
    }

    private ObjectTypeNode getObjectTypeNode(BuildContext context) {
        ObjectTypeNode otn = this.getObjectTypeNode();
        return otn != null ? otn : context.getRootObjectTypeNode();
    }

    @Override
    protected void initDeclaredMask(BuildContext context) {
        this.rightInput.initDeclaredMask(context);
        super.initDeclaredMask(context);
    }

    @Override
    public void setPartitionId(BuildContext context, RuleBasePartitionId partitionId) {
        RuleBasePartitionId parentId = this.rightInput.getParent().getPartitionId();
        if (parentId != RuleBasePartitionId.MAIN_PARTITION && !parentId.equals((Object)partitionId)) {
            this.partitionId = parentId;
            this.rightInput.setPartitionId(context, this.partitionId);
            context.setPartitionId(this.partitionId);
            this.leftInput.setSourcePartitionId(context, this.partitionId);
        } else {
            this.partitionId = partitionId;
        }
    }

    @Override
    protected void setLeftListenedProperties(Collection<String> leftListenedProperties) {
        this.leftListenedProperties = leftListenedProperties;
    }

    @Override
    protected void initInferredMask() {
        super.initInferredMask();
        this.rightInput.initInferredMask();
    }

    private void setUnificationJoin() {
        BetaConstraint[] betaCconstraints = this.constraints.getConstraints();
        if (betaCconstraints.length > 0) {
            BetaConstraint c = betaCconstraints[0];
            if (this.indexable && ((IndexableConstraint)c).isUnification()) {
                if (this.constraints instanceof SingleBetaConstraints) {
                    this.setConstraints(new SingleNonIndexSkipBetaConstraints((SingleBetaConstraints)this.constraints));
                } else if (this.constraints instanceof DoubleBetaConstraints) {
                    this.setConstraints(new DoubleNonIndexSkipBetaConstraints((DoubleBetaConstraints)this.constraints));
                } else if (this.constraints instanceof TripleBetaConstraints) {
                    this.setConstraints(new TripleNonIndexSkipBetaConstraints((TripleBetaConstraints)this.constraints));
                } else if (this.constraints instanceof QuadroupleBetaConstraints) {
                    this.setConstraints(new QuadroupleNonIndexSkipBetaConstraints((QuadroupleBetaConstraints)this.constraints));
                }
                this.indexedUnificationJoin = true;
            }
        }
    }

    public RightInputAdapterNode getRightInput() {
        return this.rightInput;
    }

    public boolean inputIsTupleToObjectNode() {
        return this.rightInput.inputIsTupleToObjectNode();
    }

    public FastIterator<TupleImpl> getRightIterator(TupleMemory memory) {
        if (this.indexedUnificationJoin) {
            return memory.fullFastIterator();
        }
        return memory.fastIterator();
    }

    public RightTuple getFirstRightTuple(TupleImpl leftTuple, TupleMemory memory, FastIterator<TupleImpl> it) {
        if (this.indexedUnificationJoin) {
            return it.next(null);
        }
        return (RightTuple)memory.getFirst(leftTuple);
    }

    public FastIterator<TupleImpl> getLeftIterator(TupleMemory memory) {
        if (this.rightInput.inputIsTupleToObjectNode()) {
            return FastIterator.NullFastIterator.INSTANCE;
        }
        if (this.indexedUnificationJoin) {
            return memory.fullFastIterator();
        }
        return memory.fastIterator();
    }

    public TupleImpl getFirstLeftTuple(TupleImpl rightTuple, TupleMemory memory, FastIterator<TupleImpl> it) {
        if (this.rightInput.inputIsTupleToObjectNode()) {
            return this.getStartTuple(rightTuple);
        }
        if (this.indexedUnificationJoin) {
            return it.next(null);
        }
        return memory.getFirst(rightTuple);
    }

    public TupleImpl getStartTuple(TupleImpl lt) {
        LeftTupleSource startTupleSource = ((TupleToObjectNode)this.rightInput.getParent()).getStartTupleSource();
        while (lt.getIndex() != startTupleSource.getPathIndex() - 1) {
            lt = lt.getLeftParent();
        }
        while (lt.getSink() != this) {
            lt = lt.getPeer();
        }
        return lt;
    }

    public static TupleImpl getFirstTuple(TupleMemory memory, FastIterator<TupleImpl> it) {
        if (!memory.isIndexed()) {
            return memory.getFirst(null);
        }
        return it.next(null);
    }

    public boolean isIndexedUnificationJoin() {
        return this.indexedUnificationJoin;
    }

    public BetaConstraint[] getConstraints() {
        return this.constraints.getConstraints();
    }

    public BetaConstraints getRawConstraints() {
        return this.constraints;
    }

    private void setConstraints(BetaConstraints constraints) {
        this.constraints = (BetaConstraints)constraints.cloneIfInUse();
    }

    @Override
    public void networkUpdated(UpdateContext updateContext) {
        updateContext.startVisitNode(this.leftInput);
        this.rightInput.networkUpdated(updateContext);
        updateContext.endVisit();
        if (!updateContext.isVisiting(this.leftInput)) {
            this.leftInput.networkUpdated(updateContext);
        }
    }

    public List<String> getRules() {
        LeftTupleSink[] sinks;
        ArrayList<String> list = new ArrayList<String>();
        for (LeftTupleSink sink1 : sinks = this.sink.getSinks()) {
            if (sink1.getType() == 5900720) {
                list.add(((RuleTerminalNode)sink1).getRule().getName());
                continue;
            }
            if (!NodeTypeEnums.isBetaNode((NetworkNode)sink1)) continue;
            list.addAll(((BetaNode)sink1).getRules());
        }
        return list;
    }

    @Override
    public ObjectTypeNode getObjectTypeNode() {
        return this.rightInput.getObjectTypeNode();
    }

    @Override
    public void doAttach(BuildContext context) {
        super.doAttach(context);
        this.setUnificationJoin();
        this.rightInput.doAttach(context);
        this.leftInput.addTupleSink(this, context);
    }

    public static BetaMemory getBetaMemory(NetworkNode node, ReteEvaluator reteEvaluator) {
        BetaMemory bm = node.getType() == 11799092 ? ((AccumulateNode.AccumulateMemory)reteEvaluator.getNodeMemory((AccumulateNode)node)).getBetaMemory() : (BetaMemory)reteEvaluator.getNodeMemory((BetaNode)node);
        return bm;
    }

    public boolean isObjectMemoryEnabled() {
        return this.objectMemory;
    }

    @Override
    public boolean isLeftTupleMemoryEnabled() {
        return this.tupleMemoryEnabled;
    }

    public Memory createMemory(RuleBaseConfiguration config, ReteEvaluator reteEvaluator) {
        return this.constraints.createBetaMemory(config, this.getType());
    }

    @Override
    public String toString() {
        return "[ " + this.getClass().getSimpleName() + "(" + this.id + ") ]";
    }

    protected int calculateHashCode() {
        int hash = 23 * this.leftInput.hashCode() + 29 * this.rightInput.hashCode() + 31 * this.constraints.hashCode();
        if (this.leftListenedProperties != null) {
            hash += 37 * this.leftListenedProperties.hashCode();
        }
        return hash;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!NodeTypeEnums.isBetaNode((NetworkNode)((NetworkNode)object)) || this.hashCode() != object.hashCode()) {
            return false;
        }
        BetaNode other = (BetaNode)object;
        return this.getClass() == other.getClass() && this.constraints.equals(other.constraints) && this.rightInput.equals(other.rightInput) && Objects.equals(this.leftListenedProperties, other.leftListenedProperties) && this.leftInput.getId() == other.leftInput.getId();
    }

    @Override
    public LeftTupleSinkNode getNextLeftTupleSinkNode() {
        return this.nextTupleSinkNode;
    }

    @Override
    public void setNextLeftTupleSinkNode(LeftTupleSinkNode next) {
        this.nextTupleSinkNode = next;
    }

    @Override
    public LeftTupleSinkNode getPreviousLeftTupleSinkNode() {
        return this.previousTupleSinkNode;
    }

    @Override
    public void setPreviousLeftTupleSinkNode(LeftTupleSinkNode previous) {
        this.previousTupleSinkNode = previous;
    }

    @Override
    public boolean doRemove(RuleRemovalContext context, ReteooBuilder builder) {
        if (!this.isInUse()) {
            this.getLeftTupleSource().removeTupleSink(this);
            return true;
        }
        return false;
    }

    @Override
    public void addAssociation(Rule rule, BuildContext context) {
        super.addAssociation(rule, context);
        this.rightInput.addAssociation(rule, context);
    }

    @Override
    public boolean removeAssociation(Rule rule, RuleRemovalContext context) {
        boolean result = super.removeAssociation(rule, context);
        this.rightInput.removeAssociation(rule, context);
        return result;
    }

    @Override
    public void addAssociatedTerminal(BaseTerminalNode terminalNode) {
        super.addAssociatedTerminal(terminalNode);
        this.rightInput.addAssociatedTerminal(terminalNode);
    }

    @Override
    public void removeAssociatedTerminal(BaseTerminalNode terminalNode) {
        super.removeAssociatedTerminal(terminalNode);
        this.rightInput.removeAssociatedTerminal(terminalNode);
    }

    public static class RightTupleSinkAdapter
    implements ObjectSink {
        private BetaNode bnNode;
        private List<DetachedTuple> detachedTuples;

        public RightTupleSinkAdapter(BetaNode bnNode, List<DetachedTuple> detachedTuples) {
            this.bnNode = bnNode;
            this.detachedTuples = detachedTuples;
        }

        public RightTupleSinkAdapter() {
        }

        @Override
        public void assertObject(InternalFactHandle factHandle, PropagationContext context, ReteEvaluator reteEvaluator) {
            ObjectTypeNodeId otnId = this.bnNode.getRightInput().getInputOtnId();
            TupleImpl detached = factHandle.getLinkedTuples().detachRightTupleAfter(this.getPartitionId(), otnId);
            if (detached != null) {
                this.detachedTuples.add(new DetachedTuple((DefaultFactHandle)factHandle, detached));
            }
            this.bnNode.getRightInput().assertObject(factHandle, context, reteEvaluator);
        }

        @Override
        public void modifyObject(InternalFactHandle factHandle, ModifyPreviousTuples modifyPreviousTuples, PropagationContext context, ReteEvaluator reteEvaluator) {
            throw new UnsupportedOperationException("ObjectSinkAdapter onlys supports assertObject method calls");
        }

        public int getId() {
            return 0;
        }

        public RuleBasePartitionId getPartitionId() {
            return this.bnNode.getPartitionId();
        }

        @Override
        public void byPassModifyToBetaNode(InternalFactHandle factHandle, ModifyPreviousTuples modifyPreviousTuples, PropagationContext context, ReteEvaluator reteEvaluator) {
            throw new UnsupportedOperationException();
        }

        public int getType() {
            return 6883436;
        }

        public Rule[] getAssociatedRules() {
            return this.bnNode.getAssociatedRules();
        }

        public boolean isAssociatedWith(Rule rule) {
            return this.bnNode.isAssociatedWith(rule);
        }

        public NetworkNode[] getSinks() {
            return new NetworkNode[0];
        }

        public void addAssociatedTerminal(BaseTerminalNode terminalNode) {
            this.bnNode.addAssociatedTerminal(terminalNode);
        }

        public void removeAssociatedTerminal(BaseTerminalNode terminalNode) {
            this.bnNode.removeAssociatedTerminal(terminalNode);
        }

        public int getAssociatedTerminalsSize() {
            return this.bnNode.getAssociatedTerminalsSize();
        }

        public boolean hasAssociatedTerminal(BaseTerminalNode terminalNode) {
            return this.bnNode.hasAssociatedTerminal(terminalNode);
        }
    }
}

