/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.reteoo;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Objects;
import org.drools.base.common.NetworkNode;
import org.drools.base.rule.AsyncSend;
import org.drools.base.rule.accessor.DataProvider;
import org.drools.base.rule.constraint.AlphaNodeFieldConstraint;
import org.drools.core.RuleBaseConfiguration;
import org.drools.core.common.BetaConstraints;
import org.drools.core.common.EmptyBetaConstraints;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.Memory;
import org.drools.core.common.MemoryFactory;
import org.drools.core.common.PropagationContext;
import org.drools.core.common.ReteEvaluator;
import org.drools.core.common.UpdateContext;
import org.drools.core.reteoo.BetaMemory;
import org.drools.core.reteoo.ClassObjectTypeConf;
import org.drools.core.reteoo.LeftTupleSinkNode;
import org.drools.core.reteoo.LeftTupleSource;
import org.drools.core.reteoo.ObjectTypeConf;
import org.drools.core.reteoo.ObjectTypeNode;
import org.drools.core.reteoo.ReteooBuilder;
import org.drools.core.reteoo.RuleRemovalContext;
import org.drools.core.reteoo.SegmentMemory;
import org.drools.core.reteoo.SegmentNodeMemory;
import org.drools.core.reteoo.TupleImpl;
import org.drools.core.reteoo.builder.BuildContext;
import org.drools.core.util.AbstractLinkedListNode;
import org.drools.core.util.index.TupleList;

public class AsyncSendNode<T extends AsyncSendMemory>
extends LeftTupleSource
implements LeftTupleSinkNode,
MemoryFactory<T> {
    private static final long serialVersionUID = 510L;
    private String messageId;
    private DataProvider dataProvider;
    private AlphaNodeFieldConstraint[] alphaConstraints;
    private BetaConstraints betaConstraints;
    private LeftTupleSinkNode previousTupleSinkNode;
    private LeftTupleSinkNode nextTupleSinkNode;
    private AsyncSend send;
    private boolean tupleMemoryEnabled;
    private transient ObjectTypeConf objectTypeConf;

    public AsyncSendNode() {
    }

    public AsyncSendNode(int id, DataProvider dataProvider, LeftTupleSource tupleSource, AlphaNodeFieldConstraint[] constraints, BetaConstraints binder, boolean tupleMemoryEnabled, BuildContext context, AsyncSend send) {
        super(id, context);
        this.dataProvider = dataProvider;
        this.setLeftTupleSource(tupleSource);
        this.setObjectCount(this.leftInput.getObjectCount());
        this.alphaConstraints = constraints;
        this.betaConstraints = binder == null ? EmptyBetaConstraints.getInstance() : binder;
        this.betaConstraints.init(context, this.getType());
        this.tupleMemoryEnabled = tupleMemoryEnabled;
        this.send = send;
        this.messageId = send.getMessageId();
        this.initMasks(context);
        this.hashcode = this.calculateHashCode();
    }

    private int calculateHashCode() {
        int hash = 23 * this.leftInput.hashCode() + 29 * this.dataProvider.hashCode();
        if (this.send.getResultPattern() != null) {
            hash += 31 * this.send.getResultPattern().hashCode();
        }
        if (this.alphaConstraints != null) {
            hash += 37 * Arrays.hashCode(this.alphaConstraints);
        }
        if (this.betaConstraints != null) {
            hash += 41 * this.betaConstraints.hashCode();
        }
        return hash;
    }

    public String getMessageId() {
        return this.messageId;
    }

    @Override
    public String toString() {
        return "[AsyncSendNode(" + this.id + "): messageId=" + this.messageId + "]";
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (((NetworkNode)object).getType() != 8194100 || this.hashCode() != object.hashCode()) {
            return false;
        }
        AsyncSendNode other = (AsyncSendNode)object;
        return this.leftInput.getId() == other.leftInput.getId() && this.dataProvider.equals(other.dataProvider) && Objects.equals(this.send.getResultPattern(), other.send.getResultPattern()) && Arrays.equals(this.alphaConstraints, other.alphaConstraints) && this.betaConstraints.equals(other.betaConstraints);
    }

    public DataProvider getDataProvider() {
        return this.dataProvider;
    }

    public AlphaNodeFieldConstraint[] getAlphaConstraints() {
        return this.alphaConstraints;
    }

    public BetaConstraints getBetaConstraints() {
        return this.betaConstraints;
    }

    public Class<?> getResultClass() {
        return this.send.getResultClass();
    }

    @Override
    public void networkUpdated(UpdateContext updateContext) {
        this.leftInput.networkUpdated(updateContext);
    }

    public InternalFactHandle createFactHandle(TupleImpl leftTuple, PropagationContext context, ReteEvaluator reteEvaluator, Object object) {
        InternalFactHandle handle = null;
        if (context.getReaderContext() != null) {
            handle = context.getReaderContext().createAsyncNodeHandle(leftTuple, reteEvaluator, object, this.getId(), this.getObjectTypeConf(reteEvaluator));
        }
        if (handle == null) {
            handle = reteEvaluator.createFactHandle(object, this.getObjectTypeConf(reteEvaluator), null);
        }
        return handle;
    }

    public ObjectTypeConf getObjectTypeConf(ReteEvaluator reteEvaluator) {
        if (this.objectTypeConf == null) {
            this.objectTypeConf = new ClassObjectTypeConf(reteEvaluator.getDefaultEntryPointId(), this.getResultClass(), reteEvaluator.getKnowledgeBase());
        }
        return this.objectTypeConf;
    }

    @Override
    public T createMemory(RuleBaseConfiguration config, ReteEvaluator reteEvaluator) {
        BetaMemory beta = new BetaMemory(new TupleList(), null, this.betaConstraints.createContext(), 8849460);
        return (T)new AsyncSendMemory(beta, this.dataProvider);
    }

    @Override
    public boolean isLeftTupleMemoryEnabled() {
        return this.tupleMemoryEnabled;
    }

    @Override
    public LeftTupleSinkNode getNextLeftTupleSinkNode() {
        return this.nextTupleSinkNode;
    }

    @Override
    public void setNextLeftTupleSinkNode(LeftTupleSinkNode next) {
        this.nextTupleSinkNode = next;
    }

    @Override
    public LeftTupleSinkNode getPreviousLeftTupleSinkNode() {
        return this.previousTupleSinkNode;
    }

    @Override
    public void setPreviousLeftTupleSinkNode(LeftTupleSinkNode previous) {
        this.previousTupleSinkNode = previous;
    }

    @Override
    public int getType() {
        return 8194100;
    }

    @Override
    public ObjectTypeNode getObjectTypeNode() {
        return this.leftInput.getObjectTypeNode();
    }

    @Override
    public void doAttach(BuildContext context) {
        super.doAttach(context);
        this.leftInput.addTupleSink(this, context);
    }

    @Override
    protected boolean doRemove(RuleRemovalContext context, ReteooBuilder builder) {
        if (!this.isInUse()) {
            this.getLeftTupleSource().removeTupleSink(this);
            return true;
        }
        return false;
    }

    public static class AsyncSendMemory
    extends AbstractLinkedListNode<Memory>
    implements Serializable,
    SegmentNodeMemory {
        private static final long serialVersionUID = 510L;
        private DataProvider dataProvider;
        private final BetaMemory betaMemory;
        public Object providerContext;

        public AsyncSendMemory(BetaMemory betaMemory, DataProvider dataProvider) {
            this.betaMemory = betaMemory;
            this.dataProvider = dataProvider;
            this.providerContext = dataProvider.createContext();
        }

        @Override
        public int getNodeType() {
            return 8194100;
        }

        @Override
        public SegmentMemory getSegmentMemory() {
            return this.betaMemory.getSegmentMemory();
        }

        @Override
        public void setSegmentMemory(SegmentMemory segmentMemory) {
            this.betaMemory.setSegmentMemory(segmentMemory);
        }

        public BetaMemory getBetaMemory() {
            return this.betaMemory;
        }

        @Override
        public void reset() {
            this.betaMemory.reset();
            this.providerContext = this.dataProvider.createContext();
        }

        @Override
        public long getNodePosMaskBit() {
            return this.betaMemory.getNodePosMaskBit();
        }

        @Override
        public void setNodePosMaskBit(long segmentPos) {
            this.betaMemory.setNodePosMaskBit(segmentPos);
        }

        @Override
        public void setNodeDirtyWithoutNotify() {
            this.betaMemory.setNodeDirtyWithoutNotify();
        }

        @Override
        public void setNodeCleanWithoutNotify() {
            this.betaMemory.setNodeCleanWithoutNotify();
        }
    }
}

