/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.phreak;

import org.drools.core.common.BetaConstraints;
import org.drools.core.common.ReteEvaluator;
import org.drools.core.common.TupleSets;
import org.drools.core.phreak.RuleNetworkEvaluator;
import org.drools.core.reteoo.BetaMemory;
import org.drools.core.reteoo.JoinNode;
import org.drools.core.reteoo.LeftTupleSink;
import org.drools.core.reteoo.RightTuple;
import org.drools.core.reteoo.TupleFactory;
import org.drools.core.reteoo.TupleImpl;
import org.drools.core.reteoo.TupleMemory;
import org.drools.core.util.AbstractHashTable;
import org.drools.core.util.FastIterator;

public class PhreakJoinNode {
    public void doNode(JoinNode joinNode, LeftTupleSink sink, BetaMemory bm, ReteEvaluator reteEvaluator, TupleSets srcLeftTuples, TupleSets trgLeftTuples, TupleSets stagedLeftTuples) {
        TupleSets srcRightTuples = bm.getStagedRightTuples().takeAll();
        if (srcRightTuples.getDeleteFirst() != null) {
            this.doRightDeletes(bm, srcRightTuples, trgLeftTuples, stagedLeftTuples);
        }
        if (srcLeftTuples.getDeleteFirst() != null) {
            this.doLeftDeletes(bm, srcLeftTuples, trgLeftTuples, stagedLeftTuples);
        }
        if (srcRightTuples.getUpdateFirst() != null) {
            RuleNetworkEvaluator.doUpdatesReorderRightMemory(bm, srcRightTuples);
        }
        if (srcLeftTuples.getUpdateFirst() != null) {
            RuleNetworkEvaluator.doUpdatesReorderLeftMemory(bm, srcLeftTuples);
        }
        if (srcRightTuples.getUpdateFirst() != null) {
            this.doRightUpdates(joinNode, sink, bm, reteEvaluator, srcRightTuples, trgLeftTuples, stagedLeftTuples);
        }
        if (srcLeftTuples.getUpdateFirst() != null) {
            this.doLeftUpdates(joinNode, sink, bm, reteEvaluator, srcLeftTuples, trgLeftTuples, stagedLeftTuples);
        }
        if (srcRightTuples.getInsertFirst() != null) {
            this.doRightInserts(joinNode, sink, bm, reteEvaluator, srcRightTuples, trgLeftTuples);
        }
        if (srcLeftTuples.getInsertFirst() != null) {
            this.doLeftInserts(joinNode, sink, bm, reteEvaluator, srcLeftTuples, trgLeftTuples);
        }
        srcRightTuples.resetAll();
        srcLeftTuples.resetAll();
    }

    public void doLeftInserts(JoinNode joinNode, LeftTupleSink sink, BetaMemory<?> bm, ReteEvaluator reteEvaluator, TupleSets srcLeftTuples, TupleSets trgLeftTuples) {
        TupleMemory ltm = bm.getLeftTupleMemory();
        TupleMemory rtm = bm.getRightTupleMemory();
        Object contextEntry = bm.getContext();
        BetaConstraints constraints = joinNode.getRawConstraints();
        TupleImpl leftTuple = srcLeftTuples.getInsertFirst();
        while (leftTuple != null) {
            TupleImpl next = leftTuple.getStagedNext();
            boolean useLeftMemory = RuleNetworkEvaluator.useLeftMemory(joinNode, leftTuple);
            if (useLeftMemory) {
                ltm.add(leftTuple);
            }
            FastIterator<TupleImpl> it = joinNode.getRightIterator(rtm);
            constraints.updateFromTuple(contextEntry, reteEvaluator, leftTuple);
            TupleImpl rightTuple = joinNode.getFirstRightTuple(leftTuple, rtm, it);
            while (rightTuple != null) {
                if (constraints.isAllowedCachedLeft(contextEntry, rightTuple.getFactHandle())) {
                    PhreakJoinNode.insertChildLeftTuple(trgLeftTuples, leftTuple, rightTuple, null, null, sink, useLeftMemory);
                }
                rightTuple = it.next(rightTuple);
            }
            leftTuple.clearStaged();
            leftTuple = next;
        }
        constraints.resetTuple(contextEntry);
    }

    public void doRightInserts(JoinNode joinNode, LeftTupleSink sink, BetaMemory<?> bm, ReteEvaluator reteEvaluator, TupleSets srcRightTuples, TupleSets trgLeftTuples) {
        TupleMemory ltm = bm.getLeftTupleMemory();
        TupleMemory rtm = bm.getRightTupleMemory();
        Object contextEntry = bm.getContext();
        BetaConstraints constraints = joinNode.getRawConstraints();
        if (srcRightTuples.getInsertSize() > 32 && rtm instanceof AbstractHashTable) {
            ((AbstractHashTable)((Object)rtm)).ensureCapacity(srcRightTuples.getInsertSize());
        }
        TupleImpl rightTuple = srcRightTuples.getInsertFirst();
        while (rightTuple != null) {
            TupleImpl next = rightTuple.getStagedNext();
            rtm.add(rightTuple);
            if (ltm != null && ltm.size() > 0) {
                FastIterator<TupleImpl> it = joinNode.getLeftIterator(ltm);
                constraints.updateFromFactHandle(contextEntry, reteEvaluator, rightTuple.getFactHandleForEvaluation());
                TupleImpl leftTuple = joinNode.getFirstLeftTuple(rightTuple, ltm, it);
                while (leftTuple != null) {
                    if (leftTuple.getStagedType() != 2 && constraints.isAllowedCachedRight(leftTuple, contextEntry)) {
                        PhreakJoinNode.insertChildLeftTuple(trgLeftTuples, leftTuple, rightTuple, null, null, sink, true);
                    }
                    leftTuple = it.next(leftTuple);
                }
            }
            rightTuple.clearStaged();
            rightTuple = next;
        }
        constraints.resetFactHandle(contextEntry);
    }

    public void doLeftUpdates(JoinNode joinNode, LeftTupleSink sink, BetaMemory<?> bm, ReteEvaluator reteEvaluator, TupleSets srcLeftTuples, TupleSets trgLeftTuples, TupleSets stagedLeftTuples) {
        TupleMemory rtm = bm.getRightTupleMemory();
        Object contextEntry = bm.getContext();
        BetaConstraints constraints = joinNode.getRawConstraints();
        TupleImpl leftTuple = srcLeftTuples.getUpdateFirst();
        while (leftTuple != null) {
            TupleImpl next = leftTuple.getStagedNext();
            constraints.updateFromTuple(contextEntry, reteEvaluator, leftTuple);
            FastIterator<TupleImpl> it = joinNode.getRightIterator(rtm);
            RightTuple rightTuple = joinNode.getFirstRightTuple(leftTuple, rtm, it);
            if (rtm.isIndexed() && !it.isFullIterator()) {
                TupleImpl childLeftTuple = leftTuple.getFirstChild();
                while (childLeftTuple != null) {
                    TupleImpl nextChild = childLeftTuple.getHandleNext();
                    if (rightTuple == null || rightTuple.getMemory() != childLeftTuple.getRightParent().getMemory()) {
                        RuleNetworkEvaluator.unlinkAndDeleteChildLeftTuple(childLeftTuple, trgLeftTuples, stagedLeftTuples);
                    }
                    childLeftTuple = nextChild;
                }
            }
            if (rightTuple != null) {
                this.doLeftUpdatesProcessChildren(leftTuple.getFirstChild(), leftTuple, rightTuple, stagedLeftTuples, contextEntry, constraints, sink, it, trgLeftTuples);
            }
            leftTuple.clearStaged();
            leftTuple = next;
        }
        constraints.resetTuple(contextEntry);
    }

    public TupleImpl doLeftUpdatesProcessChildren(TupleImpl childLeftTuple, TupleImpl leftTuple, TupleImpl rightTuple, TupleSets stagedLeftTuples, Object contextEntry, BetaConstraints constraints, LeftTupleSink sink, FastIterator<TupleImpl> it, TupleSets trgLeftTuples) {
        if (childLeftTuple == null) {
            while (rightTuple != null) {
                if (constraints.isAllowedCachedLeft(contextEntry, rightTuple.getFactHandle())) {
                    PhreakJoinNode.insertChildLeftTuple(trgLeftTuples, leftTuple, rightTuple, null, null, sink, true);
                }
                rightTuple = it.next(rightTuple);
            }
        } else {
            while (rightTuple != null) {
                if (constraints.isAllowedCachedLeft(contextEntry, rightTuple.getFactHandle())) {
                    if (childLeftTuple == null || childLeftTuple.getRightParent() != rightTuple) {
                        PhreakJoinNode.insertChildLeftTuple(trgLeftTuples, leftTuple, rightTuple, childLeftTuple, null, sink, true);
                    } else {
                        childLeftTuple.setPropagationContext(rightTuple.getPropagationContext());
                        PhreakJoinNode.updateChildLeftTuple(childLeftTuple, stagedLeftTuples, trgLeftTuples);
                        TupleImpl nextChildLeftTuple = childLeftTuple.getHandleNext();
                        childLeftTuple.reAddRight();
                        childLeftTuple = nextChildLeftTuple;
                    }
                } else if (childLeftTuple != null && childLeftTuple.getRightParent() == rightTuple) {
                    TupleImpl nextChild = childLeftTuple.getHandleNext();
                    RuleNetworkEvaluator.unlinkAndDeleteChildLeftTuple(childLeftTuple, trgLeftTuples, stagedLeftTuples);
                    childLeftTuple = nextChild;
                }
                rightTuple = it.next(rightTuple);
            }
        }
        return childLeftTuple;
    }

    public void doRightUpdates(JoinNode joinNode, LeftTupleSink sink, BetaMemory bm, ReteEvaluator reteEvaluator, TupleSets srcRightTuples, TupleSets trgLeftTuples, TupleSets stagedLeftTuples) {
        TupleMemory ltm = bm.getLeftTupleMemory();
        Object contextEntry = bm.getContext();
        BetaConstraints constraints = joinNode.getRawConstraints();
        TupleImpl rightTuple = srcRightTuples.getUpdateFirst();
        while (rightTuple != null) {
            TupleImpl next = rightTuple.getStagedNext();
            if (ltm != null && ltm.size() > 0) {
                FastIterator<TupleImpl> it = joinNode.getLeftIterator(ltm);
                TupleImpl leftTuple = joinNode.getFirstLeftTuple(rightTuple, ltm, it);
                constraints.updateFromFactHandle(contextEntry, reteEvaluator, rightTuple.getFactHandleForEvaluation());
                TupleImpl childLeftTuple = rightTuple.getFirstChild();
                if (childLeftTuple != null && ltm.isIndexed() && !it.isFullIterator() && (leftTuple == null || leftTuple.getMemory() != childLeftTuple.getLeftParent().getMemory())) {
                    while (childLeftTuple != null) {
                        childLeftTuple.setPropagationContext(rightTuple.getPropagationContext());
                        TupleImpl nextChild = childLeftTuple.getRightParentNext();
                        RuleNetworkEvaluator.unlinkAndDeleteChildLeftTuple(childLeftTuple, trgLeftTuples, stagedLeftTuples);
                        childLeftTuple = nextChild;
                    }
                }
                if (leftTuple != null) {
                    this.doRightUpdatesProcessChildren(childLeftTuple, leftTuple, rightTuple, stagedLeftTuples, contextEntry, constraints, sink, it, trgLeftTuples);
                }
            }
            rightTuple.clearStaged();
            rightTuple = next;
        }
        constraints.resetFactHandle(contextEntry);
    }

    public TupleImpl doRightUpdatesProcessChildren(TupleImpl childLeftTuple, TupleImpl leftTuple, TupleImpl rightTuple, TupleSets stagedLeftTuples, Object contextEntry, BetaConstraints constraints, LeftTupleSink sink, FastIterator it, TupleSets trgLeftTuples) {
        if (childLeftTuple == null) {
            while (leftTuple != null) {
                if (leftTuple.getStagedType() != 2 && constraints.isAllowedCachedRight(leftTuple, contextEntry)) {
                    PhreakJoinNode.insertChildLeftTuple(trgLeftTuples, leftTuple, rightTuple, null, null, sink, true);
                }
                leftTuple = it.next(leftTuple);
            }
        } else {
            while (leftTuple != null) {
                if (leftTuple.getStagedType() != 2) {
                    if (constraints.isAllowedCachedRight(leftTuple, contextEntry)) {
                        if (childLeftTuple == null || childLeftTuple.getLeftParent() != leftTuple) {
                            PhreakJoinNode.insertChildLeftTuple(trgLeftTuples, leftTuple, rightTuple, null, childLeftTuple, sink, true);
                        } else {
                            childLeftTuple.setPropagationContext(rightTuple.getPropagationContext());
                            PhreakJoinNode.updateChildLeftTuple(childLeftTuple, stagedLeftTuples, trgLeftTuples);
                            TupleImpl nextChildLeftTuple = childLeftTuple.getRightParentNext();
                            childLeftTuple.reAddLeft();
                            childLeftTuple = nextChildLeftTuple;
                        }
                    } else if (childLeftTuple != null && childLeftTuple.getLeftParent() == leftTuple) {
                        childLeftTuple.setPropagationContext(rightTuple.getPropagationContext());
                        TupleImpl nextChild = childLeftTuple.getRightParentNext();
                        RuleNetworkEvaluator.unlinkAndDeleteChildLeftTuple(childLeftTuple, trgLeftTuples, stagedLeftTuples);
                        childLeftTuple = nextChild;
                    }
                }
                leftTuple = it.next(leftTuple);
            }
        }
        return childLeftTuple;
    }

    public void doLeftDeletes(BetaMemory bm, TupleSets srcLeftTuples, TupleSets trgLeftTuples, TupleSets stagedLeftTuples) {
        TupleMemory ltm = bm.getLeftTupleMemory();
        TupleImpl leftTuple = srcLeftTuples.getDeleteFirst();
        while (leftTuple != null) {
            TupleImpl next = leftTuple.getStagedNext();
            if (leftTuple.getMemory() != null) {
                ltm.remove(leftTuple);
            }
            if (leftTuple.getFirstChild() != null) {
                TupleImpl childLeftTuple = leftTuple.getFirstChild();
                while (childLeftTuple != null) {
                    TupleImpl nextChild = childLeftTuple.getHandleNext();
                    RuleNetworkEvaluator.unlinkAndDeleteChildLeftTuple(childLeftTuple, trgLeftTuples, stagedLeftTuples);
                    childLeftTuple = nextChild;
                }
            }
            leftTuple.clearStaged();
            leftTuple = next;
        }
    }

    public void doRightDeletes(BetaMemory bm, TupleSets srcRightTuples, TupleSets trgLeftTuples, TupleSets stagedLeftTuples) {
        TupleMemory rtm = bm.getRightTupleMemory();
        TupleImpl rightTuple = srcRightTuples.getDeleteFirst();
        while (rightTuple != null) {
            TupleImpl next = rightTuple.getStagedNext();
            if (rightTuple.getMemory() != null) {
                rtm.remove(rightTuple);
            }
            if (rightTuple.getFirstChild() != null) {
                TupleImpl childLeftTuple = rightTuple.getFirstChild();
                childLeftTuple.setPropagationContext(rightTuple.getPropagationContext());
                while (childLeftTuple != null) {
                    TupleImpl nextChild = childLeftTuple.getRightParentNext();
                    RuleNetworkEvaluator.unlinkAndDeleteChildLeftTuple(childLeftTuple, trgLeftTuples, stagedLeftTuples);
                    childLeftTuple = nextChild;
                }
            }
            rightTuple.clearStaged();
            rightTuple = next;
        }
    }

    public static void updateChildLeftTuple(TupleImpl childLeftTuple, TupleSets stagedLeftTuples, TupleSets trgLeftTuples) {
        if (!childLeftTuple.isStagedOnRight()) {
            switch (childLeftTuple.getStagedType()) {
                case 1: {
                    stagedLeftTuples.removeInsert(childLeftTuple);
                    trgLeftTuples.addInsert(childLeftTuple);
                    break;
                }
                case 2: {
                    stagedLeftTuples.removeUpdate(childLeftTuple);
                    trgLeftTuples.addUpdate(childLeftTuple);
                    break;
                }
                default: {
                    trgLeftTuples.addUpdate(childLeftTuple);
                }
            }
        }
    }

    private static void insertChildLeftTuple(TupleSets trgLeftTuples, TupleImpl leftTuple, TupleImpl rightTuple, TupleImpl currentLeftChild, TupleImpl currentRightChild, LeftTupleSink sink, boolean leftTupleMemoryEnabled) {
        if (!leftTuple.isExpired() && !rightTuple.isExpired()) {
            trgLeftTuples.addInsert(TupleFactory.createLeftTuple(leftTuple, rightTuple, currentLeftChild, currentRightChild, sink, leftTupleMemoryEnabled));
        }
    }
}

