/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.phreak;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.drools.base.common.NetworkNode;
import org.drools.base.reteoo.BaseTerminalNode;
import org.drools.base.reteoo.NodeTypeEnums;
import org.drools.core.WorkingMemory;
import org.drools.core.common.BaseNode;
import org.drools.core.common.DefaultEventHandle;
import org.drools.core.common.InternalAgenda;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.common.Memory;
import org.drools.core.common.PropagationContext;
import org.drools.core.common.PropagationContextFactory;
import org.drools.core.common.SuperCacheFixer;
import org.drools.core.common.TupleSets;
import org.drools.core.impl.InternalRuleBase;
import org.drools.core.phreak.BuildtimeSegmentUtilities;
import org.drools.core.phreak.DetachedTuple;
import org.drools.core.phreak.LazyPhreakBuilder;
import org.drools.core.phreak.PhreakBuilder;
import org.drools.core.phreak.PhreakRuleTerminalNode;
import org.drools.core.phreak.RuleAgendaItem;
import org.drools.core.phreak.RuntimeSegmentUtilities;
import org.drools.core.reteoo.AccumulateNode;
import org.drools.core.reteoo.AlphaTerminalNode;
import org.drools.core.reteoo.BetaMemory;
import org.drools.core.reteoo.BetaNode;
import org.drools.core.reteoo.FromNode;
import org.drools.core.reteoo.LeftInputAdapterNode;
import org.drools.core.reteoo.LeftTuple;
import org.drools.core.reteoo.LeftTupleNode;
import org.drools.core.reteoo.LeftTupleSinkNode;
import org.drools.core.reteoo.LeftTupleSource;
import org.drools.core.reteoo.ObjectSink;
import org.drools.core.reteoo.ObjectTypeNode;
import org.drools.core.reteoo.PathEndNode;
import org.drools.core.reteoo.PathMemory;
import org.drools.core.reteoo.QueryElementNode;
import org.drools.core.reteoo.RightInputAdapterNode;
import org.drools.core.reteoo.RightTuple;
import org.drools.core.reteoo.RuleTerminalNodeLeftTuple;
import org.drools.core.reteoo.RuntimeComponentFactory;
import org.drools.core.reteoo.SegmentMemory;
import org.drools.core.reteoo.SegmentNodeMemory;
import org.drools.core.reteoo.TerminalNode;
import org.drools.core.reteoo.TupleFactory;
import org.drools.core.reteoo.TupleImpl;
import org.drools.core.reteoo.TupleMemory;
import org.drools.core.reteoo.TupleToObjectNode;
import org.drools.core.reteoo.WindowNode;
import org.drools.core.util.FastIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EagerPhreakBuilder
implements PhreakBuilder {
    private static final Logger log = LoggerFactory.getLogger(EagerPhreakBuilder.class);

    @Override
    public void addRule(TerminalNode tn, Collection<InternalWorkingMemory> wms, InternalRuleBase kBase) {
        if (log.isTraceEnabled()) {
            log.trace("Adding Rule {}", (Object)tn.getRule().getName());
        }
        for (InternalWorkingMemory wm2 : wms) {
            wm2.flushPropagations();
        }
        HashSet<SegmentMemoryPair> smemsToNotify = new HashSet<SegmentMemoryPair>();
        HashSet<Integer> visited = new HashSet<Integer>();
        if (tn.getPathNodes()[0].getAssociatedTerminalsSize() == 1) {
            BuildtimeSegmentUtilities.createPathProtoMemories(tn, null, kBase);
            wms.forEach(wm -> Add.insertLiaFacts(tn.getPathNodes()[0], wm, visited, false));
        } else {
            List<Pair> exclBranchRoots = EagerPhreakBuilder.getExclusiveBranchRoots(tn);
            exclBranchRoots.forEach(pair -> Add.processSplit(pair.parent, kBase, wms, smemsToNotify));
            Add.addNewPaths(exclBranchRoots, tn, wms, kBase, smemsToNotify);
            exclBranchRoots.forEach(pair -> EagerPhreakBuilder.processLeftTuples(pair.parent, true, tn, wms));
        }
        for (InternalWorkingMemory wm3 : wms) {
            Add.addExistingSegmentMemories(Arrays.asList(tn.getPathEndNodes()), wm3);
            Add.insertFacts(tn, wm3, visited, false);
        }
        smemsToNotify.forEach(pair -> pair.sm.notifyRuleLinkSegment(pair.wm));
    }

    @Override
    public void removeRule(TerminalNode tn, Collection<InternalWorkingMemory> wms, InternalRuleBase kBase) {
        PathMemory pmem;
        if (log.isTraceEnabled()) {
            log.trace("Removing Rule {}", (Object)tn.getRule().getName());
        }
        for (InternalWorkingMemory internalWorkingMemory : wms) {
            internalWorkingMemory.flushPropagations();
        }
        List<Pair> exclBranchRoots = EagerPhreakBuilder.getExclusiveBranchRoots(tn);
        for (InternalWorkingMemory wm : wms) {
            pmem = (PathMemory)wm.getNodeMemories().peekNodeMemory(tn);
            if (pmem == null) continue;
            List<LeftTupleNode> splits = exclBranchRoots.stream().map(pair -> pair.parent).filter(Objects::nonNull).collect(Collectors.toList());
            LazyPhreakBuilder.flushStagedTuples(wm, tn, pmem, splits);
        }
        if (exclBranchRoots.isEmpty()) {
            LeftTupleNode leftTupleNode = tn.getPathNodes()[0];
            EagerPhreakBuilder.processLeftTuples(leftTupleNode, false, tn, wms);
            Remove.removeExistingPaths(exclBranchRoots, tn, wms, kBase);
        } else {
            exclBranchRoots.forEach(pair -> EagerPhreakBuilder.processLeftTuples(pair.parent, false, tn, wms));
            Remove.removeExistingPaths(exclBranchRoots, tn, wms, kBase);
            HashSet hashSet = new HashSet();
            exclBranchRoots.forEach(pair -> Remove.processMerges(pair.parent, tn, kBase, wms, visited));
        }
        for (InternalWorkingMemory wm : wms) {
            pmem = (PathMemory)wm.getNodeMemories().peekNodeMemory(tn);
            if (pmem == null || !pmem.isInitialized() || !pmem.getRuleAgendaItem().isQueued()) continue;
            pmem.getRuleAgendaItem().dequeue();
        }
    }

    public static void notifyImpactedSegments(SegmentMemory smem, InternalWorkingMemory wm, Set<SegmentMemoryPair> segmentsToNotify) {
        if (smem.getAllLinkedMaskTest() > 0L) {
            segmentsToNotify.add(new SegmentMemoryPair(smem, wm));
        }
    }

    public static List<Pair> getExclusiveBranchRoots(TerminalNode tn) {
        ArrayList<Pair> exclbranchRoots = new ArrayList<Pair>();
        HashSet visited = new HashSet();
        Arrays.stream(tn.getPathEndNodes()).forEach(endNode -> {
            LeftTupleNode node = endNode;
            if (node.getAssociatedTerminalsSize() > 1) {
                return;
            }
            while (node.getLeftTupleSource() != null) {
                if (NodeTypeEnums.isBetaNodeWithSubnetwork((NetworkNode)node) && ((BetaNode)node).getRightInput().getParent().getAssociatedTerminalsSize() > 1) {
                    exclbranchRoots.add(new Pair((LeftTupleNode)((Object)((BetaNode)node).getRightInput().getParent()), node));
                }
                if (node.getLeftTupleSource().getAssociatedTerminalsSize() > 1) {
                    if (visited.add(node.getId())) {
                        exclbranchRoots.add(new Pair(node.getLeftTupleSource(), node));
                    }
                    return;
                }
                node = node.getLeftTupleSource();
            }
        });
        return exclbranchRoots;
    }

    public static boolean isInsideSubnetwork(PathEndNode endNode, SegmentMemory.SegmentPrototype smproto) {
        return smproto.getRootNode().getPathIndex() >= endNode.getStartTupleSource().getPathIndex();
    }

    private static void correctMemoryOnSplitsChanged(LeftTupleNode splitStart, InternalWorkingMemory wm) {
        QueryElementNode.QueryElementNodeMemory mem;
        if (splitStart.getType() == 9832500 && (mem = (QueryElementNode.QueryElementNodeMemory)wm.getNodeMemories().peekNodeMemory(splitStart)) != null) {
            mem.correctMemoryOnSinksChanged(null);
        }
    }

    private static void processLeftTuples(LeftTupleNode node, boolean insert, TerminalNode tn, Collection<InternalWorkingMemory> wms) {
        for (InternalWorkingMemory wm : wms) {
            if (node.getType() == 7211116) {
                EagerPhreakBuilder.processLeftTuplesOnLian(wm, insert, tn, (LeftInputAdapterNode)node);
                return;
            }
            Memory memory = wm.getNodeMemories().peekNodeMemory(node);
            if (memory == null || memory.getSegmentMemory() == null) {
                return;
            }
            HashSet<LeftTupleNode> visited = new HashSet<LeftTupleNode>();
            while (!NodeTypeEnums.isLeftInputAdapterNode((NetworkNode)node)) {
                if (!visited.add(node)) {
                    return;
                }
                if (NodeTypeEnums.isBetaNode((NetworkNode)node)) {
                    if (11799092 == node.getType()) {
                        AccumulateNode.AccumulateMemory am = (AccumulateNode.AccumulateMemory)memory;
                        BetaMemory bm = am.getBetaMemory();
                        FastIterator<TupleImpl> it = bm.getLeftTupleMemory().fullFastIterator();
                        TupleImpl lt = BetaNode.getFirstTuple(bm.getLeftTupleMemory(), it);
                        while (lt != null) {
                            AccumulateNode.AccumulateContext accctx = (AccumulateNode.AccumulateContext)lt.getContextObject();
                            EagerPhreakBuilder.visitChild((TupleImpl)accctx.getResultLeftTuple(), insert, wm, tn);
                            lt = it.next(lt);
                        }
                    } else if (11471412 == node.getType() && !((BetaNode)node).getRightInput().inputIsTupleToObjectNode()) {
                        BetaMemory bm = (BetaMemory)wm.getNodeMemories().peekNodeMemory(node);
                        if (bm != null) {
                            FastIterator<TupleImpl> it = bm.getRightTupleMemory().fullFastIterator();
                            RightTuple rt = (RightTuple)BetaNode.getFirstTuple(bm.getRightTupleMemory(), it);
                            while (rt != null) {
                                for (LeftTuple lt = rt.getBlocked(); lt != null; lt = lt.getBlockedNext()) {
                                    EagerPhreakBuilder.visitChild(wm, insert, tn, it, lt);
                                }
                                rt = (RightTuple)it.next(rt);
                            }
                        }
                    } else {
                        BetaMemory bm = (BetaMemory)wm.getNodeMemories().peekNodeMemory(node);
                        if (bm != null) {
                            FastIterator<TupleImpl> it = bm.getLeftTupleMemory().fullFastIterator();
                            TupleImpl lt = BetaNode.getFirstTuple(bm.getLeftTupleMemory(), it);
                            EagerPhreakBuilder.visitChild(wm, insert, tn, it, lt);
                        }
                    }
                    return;
                }
                if (8849460 == node.getType()) {
                    FromNode.FromMemory fm = (FromNode.FromMemory)wm.getNodeMemories().peekNodeMemory(node);
                    if (fm != null) {
                        TupleMemory ltm = fm.getBetaMemory().getLeftTupleMemory();
                        FastIterator<TupleImpl> it = ltm.fullFastIterator();
                        TupleImpl lt = ltm.getFirst(null);
                        while (lt != null) {
                            EagerPhreakBuilder.visitChild(lt, insert, wm, tn);
                            lt = it.next(lt);
                        }
                    }
                    return;
                }
                node = node.getLeftTupleSource();
            }
            EagerPhreakBuilder.processLeftTuplesOnLian(wm, insert, tn, (LeftInputAdapterNode)node);
        }
    }

    private static void processLeftTuplesOnLian(InternalWorkingMemory wm, boolean insert, TerminalNode tn, LeftInputAdapterNode lian) {
        BaseNode os = lian.getObjectSource();
        while (os.getType() != 4259849) {
            os = ((BaseNode)os).getParent();
        }
        ObjectTypeNode otn = (ObjectTypeNode)os;
        Iterator<InternalFactHandle> it = otn.getFactHandlesIterator(wm);
        while (it.hasNext()) {
            InternalFactHandle fh = it.next();
            fh.forEachLeftTuple(lt -> {
                TupleImpl nextLt = lt.getHandleNext();
                if (BuildtimeSegmentUtilities.isAssociatedWith(SuperCacheFixer.getLeftTupleSource(lt), tn)) {
                    EagerPhreakBuilder.visitChild(lt, insert, wm, tn);
                    if (lt.getHandlePrevious() != null) {
                        lt.getHandlePrevious().setHandleNext(nextLt);
                        if (nextLt != null) {
                            nextLt.setHandlePrevious(lt.getHandlePrevious());
                        }
                    }
                }
            });
        }
    }

    private static void visitChild(InternalWorkingMemory wm, boolean insert, TerminalNode tn, FastIterator<TupleImpl> it, TupleImpl lt) {
        while (lt != null) {
            TupleImpl childLt = lt.getFirstChild();
            while (childLt != null) {
                TupleImpl nextLt = childLt.getHandleNext();
                EagerPhreakBuilder.visitChild(childLt, insert, wm, tn);
                childLt = nextLt;
            }
            lt = it.next(lt);
        }
    }

    private static void visitChild(TupleImpl lt, boolean insert, InternalWorkingMemory wm, TerminalNode tn) {
        TupleImpl prevLt = null;
        for (LeftTupleSinkNode sink = (LeftTupleSinkNode)lt.getSink(); sink != null; sink = sink.getNextLeftTupleSinkNode()) {
            block4: {
                block5: {
                    block6: {
                        block7: {
                            if (lt == null) break block4;
                            if (!BuildtimeSegmentUtilities.isAssociatedWith(lt.getSink(), tn)) break block5;
                            if (lt.getSink().getAssociatedTerminalsSize() <= 1) break block6;
                            if (lt.getFirstChild() == null) break block7;
                            for (TupleImpl child = lt.getFirstChild(); child != null; child = child.getHandleNext()) {
                                EagerPhreakBuilder.visitChild(child, insert, wm, tn);
                            }
                            break block5;
                        }
                        if (lt.getSink().getType() != 5245233) break block5;
                        EagerPhreakBuilder.insertPeerRightTuple(lt, wm, tn, insert);
                        break block5;
                    }
                    if (!insert) {
                        EagerPhreakBuilder.iterateLeftTuple(lt, wm);
                        TupleImpl lt2 = null;
                        for (TupleImpl peerLt = lt.getPeer(); peerLt != null && BuildtimeSegmentUtilities.isAssociatedWith(peerLt.getSink(), tn) && peerLt.getSink().getAssociatedTerminalsSize() == 1; peerLt = peerLt.getPeer()) {
                            EagerPhreakBuilder.iterateLeftTuple(peerLt, wm);
                            lt2 = peerLt;
                        }
                        EagerPhreakBuilder.deleteLeftTuple(lt, lt2, prevLt);
                        break;
                    }
                }
                prevLt = lt;
                lt = lt.getPeer();
                continue;
            }
            prevLt = EagerPhreakBuilder.insertPeerLeftTuple(prevLt, sink, wm, insert);
        }
    }

    private static void insertPeerRightTuple(TupleImpl lt, InternalWorkingMemory wm, TerminalNode tn, boolean insert) {
        TupleImpl prevLt = null;
        TupleToObjectNode tton = (TupleToObjectNode)lt.getSink();
        for (ObjectSink sink : tton.getObjectSinkPropagator().getSinks()) {
            if (lt != null) {
                if (prevLt != null && !insert && BuildtimeSegmentUtilities.isAssociatedWith(sink, tn) && sink.getAssociatedTerminalsSize() == 1) {
                    prevLt.setPeer(null);
                }
                prevLt = lt;
                lt = lt.getPeer();
                continue;
            }
            if (!insert) continue;
            Object betaNode = ((RightInputAdapterNode)sink).getBetaNode();
            BetaMemory bm = (BetaMemory)wm.getNodeMemories().peekNodeMemory((NetworkNode)betaNode);
            if (bm == null) continue;
            prevLt = TupleFactory.createPeer(tton, prevLt);
            bm.linkNode((LeftTupleSource)betaNode, wm);
            bm.getStagedRightTuples().addInsert(prevLt);
        }
    }

    private static TupleImpl insertPeerLeftTuple(TupleImpl lt, LeftTupleSinkNode node, InternalWorkingMemory wm, boolean insert) {
        Memory memory;
        TupleImpl peer = TupleFactory.createPeer(node, lt);
        if (node.getLeftTupleSource().getType() == 7211116) {
            if (insert) {
                TerminalNode rtn = (TerminalNode)node;
                InternalAgenda agenda = wm.getAgenda();
                RuleAgendaItem agendaItem = AlphaTerminalNode.getRuleAgendaItem(wm, agenda, rtn, insert);
                PhreakRuleTerminalNode.doLeftTupleInsert(rtn, agendaItem.getRuleExecutor(), agenda, agendaItem, (RuleTerminalNodeLeftTuple)peer);
            }
            return peer;
        }
        LeftInputAdapterNode.LiaNodeMemory liaMem = null;
        if (NodeTypeEnums.isLeftInputAdapterNode((NetworkNode)node.getLeftTupleSource())) {
            liaMem = (LeftInputAdapterNode.LiaNodeMemory)wm.getNodeMemories().peekNodeMemory(node.getLeftTupleSource());
        }
        if ((memory = wm.getNodeMemories().peekNodeMemory(node)) == null || memory.getSegmentMemory() == null) {
            throw new IllegalStateException("Defensive Programming: this should not be possilbe, as the addRule code should init child segments if they are needed ");
        }
        if (liaMem == null) {
            memory.getSegmentMemory().getStagedLeftTuples().addInsert(peer);
        } else {
            LeftInputAdapterNode.doInsertSegmentMemoryWithFlush(wm, true, liaMem, memory.getSegmentMemory(), peer, node.getLeftTupleSource().isStreamMode());
        }
        return peer;
    }

    private static void iterateLeftTuple(TupleImpl lt, InternalWorkingMemory wm) {
        if (NodeTypeEnums.isTerminalNode((NetworkNode)lt.getSink())) {
            PathMemory pmem = (PathMemory)wm.getNodeMemories().peekNodeMemory(lt.getSink());
            if (pmem != null) {
                PhreakRuleTerminalNode.doLeftDelete(pmem.getActualActivationsManager(wm), pmem.getRuleAgendaItem().getRuleExecutor(), (RuleTerminalNodeLeftTuple)lt);
            }
        } else {
            TupleImpl resultLt;
            if (lt.getContextObject() instanceof AccumulateNode.AccumulateContext && (resultLt = (TupleImpl)((AccumulateNode.AccumulateContext)lt.getContextObject()).getResultLeftTuple()) != null) {
                EagerPhreakBuilder.iterateLeftTuple(resultLt, wm);
            }
            for (TupleImpl child = lt.getFirstChild(); child != null; child = child.getHandleNext()) {
                for (TupleImpl peer = child; peer != null; peer = peer.getPeer()) {
                    if (peer.getPeer() != null) continue;
                    EagerPhreakBuilder.iterateLeftTuple(peer, wm);
                }
            }
        }
    }

    static void deleteLeftTuple(TupleImpl removingLt, TupleImpl removingLt2, TupleImpl prevLt) {
        TupleImpl nextPeerLt;
        boolean isFirstLt = prevLt == null;
        TupleImpl tupleImpl = nextPeerLt = removingLt2 == null ? removingLt.getPeer() : removingLt2.getPeer();
        if (!isFirstLt) {
            prevLt.setPeer(nextPeerLt);
        } else {
            if (nextPeerLt == null) {
                removingLt.unlinkFromLeftParent();
                removingLt.unlinkFromRightParent();
                return;
            }
            InternalFactHandle fh = removingLt.getFactHandle();
            TupleImpl leftPrevious = removingLt.getHandlePrevious();
            TupleImpl leftNext = removingLt.getHandleNext();
            TupleImpl rightPrevious = removingLt.getRightParentPrevious();
            TupleImpl rightNext = removingLt.getRightParentNext();
            TupleImpl leftParent = removingLt.getLeftParent();
            TupleImpl rightParent = removingLt.getRightParent();
            nextPeerLt.setFactHandle(removingLt.getFactHandle());
            if (leftPrevious != null) {
                nextPeerLt.setHandlePrevious(leftPrevious);
                leftPrevious.setHandleNext(nextPeerLt);
            }
            if (leftNext != null) {
                nextPeerLt.setHandleNext(leftNext);
                leftNext.setHandlePrevious(nextPeerLt);
            }
            if (rightPrevious != null) {
                nextPeerLt.setRightParentPrevious(rightPrevious);
                rightPrevious.setRightParentNext(nextPeerLt);
            }
            if (rightNext != null) {
                nextPeerLt.setRightParentNext(rightNext);
                rightNext.setRightParentPrevious(nextPeerLt);
            }
            if (leftParent != null) {
                nextPeerLt.setLeftParent(leftParent);
                if (leftParent.getFirstChild() == removingLt) {
                    leftParent.setFirstChild(nextPeerLt);
                }
                if (leftParent.getLastChild() == removingLt) {
                    leftParent.setLastChild(nextPeerLt);
                }
            } else {
                fh.removeLeftTuple(removingLt);
                if (leftPrevious == null && nextPeerLt.getSink().getAssociatedTerminalsSize() > 0) {
                    fh.addFirstLeftTuple(nextPeerLt);
                }
            }
            if (rightParent != null) {
                nextPeerLt.setRightParent(rightParent);
                if (rightParent.getFirstChild() == removingLt) {
                    rightParent.setFirstChild(nextPeerLt);
                }
                if (rightParent.getLastChild() == removingLt) {
                    rightParent.setLastChild(nextPeerLt);
                }
            }
        }
    }

    private static void updatePaths(SegmentMemory.SegmentPrototype proto, Collection<InternalWorkingMemory> wms, PathEndNode endNode, SegmentMemory.SegmentPrototype[] newList) {
        PathEndNode.PathMemSpec spec = endNode.getPathMemSpec();
        spec.update(BuildtimeSegmentUtilities.getPathAllLinkedMaskTest(endNode.getSegmentPrototypes(), endNode), endNode.getSegmentPrototypes().length);
        for (WorkingMemory workingMemory : wms) {
            PathMemory pmem = (PathMemory)workingMemory.getNodeMemories().peekNodeMemory(endNode);
            if (pmem == null) continue;
            pmem.setAllLinkedMaskTest(spec.allLinkedTestMask());
            SegmentMemory[] newSmems = new SegmentMemory[newList.length];
            for (int i = 0; i < newList.length; ++i) {
                SegmentMemory.SegmentPrototype smproto = newList[i];
                if (!EagerPhreakBuilder.isInsideSubnetwork(endNode, smproto)) continue;
                Memory mem = workingMemory.getNodeMemories().peekNodeMemory(smproto.getRootNode());
                if (mem != null && mem.getSegmentMemory() != null) {
                    SegmentMemory sm;
                    newSmems[i] = sm = mem.getSegmentMemory();
                    if (i > proto.getPos()) {
                        long currentLinkedNodeMask = sm.getLinkedNodeMask();
                        smproto.shallowUpdateSegmentMemory(sm);
                        sm.setLinkedNodeMask(currentLinkedNodeMask);
                    }
                    if (i < proto.getPos()) continue;
                    if (sm.getAllLinkedMaskTest() > 0L && sm.isSegmentLinked()) {
                        pmem.setLinkedSegmentMask(pmem.getLinkedSegmentMask() | sm.getSegmentPosMaskBit());
                        continue;
                    }
                    pmem.setLinkedSegmentMask(pmem.getLinkedSegmentMask() & (sm.getSegmentPosMaskBit() ^ 0xFFFFFFFFFFFFFFFFL));
                    continue;
                }
                pmem.setLinkedSegmentMask(pmem.getLinkedSegmentMask() & (long)(~(1 << i)));
            }
            pmem.setSegmentMemories(newSmems);
        }
    }

    private static void setNodeTypes(SegmentMemory.SegmentPrototype proto, LeftTupleNode[] protoNodes) {
        int nodeTypesInSegment = 0;
        for (LeftTupleNode node : protoNodes) {
            nodeTypesInSegment = BuildtimeSegmentUtilities.updateNodeTypesMask(node, nodeTypesInSegment);
        }
        proto.setNodeTypesInSegment(nodeTypesInSegment);
    }

    public static class Add {
        public static void insertLiaFacts(LeftTupleNode startNode, InternalWorkingMemory wm, Set<Integer> visited, boolean allBranches) {
            PropagationContextFactory pctxFactory = RuntimeComponentFactory.get().getPropagationContextFactory();
            PropagationContext pctx = pctxFactory.createPropagationContext(wm.getNextPropagationIdCounter(), PropagationContext.Type.RULE_ADDITION, null, null, null);
            LeftInputAdapterNode lian = (LeftInputAdapterNode)startNode;
            if (allBranches && visited.add(lian.getId()) || lian.getAssociatedTerminalsSize() == 1) {
                Add.attachAdapterAndPropagate(wm, lian, pctx);
            }
        }

        public static void attachAdapterAndPropagate(InternalWorkingMemory wm, LeftInputAdapterNode lian, PropagationContext pctx) {
            ArrayList<DetachedTuple> detachedTuples = new ArrayList<DetachedTuple>();
            LeftInputAdapterNode.LeftTupleSinkAdapter liaAdapter = new LeftInputAdapterNode.LeftTupleSinkAdapter(lian, detachedTuples);
            lian.getObjectSource().updateSink(liaAdapter, pctx, wm);
            detachedTuples.forEach(d -> d.reattachToLeft());
        }

        public static void attachAdapterAndPropagate(InternalWorkingMemory wm, BetaNode bn) {
            PropagationContextFactory pctxFactory = RuntimeComponentFactory.get().getPropagationContextFactory();
            PropagationContext pctx = pctxFactory.createPropagationContext(wm.getNextPropagationIdCounter(), PropagationContext.Type.RULE_ADDITION, null, null, null);
            ArrayList<DetachedTuple> detachedTuples = new ArrayList<DetachedTuple>();
            BetaNode.RightTupleSinkAdapter bnAdapter = new BetaNode.RightTupleSinkAdapter(bn, detachedTuples);
            bn.getRightInput().updateSink(bnAdapter, pctx, wm);
            detachedTuples.forEach(d -> d.reattachToRight());
        }

        public static SegmentMemory.SegmentPrototype processSplit(LeftTupleNode splitNode, InternalRuleBase kbase, Collection<InternalWorkingMemory> wms, Set<SegmentMemoryPair> smemsToNotify) {
            LeftTupleNode segmentRoot = BuildtimeSegmentUtilities.findSegmentRoot(splitNode);
            SegmentMemory.SegmentPrototype proto1 = kbase.getSegmentPrototype(segmentRoot);
            if (proto1.getTipNode() != splitNode) {
                return Add.splitSegment(proto1, splitNode, kbase, wms, smemsToNotify);
            }
            return null;
        }

        private static void addExistingSegmentMemories(Collection<PathEndNode> pathEndNodes, InternalWorkingMemory wm) {
            pathEndNodes.forEach(endNode -> Arrays.stream(endNode.getSegmentPrototypes()).forEach(proto -> {
                if (!EagerPhreakBuilder.isInsideSubnetwork(endNode, proto)) {
                    return;
                }
                LeftTupleNode node = proto.getRootNode();
                Memory mem = wm.getNodeMemories().peekNodeMemory(node);
                if (mem != null && mem.getSegmentMemory() != null) {
                    SegmentMemory smem = mem.getSegmentMemory();
                    PathMemory pmem = (PathMemory)wm.getNodeMemories().peekNodeMemory((NetworkNode)endNode);
                    if (pmem == null) {
                        pmem = RuntimeSegmentUtilities.initializePathMemory(wm, endNode);
                    }
                    if (pmem.getSegmentMemories()[proto.getPos()] == null) {
                        RuntimeSegmentUtilities.addSegmentToPathMemory(pmem, smem);
                    }
                }
            }));
        }

        public static void insertFacts(TerminalNode tn, InternalWorkingMemory wm, Set<Integer> visited, boolean allBranches) {
            for (PathEndNode endNode : tn.getPathEndNodes()) {
                LeftTupleNode[] nodes = endNode.getPathNodes();
                for (int i = nodes.length - 1; i > 0 && nodes[i].getPathIndex() >= endNode.getStartTupleSource().getPathIndex() && (allBranches && visited.add(nodes[i].getId()) || nodes[i].getAssociatedTerminalsSize() == 1); --i) {
                    BetaNode bn;
                    LeftTupleNode node = nodes[i];
                    if (!NodeTypeEnums.isBetaNode((NetworkNode)node) || (bn = (BetaNode)node).getRightInput().inputIsTupleToObjectNode()) continue;
                    Add.attachAdapterAndPropagate(wm, bn);
                }
            }
        }

        public static void splitSegment(InternalWorkingMemory wm, SegmentMemory sm1, SegmentMemory.SegmentPrototype proto1, SegmentMemory.SegmentPrototype proto2, Set<SegmentMemoryPair> smemsToNotify) {
            Memory[] origMemories = sm1.getNodeMemories();
            SegmentMemory sm2 = proto2.shallowNewSegmentMemory();
            if (sm1.getFirst() != null) {
                SegmentMemory sm = (SegmentMemory)sm1.getFirst();
                while (sm != null) {
                    SegmentMemory next = sm.getNext();
                    sm1.remove(sm);
                    sm2.add(sm);
                    sm = next;
                }
            }
            sm1.add(sm2);
            sm2.mergePathMemories(sm1);
            long currentLinkedNodeMask = sm1.getLinkedNodeMask();
            proto1.shallowUpdateSegmentMemory(sm1);
            if (NodeTypeEnums.isLeftInputAdapterNode((NetworkNode)sm1.getTipNode()) && !sm1.getStagedLeftTuples().isEmpty()) {
                sm2.getStagedLeftTuples().addAll(sm1.getStagedLeftTuples());
            }
            Add.splitBitMasks(sm1, sm2, currentLinkedNodeMask);
            Memory[] mem1 = new Memory[proto1.getMemories().length];
            Memory[] mem2 = new Memory[proto2.getMemories().length];
            System.arraycopy(origMemories, 0, mem1, 0, mem1.length);
            for (int i = 0; i < mem2.length; ++i) {
                Memory mem;
                mem2[i] = mem = origMemories[mem1.length + i];
                mem.setSegmentMemory(sm2);
                if (!(mem instanceof SegmentNodeMemory)) continue;
                ((SegmentNodeMemory)mem).setNodePosMaskBit(proto2.getMemories()[i].getNodePosMaskBit());
            }
            mem1[mem1.length - 1].setNext(null);
            mem2[0].setPrevious(null);
            sm1.setNodeMemories(mem1);
            sm2.setNodeMemories(mem2);
            EagerPhreakBuilder.notifyImpactedSegments(sm1, wm, smemsToNotify);
            EagerPhreakBuilder.notifyImpactedSegments(sm2, wm, smemsToNotify);
        }

        public static SegmentMemory.SegmentPrototype splitSegment(SegmentMemory.SegmentPrototype proto1, LeftTupleNode splitNode, InternalRuleBase kbase, Collection<InternalWorkingMemory> wms, Set<SegmentMemoryPair> smemsToNotify) {
            PathEndNode[] endNodes;
            boolean proto1WasEager = proto1.requiresEager();
            LeftTupleSinkNode proto2RootNode = splitNode.getSinkPropagator().getFirstLeftTupleSink();
            SegmentMemory.SegmentPrototype proto2 = new SegmentMemory.SegmentPrototype(proto2RootNode, proto1.getTipNode());
            kbase.registerSegmentPrototype(proto2RootNode, proto2);
            proto2.setPos(proto1.getPos() + 1);
            Add.splitProtos(proto1, proto2, splitNode);
            for (InternalWorkingMemory wm : wms) {
                Memory mem = wm.getNodeMemories().peekNodeMemory(proto1.getRootNode());
                if (mem == null || mem.getSegmentMemory() == null) continue;
                Add.splitSegment(wm, mem.getSegmentMemory(), proto1, proto2, smemsToNotify);
            }
            for (PathEndNode endNode : endNodes = proto1.getPathEndNodes()) {
                Add.splitEagerProtos(proto1, proto1WasEager, proto2, endNode);
                proto2.setPathEndNodes(proto1.getPathEndNodes());
                SegmentMemory.SegmentPrototype[] oldList = endNode.getSegmentPrototypes();
                SegmentMemory.SegmentPrototype[] newList = new SegmentMemory.SegmentPrototype[oldList.length + 1];
                System.arraycopy(oldList, 0, newList, 0, proto1.getPos() + 1);
                newList[proto2.getPos()] = proto2;
                if (proto2.getPos() + 1 != newList.length) {
                    for (int i = proto2.getPos() + 1; i < newList.length; ++i) {
                        newList[i] = oldList[i - 1];
                        newList[i].setPos(i);
                        newList[i].setSegmentPosMaskBit(1 << i);
                    }
                }
                endNode.setSegmentPrototypes(newList);
                EagerPhreakBuilder.updatePaths(proto1, wms, endNode, newList);
            }
            return proto2;
        }

        private static void splitProtos(SegmentMemory.SegmentPrototype proto1, SegmentMemory.SegmentPrototype proto2, LeftTupleNode splitNode) {
            proto1.setTipNode(splitNode);
            LeftTupleNode[] nodes = proto1.getNodesInSegment();
            SegmentMemory.MemoryPrototype[] mems = proto1.getMemories();
            int arraySplit = splitNode.getPathIndex() - proto1.getRootNode().getPathIndex() + 1;
            LeftTupleNode[] proto1Nodes = new LeftTupleNode[arraySplit];
            LeftTupleNode[] proto2Nodes = new LeftTupleNode[nodes.length - arraySplit];
            System.arraycopy(nodes, 0, proto1Nodes, 0, proto1Nodes.length);
            System.arraycopy(nodes, arraySplit, proto2Nodes, 0, proto2Nodes.length);
            proto1.setNodesInSegment(proto1Nodes);
            proto2.setNodesInSegment(proto2Nodes);
            EagerPhreakBuilder.setNodeTypes(proto1, proto1Nodes);
            EagerPhreakBuilder.setNodeTypes(proto2, proto2Nodes);
            SegmentMemory.MemoryPrototype[] proto1Mems = new SegmentMemory.MemoryPrototype[proto1Nodes.length];
            SegmentMemory.MemoryPrototype[] proto2Mems = new SegmentMemory.MemoryPrototype[proto2Nodes.length];
            System.arraycopy(mems, 0, proto1Mems, 0, proto1Mems.length);
            proto1.setMemories(proto1Mems);
            int bitPos = 1;
            for (int i = 0; i < proto2Mems.length; ++i) {
                proto2Mems[i] = mems[i + arraySplit];
                proto2Mems[i].setNodePosMaskBit(bitPos);
                bitPos <<= 1;
            }
            proto2.setMemories(proto2Mems);
            Add.splitBitMasks(proto1, proto2);
        }

        private static void splitEagerProtos(SegmentMemory.SegmentPrototype proto1, boolean proto1WasEager, SegmentMemory.SegmentPrototype proto2, PathEndNode endNode) {
            if (proto1WasEager) {
                SegmentMemory.SegmentPrototype[] eager = endNode.getEagerSegmentPrototypes();
                if (proto1.requiresEager() && proto2.requiresEager()) {
                    SegmentMemory.SegmentPrototype[] newEager = new SegmentMemory.SegmentPrototype[eager.length + 1];
                    System.arraycopy(eager, 0, newEager, 0, eager.length);
                    newEager[newEager.length - 1] = proto2;
                    endNode.setEagerSegmentPrototypes(newEager);
                } else if (proto2.requiresEager()) {
                    for (int i = 0; i < eager.length; ++i) {
                        if (eager[i] != proto1) continue;
                        eager[i] = proto2;
                        break;
                    }
                }
            }
        }

        private static void splitBitMasks(SegmentMemory sm1, SegmentMemory sm2, long currentLinkedNodeMask) {
            int splitPos = sm1.getSegmentPrototype().getNodesInSegment().length;
            long currentDirtyNodeMask = sm1.getDirtyNodeMask();
            long splitMask = (1L << splitPos) - 1L;
            sm1.setDirtyNodeMask(currentDirtyNodeMask & splitMask);
            sm1.setLinkedNodeMask(currentLinkedNodeMask & splitMask);
            sm2.setLinkedNodeMask(currentLinkedNodeMask >> splitPos);
            sm2.setDirtyNodeMask(currentDirtyNodeMask >> splitPos);
        }

        private static void splitBitMasks(SegmentMemory.SegmentPrototype sm1, SegmentMemory.SegmentPrototype sm2) {
            int splitPos = sm1.getNodesInSegment().length;
            long splitMask = (1L << splitPos) - 1L;
            long currentLinkedNodeMask = sm1.getLinkedNodeMask();
            long currentAllLinkedMaskTest = sm1.getAllLinkedMaskTest();
            sm1.setLinkedNodeMask(currentLinkedNodeMask & splitMask);
            sm1.setAllLinkedMaskTest(currentAllLinkedMaskTest & splitMask);
            sm2.setLinkedNodeMask(currentLinkedNodeMask >> splitPos);
            sm2.setAllLinkedMaskTest(currentAllLinkedMaskTest >> splitPos);
            sm2.setSegmentPosMaskBit(sm1.getSegmentPosMaskBit() << 1);
        }

        private static void addNewPaths(List<Pair> exclBranchRoots, TerminalNode tn, Collection<InternalWorkingMemory> wms, InternalRuleBase kBase, Set<SegmentMemoryPair> smemsToNotify) {
            BuildtimeSegmentUtilities.createPathProtoMemories(tn, null, kBase);
            for (PathEndNode endNode : tn.getPathEndNodes()) {
                BuildtimeSegmentUtilities.updateSegmentEndNodes(endNode);
            }
            for (InternalWorkingMemory wm : wms) {
                Object sm;
                for (PathEndNode endNode : tn.getPathEndNodes()) {
                    if (endNode.getAssociatedTerminalsSize() > 1) {
                        Memory mem = wm.getNodeMemories().peekNodeMemory(endNode);
                        if (mem == null || mem.getSegmentMemory() == null) break;
                        sm = mem.getSegmentMemory();
                        EagerPhreakBuilder.notifyImpactedSegments((SegmentMemory)sm, wm, smemsToNotify);
                        break;
                    }
                    PathMemory pmem = null;
                    for (SegmentMemory.SegmentPrototype sproto : endNode.getSegmentPrototypes()) {
                        if (!EagerPhreakBuilder.isInsideSubnetwork(endNode, sproto)) continue;
                        if (sproto.getRootNode() != endNode) {
                            SegmentMemory sm2;
                            Memory mem = wm.getNodeMemories().peekNodeMemory(sproto.getRootNode());
                            if (mem == null || mem.getSegmentMemory() == null) continue;
                            if (pmem == null) {
                                pmem = RuntimeSegmentUtilities.initializePathMemory(wm, endNode);
                            }
                            pmem.getSegmentMemories()[sproto.getPos()] = sm2 = mem.getSegmentMemory();
                            sm2.getPathMemories().add(pmem);
                            EagerPhreakBuilder.notifyImpactedSegments(sm2, wm, smemsToNotify);
                            continue;
                        }
                        if (pmem == null) continue;
                        SegmentMemory sm3 = sproto.shallowNewSegmentMemory();
                        sm3.setNodeMemories(new Memory[]{pmem});
                        pmem.setSegmentMemory(sm3);
                        RuntimeSegmentUtilities.addSegmentToPathMemory(pmem, sm3);
                        EagerPhreakBuilder.notifyImpactedSegments(sm3, wm, smemsToNotify);
                    }
                }
                HashSet<Integer> visited = new HashSet<Integer>();
                for (int i = exclBranchRoots.size() - 1; i >= 0; --i) {
                    LeftTupleNode child = exclBranchRoots.get((int)i).child;
                    LeftTupleNode parent = exclBranchRoots.get((int)i).parent;
                    Memory parentMem = wm.getNodeMemories().peekNodeMemory(parent);
                    if (parentMem != null && parentMem.getSegmentMemory() != null && !parentMem.getSegmentMemory().isEmpty()) {
                        sm = parentMem.getSegmentMemory();
                        SegmentMemory childSmem = RuntimeSegmentUtilities.createChildSegment(wm, child);
                        ((SegmentMemory)sm).add(childSmem);
                        ((SegmentMemory)sm).notifyRuleLinkSegment(wm);
                        EagerPhreakBuilder.notifyImpactedSegments((SegmentMemory)sm, wm, smemsToNotify);
                        EagerPhreakBuilder.notifyImpactedSegments(childSmem, wm, smemsToNotify);
                    }
                    if (!visited.add(parent.getId())) continue;
                    EagerPhreakBuilder.correctMemoryOnSplitsChanged(parent, wm);
                }
            }
        }
    }

    public static class Remove {
        private static void removeExistingPaths(List<Pair> exclBranchRoots, TerminalNode tn, Collection<InternalWorkingMemory> wms, InternalRuleBase kbase) {
            for (PathEndNode endNode : tn.getPathEndNodes()) {
                if (endNode.getAssociatedTerminalsSize() > 1) continue;
                for (int i = 0; i < endNode.getSegmentPrototypes().length; ++i) {
                    SegmentMemory.SegmentPrototype smproto = endNode.getSegmentPrototypes()[i];
                    if (smproto.getRootNode().getAssociatedTerminalsSize() > 1) {
                        PathEndNode[] existingNodes = smproto.getPathEndNodes();
                        PathEndNode[] newNodes = new PathEndNode[existingNodes.length - 1];
                        int k = 0;
                        for (int j = 0; j < existingNodes.length; ++j) {
                            if (existingNodes[j] == endNode) continue;
                            newNodes[k] = existingNodes[j];
                            ++k;
                        }
                        smproto.setPathEndNodes(newNodes);
                        continue;
                    }
                    kbase.invalidateSegmentPrototype(smproto.getRootNode());
                }
            }
            for (InternalWorkingMemory wm : wms) {
                HashSet<Integer> visited = new HashSet<Integer>();
                for (int i = exclBranchRoots.size() - 1; i >= 0; --i) {
                    SegmentMemory sm;
                    Memory mem;
                    LeftTupleNode child = exclBranchRoots.get((int)i).child;
                    LeftTupleNode parent = exclBranchRoots.get((int)i).parent;
                    if (parent.getType() == 5245233) continue;
                    if (visited.add(child.getId()) && (mem = wm.getNodeMemories().peekNodeMemory(parent)) != null && mem.getSegmentMemory() != null && (sm = mem.getSegmentMemory()).getFirst() != null) {
                        SegmentMemory childSm = wm.getNodeMemories().peekNodeMemory(child).getSegmentMemory();
                        sm.remove(childSm);
                    }
                    if (!visited.add(parent.getId())) continue;
                    EagerPhreakBuilder.correctMemoryOnSplitsChanged(parent, wm);
                }
                for (PathEndNode endNode : tn.getPathEndNodes()) {
                    PathMemory pmem = (PathMemory)wm.getNodeMemories().peekNodeMemory(endNode);
                    for (SegmentMemory.SegmentPrototype smproto : endNode.getSegmentPrototypes()) {
                        if (!EagerPhreakBuilder.isInsideSubnetwork(endNode, smproto)) continue;
                        if (smproto.getRootNode().getAssociatedTerminalsSize() > 1) {
                            SegmentMemory sm;
                            Memory mem;
                            if (pmem == null || (mem = wm.getNodeMemories().peekNodeMemory(smproto.getRootNode())) == null || (sm = mem.getSegmentMemory()) == null) continue;
                            sm.removePathMemory(pmem);
                            continue;
                        }
                        for (int i = 0; i < smproto.getNodesInSegment().length; ++i) {
                            LeftTupleNode n = smproto.getNodesInSegment()[i];
                            Memory mem = wm.getNodeMemories().peekNodeMemory(n);
                            if (mem == null || !NodeTypeEnums.isBetaNode((NetworkNode)n)) continue;
                            Remove.deleteRightInputData(n, mem, wm);
                        }
                    }
                }
            }
        }

        private static void processMerges(LeftTupleNode splitNode, TerminalNode tn, InternalRuleBase kBase, Collection<InternalWorkingMemory> wms, Set<Integer> visited) {
            if (!visited.add(splitNode.getId())) {
                return;
            }
            if (!BuildtimeSegmentUtilities.isTipNode(splitNode, tn)) {
                LeftTupleNode segmentRoot = BuildtimeSegmentUtilities.findSegmentRoot(splitNode, tn);
                SegmentMemory.SegmentPrototype proto1 = kBase.getSegmentPrototype(segmentRoot);
                LeftTupleNode ltn = null;
                for (NetworkNode n : splitNode.getSinks()) {
                    if (n.getAssociatedTerminalsSize() == 1 && n.hasAssociatedTerminal((BaseTerminalNode)tn)) continue;
                    ltn = (LeftTupleNode)n;
                    break;
                }
                if (ltn == null) {
                    throw new RuntimeException();
                }
                SegmentMemory.SegmentPrototype proto2 = kBase.getSegmentPrototype(ltn);
                Remove.mergeSegments(proto1, proto2, kBase, wms);
            }
        }

        public static void mergeSegments(SegmentMemory.SegmentPrototype proto1, SegmentMemory.SegmentPrototype proto2, InternalRuleBase kbase, Collection<InternalWorkingMemory> wms) {
            PathEndNode[] endNodes;
            boolean proto2WasEager = proto2.requiresEager();
            LeftTupleNode[] origNodes = proto1.getNodesInSegment();
            Remove.mergeProtos(proto1, proto2, origNodes);
            for (InternalWorkingMemory wm : wms) {
                Memory mem1 = wm.getNodeMemories().peekNodeMemory(proto1.getRootNode());
                Memory mem2 = wm.getNodeMemories().peekNodeMemory(proto2.getRootNode());
                Remove.mergeSegment(proto1, mem1, proto2, origNodes, mem2, wm);
            }
            for (PathEndNode endNode : endNodes = proto1.getPathEndNodes()) {
                Remove.mergeEagerProtos(proto1, proto2, proto2WasEager, endNode);
                proto1.setPathEndNodes(proto2.getPathEndNodes());
                SegmentMemory.SegmentPrototype[] newList = new SegmentMemory.SegmentPrototype[endNode.getSegmentPrototypes().length - 1];
                Remove.copyWithRemoval(endNode.getSegmentPrototypes(), newList, proto2);
                if (proto1.getPos() + 1 != newList.length) {
                    for (int i = proto1.getPos() + 1; i < newList.length; ++i) {
                        newList[i].setPos(i);
                        newList[i].setSegmentPosMaskBit(1 << i);
                    }
                }
                endNode.setSegmentPrototypes(newList);
                EagerPhreakBuilder.updatePaths(proto1, wms, endNode, newList);
            }
            kbase.invalidateSegmentPrototype(proto2.getRootNode());
        }

        private static void mergeProtos(SegmentMemory.SegmentPrototype proto1, SegmentMemory.SegmentPrototype proto2, LeftTupleNode[] origNodes) {
            proto1.setTipNode(proto2.getTipNode());
            LeftTupleNode[] nodes = new LeftTupleNode[proto1.getNodesInSegment().length + proto2.getNodesInSegment().length];
            System.arraycopy(proto1.getNodesInSegment(), 0, nodes, 0, proto1.getNodesInSegment().length);
            System.arraycopy(proto2.getNodesInSegment(), 0, nodes, proto1.getNodesInSegment().length, proto2.getNodesInSegment().length);
            proto1.setNodesInSegment(nodes);
            SegmentMemory.MemoryPrototype[] protoMems = new SegmentMemory.MemoryPrototype[proto1.getMemories().length + proto2.getMemories().length];
            System.arraycopy(proto1.getMemories(), 0, protoMems, 0, proto1.getMemories().length);
            System.arraycopy(proto2.getMemories(), 0, protoMems, proto1.getMemories().length, proto2.getMemories().length);
            proto1.setNodesInSegment(nodes);
            proto1.setMemories(protoMems);
            int bitPos = 1;
            for (SegmentMemory.MemoryPrototype protoMem : protoMems) {
                protoMem.setNodePosMaskBit(bitPos);
                bitPos <<= 1;
            }
            EagerPhreakBuilder.setNodeTypes(proto1, nodes);
            Remove.mergeBitMasks(proto1, proto2, origNodes);
        }

        private static void mergeSegment(SegmentMemory.SegmentPrototype proto1, Memory m1, SegmentMemory.SegmentPrototype proto2, LeftTupleNode[] origNodes, Memory m2, InternalWorkingMemory wm) {
            SegmentMemory sm2;
            SegmentMemory sm1 = m1 != null ? m1.getSegmentMemory() : null;
            SegmentMemory segmentMemory = sm2 = m2 != null ? m2.getSegmentMemory() : null;
            if (sm1 == null && sm2 == null) {
                return;
            }
            if (sm1 == null) {
                sm1 = RuntimeSegmentUtilities.getOrCreateSegmentMemory(wm, proto1.getRootNode());
            }
            if (sm2 == null) {
                sm2 = RuntimeSegmentUtilities.getOrCreateSegmentMemory(wm, proto2.getRootNode());
            }
            Memory[] mems1 = sm1.getNodeMemories();
            Memory[] mems2 = sm2.getNodeMemories();
            Memory[] mems = new Memory[mems1.length + mems2.length];
            System.arraycopy(mems1, 0, mems, 0, mems1.length);
            for (int i = 0; i < mems2.length; ++i) {
                Memory mem;
                mems[mems1.length + i] = mem = mems2[i];
                mem.setSegmentMemory(sm1);
                mem.setPrevious(mems[mems1.length + i - 1]);
                mems[mems1.length + i - 1].setNext(mem);
                if (!(mem instanceof SegmentNodeMemory)) continue;
                ((SegmentNodeMemory)mem).setNodePosMaskBit(proto2.getMemories()[i].getNodePosMaskBit());
            }
            sm1.setNodeMemories(mems);
            Remove.mergeSegment(sm1, sm2, proto1, origNodes);
        }

        private static void mergeSegment(SegmentMemory sm1, SegmentMemory sm2, SegmentMemory.SegmentPrototype proto1, LeftTupleNode[] origNodes) {
            if (NodeTypeEnums.isLeftInputAdapterNode((NetworkNode)sm1.getTipNode()) && !sm2.getStagedLeftTuples().isEmpty()) {
                sm1.getStagedLeftTuples().addAll(sm2.getStagedLeftTuples());
            }
            if (sm1.contains(sm2)) {
                sm1.remove(sm2);
            }
            if (sm2.getFirst() != null) {
                SegmentMemory sm = (SegmentMemory)sm2.getFirst();
                while (sm != null) {
                    SegmentMemory next = sm.getNext();
                    sm2.remove(sm);
                    sm1.add(sm);
                    sm = next;
                }
            }
            long currentLinkedNodeMask = sm1.getLinkedNodeMask();
            proto1.shallowUpdateSegmentMemory(sm1);
            Remove.mergeBitMasks(sm1, sm2, origNodes, currentLinkedNodeMask);
        }

        private static void mergeBitMasks(SegmentMemory.SegmentPrototype sm1, SegmentMemory.SegmentPrototype sm2, LeftTupleNode[] origNodes) {
            int shiftBits = origNodes.length;
            long currentLinkedNodeMask = sm1.getLinkedNodeMask();
            long currentAllLinkedMaskTest = sm1.getAllLinkedMaskTest();
            long linkedBitsToAdd = sm2.getLinkedNodeMask() << shiftBits;
            long allBitsToAdd = sm2.getAllLinkedMaskTest() << shiftBits;
            sm1.setLinkedNodeMask(linkedBitsToAdd | currentLinkedNodeMask);
            sm1.setAllLinkedMaskTest(allBitsToAdd | currentAllLinkedMaskTest);
        }

        private static void mergeBitMasks(SegmentMemory sm1, SegmentMemory sm2, LeftTupleNode[] origNodes, long currentLinkedNodeMask) {
            int shiftBits = origNodes.length;
            long linkedBitsToAdd = sm2.getLinkedNodeMask() << shiftBits;
            long dirtyBitsToAdd = sm2.getDirtyNodeMask() << shiftBits;
            sm1.setLinkedNodeMask(linkedBitsToAdd | currentLinkedNodeMask);
            sm1.setDirtyNodeMask(dirtyBitsToAdd | sm1.getDirtyNodeMask());
        }

        private static void mergeEagerProtos(SegmentMemory.SegmentPrototype proto1, SegmentMemory.SegmentPrototype proto2, boolean proto2WasEager, PathEndNode endNode) {
            if (!proto1.requiresEager() && !proto2.requiresEager()) {
                return;
            }
            SegmentMemory.SegmentPrototype[] eager = endNode.getEagerSegmentPrototypes();
            if (proto1.requiresEager() && proto2.requiresEager()) {
                SegmentMemory.SegmentPrototype[] newEager = new SegmentMemory.SegmentPrototype[eager.length - 1];
                Remove.copyWithRemoval(eager, newEager, proto2);
                endNode.setEagerSegmentPrototypes(newEager);
            } else if (proto1.requiresEager() && proto2WasEager) {
                for (int i = 0; i < eager.length; ++i) {
                    if (eager[i] != proto2) continue;
                    eager[i] = proto1;
                    break;
                }
            }
        }

        private static void deleteRightInputData(LeftTupleNode node, Memory m, InternalWorkingMemory wm) {
            BetaNode bn = (BetaNode)node;
            BetaMemory bm = bn.getType() == 11799092 ? ((AccumulateNode.AccumulateMemory)m).getBetaMemory() : (BetaMemory)m;
            TupleMemory rtm = bm.getRightTupleMemory();
            FastIterator<TupleImpl> it = rtm.fullFastIterator();
            TupleImpl rightTuple = BetaNode.getFirstTuple(rtm, it);
            while (rightTuple != null) {
                TupleImpl next = it.next(rightTuple);
                rtm.remove(rightTuple);
                rightTuple.unlinkFromRightParent();
                rightTuple = next;
            }
            if (!bm.getStagedRightTuples().isEmpty()) {
                bm.setNodeDirtyWithoutNotify();
            }
            TupleSets srcRightTuples = bm.getStagedRightTuples().takeAll();
            Remove.unlinkRightTuples(srcRightTuples.getInsertFirst());
            Remove.unlinkRightTuples(srcRightTuples.getUpdateFirst());
            Remove.unlinkRightTuples(srcRightTuples.getDeleteFirst());
            Remove.deleteFactsFromRightInput(bn, wm);
        }

        private static void deleteFactsFromRightInput(BetaNode bn, InternalWorkingMemory wm) {
            WindowNode.WindowMemory memory;
            RightInputAdapterNode source = bn.getRightInput();
            if (source.getType() == 4917257 && (memory = (WindowNode.WindowMemory)wm.getNodeMemories().peekNodeMemory(source)) != null) {
                for (DefaultEventHandle factHandle : memory.getFactHandles()) {
                    factHandle.forEachRightTuple(rt -> {
                        if (source.equals(rt.getSink())) {
                            rt.unlinkFromRightParent();
                        }
                    });
                }
            }
        }

        private static void unlinkRightTuples(TupleImpl rightTuple) {
            TupleImpl rt = rightTuple;
            while (rt != null) {
                TupleImpl next = rt.getStagedNext();
                if (rt.getFactHandle() != null) {
                    rt.unlinkFromRightParent();
                }
                rt = next;
            }
        }

        private static void copyWithRemoval(SegmentMemory.SegmentPrototype[] orinalProtos, SegmentMemory.SegmentPrototype[] newProtos, SegmentMemory.SegmentPrototype protoToRemove) {
            int j = 0;
            for (int i = 0; i < orinalProtos.length; ++i) {
                if (orinalProtos[i] == protoToRemove) continue;
                newProtos[j] = orinalProtos[i];
                ++j;
            }
        }
    }

    public static class SegmentMemoryPair {
        public SegmentMemory sm;
        public InternalWorkingMemory wm;
        public int nodeId;
        public long sessionId;

        public SegmentMemoryPair(SegmentMemory sm, InternalWorkingMemory wm) {
            this.sm = sm;
            this.wm = wm;
            this.nodeId = sm.getRootNode().getId();
            this.sessionId = wm.getIdentifier();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (this.getClass() != o.getClass()) {
                return false;
            }
            SegmentMemoryPair that = (SegmentMemoryPair)o;
            return this.nodeId == that.nodeId && this.sessionId == that.sessionId;
        }

        public int hashCode() {
            return Objects.hash(this.nodeId, this.sessionId);
        }
    }

    public static class Pair {
        public final LeftTupleNode parent;
        public final LeftTupleNode child;

        public Pair(LeftTupleNode parent, LeftTupleNode child) {
            this.parent = parent;
            this.child = child;
        }

        public String toString() {
            return "Pair{parent=" + this.parent + ", child=" + this.child + "}";
        }
    }
}

