/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.common;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.drools.base.base.ValueResolver;
import org.drools.base.reteoo.BaseTuple;
import org.drools.base.rule.ContextEntry;
import org.drools.base.rule.Declaration;
import org.drools.base.rule.constraint.BetaConstraint;
import org.drools.base.rule.constraint.Constraint;
import org.drools.core.reteoo.Tuple;
import org.drools.core.reteoo.TupleImpl;
import org.kie.api.runtime.rule.FactHandle;

public class TupleStartEqualsConstraint
implements BetaConstraint<ContextEntry> {
    private static final long serialVersionUID = 510L;
    private Declaration[] declarations = new Declaration[0];
    private static final TupleStartEqualsConstraint INSTANCE = new TupleStartEqualsConstraint();

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.declarations = (Declaration[])in.readObject();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.declarations);
    }

    public static TupleStartEqualsConstraint getInstance() {
        return INSTANCE;
    }

    public Declaration[] getRequiredDeclarations() {
        return this.declarations;
    }

    public void replaceDeclaration(Declaration oldDecl, Declaration newDecl) {
    }

    public boolean isTemporal() {
        return false;
    }

    public ContextEntry createContext() {
        return new TupleStartEqualsConstraintContextEntry();
    }

    public boolean isAllowedCachedLeft(ContextEntry context, FactHandle handle) {
        int size = ((TupleStartEqualsConstraintContextEntry)context).compareSize;
        Object tuple = ((Tuple)handle.getObject()).getSubTuple(size);
        return ((TupleImpl)((TupleStartEqualsConstraintContextEntry)context).leftTuple.getSubTuple(size)).equals(tuple);
    }

    public boolean isAllowedCachedRight(BaseTuple tuple, ContextEntry context) {
        TupleImpl nonEmptyLeftTuple = (TupleImpl)tuple.skipEmptyHandles();
        return nonEmptyLeftTuple.equals(((TupleStartEqualsConstraintContextEntry)context).rightTuple.getSubTuple(nonEmptyLeftTuple.size()));
    }

    public String toString() {
        return "[ TupleStartEqualsConstraint ]";
    }

    public int hashCode() {
        return 10;
    }

    public boolean equals(Object object) {
        return object instanceof TupleStartEqualsConstraint;
    }

    public TupleStartEqualsConstraint clone() {
        return INSTANCE;
    }

    public Constraint.ConstraintType getType() {
        return Constraint.ConstraintType.BETA;
    }

    public BetaConstraint cloneIfInUse() {
        return this;
    }

    public static class TupleStartEqualsConstraintContextEntry
    implements ContextEntry {
        private static final long serialVersionUID = 510L;
        public Tuple leftTuple;
        public Tuple rightTuple;
        public int compareSize;
        private ContextEntry entry;

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.leftTuple = (Tuple)in.readObject();
            this.rightTuple = (Tuple)in.readObject();
            this.compareSize = in.readInt();
            this.entry = (ContextEntry)in.readObject();
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeObject(this.leftTuple);
            out.writeObject(this.rightTuple);
            out.writeInt(this.compareSize);
            out.writeObject(this.entry);
        }

        public ContextEntry getNext() {
            return this.entry;
        }

        public void setNext(ContextEntry entry) {
            this.entry = entry;
        }

        public void updateFromTuple(ValueResolver valueResolver, BaseTuple tuple) {
            this.leftTuple = (Tuple)tuple.skipEmptyHandles();
            this.compareSize = this.leftTuple.size();
        }

        public void updateFromFactHandle(ValueResolver valueResolver, FactHandle handle) {
            this.rightTuple = ((TupleImpl)handle.getObject()).skipEmptyHandles();
        }

        public void resetTuple() {
            this.leftTuple = null;
        }

        public void resetFactHandle() {
            this.rightTuple = null;
        }
    }
}

