/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.reteoo;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.drools.base.RuleBase;
import org.drools.base.base.ObjectType;
import org.drools.base.common.RuleBasePartitionId;
import org.drools.base.reteoo.PropertySpecificUtil;
import org.drools.base.rule.Pattern;
import org.drools.core.common.BaseNode;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.common.PropagationContext;
import org.drools.core.common.ReteEvaluator;
import org.drools.core.common.TupleSets;
import org.drools.core.common.UpdateContext;
import org.drools.core.phreak.RuleNetworkEvaluator;
import org.drools.core.phreak.TupleEvaluationUtil;
import org.drools.core.reteoo.AccumulateNode;
import org.drools.core.reteoo.AlphaNode;
import org.drools.core.reteoo.BetaMemory;
import org.drools.core.reteoo.BetaNode;
import org.drools.core.reteoo.LeftTupleSource;
import org.drools.core.reteoo.ModifyPreviousTuples;
import org.drools.core.reteoo.ObjectSink;
import org.drools.core.reteoo.ObjectSinkNode;
import org.drools.core.reteoo.ObjectSource;
import org.drools.core.reteoo.ObjectTypeNode;
import org.drools.core.reteoo.ObjectTypeNodeId;
import org.drools.core.reteoo.ReteooBuilder;
import org.drools.core.reteoo.RightTuple;
import org.drools.core.reteoo.RightTupleSink;
import org.drools.core.reteoo.RuleRemovalContext;
import org.drools.core.reteoo.TupleImpl;
import org.drools.core.reteoo.builder.BuildContext;
import org.drools.util.bitmask.AllSetBitMask;
import org.drools.util.bitmask.BitMask;
import org.drools.util.bitmask.EmptyBitMask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RightInputAdapterNode<T extends BetaNode>
extends BaseNode
implements ObjectSinkNode,
RightTupleSink {
    protected static final Logger log = LoggerFactory.getLogger(RightInputAdapterNode.class);
    protected static final boolean isLogTraceEnabled = log.isTraceEnabled();
    protected T betaNode;
    private ObjectSinkNode previousObjectSinkNode;
    protected BitMask declaredMask = EmptyBitMask.get();
    protected BitMask inferredMask = EmptyBitMask.get();
    private ObjectSinkNode nextObjectSinkNode;
    private BitMask negativeMask = EmptyBitMask.get();
    private ObjectTypeNodeId inputOtnId = ObjectTypeNodeId.DEFAULT_ID;
    private ObjectSource source;
    private Collection<String> listenedProperties;
    protected boolean inputIsTupleToObjectNode;
    private boolean inputIsPassive;
    private transient ObjectTypeNode objectTypeNode;

    public RightInputAdapterNode(int id, ObjectSource input, BuildContext context) {
        super(id, context.getPartitionId());
        ObjectTypeNode otn;
        this.inputIsTupleToObjectNode = 5245233 == input.getType();
        this.source = input;
        this.hashcode = this.calculateHashCode();
        if (context.isStreamMode() && (otn = this.getObjectTypeNode()) != null) {
            this.setStreamMode(otn.getObjectType().isEvent());
        }
    }

    @Override
    public ObjectSource getParent() {
        return this.source;
    }

    public T getBetaNode() {
        return this.betaNode;
    }

    public void setBetaNode(T betaNode) {
        this.betaNode = betaNode;
    }

    @Override
    public void assertObject(InternalFactHandle factHandle, PropagationContext pctx, ReteEvaluator reteEvaluator) {
        BetaMemory memory = RightInputAdapterNode.getBetaMemoryFromRightInput(this.betaNode, reteEvaluator);
        RightTuple rightTuple = this.createRightTuple(factHandle, this, pctx);
        boolean stagedInsertWasEmpty = memory.getStagedRightTuples().addInsert(rightTuple);
        if (isLogTraceEnabled) {
            log.trace("BetaNode stagedInsertWasEmpty={}", (Object)stagedInsertWasEmpty);
        }
        boolean shouldFlush = this.isStreamMode();
        if (memory.getAndIncCounter() == 0) {
            if (stagedInsertWasEmpty) {
                memory.setNodeDirtyWithoutNotify();
            }
            shouldFlush = memory.linkNode((LeftTupleSource)this.betaNode, reteEvaluator, !this.inputIsPassive) | shouldFlush;
        } else if (stagedInsertWasEmpty) {
            shouldFlush = memory.setNodeDirty((LeftTupleSource)this.betaNode, reteEvaluator, !this.inputIsPassive) | shouldFlush;
        }
        if (shouldFlush) {
            TupleEvaluationUtil.flushLeftTupleIfNecessary(reteEvaluator, memory.getOrCreateSegmentMemory((LeftTupleSource)this.betaNode, reteEvaluator), this.isStreamMode());
        }
    }

    @Override
    public void modifyObject(InternalFactHandle factHandle, ModifyPreviousTuples modifyPreviousTuples, PropagationContext context, ReteEvaluator reteEvaluator) {
        BetaMemory bm;
        TupleImpl rightTuple = modifyPreviousTuples.peekRightTuple(this.partitionId);
        while (rightTuple != null && rightTuple.getInputOtnId().before(this.getInputOtnId())) {
            modifyPreviousTuples.removeRightTuple(this.partitionId);
            rightTuple.setPropagationContext(context);
            bm = BetaNode.getBetaMemory(((RightInputAdapterNode)rightTuple.getSink()).getBetaNode(), reteEvaluator);
            ((RightInputAdapterNode)rightTuple.getSink()).doDeleteRightTuple(rightTuple, reteEvaluator, bm);
            rightTuple = modifyPreviousTuples.peekRightTuple(this.partitionId);
        }
        if (rightTuple != null && rightTuple.getInputOtnId().equals(this.getInputOtnId())) {
            modifyPreviousTuples.removeRightTuple(this.partitionId);
            rightTuple.reAdd();
            if (context.getModificationMask().intersects(this.inferredMask)) {
                rightTuple.setPropagationContext(context);
                bm = BetaNode.getBetaMemory(this.betaNode, reteEvaluator);
                rightTuple.setPropagationContext(context);
                this.doUpdateRightTuple(rightTuple, reteEvaluator, bm);
            } else if (rightTuple.getMemory() != null) {
                this.reorderRightTuple(reteEvaluator, rightTuple);
            }
        } else if (context.getModificationMask().intersects(this.inferredMask)) {
            this.assertObject(factHandle, context, reteEvaluator);
        }
    }

    protected void reorderRightTuple(ReteEvaluator reteEvaluator, TupleImpl rightTuple) {
        BetaNode.getBetaMemory(this.betaNode, reteEvaluator).getRightTupleMemory().removeAdd(rightTuple);
        RuleNetworkEvaluator.doUpdatesReorderChildLeftTuple(rightTuple);
    }

    public void doDeleteRightTuple(TupleImpl rightTuple, ReteEvaluator reteEvaluator, BetaMemory memory) {
        TupleSets stagedRightTuples = memory.getStagedRightTuples();
        boolean stagedDeleteWasEmpty = stagedRightTuples.addDelete(rightTuple);
        boolean shouldFlush = this.isStreamMode();
        if (memory.getAndDecCounter() == 1) {
            if (stagedDeleteWasEmpty) {
                memory.setNodeDirtyWithoutNotify();
            }
            shouldFlush = memory.unlinkNode(reteEvaluator) | shouldFlush;
        } else if (stagedDeleteWasEmpty) {
            shouldFlush = memory.setNodeDirty((LeftTupleSource)this.betaNode, reteEvaluator) | shouldFlush;
        }
        if (shouldFlush) {
            TupleEvaluationUtil.flushLeftTupleIfNecessary(reteEvaluator, memory.getOrCreateSegmentMemory((LeftTupleSource)this.betaNode, reteEvaluator), this.isStreamMode());
        }
    }

    public void doUpdateRightTuple(TupleImpl rightTuple, ReteEvaluator reteEvaluator, BetaMemory memory) {
        TupleSets stagedRightTuples = memory.getStagedRightTuples();
        boolean stagedUpdateWasEmpty = stagedRightTuples.addUpdate(rightTuple);
        boolean shouldFlush = this.isStreamMode();
        if (stagedUpdateWasEmpty) {
            shouldFlush = memory.setNodeDirty((LeftTupleSource)this.betaNode, reteEvaluator) | shouldFlush;
        }
        if (shouldFlush) {
            TupleEvaluationUtil.flushLeftTupleIfNecessary(reteEvaluator, memory.getOrCreateSegmentMemory((LeftTupleSource)this.betaNode, reteEvaluator), this.isStreamMode());
        }
    }

    public static BetaMemory getBetaMemoryFromRightInput(BetaNode betaNode, ReteEvaluator reteEvaluator) {
        return 11799092 == betaNode.getType() ? ((AccumulateNode.AccumulateMemory)reteEvaluator.getNodeMemory(betaNode)).getBetaMemory() : (BetaMemory)reteEvaluator.getNodeMemory(betaNode);
    }

    public RightTuple createRightTuple(InternalFactHandle handle, RightTupleSink sink, PropagationContext context) {
        RightTuple rightTuple = new RightTuple(handle, sink);
        rightTuple.setPropagationContext(context);
        return rightTuple;
    }

    public void initDeclaredMask(BuildContext context) {
        if (context == null || context.getLastBuiltPatterns() == null) {
            this.declaredMask = AllSetBitMask.get();
            return;
        }
        Pattern pattern = context.getLastBuiltPatterns()[0];
        this.inputIsPassive = pattern.isPassive();
        if (!this.inputIsTupleToObjectNode()) {
            ObjectType objectType = pattern.getObjectType();
            if (PropertySpecificUtil.isPropertyReactive((RuleBase)context.getRuleBase(), (ObjectType)objectType)) {
                this.listenedProperties = pattern.getListenedProperties();
                List accessibleProperties = pattern.getAccessibleProperties((RuleBase)context.getRuleBase());
                this.declaredMask = pattern.getPositiveWatchMask(accessibleProperties);
                this.declaredMask = this.declaredMask.setAll(((BetaNode)this.betaNode).getRawConstraints().getListenedPropertyMask(pattern, objectType, accessibleProperties));
                this.negativeMask = pattern.getNegativeWatchMask(accessibleProperties);
            } else {
                this.declaredMask = AllSetBitMask.get();
            }
        } else {
            this.declaredMask = AllSetBitMask.get();
            context.setLastBuiltPattern(context.getLastBuiltPatterns()[0]);
        }
    }

    protected void initInferredMask() {
        ObjectSource unwrappedRight = this.getParent();
        if (unwrappedRight.getType() == 4587529) {
            AlphaNode alphaNode = (AlphaNode)unwrappedRight;
            this.inferredMask = alphaNode.updateMask(this.declaredMask);
        } else {
            this.inferredMask = this.declaredMask;
        }
        this.inferredMask = this.inferredMask.resetAll(this.negativeMask);
    }

    public boolean inputIsTupleToObjectNode() {
        return this.inputIsTupleToObjectNode;
    }

    @Override
    public void byPassModifyToBetaNode(InternalFactHandle factHandle, ModifyPreviousTuples modifyPreviousTuples, PropagationContext context, ReteEvaluator reteEvaluator) {
        this.modifyObject(factHandle, modifyPreviousTuples, context, reteEvaluator);
    }

    public BitMask calculateDeclaredMask(ObjectType modifiedType, List<String> settableProperties) {
        return null;
    }

    public void updateSink(ObjectSink sink, PropagationContext context, InternalWorkingMemory workingMemory) {
        this.source.updateSink(this, context, workingMemory);
    }

    @Override
    public abstract void retractRightTuple(TupleImpl var1, PropagationContext var2, ReteEvaluator var3);

    @Override
    public abstract void modifyRightTuple(TupleImpl var1, PropagationContext var2, ReteEvaluator var3);

    @Override
    public ObjectSinkNode getNextObjectSinkNode() {
        return this.nextObjectSinkNode;
    }

    @Override
    public void setNextObjectSinkNode(ObjectSinkNode next) {
        this.nextObjectSinkNode = next;
    }

    @Override
    public ObjectSinkNode getPreviousObjectSinkNode() {
        return this.previousObjectSinkNode;
    }

    @Override
    public void setPreviousObjectSinkNode(ObjectSinkNode previous) {
        this.previousObjectSinkNode = previous;
    }

    public BitMask getNegativeMask() {
        return this.negativeMask;
    }

    @Override
    public ObjectTypeNodeId getInputOtnId() {
        return this.inputOtnId;
    }

    public void setInputOtnId(ObjectTypeNodeId inputOtnId) {
        this.inputOtnId = inputOtnId;
    }

    public boolean isRightInputPassive() {
        return this.inputIsPassive;
    }

    @Override
    public ObjectTypeNode getObjectTypeNode() {
        if (this.objectTypeNode == null) {
            ObjectSource source = this.source;
            while (source != null) {
                if (4259849 == source.getType()) {
                    this.objectTypeNode = (ObjectTypeNode)source;
                    break;
                }
                source = source.source;
            }
        }
        return this.objectTypeNode;
    }

    @Override
    public void doAttach(BuildContext context) {
        super.doAttach(context);
        this.source.addObjectSink(this);
    }

    @Override
    public boolean doRemove(RuleRemovalContext context, ReteooBuilder builder) {
        if (!this.isInUse()) {
            this.source.removeObjectSink(this);
            return true;
        }
        return false;
    }

    @Override
    public boolean isInUse() {
        return ((LeftTupleSource)this.betaNode).isInUse();
    }

    protected int calculateHashCode() {
        int hash = 29 * this.source.hashCode();
        if (this.listenedProperties != null) {
            hash += 41 * this.listenedProperties.hashCode();
        }
        return hash + (this.inputIsPassive ? 43 : 0);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (this.hashCode() != object.hashCode()) {
            return false;
        }
        RightInputAdapterNode other = (RightInputAdapterNode)object;
        return this.getClass() == other.getClass() && this.inputIsPassive == other.inputIsPassive && Objects.equals(this.listenedProperties, other.listenedProperties) && this.source.getId() == other.source.getId();
    }

    @Override
    public String toString() {
        return "RightInputAdapterNode(" + this.id + ")[ source=" + this.source + ", associations=" + this.associations + ", partitionId=" + this.partitionId + "]";
    }

    @Override
    public void networkUpdated(UpdateContext updateContext) {
        this.source.networkUpdated(updateContext);
    }

    @Override
    public final void setPartitionIdWithSinks(RuleBasePartitionId partitionId) {
        this.partitionId = partitionId;
    }

    @Override
    public BitMask getDeclaredMask() {
        return this.declaredMask;
    }

    @Override
    public BitMask getInferredMask() {
        return this.inferredMask;
    }
}

