/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.reteoo;

import java.util.List;
import org.drools.base.RuleBase;
import org.drools.base.base.ObjectType;
import org.drools.base.common.NetworkNode;
import org.drools.base.common.RuleBasePartitionId;
import org.drools.base.reteoo.NodeTypeEnums;
import org.drools.base.reteoo.PropertySpecificUtil;
import org.drools.base.rule.Pattern;
import org.drools.core.common.BaseNode;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.common.PropagationContext;
import org.drools.core.common.UpdateContext;
import org.drools.core.impl.InternalRuleBase;
import org.drools.core.reteoo.EmptyObjectSinkAdapter;
import org.drools.core.reteoo.ObjectSink;
import org.drools.core.reteoo.ObjectSinkNode;
import org.drools.core.reteoo.ObjectSinkPropagator;
import org.drools.core.reteoo.ObjectTypeNode;
import org.drools.core.reteoo.ReteooBuilder;
import org.drools.core.reteoo.RuleRemovalContext;
import org.drools.core.reteoo.builder.BuildContext;
import org.drools.util.bitmask.AllSetBitMask;
import org.drools.util.bitmask.BitMask;
import org.drools.util.bitmask.EmptyBitMask;

public abstract class ObjectSource
extends BaseNode {
    protected ObjectSinkPropagator sink;
    protected ObjectSource source;
    protected int alphaNodeHashingThreshold;
    protected int alphaNodeRangeIndexThreshold;
    protected BitMask declaredMask = EmptyBitMask.get();
    protected BitMask inferredMask = EmptyBitMask.get();

    public ObjectSource() {
    }

    protected ObjectSource(int id, RuleBasePartitionId partitionId) {
        this(id, partitionId, null, 3, 3);
    }

    protected ObjectSource(int id, ObjectSource objectSource, RuleBasePartitionId partitionId) {
        this(id, partitionId, objectSource, 3, 3);
    }

    ObjectSource(int id, RuleBasePartitionId partitionId, ObjectSource objectSource, int alphaNodeHashingThreshold, int alphaNodeRangeIndexThreshold) {
        super(id, partitionId);
        this.source = objectSource;
        this.alphaNodeHashingThreshold = alphaNodeHashingThreshold;
        this.alphaNodeRangeIndexThreshold = alphaNodeRangeIndexThreshold;
        this.sink = EmptyObjectSinkAdapter.getInstance();
    }

    public InternalRuleBase getRuleBase() {
        return this.source.getRuleBase();
    }

    @Override
    public BaseNode getParent() {
        return this.source;
    }

    public void initDeclaredMask(BuildContext context) {
        if (context == null || context.getLastBuiltPatterns() == null) {
            this.declaredMask = AllSetBitMask.get();
            return;
        }
        Pattern pattern = context.getLastBuiltPatterns()[0];
        ObjectType objectType = pattern.getObjectType();
        if (PropertySpecificUtil.isPropertyReactive((RuleBase)context.getRuleBase(), (ObjectType)objectType)) {
            List settableProperties = PropertySpecificUtil.getAccessibleProperties((RuleBase)context.getRuleBase(), (ObjectType)objectType);
            this.declaredMask = this.calculateDeclaredMask(pattern, objectType, settableProperties);
        } else {
            this.declaredMask = AllSetBitMask.get();
        }
    }

    public abstract BitMask calculateDeclaredMask(Pattern var1, ObjectType var2, List<String> var3);

    public void resetInferredMask() {
        this.inferredMask = EmptyBitMask.get();
    }

    public BitMask updateMask(BitMask mask) {
        BitMask returnMask = this.source.getType() != 4259849 ? this.source.updateMask(this.declaredMask.clone().setAll(mask)) : this.declaredMask.clone().setAll(mask);
        this.inferredMask = this.inferredMask.setAll(returnMask);
        return returnMask;
    }

    @Override
    public void setPartitionId(BuildContext context, RuleBasePartitionId partitionId) {
        if (this.partitionId != null && this.partitionId != partitionId) {
            this.source.sink.changeSinkPartition((ObjectSink)((Object)this), this.partitionId, partitionId, this.source.alphaNodeHashingThreshold, this.source.alphaNodeRangeIndexThreshold);
        }
        this.partitionId = partitionId;
    }

    public final RuleBasePartitionId setSourcePartitionId(RuleBasePartitionId partitionId) {
        if (this.partitionId == null || this.partitionId == partitionId) {
            this.partitionId = partitionId;
            return partitionId;
        }
        this.partitionId = partitionId;
        if (this.source.getPartitionId() == RuleBasePartitionId.MAIN_PARTITION) {
            this.setPartitionIdWithSinks(partitionId);
        } else {
            this.source.setSourcePartitionId(partitionId);
        }
        return partitionId;
    }

    public final void setPartitionIdWithSinks(RuleBasePartitionId partitionId) {
        this.partitionId = partitionId;
        for (ObjectSink sink : this.getObjectSinkPropagator().getSinks()) {
            ((ObjectSinkNode)sink).setPartitionIdWithSinks(partitionId);
        }
    }

    public void addObjectSink(ObjectSink objectSink) {
        this.sink = this.sink.addObjectSink(objectSink, this.alphaNodeHashingThreshold, this.alphaNodeRangeIndexThreshold);
    }

    public void removeObjectSink(ObjectSink objectSink) {
        this.sink = this.sink.removeObjectSink(objectSink);
    }

    public abstract void updateSink(ObjectSink var1, PropagationContext var2, InternalWorkingMemory var3);

    @Override
    public void networkUpdated(UpdateContext updateContext) {
        this.source.networkUpdated(updateContext);
    }

    public ObjectSinkPropagator getObjectSinkPropagator() {
        return this.sink;
    }

    public void setObjectSinkPropagator(ObjectSinkPropagator sink) {
        this.sink = sink;
    }

    @Override
    public boolean isInUse() {
        return this.sink.size() > 0;
    }

    @Override
    protected boolean doRemove(RuleRemovalContext context, ReteooBuilder builder) {
        if (!this.isInUse() && NodeTypeEnums.isObjectSink((NetworkNode)this)) {
            this.source.removeObjectSink((ObjectSink)((Object)this));
            return true;
        }
        return false;
    }

    @Override
    public ObjectTypeNode getObjectTypeNode() {
        ObjectSource source = this;
        while (source != null) {
            if (source.getType() == 4259849) {
                return (ObjectTypeNode)source;
            }
            source = source.source;
        }
        return null;
    }

    @Override
    public BitMask getDeclaredMask() {
        return this.declaredMask;
    }

    @Override
    public BitMask getInferredMask() {
        return this.inferredMask;
    }
}

