/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.reteoo;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.drools.base.base.ClassObjectType;
import org.drools.base.base.ObjectType;
import org.drools.base.base.ValueResolver;
import org.drools.base.common.NetworkNode;
import org.drools.base.reteoo.AccumulateContextEntry;
import org.drools.base.reteoo.BaseTuple;
import org.drools.base.rule.Accumulate;
import org.drools.base.rule.Declaration;
import org.drools.base.rule.Pattern;
import org.drools.base.rule.TypeDeclaration;
import org.drools.base.rule.accessor.Accumulator;
import org.drools.base.rule.constraint.AlphaNodeFieldConstraint;
import org.drools.core.RuleBaseConfiguration;
import org.drools.core.common.BetaConstraints;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.Memory;
import org.drools.core.common.PropagationContext;
import org.drools.core.common.ReteEvaluator;
import org.drools.core.impl.InternalRuleBase;
import org.drools.core.phreak.PhreakAccumulateNode;
import org.drools.core.reteoo.BetaMemory;
import org.drools.core.reteoo.BetaNode;
import org.drools.core.reteoo.LeftInputAdapterNode;
import org.drools.core.reteoo.LeftTupleSource;
import org.drools.core.reteoo.RightInputAdapterNode;
import org.drools.core.reteoo.SegmentMemory;
import org.drools.core.reteoo.SegmentNodeMemory;
import org.drools.core.reteoo.TupleImpl;
import org.drools.core.reteoo.builder.BuildContext;
import org.drools.core.util.AbstractLinkedListNode;
import org.drools.core.util.index.TupleList;
import org.drools.core.util.index.TupleListWithContext;
import org.drools.util.bitmask.BitMask;

public class AccumulateNode
extends BetaNode {
    private static final long serialVersionUID = 510L;
    protected Accumulate accumulate;
    protected AlphaNodeFieldConstraint[] resultConstraints;
    protected BetaConstraints resultBinder;

    public AccumulateNode() {
    }

    public AccumulateNode(int id, LeftTupleSource leftInput, RightInputAdapterNode rightInput, AlphaNodeFieldConstraint[] resultConstraints, BetaConstraints sourceBinder, BetaConstraints resultBinder, Accumulate accumulate, BuildContext context) {
        super(id, leftInput, rightInput, sourceBinder, context);
        this.setObjectCount(leftInput.getObjectCount() + 1);
        this.resultBinder = resultBinder;
        this.resultBinder.init(context, this.getType());
        this.resultConstraints = resultConstraints;
        this.accumulate = accumulate;
        this.tupleMemoryEnabled = context.isTupleMemoryEnabled();
        this.addAccFunctionDeclarationsToLeftMask(context.getRuleBase(), leftInput, accumulate);
        this.hashcode = this.leftInput.hashCode() ^ this.rightInput.hashCode() ^ this.accumulate.hashCode() ^ this.resultBinder.hashCode() ^ Arrays.hashCode(this.resultConstraints);
    }

    private void addAccFunctionDeclarationsToLeftMask(InternalRuleBase ruleBase, LeftTupleSource leftInput, Accumulate accumulate) {
        TypeDeclaration typeDeclaration;
        BitMask leftMask = this.getInferredMask();
        ObjectType leftObjectType = leftInput.getObjectType();
        if (leftObjectType instanceof ClassObjectType && (typeDeclaration = ruleBase.getExactTypeDeclaration(((ClassObjectType)leftObjectType).getClassType())) != null && typeDeclaration.isPropertyReactive()) {
            List accessibleProperties = typeDeclaration.getAccessibleProperties();
            for (Declaration decl : accumulate.getRequiredDeclarations()) {
                if (!leftObjectType.equals(decl.getPattern().getObjectType())) continue;
                leftMask = leftMask.setAll(decl.getPattern().getPositiveWatchMask(accessibleProperties));
            }
        }
        this.setInferredMask(leftMask);
    }

    @Override
    protected ObjectType getObjectTypeForPropertyReactivity(LeftInputAdapterNode leftInput, Pattern pattern) {
        return pattern != null && this.rightInput.inputIsTupleToObjectNode() ? pattern.getObjectType() : leftInput.getParentObjectSource().getObjectTypeNode().getObjectType();
    }

    @Override
    public int getType() {
        return 11799092;
    }

    public Accumulate getAccumulate() {
        return this.accumulate;
    }

    public AlphaNodeFieldConstraint[] getResultConstraints() {
        return this.resultConstraints;
    }

    public BetaConstraints getResultBinder() {
        return this.resultBinder;
    }

    public InternalFactHandle createResultFactHandle(PropagationContext context, ReteEvaluator reteEvaluator, TupleImpl leftTuple, Object result) {
        InternalFactHandle handle = null;
        if (context.getReaderContext() != null) {
            handle = context.getReaderContext().createAccumulateHandle(context.getEntryPoint(), reteEvaluator, leftTuple, result, this.getId());
        }
        if (handle == null) {
            handle = reteEvaluator.createFactHandle(result, null, null);
        }
        return handle;
    }

    @Override
    public void doAttach(BuildContext context) {
        super.doAttach(context);
    }

    @Override
    protected int calculateHashCode() {
        return 0;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (((NetworkNode)object).getType() != 11799092 || this.hashCode() != object.hashCode()) {
            return false;
        }
        AccumulateNode other = (AccumulateNode)object;
        return this.leftInput.getId() == other.leftInput.getId() && this.rightInput.equals(other.rightInput) && this.constraints.equals(other.constraints) && this.accumulate.equals(other.accumulate) && this.resultBinder.equals(other.resultBinder) && Arrays.equals(this.resultConstraints, other.resultConstraints);
    }

    @Override
    public Memory createMemory(RuleBaseConfiguration config, ReteEvaluator reteEvaluator) {
        BetaMemory betaMemory = this.constraints.createBetaMemory(config, 11799092);
        AccumulateMemory memory = this.accumulate.isMultiFunction() ? new MultiAccumulateMemory(betaMemory, this.accumulate.getAccumulators()) : new SingleAccumulateMemory(betaMemory, this.accumulate.getAccumulators()[0]);
        memory.workingMemoryContext = this.accumulate.createWorkingMemoryContext();
        memory.resultsContext = this.resultBinder.createContext();
        return memory;
    }

    public static class MultiAccumulateMemory
    extends AccumulateMemory {
        private final Accumulator[] accumulators;

        public MultiAccumulateMemory(BetaMemory betaMemory, Accumulator[] accumulators) {
            super(betaMemory);
            this.accumulators = accumulators;
        }

        @Override
        public void reset() {
            this.getBetaMemory().reset();
            this.workingMemoryContext = new Object[this.accumulators.length];
            for (int i = 0; i < this.accumulators.length; ++i) {
                ((Object[])this.workingMemoryContext)[i] = this.accumulators[i].createWorkingMemoryContext();
            }
        }
    }

    public static class SingleAccumulateMemory
    extends AccumulateMemory {
        private final Accumulator accumulator;

        public SingleAccumulateMemory(BetaMemory betaMemory, Accumulator accumulator) {
            super(betaMemory);
            this.accumulator = accumulator;
        }

        @Override
        public void reset() {
            this.getBetaMemory().reset();
            this.workingMemoryContext = this.accumulator.createWorkingMemoryContext();
        }
    }

    public static abstract class AccumulateMemory
    extends AbstractLinkedListNode<Memory>
    implements SegmentNodeMemory {
        public Object workingMemoryContext;
        private final BetaMemory<?> betaMemory;
        public Object resultsContext;

        protected AccumulateMemory(BetaMemory betaMemory) {
            this.betaMemory = betaMemory;
        }

        public BetaMemory getBetaMemory() {
            return this.betaMemory;
        }

        @Override
        public int getNodeType() {
            return 11799092;
        }

        @Override
        public SegmentMemory getSegmentMemory() {
            return this.betaMemory.getSegmentMemory();
        }

        @Override
        public void setSegmentMemory(SegmentMemory segmentMemory) {
            this.betaMemory.setSegmentMemory(segmentMemory);
        }

        @Override
        public abstract void reset();

        @Override
        public long getNodePosMaskBit() {
            return this.betaMemory.getNodePosMaskBit();
        }

        @Override
        public void setNodePosMaskBit(long segmentPos) {
            this.betaMemory.setNodePosMaskBit(segmentPos);
        }

        @Override
        public void setNodeDirtyWithoutNotify() {
            this.betaMemory.setNodeDirtyWithoutNotify();
        }

        @Override
        public void setNodeCleanWithoutNotify() {
            this.betaMemory.setNodeCleanWithoutNotify();
        }
    }

    public static class GroupByContext
    implements BaseAccumulation {
        private PropagationContext propagationContext;
        private Map<Object, TupleListWithContext<AccumulateContextEntry>> groupsMap = new HashMap<Object, TupleListWithContext<AccumulateContextEntry>>();
        private TupleListWithContext<AccumulateContextEntry> lastTupleList;
        private TupleListWithContext<AccumulateContextEntry> toPropagateList;

        @Override
        public PropagationContext getPropagationContext() {
            return this.propagationContext;
        }

        @Override
        public void setPropagationContext(PropagationContext propagationContext) {
            this.propagationContext = propagationContext;
        }

        public Map<Object, TupleListWithContext<AccumulateContextEntry>> getGroups() {
            return this.groupsMap;
        }

        public TupleListWithContext<AccumulateContextEntry> getGroup(Object workingMemoryContext, Accumulate accumulate, BaseTuple leftTuple, Object key, ValueResolver reteEvaluator) {
            return this.groupsMap.computeIfAbsent(key, k -> {
                AccumulateContextEntry entry = new AccumulateContextEntry(key);
                entry.setFunctionContext(accumulate.init(workingMemoryContext, (Object)entry, accumulate.createFunctionContext(), leftTuple, reteEvaluator));
                PhreakAccumulateNode.initContext(workingMemoryContext, reteEvaluator, accumulate, leftTuple, entry);
                return new TupleListWithContext<AccumulateContextEntry>(entry);
            });
        }

        public void removeGroup(Object key) {
            this.groupsMap.remove(key);
        }

        public void moveToPropagateTupleList(TupleListWithContext<AccumulateContextEntry> list) {
            this.lastTupleList = list;
            if (list.getContext().isToPropagate()) {
                return;
            }
            list.setNext(this.toPropagateList);
            this.toPropagateList = list;
            list.getContext().setToPropagate(true);
        }

        public TupleListWithContext<AccumulateContextEntry> takeToPropagateList() {
            TupleListWithContext<AccumulateContextEntry> list = this.toPropagateList;
            this.toPropagateList = null;
            return list;
        }

        public void addMatchOnLastTupleList(TupleImpl match) {
            this.lastTupleList.add(match);
            this.lastTupleList.getContext().setEmpty(false);
        }

        public void clear() {
            for (TupleList tupleList : this.groupsMap.values()) {
                TupleImpl tuple = (TupleImpl)tupleList.getFirst();
                while (tupleList.getFirst() != null) {
                    tupleList.remove(tuple);
                    tuple.setContextObject(null);
                    tuple = (TupleImpl)tupleList.getFirst();
                }
            }
            this.groupsMap.clear();
            this.toPropagateList = null;
            this.lastTupleList = null;
        }
    }

    public static class AccumulateContext
    extends AccumulateContextEntry
    implements BaseAccumulation {
        private PropagationContext propagationContext;

        public AccumulateContext() {
            super(null);
        }

        @Override
        public PropagationContext getPropagationContext() {
            return this.propagationContext;
        }

        @Override
        public void setPropagationContext(PropagationContext propagationContext) {
            this.propagationContext = propagationContext;
        }
    }

    public static interface BaseAccumulation {
        public PropagationContext getPropagationContext();

        public void setPropagationContext(PropagationContext var1);
    }
}

