/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.phreak;

import java.util.Iterator;
import org.drools.core.common.ReteEvaluator;
import org.drools.core.common.TupleSets;
import org.drools.core.phreak.RuntimeSegmentUtilities;
import org.drools.core.phreak.TupleEvaluationUtil;
import org.drools.core.reteoo.LeftTupleSink;
import org.drools.core.reteoo.LeftTupleSource;
import org.drools.core.reteoo.PathMemory;
import org.drools.core.reteoo.SegmentMemory;
import org.drools.core.reteoo.TupleFactory;
import org.drools.core.reteoo.TupleImpl;

public class SegmentPropagator {
    public static void propagate(SegmentMemory sourceSegment, TupleSets leftTuples, ReteEvaluator reteEvaluator) {
        if (leftTuples.isEmpty()) {
            return;
        }
        LeftTupleSource source = (LeftTupleSource)sourceSegment.getTipNode();
        if (sourceSegment.isEmpty()) {
            RuntimeSegmentUtilities.createChildSegments(reteEvaluator, source.getSinkPropagator(), sourceSegment);
        }
        SegmentPropagator.processPeers(sourceSegment, leftTuples);
        Iterator<SegmentMemory> peersIterator = sourceSegment.getPeersWithDataDrivenPathMemoriesIterator();
        while (peersIterator.hasNext()) {
            SegmentMemory smem = peersIterator.next();
            for (PathMemory dataDrivenPmem : smem.getDataDrivenPathMemories()) {
                if (smem.getStagedLeftTuples().getDeleteFirst() == null && smem.getStagedLeftTuples().getUpdateFirst() == null && !dataDrivenPmem.isRuleLinked()) continue;
                TupleEvaluationUtil.forceFlushLeftTuple(dataDrivenPmem, smem, reteEvaluator, smem.getStagedLeftTuples());
                TupleEvaluationUtil.forceFlushWhenSubnetwork(reteEvaluator, dataDrivenPmem);
            }
        }
    }

    private static void processPeers(SegmentMemory sourceSegment, TupleSets leftTuples) {
        SegmentMemory firstSmem = (SegmentMemory)sourceSegment.getFirst();
        SegmentPropagator.processPeerDeletes(leftTuples.getDeleteFirst(), firstSmem);
        SegmentPropagator.processPeerDeletes(leftTuples.getNormalizedDeleteFirst(), firstSmem);
        SegmentPropagator.processPeerUpdates(leftTuples, firstSmem);
        SegmentPropagator.processPeerInserts(leftTuples, firstSmem);
        firstSmem.getStagedLeftTuples().addAll(leftTuples);
        leftTuples.resetAll();
    }

    private static void processPeerInserts(TupleSets leftTuples, SegmentMemory firstSmem) {
        for (TupleImpl leftTuple = leftTuples.getInsertFirst(); leftTuple != null; leftTuple = leftTuple.getStagedNext()) {
            TupleImpl peer;
            SegmentMemory smem = firstSmem.getNext();
            if (smem == null) continue;
            if (leftTuple.getPeer() == null) {
                peer = leftTuple;
                while (smem != null) {
                    LeftTupleSink sink = smem.getSinkFactory();
                    peer = TupleFactory.createPeer(sink, peer);
                    smem.getStagedLeftTuples().addInsert(peer);
                    smem = smem.getNext();
                }
                continue;
            }
            peer = leftTuple.getPeer();
            while (smem != null) {
                peer.setPropagationContext(leftTuple.getPropagationContext());
                SegmentPropagator.updateChildLeftTupleDuringInsert(peer, smem.getStagedLeftTuples(), smem.getStagedLeftTuples());
                peer = peer.getPeer();
                smem = smem.getNext();
            }
        }
    }

    private static void processPeerUpdates(TupleSets leftTuples, SegmentMemory firstSmem) {
        for (TupleImpl leftTuple = leftTuples.getUpdateFirst(); leftTuple != null; leftTuple = leftTuple.getStagedNext()) {
            SegmentMemory smem = firstSmem.getNext();
            if (smem == null) continue;
            for (TupleImpl peer = leftTuple.getPeer(); peer != null; peer = peer.getPeer()) {
                if (peer.getStagedType() == 0) {
                    peer.setPropagationContext(leftTuple.getPropagationContext());
                    smem.getStagedLeftTuples().addUpdate(peer);
                }
                smem = smem.getNext();
            }
        }
    }

    private static void updateChildLeftTupleDuringInsert(TupleImpl childLeftTuple, TupleSets stagedLeftTuples, TupleSets trgLeftTuples) {
        switch (childLeftTuple.getStagedType()) {
            case 1: {
                stagedLeftTuples.removeInsert(childLeftTuple);
                trgLeftTuples.addInsert(childLeftTuple);
                break;
            }
            case 2: {
                stagedLeftTuples.removeUpdate(childLeftTuple);
                trgLeftTuples.addUpdate(childLeftTuple);
                break;
            }
            default: {
                if (childLeftTuple.getSink().getType() == 11799092) {
                    trgLeftTuples.addInsert(childLeftTuple);
                    break;
                }
                trgLeftTuples.addUpdate(childLeftTuple);
            }
        }
    }

    private static void processPeerDeletes(TupleImpl leftTuple, SegmentMemory firstSmem) {
        while (leftTuple != null) {
            SegmentMemory smem = firstSmem.getNext();
            if (smem != null) {
                for (TupleImpl peer = leftTuple.getPeer(); peer != null; peer = peer.getPeer()) {
                    peer.setPropagationContext(leftTuple.getPropagationContext());
                    TupleSets stagedLeftTuples = smem.getStagedLeftTuples();
                    stagedLeftTuples.addDelete(peer);
                    smem = smem.getNext();
                }
            }
            leftTuple = leftTuple.getStagedNext();
        }
    }
}

