/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.phreak;

import org.drools.core.base.DroolsQueryImpl;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.PropagationContext;
import org.drools.core.common.ReteEvaluator;
import org.drools.core.common.TupleSets;
import org.drools.core.phreak.RuleNetworkEvaluator;
import org.drools.core.phreak.StackEntry;
import org.drools.core.reteoo.LeftInputAdapterNode;
import org.drools.core.reteoo.QueryElementNode;
import org.drools.core.reteoo.SegmentMemory;
import org.drools.core.reteoo.TupleImpl;

public class PhreakQueryNode {
    public void doNode(QueryElementNode queryNode, QueryElementNode.QueryElementNodeMemory qmem, StackEntry stackEntry, ReteEvaluator reteEvaluator, TupleSets srcLeftTuples, TupleSets trgLeftTuples, TupleSets stagedLeftTuples) {
        if (srcLeftTuples.getDeleteFirst() != null) {
            this.doLeftDeletes(qmem, reteEvaluator, srcLeftTuples, trgLeftTuples, stagedLeftTuples);
        }
        if (srcLeftTuples.getUpdateFirst() != null) {
            this.doLeftUpdates(queryNode, qmem, reteEvaluator, srcLeftTuples);
        }
        if (srcLeftTuples.getInsertFirst() != null) {
            this.doLeftInserts(queryNode, qmem, stackEntry, reteEvaluator, srcLeftTuples);
        }
        srcLeftTuples.resetAll();
    }

    public void doLeftInserts(QueryElementNode queryNode, QueryElementNode.QueryElementNodeMemory qmem, StackEntry stackEntry, ReteEvaluator reteEvaluator, TupleSets srcLeftTuples) {
        TupleImpl leftTuple = srcLeftTuples.getInsertFirst();
        while (leftTuple != null) {
            TupleImpl next = leftTuple.getStagedNext();
            PropagationContext pCtx = leftTuple.getPropagationContext();
            InternalFactHandle handle = queryNode.createFactHandle(pCtx, reteEvaluator, leftTuple);
            DroolsQueryImpl dquery = queryNode.createDroolsQuery(leftTuple, handle, stackEntry, qmem.getSegmentMemory().getPathMemories(), qmem, stackEntry.getSink(), reteEvaluator);
            LeftInputAdapterNode lian = (LeftInputAdapterNode)qmem.getQuerySegmentMemory().getRootNode();
            LeftInputAdapterNode.LiaNodeMemory lm = (LeftInputAdapterNode.LiaNodeMemory)qmem.getQuerySegmentMemory().getNodeMemories()[0];
            LeftInputAdapterNode.doInsertObject(handle, pCtx, lian, reteEvaluator, lm, false, dquery.isOpen());
            leftTuple.clearStaged();
            leftTuple = next;
        }
    }

    public void doLeftUpdates(QueryElementNode queryNode, QueryElementNode.QueryElementNodeMemory qmem, ReteEvaluator reteEvaluator, TupleSets srcLeftTuples) {
        TupleImpl leftTuple = srcLeftTuples.getUpdateFirst();
        while (leftTuple != null) {
            TupleImpl next = leftTuple.getStagedNext();
            InternalFactHandle fh = (InternalFactHandle)leftTuple.getContextObject();
            DroolsQueryImpl dquery = (DroolsQueryImpl)fh.getObject();
            dquery.setParameters(queryNode.getActualArguments(leftTuple, reteEvaluator));
            SegmentMemory qsmem = qmem.getQuerySegmentMemory();
            LeftInputAdapterNode lian = (LeftInputAdapterNode)qsmem.getRootNode();
            LeftInputAdapterNode.LiaNodeMemory lmem = (LeftInputAdapterNode.LiaNodeMemory)qsmem.getNodeMemories()[0];
            if (dquery.isOpen()) {
                TupleImpl childLeftTuple = fh.getFirstLeftTuple();
                LeftInputAdapterNode.doUpdateObject(childLeftTuple, childLeftTuple.getPropagationContext(), reteEvaluator, lian, false, lmem, qmem.getQuerySegmentMemory());
            } else {
                if (fh.getFirstLeftTuple() != null) {
                    throw new RuntimeException("defensive programming while testing");
                }
                LeftInputAdapterNode.LiaNodeMemory lm = (LeftInputAdapterNode.LiaNodeMemory)qmem.getQuerySegmentMemory().getNodeMemories()[0];
                LeftInputAdapterNode.doInsertObject(fh, leftTuple.getPropagationContext(), lian, reteEvaluator, lm, false, dquery.isOpen());
            }
            leftTuple.clearStaged();
            leftTuple = next;
        }
    }

    public void doLeftDeletes(QueryElementNode.QueryElementNodeMemory qmem, ReteEvaluator reteEvaluator, TupleSets srcLeftTuples, TupleSets trgLeftTuples, TupleSets stagedLeftTuples) {
        TupleImpl leftTuple = srcLeftTuples.getDeleteFirst();
        while (leftTuple != null) {
            TupleImpl next = leftTuple.getStagedNext();
            InternalFactHandle fh = (InternalFactHandle)leftTuple.getContextObject();
            DroolsQueryImpl dquery = (DroolsQueryImpl)fh.getObject();
            if (dquery.isOpen()) {
                LeftInputAdapterNode lian = (LeftInputAdapterNode)qmem.getQuerySegmentMemory().getRootNode();
                LeftInputAdapterNode.LiaNodeMemory lm = (LeftInputAdapterNode.LiaNodeMemory)qmem.getQuerySegmentMemory().getNodeMemories()[0];
                TupleImpl childLeftTuple = fh.getFirstLeftTuple();
                LeftInputAdapterNode.doDeleteObject(childLeftTuple, childLeftTuple.getPropagationContext(), qmem.getQuerySegmentMemory(), reteEvaluator, lian, false, lm);
            } else {
                TupleImpl childLeftTuple = leftTuple.getFirstChild();
                while (childLeftTuple != null) {
                    TupleImpl nextChild = childLeftTuple.getHandleNext();
                    RuleNetworkEvaluator.unlinkAndDeleteChildLeftTuple(childLeftTuple, trgLeftTuples, stagedLeftTuples);
                    childLeftTuple = nextChild;
                }
            }
            leftTuple.clearStaged();
            leftTuple = next;
        }
    }
}

