/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.phreak;

import org.drools.core.common.BetaConstraints;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.ReteEvaluator;
import org.drools.core.common.TupleSets;
import org.drools.core.phreak.PhreakAsyncSendNode;
import org.drools.core.reteoo.AsyncReceiveNode;
import org.drools.core.reteoo.LeftTupleSink;
import org.drools.core.reteoo.Sink;
import org.drools.core.reteoo.TupleFactory;
import org.drools.core.reteoo.TupleImpl;
import org.drools.core.util.index.TupleList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PhreakAsyncReceiveNode {
    private static final Logger log = LoggerFactory.getLogger(PhreakAsyncReceiveNode.class);

    public void doNode(AsyncReceiveNode node, AsyncReceiveNode.AsyncReceiveMemory memory, LeftTupleSink sink, ReteEvaluator reteEvaluator, TupleSets srcLeftTuples, TupleSets trgLeftTuples) {
        if (srcLeftTuples.getInsertFirst() != null) {
            this.doLeftInserts(memory, srcLeftTuples);
        }
        PhreakAsyncReceiveNode.doPropagateChildLeftTuples(node, memory, reteEvaluator, sink, trgLeftTuples);
        srcLeftTuples.resetAll();
    }

    private void doLeftInserts(AsyncReceiveNode.AsyncReceiveMemory memory, TupleSets srcLeftTuples) {
        TupleImpl leftTuple = srcLeftTuples.getInsertFirst();
        while (leftTuple != null) {
            TupleImpl next = leftTuple.getStagedNext();
            memory.addInsertOrUpdateLeftTuple(leftTuple);
            leftTuple.clearStaged();
            leftTuple = next;
        }
    }

    private static void doPropagateChildLeftTuples(AsyncReceiveNode node, AsyncReceiveNode.AsyncReceiveMemory memory, ReteEvaluator reteEvaluator, LeftTupleSink sink, TupleSets trgLeftTuples) {
        BetaConstraints betaConstraints = node.getBetaConstraints();
        Object context = betaConstraints.createContext();
        TupleList leftTuples = memory.getInsertOrUpdateLeftTuples();
        for (TupleImpl leftTuple = (TupleImpl)leftTuples.getFirst(); leftTuple != null; leftTuple = leftTuple.getNext()) {
            betaConstraints.updateFromTuple(context, reteEvaluator, leftTuple);
            for (Object message : memory.getMessages()) {
                InternalFactHandle factHandle = reteEvaluator.getFactHandleFactory().newFactHandle(message, node.getObjectTypeConf(reteEvaluator), reteEvaluator, null);
                if (!PhreakAsyncSendNode.isAllowed(factHandle, node.getAlphaConstraints(), reteEvaluator) || !betaConstraints.isAllowedCachedLeft(context, factHandle)) continue;
                TupleImpl childLeftTuple = TupleFactory.createLeftTuple(factHandle, leftTuple, (Sink)sink);
                childLeftTuple.setPropagationContext(leftTuple.getPropagationContext());
                trgLeftTuples.addInsert(childLeftTuple);
            }
        }
        memory.reset();
    }
}

