/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.concurrent;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.drools.base.common.PartitionsManager;
import org.drools.base.common.RuleBasePartitionId;
import org.drools.core.common.ActivationsManager;
import org.drools.core.common.InternalAgendaGroup;
import org.drools.core.concurrent.AbstractGroupEvaluator;
import org.drools.core.impl.InternalRuleBase;
import org.drools.core.phreak.RuleAgendaItem;

public class ParallelGroupEvaluator
extends AbstractGroupEvaluator {
    public ParallelGroupEvaluator(InternalRuleBase ruleBase, ActivationsManager activationsManager) {
        super(ruleBase, activationsManager);
    }

    @Override
    protected void startEvaluation(InternalAgendaGroup group) {
        super.startEvaluation(group);
        this.parallelPreEvaluation(group);
    }

    private void parallelPreEvaluation(InternalAgendaGroup group) {
        Collection<RuleAgendaItem> activations = group.getActivations();
        if (activations.size() < 8) {
            return;
        }
        Map<RuleBasePartitionId, List<RuleAgendaItem>> partitionedActivations = activations.stream().collect(Collectors.groupingBy(RuleAgendaItem::getPartition));
        if (partitionedActivations.size() < 8) {
            return;
        }
        PartitionsManager.doOnForkJoinPool(() -> partitionedActivations.values().parallelStream().forEach(items -> items.forEach(item -> item.getRuleExecutor().evaluateNetworkIfDirty(this.activationsManager))));
    }
}

