/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.util;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.drools.core.util.AbstractHashTable;
import org.drools.core.util.Iterator;
import org.drools.core.util.SingleLinkedEntry;

public class HashTableIterator
implements Iterator,
Externalizable {
    private static final long serialVersionUID = 510L;
    private AbstractHashTable hashTable;
    private SingleLinkedEntry[] table;
    public int row;
    private int length;
    private SingleLinkedEntry entry;

    public HashTableIterator() {
    }

    public HashTableIterator(AbstractHashTable hashTable) {
        this.hashTable = hashTable;
        this.reset();
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.hashTable = (AbstractHashTable)in.readObject();
        this.table = (SingleLinkedEntry[])in.readObject();
        this.row = in.readInt();
        this.length = in.readInt();
        this.entry = (SingleLinkedEntry)in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.hashTable);
        out.writeObject(this.table);
        out.writeInt(this.row);
        out.writeInt(this.length);
        out.writeObject(this.entry);
    }

    public Object next() {
        if (this.entry != null) {
            this.entry = this.entry.getNext();
        }
        while (this.entry == null && this.row < this.length) {
            this.entry = this.table[this.row];
            ++this.row;
        }
        return this.entry;
    }

    public void reset() {
        this.table = this.hashTable.getTable();
        this.length = this.table.length;
        this.entry = null;
        this.row = 0;
    }
}

