/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.reteoo;

import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.PropagationContext;
import org.drools.core.reteoo.AgendaComponentFactory;
import org.drools.core.reteoo.EvalNodeLeftTuple;
import org.drools.core.reteoo.LeftTuple;
import org.drools.core.reteoo.NotNodeLeftTuple;
import org.drools.core.reteoo.ReactiveFromNodeLeftTuple;
import org.drools.core.reteoo.Sink;
import org.drools.core.reteoo.SubnetworkTuple;
import org.drools.core.reteoo.TupleImpl;
import org.kie.api.runtime.rule.FactHandle;

public class TupleFactory {
    public static TupleImpl createPeer(Sink n, TupleImpl original) {
        TupleImpl peer = switch (n.getType()) {
            case 8849460, 9832500, 10816052, 11799092 -> new LeftTuple();
            case 11143732, 11471412 -> new NotNodeLeftTuple();
            case 7538740, 7866420, 8521780, 10160180 -> new EvalNodeLeftTuple();
            case 9177140 -> new ReactiveFromNodeLeftTuple();
            case 5245233 -> new SubnetworkTuple();
            case 5900720, 6228400 -> AgendaComponentFactory.get().createTerminalTuple();
            default -> throw new IllegalStateException("Tuple factory not found for node: " + n);
        };
        peer.initPeer(original, n);
        original.setPeer(peer);
        return peer;
    }

    public static TupleImpl createLeftTuple(Sink s, InternalFactHandle factHandle, boolean leftTupleMemoryEnabled) {
        switch (s.getType()) {
            case 8194100: 
            case 8849460: 
            case 9832500: 
            case 10816052: 
            case 11799092: {
                return new LeftTuple(factHandle, s, leftTupleMemoryEnabled);
            }
            case 11143732: 
            case 11471412: {
                return new NotNodeLeftTuple(factHandle, s, leftTupleMemoryEnabled);
            }
            case 7538740: 
            case 7866420: 
            case 8521780: 
            case 10160180: {
                return new EvalNodeLeftTuple(factHandle, s, leftTupleMemoryEnabled);
            }
            case 9177140: {
                return new ReactiveFromNodeLeftTuple((FactHandle)factHandle, s, leftTupleMemoryEnabled);
            }
            case 5245233: {
                return new SubnetworkTuple(factHandle, s, leftTupleMemoryEnabled);
            }
            case 5900720: 
            case 6228400: {
                return AgendaComponentFactory.get().createTerminalTuple(factHandle, s, leftTupleMemoryEnabled);
            }
        }
        throw new IllegalStateException("Tuple factory not found for node: " + s);
    }

    public static TupleImpl createLeftTuple(InternalFactHandle factHandle, TupleImpl leftTuple, Sink s) {
        switch (s.getType()) {
            case 8194100: 
            case 8849460: 
            case 9832500: 
            case 10816052: 
            case 11799092: {
                return new LeftTuple(factHandle, leftTuple, s);
            }
            case 11143732: 
            case 11471412: {
                return new NotNodeLeftTuple(factHandle, leftTuple, s);
            }
            case 7538740: 
            case 7866420: 
            case 8521780: 
            case 10160180: {
                return new EvalNodeLeftTuple(factHandle, leftTuple, s);
            }
            case 9177140: {
                return new ReactiveFromNodeLeftTuple(factHandle, leftTuple, s);
            }
            case 5245233: {
                return new SubnetworkTuple(factHandle, leftTuple, s);
            }
            case 5900720: 
            case 6228400: {
                return AgendaComponentFactory.get().createTerminalTuple(factHandle, leftTuple, s);
            }
        }
        throw new IllegalStateException("Tuple factory not found for node: " + s);
    }

    public static TupleImpl createLeftTuple(TupleImpl leftTuple, Sink s, PropagationContext pctx, boolean leftTupleMemoryEnabled) {
        switch (s.getType()) {
            case 8194100: 
            case 8849460: 
            case 9832500: 
            case 10816052: 
            case 11799092: {
                return new LeftTuple(leftTuple, s, pctx, leftTupleMemoryEnabled);
            }
            case 11143732: 
            case 11471412: {
                return new NotNodeLeftTuple(leftTuple, s, pctx, leftTupleMemoryEnabled);
            }
            case 7538740: 
            case 7866420: 
            case 8521780: 
            case 10160180: {
                return new EvalNodeLeftTuple(leftTuple, s, pctx, leftTupleMemoryEnabled);
            }
            case 9177140: {
                throw new IllegalStateException("ReactFromNode does not implement this constructor.");
            }
            case 5245233: {
                return new SubnetworkTuple(leftTuple, s, pctx, leftTupleMemoryEnabled);
            }
            case 5900720: 
            case 6228400: {
                return AgendaComponentFactory.get().createTerminalTuple(leftTuple, s, pctx, leftTupleMemoryEnabled);
            }
        }
        throw new IllegalStateException("Tuple factory not found for node: " + s);
    }

    public static TupleImpl createLeftTuple(TupleImpl leftTuple, TupleImpl rightTuple, Sink s) {
        switch (s.getType()) {
            case 8194100: 
            case 8849460: 
            case 9832500: 
            case 10816052: 
            case 11799092: {
                return new LeftTuple(leftTuple, rightTuple, s);
            }
            case 11143732: 
            case 11471412: {
                return new NotNodeLeftTuple(leftTuple, rightTuple, s);
            }
            case 7538740: 
            case 7866420: 
            case 8521780: 
            case 10160180: {
                return new EvalNodeLeftTuple(leftTuple, rightTuple, s);
            }
            case 9177140: {
                throw new IllegalStateException("ReactFromNode does not implement this constructor.");
            }
            case 5245233: {
                return new SubnetworkTuple(leftTuple, rightTuple, s);
            }
            case 5900720: 
            case 6228400: {
                return AgendaComponentFactory.get().createTerminalTuple(leftTuple, rightTuple, s);
            }
        }
        throw new IllegalStateException("Tuple factory not found for node: " + s);
    }

    public static TupleImpl createLeftTuple(TupleImpl leftTuple, TupleImpl rightTuple, TupleImpl currentLeftChild, TupleImpl currentRightChild, Sink s, boolean leftTupleMemoryEnabled) {
        switch (s.getType()) {
            case 8194100: 
            case 8849460: 
            case 9832500: 
            case 10816052: 
            case 11799092: {
                return new LeftTuple(leftTuple, rightTuple, currentLeftChild, currentRightChild, s, leftTupleMemoryEnabled);
            }
            case 11143732: 
            case 11471412: {
                return new NotNodeLeftTuple(leftTuple, rightTuple, currentLeftChild, currentRightChild, s, leftTupleMemoryEnabled);
            }
            case 7538740: 
            case 7866420: 
            case 8521780: 
            case 10160180: {
                return new EvalNodeLeftTuple(leftTuple, rightTuple, currentLeftChild, currentRightChild, s, leftTupleMemoryEnabled);
            }
            case 9177140: {
                return new ReactiveFromNodeLeftTuple(leftTuple, rightTuple, currentLeftChild, currentRightChild, s, leftTupleMemoryEnabled);
            }
            case 5245233: {
                return new SubnetworkTuple(leftTuple, rightTuple, currentLeftChild, currentRightChild, s, leftTupleMemoryEnabled);
            }
            case 5900720: 
            case 6228400: {
                return AgendaComponentFactory.get().createTerminalTuple(leftTuple, rightTuple, currentLeftChild, currentRightChild, s, leftTupleMemoryEnabled);
            }
        }
        throw new IllegalStateException("Tuple factory not found for node: " + s);
    }
}

