/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.reteoo;

import java.io.Serializable;
import org.drools.base.common.NetworkNode;
import org.drools.base.definitions.rule.impl.RuleImpl;
import org.drools.base.reteoo.NodeTypeEnums;
import org.drools.core.common.ActivationsFilter;
import org.drools.core.common.ActivationsManager;
import org.drools.core.common.InternalAgendaGroup;
import org.drools.core.common.Memory;
import org.drools.core.common.ReteEvaluator;
import org.drools.core.phreak.RuleAgendaItem;
import org.drools.core.reteoo.AbstractTerminalNode;
import org.drools.core.reteoo.PathEndNode;
import org.drools.core.reteoo.SegmentMemory;
import org.drools.core.reteoo.TerminalNode;
import org.drools.core.util.AbstractLinkedListNode;
import org.kie.api.definition.rule.Rule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PathMemory
extends AbstractLinkedListNode<Memory>
implements Serializable,
Memory {
    protected static final Logger log = LoggerFactory.getLogger(PathMemory.class);
    protected static final boolean isLogTraceEnabled = log.isTraceEnabled();
    private long linkedSegmentMask;
    private long allLinkedMaskTest;
    private final PathEndNode pathEndNode;
    private RuleAgendaItem agendaItem;
    private SegmentMemory[] segmentMemories;
    private SegmentMemory segmentMemory;
    public final boolean dataDriven;

    public PathMemory(PathEndNode pathEndNode, ReteEvaluator reteEvaluator) {
        this.pathEndNode = pathEndNode;
        this.linkedSegmentMask = 0L;
        this.dataDriven = this.initDataDriven(reteEvaluator);
    }

    protected boolean initDataDriven(ReteEvaluator reteEvaluator) {
        return this.isRuleDataDriven(reteEvaluator, this.getRule());
    }

    protected boolean isRuleDataDriven(ReteEvaluator reteEvaluator, RuleImpl rule) {
        return rule != null && (rule.isDataDriven() || reteEvaluator != null && reteEvaluator.getRuleSessionConfiguration().getForceEagerActivationFilter().accept((Rule)rule));
    }

    public PathEndNode getPathEndNode() {
        return this.pathEndNode;
    }

    public RuleImpl getRule() {
        return NodeTypeEnums.isTerminalNode((NetworkNode)this.pathEndNode) ? ((TerminalNode)this.pathEndNode).getRule() : null;
    }

    public RuleAgendaItem getRuleAgendaItem() {
        return this.agendaItem;
    }

    public long getLinkedSegmentMask() {
        return this.linkedSegmentMask;
    }

    public void setLinkedSegmentMask(long mask) {
        this.linkedSegmentMask = mask;
    }

    public long getAllLinkedMaskTest() {
        return this.allLinkedMaskTest;
    }

    public void setAllLinkedMaskTest(long allLinkedTestMask) {
        this.allLinkedMaskTest = allLinkedTestMask;
    }

    public void linkSegmentWithoutRuleNotify(long mask) {
        this.linkedSegmentMask |= mask;
    }

    public void linkSegment(long mask, ReteEvaluator reteEvaluator) {
        this.linkedSegmentMask |= mask;
        if (isLogTraceEnabled) {
            if (NodeTypeEnums.isTerminalNode((NetworkNode)this.getPathEndNode())) {
                TerminalNode rtn = (TerminalNode)this.getPathEndNode();
                log.trace("  LinkSegment smask={} rmask={} name={}", new Object[]{mask, this.linkedSegmentMask, rtn.getRule().getName()});
            } else {
                log.trace("  LinkSegment smask={} rmask={}", (Object)mask, (Object)"TupleToObjectNode");
            }
        }
        if (this.isRuleLinked()) {
            this.doLinkRule(reteEvaluator);
        }
    }

    public RuleAgendaItem getOrCreateRuleAgendaItem(ActivationsManager activationsManager) {
        this.ensureAgendaItemCreated(activationsManager);
        return this.agendaItem;
    }

    private TerminalNode ensureAgendaItemCreated(ActivationsManager activationsManager) {
        AbstractTerminalNode rtn = (AbstractTerminalNode)this.getPathEndNode();
        if (this.agendaItem == null) {
            int salience = rtn.getRule().getSalience().isDynamic() ? 0 : rtn.getRule().getSalience().getValue();
            this.agendaItem = activationsManager.createRuleAgendaItem(salience, this, rtn);
        }
        return rtn;
    }

    public void doLinkRule(ReteEvaluator reteEvaluator) {
        this.doLinkRule(this.getActualActivationsManager(reteEvaluator));
    }

    public void doLinkRule(ActivationsManager activationsManager) {
        TerminalNode rtn = this.ensureAgendaItemCreated(activationsManager);
        if (isLogTraceEnabled) {
            log.trace(" LinkRule name={}", (Object)rtn.getRule().getName());
        }
        this.queueRuleAgendaItem(activationsManager);
    }

    public void doUnlinkRule(ReteEvaluator reteEvaluator) {
        this.doUnlinkRule(this.getActualActivationsManager(reteEvaluator));
    }

    public void doUnlinkRule(ActivationsManager activationsManager) {
        TerminalNode rtn = this.ensureAgendaItemCreated(activationsManager);
        if (isLogTraceEnabled) {
            log.trace("    UnlinkRule name={}", (Object)rtn.getRule().getName());
        }
        this.agendaItem.getRuleExecutor().setDirty(true);
        if (!this.agendaItem.isQueued()) {
            if (isLogTraceEnabled) {
                log.trace("Queue RuleAgendaItem {}", (Object)this.agendaItem);
            }
            InternalAgendaGroup ag = this.agendaItem.getAgendaGroup();
            ag.add(this.agendaItem);
        }
    }

    public void queueRuleAgendaItem(ActivationsManager activationsManager) {
        this.agendaItem.getRuleExecutor().setDirty(true);
        ActivationsFilter activationFilter = activationsManager.getActivationsFilter();
        if (activationFilter != null) {
            activationFilter.accept(this.agendaItem);
        }
        if (!this.agendaItem.isQueued()) {
            if (isLogTraceEnabled) {
                log.trace("Queue RuleAgendaItem {}", (Object)this.agendaItem);
            }
            InternalAgendaGroup ag = this.agendaItem.getAgendaGroup();
            ag.add(this.agendaItem);
        }
        if (this.agendaItem.getRule().isQuery()) {
            activationsManager.addQueryAgendaItem(this.agendaItem);
        } else if (this.agendaItem.getRule().isEager()) {
            activationsManager.addEagerRuleAgendaItem(this.agendaItem);
        }
    }

    public void unlinkedSegment(long mask, ReteEvaluator reteEvaluator) {
        boolean linkedRule = this.isRuleLinked();
        this.linkedSegmentMask &= mask ^ 0xFFFFFFFFFFFFFFFFL;
        if (isLogTraceEnabled) {
            log.trace("  UnlinkSegment smask={} rmask={} name={}", new Object[]{mask, this.linkedSegmentMask, this});
        }
        if (linkedRule && !this.isRuleLinked()) {
            this.doUnlinkRule(reteEvaluator);
        }
    }

    public boolean isRuleLinked() {
        return (this.linkedSegmentMask & this.allLinkedMaskTest) == this.allLinkedMaskTest;
    }

    public boolean isDataDriven() {
        return this.dataDriven;
    }

    @Override
    public int getNodeType() {
        return 5900720;
    }

    public boolean isInitialized() {
        return this.agendaItem != null && this.segmentMemories != null;
    }

    public SegmentMemory[] getSegmentMemories() {
        return this.segmentMemories;
    }

    public void setSegmentMemory(int index, SegmentMemory sm) {
        this.segmentMemories[index] = sm;
    }

    public void setSegmentMemories(SegmentMemory[] segmentMemories) {
        this.segmentMemories = segmentMemories;
    }

    @Override
    public SegmentMemory getSegmentMemory() {
        return this.segmentMemory;
    }

    @Override
    public void setSegmentMemory(SegmentMemory sm) {
        this.segmentMemory = sm;
    }

    public String toString() {
        return "PathEnd(" + this.getPathEndNode().getId() + ") [" + this.getRule().getName() + "]";
    }

    @Override
    public void reset() {
        this.linkedSegmentMask = 0L;
        this.agendaItem = null;
    }

    public ActivationsManager getActualActivationsManager(ReteEvaluator reteEvaluator) {
        ActivationsManager activationsManager = reteEvaluator.getActivationsManager();
        return activationsManager.getPartitionedAgendaForNode(this.getPathEndNode());
    }
}

