/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.reteoo;

import java.util.Collection;
import java.util.List;
import org.drools.base.RuleBase;
import org.drools.base.base.ClassObjectType;
import org.drools.base.base.ObjectType;
import org.drools.base.common.NetworkNode;
import org.drools.base.common.RuleBasePartitionId;
import org.drools.base.reteoo.NodeTypeEnums;
import org.drools.base.reteoo.PropertySpecificUtil;
import org.drools.base.rule.Pattern;
import org.drools.core.common.BaseNode;
import org.drools.core.phreak.BuildtimeSegmentUtilities;
import org.drools.core.reteoo.CompositeLeftTupleSinkAdapter;
import org.drools.core.reteoo.EmptyLeftTupleSinkAdapter;
import org.drools.core.reteoo.LeftInputAdapterNode;
import org.drools.core.reteoo.LeftTupleNode;
import org.drools.core.reteoo.LeftTupleSink;
import org.drools.core.reteoo.LeftTupleSinkNode;
import org.drools.core.reteoo.LeftTupleSinkPropagator;
import org.drools.core.reteoo.ObjectSource;
import org.drools.core.reteoo.ObjectTypeNode;
import org.drools.core.reteoo.ObjectTypeNodeId;
import org.drools.core.reteoo.SingleLeftTupleSinkAdapter;
import org.drools.core.reteoo.TerminalNode;
import org.drools.core.reteoo.builder.BuildContext;
import org.drools.util.bitmask.AllSetBitMask;
import org.drools.util.bitmask.BitMask;
import org.drools.util.bitmask.EmptyBitMask;

public abstract class LeftTupleSource
extends BaseNode
implements LeftTupleNode {
    protected BitMask declaredMask = EmptyBitMask.get();
    protected BitMask inferredMask = EmptyBitMask.get();
    protected BitMask negativeMask = EmptyBitMask.get();
    protected LeftTupleSource leftInput;
    private ObjectTypeNodeId inputOtnId = ObjectTypeNodeId.DEFAULT_ID;
    protected LeftTupleSinkPropagator sink;
    private int pathIndex;
    private int objectCount;

    public LeftTupleSource() {
    }

    protected LeftTupleSource(int id, BuildContext context) {
        super(id, context.getPartitionId());
        this.sink = EmptyLeftTupleSinkAdapter.getInstance();
        this.initMemoryId(context);
    }

    @Override
    public int getPathIndex() {
        return this.pathIndex;
    }

    public abstract int getType();

    public ObjectTypeNodeId getInputOtnId() {
        return this.inputOtnId;
    }

    public void setInputOtnId(ObjectTypeNodeId inputOtnId) {
        this.inputOtnId = inputOtnId;
    }

    public void addTupleSink(LeftTupleSink tupleSink) {
        this.addTupleSink(tupleSink, null);
    }

    @Override
    public LeftTupleSource getLeftTupleSource() {
        return this.leftInput;
    }

    public LeftTupleSource getLeftInput() {
        return this.leftInput;
    }

    public LeftTupleSinkPropagator getSink() {
        return this.sink;
    }

    public final void setLeftTupleSource(LeftTupleSource leftInput) {
        this.leftInput = leftInput;
        this.pathIndex = leftInput.getPathIndex() + 1;
    }

    @Override
    public int getObjectCount() {
        return this.objectCount;
    }

    @Override
    public void setObjectCount(int count) {
        this.objectCount = count;
    }

    @Override
    public BaseNode getParent() {
        return this.leftInput;
    }

    public void addTupleSink(LeftTupleSink tupleSink, BuildContext context) {
        this.sink = this.addTupleSink(this.sink, tupleSink, context);
    }

    protected LeftTupleSinkPropagator addTupleSink(LeftTupleSinkPropagator sinkPropagator, LeftTupleSink tupleSink, BuildContext context) {
        if (sinkPropagator instanceof EmptyLeftTupleSinkAdapter) {
            return new SingleLeftTupleSinkAdapter(this.getPartitionId(), tupleSink);
        }
        if (sinkPropagator instanceof SingleLeftTupleSinkAdapter) {
            CompositeLeftTupleSinkAdapter sinkAdapter = new CompositeLeftTupleSinkAdapter(this.getPartitionId());
            sinkAdapter.addTupleSink(sinkPropagator.getSinks()[0]);
            sinkAdapter.addTupleSink(tupleSink);
            return sinkAdapter;
        }
        ((CompositeLeftTupleSinkAdapter)sinkPropagator).addTupleSink(tupleSink);
        return sinkPropagator;
    }

    public void removeTupleSink(LeftTupleSink tupleSink) {
        if (this.sink instanceof EmptyLeftTupleSinkAdapter) {
            throw new IllegalArgumentException("Cannot remove a sink, when the list of sinks is null");
        }
        if (this.sink instanceof SingleLeftTupleSinkAdapter) {
            this.sink = EmptyLeftTupleSinkAdapter.getInstance();
        } else {
            CompositeLeftTupleSinkAdapter sinkAdapter = (CompositeLeftTupleSinkAdapter)this.sink;
            sinkAdapter.removeTupleSink(tupleSink);
            if (sinkAdapter.size() == 1) {
                this.sink = new SingleLeftTupleSinkAdapter(this.getPartitionId(), sinkAdapter.getSinks()[0]);
            }
        }
    }

    public LeftTupleSinkNode getFirstLeftTupleSinkIgnoreRemoving(TerminalNode removingTn) {
        if (removingTn == null) {
            return this.sink.getFirstLeftTupleSink();
        }
        for (LeftTupleSink sink : this.sink.getSinks()) {
            if (!BuildtimeSegmentUtilities.sinkNotExclusivelyAssociatedWithTerminal(removingTn, sink)) continue;
            return (LeftTupleSinkNode)sink;
        }
        throw new RuntimeException("This should always return a sink");
    }

    @Override
    public LeftTupleSinkPropagator getSinkPropagator() {
        return this.sink;
    }

    public void setSourcePartitionId(BuildContext context, RuleBasePartitionId partitionId) {
        this.setSourcePartitionId(this.leftInput, context, partitionId);
    }

    protected void setSourcePartitionId(BaseNode source, BuildContext context, RuleBasePartitionId partitionId) {
        if (this.partitionId == partitionId) {
            return;
        }
        this.partitionId = partitionId;
        if (source.getPartitionId() == RuleBasePartitionId.MAIN_PARTITION) {
            this.setPartitionIdWithSinks(partitionId);
        } else {
            source.setPartitionId(context, partitionId);
        }
    }

    public final void setPartitionIdWithSinks(RuleBasePartitionId partitionId) {
        this.partitionId = partitionId;
        for (LeftTupleSink sink : this.getSinkPropagator().getSinks()) {
            sink.setPartitionIdWithSinks(partitionId);
        }
    }

    @Override
    public boolean isInUse() {
        return this.sink.size() > 0;
    }

    protected final void initMasks(BuildContext context) {
        this.initDeclaredMask(context);
        this.initInferredMask();
    }

    protected void initDeclaredMask(BuildContext context) {
        if (context == null || context.getLastBuiltPatterns() == null) {
            this.declaredMask = AllSetBitMask.get();
            return;
        }
        if (!NodeTypeEnums.isLeftInputAdapterNode((NetworkNode)this.leftInput)) {
            this.declaredMask = AllSetBitMask.get();
            return;
        }
        Pattern pattern = this.getLeftInputPattern(context);
        ObjectType objectType = this.getObjectTypeForPropertyReactivity((LeftInputAdapterNode)this.leftInput, pattern);
        if (!(objectType instanceof ClassObjectType)) {
            this.declaredMask = AllSetBitMask.get();
            return;
        }
        if (pattern != null && PropertySpecificUtil.isPropertyReactive((RuleBase)context.getRuleBase(), (ObjectType)objectType)) {
            Collection leftListenedProperties = pattern.getListenedProperties();
            List accessibleProperties = PropertySpecificUtil.getAccessibleProperties((RuleBase)context.getRuleBase(), (ObjectType)objectType);
            this.declaredMask = PropertySpecificUtil.calculatePositiveMask((ObjectType)objectType, (Collection)leftListenedProperties, (List)accessibleProperties);
            this.declaredMask = this.setNodeConstraintsPropertyReactiveMask(this.declaredMask, objectType, accessibleProperties);
            this.negativeMask = PropertySpecificUtil.calculateNegativeMask((ObjectType)objectType, (Collection)leftListenedProperties, (List)accessibleProperties);
            this.setLeftListenedProperties(leftListenedProperties);
        } else {
            this.declaredMask = AllSetBitMask.get();
        }
    }

    protected BitMask setNodeConstraintsPropertyReactiveMask(BitMask mask, ObjectType objectType, List<String> accessibleProperties) {
        return mask;
    }

    protected Pattern getLeftInputPattern(BuildContext context) {
        return context.getLastBuiltPatterns()[1];
    }

    protected ObjectType getObjectTypeForPropertyReactivity(LeftInputAdapterNode leftInput, Pattern pattern) {
        return pattern != null ? pattern.getObjectType() : leftInput.getParentObjectSource().getObjectTypeNode().getObjectType();
    }

    protected void setLeftListenedProperties(Collection<String> leftListenedProperties) {
    }

    protected void initInferredMask() {
        LeftTupleSource unwrappedLeft = this.unwrapLeftInput();
        if (NodeTypeEnums.isLeftInputAdapterNode((NetworkNode)unwrappedLeft) && ((LeftInputAdapterNode)unwrappedLeft).getParentObjectSource().getType() == 4587529) {
            ObjectSource objectSource = ((LeftInputAdapterNode)unwrappedLeft).getParentObjectSource();
            this.inferredMask = objectSource.updateMask(this.declaredMask);
        } else {
            this.inferredMask = this.declaredMask;
        }
        this.inferredMask = this.inferredMask.resetAll(this.negativeMask);
    }

    private LeftTupleSource unwrapLeftInput() {
        if (this.leftInput.getType() == 8849460 || this.leftInput.getType() == 9177140) {
            return this.leftInput.getLeftTupleSource();
        }
        return this.leftInput;
    }

    @Override
    public BitMask getDeclaredMask() {
        return this.declaredMask;
    }

    @Override
    public BitMask getInferredMask() {
        return this.inferredMask;
    }

    protected void setInferredMask(BitMask inferredMask) {
        this.inferredMask = inferredMask;
    }

    public BitMask getNegativeMask() {
        return this.negativeMask;
    }

    public ObjectType getObjectType() {
        ObjectTypeNode objectTypeNode = this.getObjectTypeNode();
        return objectTypeNode != null ? objectTypeNode.getObjectType() : null;
    }

    public abstract boolean isLeftTupleMemoryEnabled();
}

