/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.phreak;

import java.util.ArrayList;
import java.util.List;
import org.drools.base.common.NetworkNode;
import org.drools.base.reteoo.BaseTerminalNode;
import org.drools.base.reteoo.NodeTypeEnums;
import org.drools.core.impl.InternalRuleBase;
import org.drools.core.phreak.EagerPhreakBuilder;
import org.drools.core.reteoo.AsyncReceiveNode;
import org.drools.core.reteoo.AsyncSendNode;
import org.drools.core.reteoo.BetaNode;
import org.drools.core.reteoo.ConditionalBranchNode;
import org.drools.core.reteoo.EvalConditionNode;
import org.drools.core.reteoo.ExistsNode;
import org.drools.core.reteoo.FromNode;
import org.drools.core.reteoo.LeftInputAdapterNode;
import org.drools.core.reteoo.LeftTupleNode;
import org.drools.core.reteoo.LeftTupleSinkNode;
import org.drools.core.reteoo.LeftTupleSinkPropagator;
import org.drools.core.reteoo.LeftTupleSource;
import org.drools.core.reteoo.NotNode;
import org.drools.core.reteoo.PathEndNode;
import org.drools.core.reteoo.QueryElementNode;
import org.drools.core.reteoo.ReactiveFromNode;
import org.drools.core.reteoo.SegmentMemory;
import org.drools.core.reteoo.TerminalNode;
import org.drools.core.reteoo.TimerNode;
import org.drools.core.reteoo.TupleToObjectNode;

public class BuildtimeSegmentUtilities {
    public static final int NOT_NODE_BIT = 1;
    public static final int JOIN_NODE_BIT = 2;
    public static final int REACTIVE_EXISTS_NODE_BIT = 4;
    public static final int PASSIVE_EXISTS_NODE_BIT = 8;
    public static final int CONDITIONAL_BRANCH_BIT = 16;

    public static void updateSegmentEndNodes(PathEndNode endNode) {
        SegmentMemory.SegmentPrototype smproto = endNode.getSegmentPrototypes()[endNode.getSegmentPrototypes().length - 1];
        if (smproto.getPathEndNodes() != null) {
            return;
        }
        for (int i = 0; i < endNode.getSegmentPrototypes().length; ++i) {
            smproto = endNode.getSegmentPrototypes()[i];
            if (smproto.getPathEndNodes() != null) {
                PathEndNode[] existingNodes = smproto.getPathEndNodes();
                PathEndNode[] newNodes = new PathEndNode[existingNodes.length + 1];
                System.arraycopy(existingNodes, 0, newNodes, 0, existingNodes.length);
                newNodes[newNodes.length - 1] = endNode;
                smproto.setPathEndNodes(newNodes);
                continue;
            }
            smproto.setPathEndNodes(new PathEndNode[]{endNode});
        }
    }

    private static void setSegments(PathEndNode endNode, SegmentMemory.SegmentPrototype[] smems) {
        ArrayList<SegmentMemory.SegmentPrototype> eager = new ArrayList<SegmentMemory.SegmentPrototype>();
        for (SegmentMemory.SegmentPrototype smem : smems) {
            if (smem == null || !smem.requiresEager()) continue;
            eager.add(smem);
        }
        endNode.setEagerSegmentPrototypes(eager.toArray(new SegmentMemory.SegmentPrototype[eager.size()]));
        long allLinkedMaskTest = BuildtimeSegmentUtilities.getPathAllLinkedMaskTest(smems, endNode);
        endNode.setPathMemSpec(new PathEndNode.PathMemSpec(allLinkedMaskTest, smems.length));
        endNode.setSegmentPrototypes(smems);
        BuildtimeSegmentUtilities.updateSegmentEndNodes(endNode);
    }

    public static long getPathAllLinkedMaskTest(SegmentMemory.SegmentPrototype[] smems, PathEndNode endNode) {
        long allLinkedMaskTest = 0L;
        for (int i = smems.length - 1; i >= 0; --i) {
            SegmentMemory.SegmentPrototype smem = smems[i];
            if (EagerPhreakBuilder.isInsideSubnetwork(endNode, smem) && smem.getAllLinkedMaskTest() > 0L) {
                allLinkedMaskTest |= 1L;
            }
            if (i <= 0) continue;
            allLinkedMaskTest = BuildtimeSegmentUtilities.nextNodePosMask(allLinkedMaskTest);
        }
        return allLinkedMaskTest;
    }

    public static SegmentMemory.SegmentPrototype[] createPathProtoMemories(TerminalNode tn, TerminalNode removingTn, InternalRuleBase rbase) {
        SegmentMemory.SegmentPrototype[] smems = BuildtimeSegmentUtilities.createLeftTupleNodeProtoMemories(tn, removingTn, rbase);
        if (smems.length > 0) {
            BuildtimeSegmentUtilities.setSegments(tn, smems);
        }
        return smems;
    }

    public static SegmentMemory.SegmentPrototype[] createLeftTupleNodeProtoMemories(LeftTupleNode lts, TerminalNode removingTn, InternalRuleBase rbase) {
        int recordBefore;
        LeftTupleNode segmentRoot = lts;
        LeftTupleNode segmentTip = lts;
        ArrayList<SegmentMemory.SegmentPrototype> smems = new ArrayList<SegmentMemory.SegmentPrototype>();
        int start = 0;
        LeftTupleNode firstConditional = BuildtimeSegmentUtilities.getFirstConditionalBranchNode(lts);
        int n = recordBefore = firstConditional == null ? Integer.MAX_VALUE : firstConditional.getPathIndex();
        while (true) {
            if (!BuildtimeSegmentUtilities.isRootNode(segmentRoot, removingTn)) {
                segmentRoot = segmentRoot.getLeftTupleSource();
                continue;
            }
            SegmentMemory.SegmentPrototype smem = rbase.getSegmentPrototype(segmentRoot);
            if (smem == null) {
                start = segmentRoot.getPathIndex();
                smem = BuildtimeSegmentUtilities.createSegmentMemory(segmentRoot, segmentTip, recordBefore, removingTn, rbase);
            }
            smems.add(0, smem);
            segmentTip = segmentRoot = segmentRoot.getLeftTupleSource();
            if (segmentRoot == null) break;
        }
        int ruleSegmentPosMask = 1;
        for (int i = 0; i < smems.size(); ++i) {
            if (start >= 0 && smems.get(i) != null) {
                ((SegmentMemory.SegmentPrototype)smems.get(i)).setPos(i);
                if (((SegmentMemory.SegmentPrototype)smems.get(i)).getAllLinkedMaskTest() > 0L) {
                    ((SegmentMemory.SegmentPrototype)smems.get(i)).setSegmentPosMaskBit(ruleSegmentPosMask);
                } else {
                    ((SegmentMemory.SegmentPrototype)smems.get(i)).setSegmentPosMaskBit(0L);
                }
            }
            ruleSegmentPosMask <<= 1;
        }
        return smems.toArray(new SegmentMemory.SegmentPrototype[smems.size()]);
    }

    static LeftTupleNode getFirstConditionalBranchNode(LeftTupleNode tupleSource) {
        LeftTupleNode conditionalBranch = null;
        while (!NodeTypeEnums.isLeftInputAdapterNode((NetworkNode)tupleSource)) {
            if (tupleSource.getType() == 10160180) {
                conditionalBranch = tupleSource;
            }
            tupleSource = tupleSource.getLeftTupleSource();
        }
        return conditionalBranch;
    }

    public static SegmentMemory.SegmentPrototype createSegmentMemory(LeftTupleNode segmentRoot, LeftTupleNode segmentTip, int recordBefore, TerminalNode removingTn, InternalRuleBase rbase) {
        LeftTupleNode node = segmentRoot;
        int nodeTypesInSegment = 0;
        SegmentMemory.SegmentPrototype smem = new SegmentMemory.SegmentPrototype(segmentRoot, segmentTip);
        ArrayList<SegmentMemory.MemoryPrototype> memories = new ArrayList<SegmentMemory.MemoryPrototype>();
        ArrayList<LeftTupleNode> nodes = new ArrayList<LeftTupleNode>();
        long nodePosMask = 1L;
        long allLinkedTestMask = 0L;
        boolean updateNodeBit = true;
        while (true) {
            nodeTypesInSegment = BuildtimeSegmentUtilities.updateNodeTypesMask(node, nodeTypesInSegment);
            if (NodeTypeEnums.isBetaNode((NetworkNode)node)) {
                boolean updateAllLinked = node.getPathIndex() < recordBefore && updateNodeBit;
                allLinkedTestMask = BuildtimeSegmentUtilities.processBetaNode((BetaNode)node, smem, memories, nodes, nodePosMask, allLinkedTestMask, updateAllLinked, removingTn, rbase);
            } else {
                switch (node.getType()) {
                    case 6883436: 
                    case 7211116: {
                        allLinkedTestMask = BuildtimeSegmentUtilities.processLiaNode((LeftInputAdapterNode)node, memories, nodes, nodePosMask, allLinkedTestMask);
                        break;
                    }
                    case 10160180: {
                        BuildtimeSegmentUtilities.processConditionalBranchNode((ConditionalBranchNode)node, memories, nodes);
                        break;
                    }
                    case 8849460: {
                        BuildtimeSegmentUtilities.processFromNode((FromNode)node, memories, nodes);
                        break;
                    }
                    case 7538740: {
                        BuildtimeSegmentUtilities.processEvalFromNode((EvalConditionNode)node, memories, nodes);
                        break;
                    }
                    case 9177140: {
                        BuildtimeSegmentUtilities.processReactiveFromNode((ReactiveFromNode)node, memories, nodes, nodePosMask);
                        break;
                    }
                    case 7866420: {
                        BuildtimeSegmentUtilities.processTimerNode((TimerNode)node, memories, nodes, nodePosMask);
                        break;
                    }
                    case 8194100: {
                        BuildtimeSegmentUtilities.processAsyncSendNode((AsyncSendNode)node, memories, nodes);
                        break;
                    }
                    case 8521780: {
                        BuildtimeSegmentUtilities.processAsyncReceiveNode((AsyncReceiveNode)node, memories, nodes, nodePosMask);
                        break;
                    }
                    case 9832500: {
                        updateNodeBit = BuildtimeSegmentUtilities.processQueryNode((QueryElementNode)node, memories, nodes, nodePosMask);
                        break;
                    }
                    case 5245233: {
                        BuildtimeSegmentUtilities.processRightInputAdapterNode((TupleToObjectNode)node, memories, nodes);
                        break;
                    }
                    case 5900720: 
                    case 6228400: {
                        BuildtimeSegmentUtilities.processTerminalNode((TerminalNode)node, memories, nodes);
                    }
                }
            }
            nodePosMask = BuildtimeSegmentUtilities.nextNodePosMask(nodePosMask);
            if (node == segmentTip || !NodeTypeEnums.isLeftTupleSource((NetworkNode)node)) break;
            node = ((LeftTupleSource)node).getFirstLeftTupleSinkIgnoreRemoving(removingTn);
        }
        smem.setAllLinkedMaskTest(allLinkedTestMask);
        smem.setNodesInSegment(nodes.toArray(new LeftTupleNode[nodes.size()]));
        smem.setMemories(memories.toArray(new SegmentMemory.MemoryPrototype[memories.size()]));
        smem.setNodeTypesInSegment(nodeTypesInSegment);
        rbase.registerSegmentPrototype(segmentRoot, smem);
        return smem;
    }

    public static boolean requiresAnEagerSegment(int nodeTypesInSegment) {
        return BuildtimeSegmentUtilities.isSet(nodeTypesInSegment, 1) && !BuildtimeSegmentUtilities.isSet(nodeTypesInSegment, 2) && !BuildtimeSegmentUtilities.isSet(nodeTypesInSegment, 4);
    }

    public static long nextNodePosMask(long posMask) {
        long nextNodePosMask = posMask << 1;
        return nextNodePosMask > 0L ? nextNodePosMask : posMask;
    }

    private static boolean processQueryNode(QueryElementNode queryNode, List<SegmentMemory.MemoryPrototype> memories, List<LeftTupleNode> nodes, long nodePosMask) {
        SegmentMemory.QueryMemoryPrototype queryNodeMem = new SegmentMemory.QueryMemoryPrototype(nodePosMask, queryNode);
        memories.add(queryNodeMem);
        nodes.add(queryNode);
        return !queryNode.getQueryElement().isAbductive();
    }

    private static void processAsyncSendNode(AsyncSendNode tupleSource, List<SegmentMemory.MemoryPrototype> memories, List<LeftTupleNode> nodes) {
        SegmentMemory.AsyncSendMemoryPrototype mem = new SegmentMemory.AsyncSendMemoryPrototype();
        memories.add(mem);
        nodes.add(tupleSource);
    }

    private static void processAsyncReceiveNode(AsyncReceiveNode tupleSource, List<SegmentMemory.MemoryPrototype> memories, List<LeftTupleNode> nodes, long nodePosMask) {
        SegmentMemory.AsyncReceiveMemoryPrototype mem = new SegmentMemory.AsyncReceiveMemoryPrototype(nodePosMask);
        memories.add(mem);
        nodes.add(tupleSource);
    }

    private static void processConditionalBranchNode(ConditionalBranchNode tupleSource, List<SegmentMemory.MemoryPrototype> memories, List<LeftTupleNode> nodes) {
        SegmentMemory.ConditionalBranchMemoryPrototype mem = new SegmentMemory.ConditionalBranchMemoryPrototype();
        memories.add(mem);
        nodes.add(tupleSource);
    }

    private static void processRightInputAdapterNode(TupleToObjectNode tupleSource, List<SegmentMemory.MemoryPrototype> memories, List<LeftTupleNode> nodes) {
        SegmentMemory.RightInputAdapterPrototype mem = new SegmentMemory.RightInputAdapterPrototype();
        memories.add(mem);
        nodes.add(tupleSource);
    }

    private static void processTerminalNode(TerminalNode tupleSource, List<SegmentMemory.MemoryPrototype> memories, List<LeftTupleNode> nodes) {
        SegmentMemory.TerminalPrototype mem = new SegmentMemory.TerminalPrototype();
        memories.add(mem);
        nodes.add(tupleSource);
    }

    private static void processFromNode(FromNode tupleSource, List<SegmentMemory.MemoryPrototype> memories, List<LeftTupleNode> nodes) {
        SegmentMemory.FromMemoryPrototype mem = new SegmentMemory.FromMemoryPrototype();
        memories.add(mem);
        nodes.add(tupleSource);
    }

    private static void processEvalFromNode(EvalConditionNode tupleSource, List<SegmentMemory.MemoryPrototype> memories, List<LeftTupleNode> nodes) {
        SegmentMemory.EvalMemoryPrototype mem = new SegmentMemory.EvalMemoryPrototype();
        memories.add(mem);
        nodes.add(tupleSource);
    }

    private static void processReactiveFromNode(ReactiveFromNode tupleSource, List<SegmentMemory.MemoryPrototype> memories, List<LeftTupleNode> nodes, long nodePosMask) {
        SegmentMemory.ReactiveFromMemoryPrototype mem = new SegmentMemory.ReactiveFromMemoryPrototype(nodePosMask);
        memories.add(mem);
        nodes.add(tupleSource);
    }

    private static void processTimerNode(TimerNode tupleSource, List<SegmentMemory.MemoryPrototype> memories, List<LeftTupleNode> nodes, long nodePosMask) {
        SegmentMemory.TimerMemoryPrototype tnMem = new SegmentMemory.TimerMemoryPrototype(nodePosMask);
        memories.add(tnMem);
        nodes.add(tupleSource);
    }

    private static long processLiaNode(LeftInputAdapterNode tupleSource, List<SegmentMemory.MemoryPrototype> memories, List<LeftTupleNode> nodes, long nodePosMask, long allLinkedTestMask) {
        SegmentMemory.LiaMemoryPrototype liaMemory = new SegmentMemory.LiaMemoryPrototype(nodePosMask);
        memories.add(liaMemory);
        nodes.add(tupleSource);
        return allLinkedTestMask |= nodePosMask;
    }

    private static long processBetaNode(BetaNode betaNode, SegmentMemory.SegmentPrototype smem, List<SegmentMemory.MemoryPrototype> memories, List<LeftTupleNode> nodes, long nodePosMask, long allLinkedTestMask, boolean updateNodeBit, TerminalNode removingTn, InternalRuleBase rbase) {
        TupleToObjectNode tton = null;
        if (betaNode.getRightInput().inputIsTupleToObjectNode()) {
            tton = (TupleToObjectNode)betaNode.getRightInput().getParent();
            SegmentMemory.SegmentPrototype[] smems = BuildtimeSegmentUtilities.createLeftTupleNodeProtoMemories(tton, removingTn, rbase);
            BuildtimeSegmentUtilities.setSegments(tton, smems);
            if (updateNodeBit && BuildtimeSegmentUtilities.canBeDisabled(betaNode) && tton.getPathMemSpec().allLinkedTestMask() > 0L) {
                allLinkedTestMask |= nodePosMask;
            }
        } else if (updateNodeBit && BuildtimeSegmentUtilities.canBeDisabled(betaNode)) {
            allLinkedTestMask |= nodePosMask;
        }
        if (11143732 == betaNode.getType()) {
            smem.linkNode(nodePosMask);
        }
        SegmentMemory.BetaMemoryPrototype bm = new SegmentMemory.BetaMemoryPrototype(nodePosMask, tton);
        if (11799092 == betaNode.getType()) {
            SegmentMemory.AccumulateMemoryPrototype am = new SegmentMemory.AccumulateMemoryPrototype(bm);
            memories.add(am);
        } else {
            memories.add(bm);
        }
        nodes.add(betaNode);
        return allLinkedTestMask;
    }

    public static boolean canBeDisabled(BetaNode betaNode) {
        return (11143732 != betaNode.getType() || ((NotNode)betaNode).isEmptyBetaConstraints()) && 11799092 != betaNode.getType() && !betaNode.getRightInput().isRightInputPassive();
    }

    public static boolean isRootNode(LeftTupleNode node, TerminalNode ignoreTn) {
        return NodeTypeEnums.isLeftInputAdapterNode((NetworkNode)node) || BuildtimeSegmentUtilities.isTipNode(node.getLeftTupleSource(), ignoreTn);
    }

    public static boolean isTipNode(LeftTupleNode node, TerminalNode removingTN) {
        return NodeTypeEnums.isEndNode((NetworkNode)node) || BuildtimeSegmentUtilities.isNonTerminalTipNode(node, removingTN);
    }

    public static boolean isNonTerminalTipNode(LeftTupleNode node, TerminalNode removingTN) {
        LeftTupleSinkPropagator sinkPropagator = node.getSinkPropagator();
        if (removingTN == null) {
            return sinkPropagator.size() > 1;
        }
        if (sinkPropagator.size() == 1) {
            return false;
        }
        int count = 0;
        for (LeftTupleSinkNode sink = sinkPropagator.getFirstLeftTupleSink(); sink != null; sink = sink.getNextLeftTupleSinkNode()) {
            if (!BuildtimeSegmentUtilities.sinkNotExclusivelyAssociatedWithTerminal(removingTN, sink) || ++count <= 1) continue;
            return true;
        }
        return false;
    }

    public static boolean sinkNotExclusivelyAssociatedWithTerminal(TerminalNode removingTN, LeftTupleNode sink) {
        return sink.getAssociatedTerminalsSize() > 1 || !sink.hasAssociatedTerminal(removingTN);
    }

    public static int updateNodeTypesMask(NetworkNode node, int mask) {
        if (node != null) {
            switch (node.getType()) {
                case 10816052: {
                    mask |= 2;
                    break;
                }
                case 11471412: {
                    if (((ExistsNode)node).getRightInput().isRightInputPassive()) {
                        mask |= 8;
                        break;
                    }
                    mask |= 4;
                    break;
                }
                case 11143732: {
                    mask |= 1;
                    break;
                }
                case 10160180: {
                    mask |= 0x10;
                }
            }
        }
        return mask;
    }

    public static boolean isSet(int mask, int bit) {
        return (mask & bit) == bit;
    }

    public static LeftTupleNode findSegmentRoot(LeftTupleNode tupleSource) {
        return BuildtimeSegmentUtilities.findSegmentRoot(tupleSource, null);
    }

    public static LeftTupleNode findSegmentRoot(LeftTupleNode tupleSource, TerminalNode ignoreTn) {
        while (!BuildtimeSegmentUtilities.isRootNode(tupleSource, ignoreTn)) {
            tupleSource = tupleSource.getLeftTupleSource();
        }
        return tupleSource;
    }

    public static boolean isAssociatedWith(NetworkNode node, TerminalNode tn) {
        return node.hasAssociatedTerminal((BaseTerminalNode)tn);
    }
}

