/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.phreak;

import java.util.Collection;
import org.drools.base.phreak.ReactiveObject;
import org.drools.base.reteoo.BaseTuple;
import org.drools.core.common.BetaConstraints;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.PropagationContext;
import org.drools.core.common.ReteEvaluator;
import org.drools.core.phreak.PhreakFromNode;
import org.drools.core.phreak.PropagationEntry;
import org.drools.core.phreak.RuleNetworkEvaluator;
import org.drools.core.reteoo.LeftTupleSinkNode;
import org.drools.core.reteoo.ReactiveFromNode;
import org.drools.core.reteoo.ReactiveFromNodeLeftTuple;
import org.drools.core.reteoo.RightTuple;
import org.drools.core.reteoo.Tuple;
import org.drools.core.reteoo.TupleImpl;

public class ReactiveObjectUtil {
    public static void notifyModification(ReactiveObject reactiveObject) {
        ReactiveObjectUtil.notifyModification(reactiveObject, reactiveObject.getTuples(), ModificationType.MODIFY);
    }

    public static void notifyModification(Object object, Collection<BaseTuple> leftTuples, ModificationType type) {
        for (BaseTuple baseTuple : leftTuples) {
            Tuple tuple = (Tuple)baseTuple;
            if (!((ReactiveFromNodeLeftTuple)tuple).updateModificationState(object, type)) continue;
            PropagationContext propagationContext = tuple.getPropagationContext();
            ReactiveFromNode node = (ReactiveFromNode)tuple.getSink();
            LeftTupleSinkNode sink = node.getSinkPropagator().getFirstLeftTupleSink();
            ReteEvaluator reteEvaluator = ((InternalFactHandle)propagationContext.getFactHandle()).getReteEvaluator();
            reteEvaluator.addPropagation(new ReactivePropagation(object, (ReactiveFromNodeLeftTuple)tuple, propagationContext, node, sink, type));
        }
    }

    public static enum ModificationType {
        NONE,
        MODIFY,
        ADD,
        REMOVE;

    }

    static class ReactivePropagation
    extends PropagationEntry.AbstractPropagationEntry {
        private final Object object;
        private final ReactiveFromNodeLeftTuple leftTuple;
        private final PropagationContext propagationContext;
        private final ReactiveFromNode node;
        private final LeftTupleSinkNode sink;
        private final ModificationType type;

        ReactivePropagation(Object object, ReactiveFromNodeLeftTuple leftTuple, PropagationContext propagationContext, ReactiveFromNode node, LeftTupleSinkNode sink, ModificationType type) {
            this.object = object;
            this.leftTuple = leftTuple;
            this.propagationContext = propagationContext;
            this.node = node;
            this.sink = sink;
            this.type = type;
        }

        @Override
        public void internalExecute(ReteEvaluator reteEvaluator) {
            if (this.leftTuple.resetModificationState(this.object) == ModificationType.NONE) {
                return;
            }
            ReactiveFromNode.ReactiveFromMemory mem = reteEvaluator.getNodeMemory(this.node);
            InternalFactHandle factHandle = this.node.createFactHandle(reteEvaluator, this.object);
            if (this.type != ModificationType.REMOVE && PhreakFromNode.isAllowed(factHandle, this.node.getAlphaConstraints(), reteEvaluator, mem)) {
                Object context = mem.getBetaMemory().getContext();
                BetaConstraints betaConstraints = this.node.getBetaConstraints();
                betaConstraints.updateFromTuple(context, reteEvaluator, this.leftTuple);
                PhreakFromNode.propagate(this.sink, this.leftTuple, new RightTuple(factHandle), betaConstraints, this.propagationContext, context, RuleNetworkEvaluator.useLeftMemory(this.node, this.leftTuple), mem.getStagedLeftTuples(), null);
            } else {
                TupleImpl childLeftTuple = this.leftTuple.getFirstChild();
                while (childLeftTuple != null) {
                    TupleImpl next = childLeftTuple.getHandleNext();
                    if (this.object == childLeftTuple.getFactHandle().getObject()) {
                        PhreakFromNode.deleteChildLeftTuple(this.propagationContext, mem.getStagedLeftTuples(), null, childLeftTuple);
                    }
                    childLeftTuple = next;
                }
            }
            mem.getBetaMemory().setNodeDirty(this.node, reteEvaluator);
        }
    }
}

