/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.common;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.drools.core.common.AgendaGroupFactory;
import org.drools.core.common.InternalAgenda;
import org.drools.core.common.InternalAgendaGroup;
import org.drools.core.common.InternalRuleFlowGroup;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.common.ReteEvaluator;
import org.drools.core.impl.InternalRuleBase;
import org.drools.core.phreak.RuleAgendaItem;
import org.drools.core.reteoo.RuntimeComponentFactory;
import org.kie.api.runtime.rule.AgendaGroup;

public interface AgendaGroupsManager
extends Externalizable {
    public void reset(boolean var1);

    public void deactivateMainGroupWhenEmpty();

    public void clearAndCancel(InternalAgenda var1);

    public void clearAndCancelAgendaGroup(String var1, InternalAgenda var2);

    public InternalAgendaGroup[] getAgendaGroups();

    public Map<String, InternalAgendaGroup> getAgendaGroupsMap();

    public void putOnAgendaGroupsMap(String var1, InternalAgendaGroup var2);

    public void addAgendaGroupOnStack(InternalAgendaGroup var1);

    public boolean setFocus(InternalAgendaGroup var1);

    public Collection<String> getGroupsName();

    public String getFocusName();

    public RuleAgendaItem peekNextRule();

    public InternalAgendaGroup getAgendaGroup(String var1);

    public InternalAgendaGroup getAgendaGroup(String var1, InternalRuleBase var2);

    public InternalAgendaGroup getNextFocus();

    public void deactivateRuleFlowGroup(String var1);

    public boolean removeGroup(InternalAgendaGroup var1);

    public int agendaSize();

    public int sizeOfRuleFlowGroup(String var1);

    public Collection<RuleAgendaItem> getActivations();

    public InternalAgendaGroup getMainAgendaGroup();

    public static AgendaGroupsManager create(InternalWorkingMemory workingMemory) {
        InternalRuleBase kBase = workingMemory.getKnowledgeBase();
        return kBase.hasMultipleAgendaGroups() || !kBase.getProcesses().isEmpty() ? new StackedAgendaGroupsManager(workingMemory) : new SimpleAgendaGroupsManager(workingMemory);
    }

    public static class StackedAgendaGroupsManager
    implements AgendaGroupsManager {
        private AgendaGroupFactory agendaGroupFactory;
        private Map<String, InternalAgendaGroup> agendaGroups = new HashMap<String, InternalAgendaGroup>();
        private Deque<InternalAgendaGroup> focusStack = new ArrayDeque<InternalAgendaGroup>();
        private InternalAgendaGroup mainAgendaGroup;
        private InternalWorkingMemory workingMemory;

        public StackedAgendaGroupsManager() {
        }

        public StackedAgendaGroupsManager(InternalWorkingMemory workingMemory) {
            this.agendaGroupFactory = RuntimeComponentFactory.get().getAgendaGroupFactory();
            this.workingMemory = workingMemory;
            if (this.mainAgendaGroup == null) {
                this.initMainAgendaGroup(workingMemory.getKnowledgeBase());
            }
            this.mainAgendaGroup.setReteEvaluator(workingMemory);
        }

        @Override
        public InternalAgendaGroup getMainAgendaGroup() {
            return this.mainAgendaGroup;
        }

        private void initMainAgendaGroup(InternalRuleBase kBase) {
            this.mainAgendaGroup = this.agendaGroupFactory.createAgendaGroup("MAIN", kBase);
            this.agendaGroups.put("MAIN", this.mainAgendaGroup);
            this.focusStack.add(this.mainAgendaGroup);
        }

        private boolean isEmpty() {
            return this.focusStack.isEmpty();
        }

        private void addAgendaGroup(InternalAgendaGroup agendaGroup) {
            this.agendaGroups.put(agendaGroup.getName(), agendaGroup);
        }

        @Override
        public void reset(boolean clearForRecency) {
            for (InternalAgendaGroup group : this.focusStack) {
                group.visited();
            }
            this.focusStack.clear();
            this.focusStack.add(this.mainAgendaGroup);
            for (InternalAgendaGroup group : this.agendaGroups.values()) {
                if (clearForRecency) {
                    group.setClearedForRecency(this.workingMemory.getFactHandleFactory().getRecency());
                }
                group.reset();
            }
        }

        @Override
        public void deactivateMainGroupWhenEmpty() {
            if (this.focusStack.size() == 1 && this.mainAgendaGroup.isEmpty()) {
                this.mainAgendaGroup.setActive(false);
            }
        }

        @Override
        public void clearAndCancel(InternalAgenda agenda) {
            for (InternalAgendaGroup internalAgendaGroup : this.agendaGroups.values()) {
                this.clearAndCancelAgendaGroup(internalAgendaGroup, agenda);
            }
        }

        @Override
        public void clearAndCancelAgendaGroup(String name, InternalAgenda agenda) {
            InternalAgendaGroup agendaGroup = this.agendaGroups.get(name);
            if (agendaGroup != null) {
                this.clearAndCancelAgendaGroup(agendaGroup, agenda);
            }
        }

        private void clearAndCancelAgendaGroup(InternalAgendaGroup agendaGroup, InternalAgenda agenda) {
            for (RuleAgendaItem activation : agendaGroup.getActivations()) {
                activation.getRuleExecutor().evaluateNetworkIfDirty(agenda);
            }
            InternalWorkingMemory eventsupport = this.workingMemory;
            agendaGroup.setClearedForRecency(this.workingMemory.getFactHandleFactory().getRecency());
            ArrayList<RuleAgendaItem> lazyItems = new ArrayList<RuleAgendaItem>();
            for (RuleAgendaItem item : agendaGroup.getActivations()) {
                lazyItems.add(item);
                item.getRuleExecutor().cancel(this.workingMemory, eventsupport);
            }
            agendaGroup.reset();
            for (RuleAgendaItem lazyItem : lazyItems) {
                agendaGroup.add(lazyItem);
            }
        }

        @Override
        public InternalAgendaGroup[] getAgendaGroups() {
            return this.agendaGroups.values().toArray(new InternalAgendaGroup[this.agendaGroups.size()]);
        }

        @Override
        public Map<String, InternalAgendaGroup> getAgendaGroupsMap() {
            return this.agendaGroups;
        }

        @Override
        public void putOnAgendaGroupsMap(String name, InternalAgendaGroup group) {
            this.agendaGroups.put(name, group);
        }

        @Override
        public void addAgendaGroupOnStack(InternalAgendaGroup agendaGroup) {
            if (this.focusStack.isEmpty() || this.focusStack.getLast() != agendaGroup) {
                this.focusStack.add(agendaGroup);
            }
        }

        @Override
        public boolean setFocus(InternalAgendaGroup agendaGroup) {
            if (this.focusStack.getLast() != agendaGroup) {
                this.focusStack.getLast().setActive(false);
                InternalAgendaGroup internalGroup = agendaGroup;
                this.focusStack.add(internalGroup);
                internalGroup.setActive(true);
                internalGroup.setActivatedForRecency(this.workingMemory.getFactHandleFactory().getRecency());
                InternalWorkingMemory eventsupport = this.workingMemory;
                eventsupport.getAgendaEventSupport().fireAgendaGroupPushed(agendaGroup, this.workingMemory);
                return true;
            }
            return false;
        }

        @Override
        public Collection<String> getGroupsName() {
            return this.focusStack.stream().map(AgendaGroup::getName).collect(Collectors.toList());
        }

        @Override
        public String getFocusName() {
            return this.focusStack.getLast().getName();
        }

        @Override
        public RuleAgendaItem peekNextRule() {
            return this.focusStack.peekLast().peek();
        }

        @Override
        public InternalAgendaGroup getAgendaGroup(String name) {
            return this.getAgendaGroup(name, this.workingMemory == null ? null : this.workingMemory.getKnowledgeBase());
        }

        @Override
        public InternalAgendaGroup getAgendaGroup(String name, InternalRuleBase kBase) {
            String groupName = name == null || name.length() == 0 ? "MAIN" : name;
            InternalAgendaGroup agendaGroup = this.agendaGroups.get(groupName);
            if (agendaGroup == null) {
                agendaGroup = this.agendaGroupFactory.createAgendaGroup(name, kBase);
                this.addAgendaGroup(agendaGroup);
                agendaGroup.setReteEvaluator(this.workingMemory);
            }
            return agendaGroup;
        }

        @Override
        public InternalAgendaGroup getNextFocus() {
            InternalAgendaGroup agendaGroup;
            if (this.isEmpty()) {
                return null;
            }
            while ((agendaGroup = this.focusStack.getLast()).isAutoDeactivate()) {
                if (agendaGroup.isEmpty() && this.focusStack.size() > 1) {
                    agendaGroup.setActive(false);
                    this.removeLast();
                    if (agendaGroup.isAutoDeactivate() && !agendaGroup.getNodeInstances().isEmpty()) {
                        InternalRuleFlowGroup ruleFlowGroup = (InternalRuleFlowGroup)agendaGroup;
                        this.workingMemory.getAgendaEventSupport().fireBeforeRuleFlowGroupDeactivated(ruleFlowGroup, this.workingMemory);
                        this.innerDeactiveRuleFlowGroup(ruleFlowGroup);
                        this.workingMemory.getAgendaEventSupport().fireAfterRuleFlowGroupDeactivated(ruleFlowGroup, this.workingMemory);
                    }
                    InternalWorkingMemory eventsupport = this.workingMemory;
                    eventsupport.getAgendaEventSupport().fireAgendaGroupPopped(agendaGroup, this.workingMemory);
                    continue;
                }
                InternalAgendaGroup internalAgendaGroup = agendaGroup = agendaGroup.isEmpty() ? null : agendaGroup;
                break;
            }
            if (agendaGroup != null && !agendaGroup.isActive()) {
                agendaGroup.setActivatedForRecency(this.workingMemory.getFactHandleFactory().getRecency());
                agendaGroup.setActive(true);
            }
            return agendaGroup;
        }

        @Override
        public void deactivateRuleFlowGroup(String name) {
            InternalRuleFlowGroup group = (InternalRuleFlowGroup)this.getAgendaGroup(name);
            if (!group.isRuleFlowListener()) {
                return;
            }
            this.workingMemory.getAgendaEventSupport().fireBeforeRuleFlowGroupDeactivated(group, this.workingMemory);
            while (this.removeGroup(group)) {
            }
            group.setActive(false);
            this.innerDeactiveRuleFlowGroup(group);
            this.workingMemory.getAgendaEventSupport().fireAfterRuleFlowGroupDeactivated(group, this.workingMemory);
        }

        private void innerDeactiveRuleFlowGroup(InternalRuleFlowGroup group) {
            group.hasRuleFlowListener(false);
            group.getNodeInstances().clear();
        }

        private void removeLast() {
            this.focusStack.removeLast().visited();
        }

        @Override
        public boolean removeGroup(InternalAgendaGroup group) {
            boolean existed = this.focusStack.remove(group);
            group.visited();
            return existed;
        }

        @Override
        public int agendaSize() {
            int size = 0;
            for (InternalAgendaGroup internalAgendaGroup : this.agendaGroups.values()) {
                size += internalAgendaGroup.size();
            }
            return size;
        }

        @Override
        public int sizeOfRuleFlowGroup(String name) {
            InternalAgendaGroup group = this.agendaGroups.get(name);
            if (group == null) {
                return 0;
            }
            int count = 0;
            for (RuleAgendaItem item : group.getActivations()) {
                if (item.getRuleExecutor().getLeftTupleList().isEmpty()) continue;
                count += item.getRuleExecutor().getLeftTupleList().size();
            }
            return count;
        }

        @Override
        public Collection<RuleAgendaItem> getActivations() {
            ArrayList<RuleAgendaItem> list = new ArrayList<RuleAgendaItem>();
            for (InternalAgendaGroup group : this.agendaGroups.values()) {
                list.addAll(group.getActivations());
            }
            return list;
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeObject(this.agendaGroups);
            out.writeObject(this.focusStack);
            out.writeObject(this.mainAgendaGroup);
            out.writeObject(this.agendaGroupFactory);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.agendaGroups = (Map)in.readObject();
            this.focusStack = (Deque)in.readObject();
            this.mainAgendaGroup = (InternalAgendaGroup)in.readObject();
            this.agendaGroupFactory = (AgendaGroupFactory)in.readObject();
        }
    }

    public static class SimpleAgendaGroupsManager
    implements AgendaGroupsManager {
        private InternalAgendaGroup mainAgendaGroup;
        private ReteEvaluator reteEvaluator;

        public SimpleAgendaGroupsManager() {
        }

        public SimpleAgendaGroupsManager(ReteEvaluator reteEvaluator) {
            this.reteEvaluator = reteEvaluator;
            this.mainAgendaGroup = RuntimeComponentFactory.get().getAgendaGroupFactory().createAgendaGroup("MAIN", reteEvaluator.getKnowledgeBase());
            this.mainAgendaGroup.setReteEvaluator(reteEvaluator);
        }

        @Override
        public InternalAgendaGroup getMainAgendaGroup() {
            return this.mainAgendaGroup;
        }

        @Override
        public void reset(boolean clearForRecency) {
            this.mainAgendaGroup.visited();
            if (clearForRecency) {
                this.mainAgendaGroup.setClearedForRecency(this.reteEvaluator.getFactHandleFactory().getRecency());
            }
            this.mainAgendaGroup.reset();
        }

        @Override
        public void deactivateMainGroupWhenEmpty() {
            if (this.mainAgendaGroup.isEmpty()) {
                this.mainAgendaGroup.setActive(false);
            }
        }

        @Override
        public void clearAndCancel(InternalAgenda agenda) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clearAndCancelAgendaGroup(String name, InternalAgenda agenda) {
            throw new UnsupportedOperationException();
        }

        @Override
        public InternalAgendaGroup[] getAgendaGroups() {
            return new InternalAgendaGroup[]{this.mainAgendaGroup};
        }

        @Override
        public Map<String, InternalAgendaGroup> getAgendaGroupsMap() {
            return Collections.singletonMap("MAIN", this.mainAgendaGroup);
        }

        @Override
        public void addAgendaGroupOnStack(InternalAgendaGroup agendaGroup) {
            if (!"MAIN".equals(agendaGroup.getName())) {
                throw new UnsupportedOperationException();
            }
            this.mainAgendaGroup = agendaGroup;
        }

        @Override
        public boolean setFocus(InternalAgendaGroup agendaGroup) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Collection<String> getGroupsName() {
            return Collections.singleton("MAIN");
        }

        @Override
        public void putOnAgendaGroupsMap(String name, InternalAgendaGroup group) {
            if (!"MAIN".equals(name)) {
                throw new UnsupportedOperationException();
            }
        }

        @Override
        public String getFocusName() {
            return "MAIN";
        }

        @Override
        public RuleAgendaItem peekNextRule() {
            return this.mainAgendaGroup.peek();
        }

        @Override
        public InternalAgendaGroup getAgendaGroup(String name) {
            return "MAIN".equals(name) ? this.mainAgendaGroup : null;
        }

        @Override
        public InternalAgendaGroup getAgendaGroup(String name, InternalRuleBase kBase) {
            return "MAIN".equals(name) ? this.mainAgendaGroup : null;
        }

        @Override
        public InternalAgendaGroup getNextFocus() {
            if (this.mainAgendaGroup.isEmpty()) {
                return null;
            }
            if (!this.mainAgendaGroup.isActive()) {
                this.mainAgendaGroup.setActivatedForRecency(this.reteEvaluator.getFactHandleFactory().getRecency());
                this.mainAgendaGroup.setActive(true);
            }
            return this.mainAgendaGroup;
        }

        @Override
        public void deactivateRuleFlowGroup(String name) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeGroup(InternalAgendaGroup group) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int agendaSize() {
            return this.mainAgendaGroup.size();
        }

        @Override
        public int sizeOfRuleFlowGroup(String name) {
            if (!"MAIN".equals(name)) {
                return 0;
            }
            int count = 0;
            for (RuleAgendaItem item : this.mainAgendaGroup.getActivations()) {
                if (item.getRuleExecutor().getLeftTupleList().isEmpty()) continue;
                count += item.getRuleExecutor().getLeftTupleList().size();
            }
            return count;
        }

        @Override
        public Collection<RuleAgendaItem> getActivations() {
            return this.mainAgendaGroup.getActivations();
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeObject(this.mainAgendaGroup);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.mainAgendaGroup = (InternalAgendaGroup)in.readObject();
        }
    }
}

