/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.reteoo.builder;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.drools.base.base.ClassObjectType;
import org.drools.base.base.DroolsQuery;
import org.drools.base.base.ObjectType;
import org.drools.base.rule.Accumulate;
import org.drools.base.rule.Behavior;
import org.drools.base.rule.Declaration;
import org.drools.base.rule.EntryPointId;
import org.drools.base.rule.GroupElement;
import org.drools.base.rule.IntervalProviderConstraint;
import org.drools.base.rule.InvalidPatternException;
import org.drools.base.rule.Pattern;
import org.drools.base.rule.PatternSource;
import org.drools.base.rule.RuleComponent;
import org.drools.base.rule.RuleConditionElement;
import org.drools.base.rule.TypeDeclaration;
import org.drools.base.rule.WindowReference;
import org.drools.base.rule.constraint.AlphaNodeFieldConstraint;
import org.drools.base.rule.constraint.BetaNodeFieldConstraint;
import org.drools.base.rule.constraint.Constraint;
import org.drools.base.rule.constraint.XpathConstraint;
import org.drools.base.time.impl.Timer;
import org.drools.core.reteoo.CoreComponentFactory;
import org.drools.core.reteoo.EntryPointNode;
import org.drools.core.reteoo.ObjectTypeNode;
import org.drools.core.reteoo.WindowNode;
import org.drools.core.reteoo.builder.BuildContext;
import org.drools.core.reteoo.builder.BuildUtils;
import org.drools.core.reteoo.builder.GroupElementBuilder;
import org.drools.core.reteoo.builder.InstanceNotEqualsConstraint;
import org.drools.core.reteoo.builder.NodeFactory;
import org.drools.core.reteoo.builder.ReteooComponentBuilder;
import org.drools.core.rule.BehaviorRuntime;
import org.drools.core.time.impl.CompositeMaxDurationTimer;
import org.drools.core.time.impl.DurationTimer;
import org.kie.api.conf.EventProcessingOption;
import org.kie.api.definition.type.Expires;

public class PatternBuilder
implements ReteooComponentBuilder {
    @Override
    public void build(BuildContext context, BuildUtils utils, RuleConditionElement rce) {
        Pattern pattern = (Pattern)rce;
        if (!(pattern.getSource() instanceof Accumulate)) {
            context.setLastBuiltPattern(pattern);
        }
        context.pushRuleComponent((RuleComponent)pattern);
        context.syncObjectTypesWithObjectCount();
        this.attachPattern(context, utils, pattern);
        context.addPattern(pattern);
        context.popRuleComponent();
    }

    private void attachPattern(BuildContext context, BuildUtils utils, Pattern pattern) throws InvalidPatternException {
        Constraints constraints = this.createConstraints(context, pattern);
        pattern.setTupleIndex(context.getTupleSource() == null ? 0 : context.getTupleSource().getPathIndex() + 1);
        pattern.setObjectIndex(context.getTupleSource() != null ? context.getTupleSource().getObjectCount() : 0);
        context.setBetaconstraints(constraints.betaConstraints);
        if (pattern.getSource() != null) {
            context.setAlphaConstraints(constraints.alphaConstraints);
            PatternSource source = pattern.getSource();
            ReteooComponentBuilder builder = utils.getBuilderFor((RuleConditionElement)source);
            if (builder == null) {
                throw new RuntimeException("Unknown pattern source type: " + source.getClass() + " for source " + source + " on pattern " + pattern);
            }
            builder.build(context, utils, (RuleConditionElement)source);
        } else {
            EntryPointId source = EntryPointId.DEFAULT;
            ReteooComponentBuilder builder = utils.getBuilderFor((RuleConditionElement)source);
            builder.build(context, utils, (RuleConditionElement)source);
        }
        this.buildBehaviors(context, utils, pattern, constraints);
        if (context.getObjectSource() != null) {
            this.attachAlphaNodes(context, utils, constraints.alphaConstraints);
        }
        this.buildXpathConstraints(context, utils, constraints);
    }

    private void buildBehaviors(BuildContext context, BuildUtils utils, Pattern pattern, Constraints constraints) {
        if (pattern.getSource() == null || !(pattern.getSource() instanceof WindowReference) && (context.getCurrentEntryPoint() != EntryPointId.DEFAULT || !pattern.getBehaviors().isEmpty())) {
            this.attachObjectTypeNode(context, utils, pattern);
        }
        if (!pattern.getBehaviors().isEmpty()) {
            List<BehaviorRuntime> behaviors = pattern.getBehaviors().stream().map(BehaviorRuntime.class::cast).collect(Collectors.toList());
            WindowNode wn = CoreComponentFactory.get().getNodeFactoryService().buildWindowNode(context.getNextNodeId(), constraints.alphaConstraints, behaviors, context.getObjectSource(), context);
            context.setObjectSource(utils.attachNode(context, wn));
            constraints.alphaConstraints.clear();
        }
    }

    private void buildXpathConstraints(BuildContext context, BuildUtils utils, Constraints constraints) {
        if (!constraints.xpathConstraints.isEmpty()) {
            GroupElementBuilder.AndBuilder.buildTupleSource(context, utils, false);
            if (constraints.xpathConstraints.size() == 1 && constraints.xpathConstraints.get(0).getXpathStartDeclaration() != null) {
                context.setObjectSource(null);
            } else {
                GroupElementBuilder.AndBuilder.buildJoinNode(context, utils);
            }
            ReteooComponentBuilder builder = utils.getBuilderFor(XpathConstraint.class);
            for (XpathConstraint xpathConstraint : constraints.xpathConstraints) {
                for (XpathConstraint.XpathChunk chunk : xpathConstraint.getChunks()) {
                    context.setAlphaConstraints(chunk.getAlphaConstraints());
                    context.setBetaconstraints(chunk.getBetaConstraints());
                    context.setXpathConstraints(chunk.getXpathConstraints());
                    builder.build(context, utils, (RuleConditionElement)chunk.asFrom());
                }
            }
            context.popRuleComponent();
        }
    }

    private Constraints createConstraints(BuildContext context, Pattern pattern) {
        Constraints constraints = new Constraints();
        this.checkRemoveIdentities(context, pattern, constraints.betaConstraints);
        boolean isNegative = this.isNegative(context);
        block5: for (Constraint constraint : pattern.getConstraints()) {
            switch (constraint.getType()) {
                case ALPHA: {
                    this.linkAlphaConstraint((AlphaNodeFieldConstraint)constraint, constraints.alphaConstraints);
                    continue block5;
                }
                case BETA: {
                    this.linkBetaConstraint((BetaNodeFieldConstraint)constraint, constraints.betaConstraints);
                    if (!isNegative || context.getRuleBase().getRuleBaseConfiguration().getEventProcessingMode() != EventProcessingOption.STREAM || !pattern.getObjectType().isEvent() || !constraint.isTemporal()) continue block5;
                    this.checkDelaying(context, constraint);
                    continue block5;
                }
                case XPATH: {
                    constraints.xpathConstraints.add((XpathConstraint)constraint);
                    continue block5;
                }
            }
            throw new RuntimeException("Unknown constraint type: " + constraint.getType() + ". This is a bug. Please contact development team.");
        }
        return constraints;
    }

    protected void linkBetaConstraint(BetaNodeFieldConstraint constraint, List<BetaNodeFieldConstraint> betaConstraints) {
        betaConstraints.add(constraint);
    }

    protected void linkAlphaConstraint(AlphaNodeFieldConstraint constraint, List<AlphaNodeFieldConstraint> alphaConstraints) {
        alphaConstraints.add(constraint);
    }

    private void checkDelaying(BuildContext context, Constraint constraint) {
        long uplimit;
        Declaration target;
        if (constraint instanceof IntervalProviderConstraint && (target = constraint.getRequiredDeclarations()[0]).isPatternDeclaration() && target.getPattern().getObjectType().isEvent() && (uplimit = ((IntervalProviderConstraint)constraint).getInterval().getUpperBound()) >= 0L && uplimit < Long.MAX_VALUE) {
            Timer timer = context.getRule().getTimer();
            DurationTimer durationTimer = new DurationTimer(uplimit);
            durationTimer.setEventFactHandle(target);
            if (timer instanceof CompositeMaxDurationTimer) {
                ((CompositeMaxDurationTimer)timer).addDurationTimer(durationTimer);
            } else {
                if (timer == null) {
                    timer = durationTimer;
                } else {
                    CompositeMaxDurationTimer temp = new CompositeMaxDurationTimer();
                    if (timer instanceof DurationTimer) {
                        temp.addDurationTimer((DurationTimer)timer);
                    } else {
                        temp.setTimer(context.getRule().getTimer());
                    }
                    temp.addDurationTimer(durationTimer);
                    timer = temp;
                }
                context.getRule().setTimer(timer);
            }
        }
    }

    private boolean isNegative(BuildContext context) {
        for (RuleConditionElement rce : context.getBuildstack()) {
            if (!(rce instanceof GroupElement) || !((GroupElement)rce).isNot()) continue;
            return true;
        }
        return false;
    }

    private static ExpirationSpec getExpirationForType(BuildContext context, ObjectType objectType) {
        long offset = -1L;
        boolean hard = false;
        for (TypeDeclaration type : context.getRuleBase().getTypeDeclarations()) {
            if (!type.getObjectType().isAssignableFrom(objectType)) continue;
            if (hard) {
                if (type.getExpirationPolicy() != Expires.Policy.TIME_HARD || type.getExpirationOffset() <= offset) continue;
                offset = type.getExpirationOffset();
                continue;
            }
            if (type.getExpirationPolicy() == Expires.Policy.TIME_HARD) {
                offset = type.getExpirationOffset();
                hard = true;
                continue;
            }
            if (type.getExpirationOffset() <= offset) continue;
            offset = type.getExpirationOffset();
        }
        return new ExpirationSpec(offset == -1L ? -1L : offset + 1L, hard);
    }

    public void attachAlphaNodes(BuildContext context, BuildUtils utils, List<AlphaNodeFieldConstraint> alphaConstraints) throws InvalidPatternException {
        this.buildAlphaNodeChain(context, utils, alphaConstraints);
        NodeFactory nfactory = CoreComponentFactory.get().getNodeFactoryService();
        if (context.getCurrentEntryPoint() != EntryPointId.DEFAULT && context.isAttachPQN()) {
            context.setCurrentEntryPoint(EntryPointId.DEFAULT);
        }
    }

    private void buildAlphaNodeChain(BuildContext context, BuildUtils utils, List<AlphaNodeFieldConstraint> alphaConstraints) {
        for (AlphaNodeFieldConstraint constraint : alphaConstraints) {
            context.pushRuleComponent((RuleComponent)constraint);
            context.setObjectSource(utils.attachNode(context, CoreComponentFactory.get().getNodeFactoryService().buildAlphaNode(context.getNextNodeId(), constraint, context.getObjectSource(), context)));
            context.popRuleComponent();
        }
    }

    private void attachObjectTypeNode(BuildContext context, BuildUtils utils, Pattern pattern) {
        ObjectType objectType = pattern.getObjectType();
        if (pattern.getObjectType() instanceof ClassObjectType && DroolsQuery.class == ((ClassObjectType)pattern.getObjectType()).getClassType()) {
            context.setTupleMemoryEnabled(false);
        }
        ObjectTypeNode otn = CoreComponentFactory.get().getNodeFactoryService().buildObjectTypeNode(context.getNextNodeId(), (EntryPointNode)context.getObjectSource(), objectType, context);
        if (objectType.isEvent() && EventProcessingOption.STREAM.equals((Object)context.getRuleBase().getRuleBaseConfiguration().getEventProcessingMode())) {
            ExpirationSpec expirationSpec = PatternBuilder.getExpirationForType(context, objectType);
            if (expirationSpec.offset != -1L && expirationSpec.hard) {
                otn.setExpirationOffset(expirationSpec.offset);
            } else {
                long distance;
                long offset = -1L;
                for (Behavior behavior : pattern.getBehaviors()) {
                    if (behavior.getExpirationOffset() == -1L) continue;
                    offset = Math.max(behavior.getExpirationOffset(), offset);
                }
                if (offset == -1L && !expirationSpec.hard) {
                    offset = expirationSpec.offset;
                }
                if ((distance = context.getExpirationOffset(pattern)) == -1L) {
                    otn.setExpirationOffset(offset);
                } else {
                    otn.setExpirationOffset(Math.max(distance, offset));
                }
            }
        }
        context.setObjectSource(utils.attachNode(context, otn));
    }

    private void checkRemoveIdentities(BuildContext context, Pattern pattern, List<BetaNodeFieldConstraint> betaConstraints) {
        if (context.getRuleBase().getRuleBaseConfiguration().isRemoveIdentities() && pattern.getObjectType().getClass() == ClassObjectType.class) {
            ObjectType thisObjectType = pattern.getObjectType();
            for (Pattern previousPattern : context.getPatterns()) {
                ObjectType previousObjectType = previousPattern.getObjectType();
                if (!thisObjectType.isAssignableFrom(previousObjectType)) continue;
                betaConstraints.add(new InstanceNotEqualsConstraint(previousPattern));
            }
        }
    }

    @Override
    public boolean requiresLeftActivation(BuildUtils utils, RuleConditionElement rce) {
        PatternSource source = ((Pattern)rce).getSource();
        return source != null && source.requiresLeftActivation() || !((Pattern)rce).getBehaviors().isEmpty();
    }

    private static class Constraints {
        private final List<AlphaNodeFieldConstraint> alphaConstraints = new ArrayList<AlphaNodeFieldConstraint>();
        private final List<BetaNodeFieldConstraint> betaConstraints = new ArrayList<BetaNodeFieldConstraint>();
        private final List<XpathConstraint> xpathConstraints = new ArrayList<XpathConstraint>();

        private Constraints() {
        }
    }

    private static class ExpirationSpec {
        final long offset;
        final boolean hard;

        private ExpirationSpec(long offset, boolean hard) {
            this.offset = offset;
            this.hard = hard;
        }
    }
}

