/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.rule;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.drools.core.base.ClassObjectType;
import org.drools.core.common.ReteEvaluator;
import org.drools.core.rule.ConditionalElement;
import org.drools.core.rule.Declaration;
import org.drools.core.rule.Pattern;
import org.drools.core.rule.PatternSource;

public class Collect
extends ConditionalElement
implements PatternSource {
    private static final long serialVersionUID = 510L;
    private Pattern sourcePattern;
    private Pattern resultPattern;
    private Class<Collection<Object>> cls;

    public Collect() {
    }

    public Collect(Pattern sourcePattern, Pattern resultPattern) {
        this.sourcePattern = sourcePattern;
        this.resultPattern = resultPattern;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.sourcePattern = (Pattern)in.readObject();
        this.resultPattern = (Pattern)in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.sourcePattern);
        out.writeObject(this.resultPattern);
    }

    @Override
    public Collect clone() {
        PatternSource source = this.resultPattern.getSource();
        if (source == this) {
            this.resultPattern.setSource(null);
        }
        Pattern clonedResultPattern = this.resultPattern.clone();
        Collect collect = new Collect(this.sourcePattern.clone(), clonedResultPattern);
        collect.getResultPattern().setSource(collect);
        if (source == this) {
            this.resultPattern.setSource(this);
        }
        return collect;
    }

    public Pattern getResultPattern() {
        return this.resultPattern;
    }

    public Pattern getSourcePattern() {
        return this.sourcePattern;
    }

    public Collection<Object> instantiateResultObject(ReteEvaluator reteEvaluator) throws RuntimeException {
        try {
            if (this.cls == null) {
                ClassObjectType objType = (ClassObjectType)this.resultPattern.getObjectType();
                String className = this.determineResultClassName(objType);
                this.cls = Class.forName(className, true, reteEvaluator.getKnowledgeBase().getRootClassLoader());
            }
            return this.cls.newInstance();
        }
        catch (ClassCastException cce) {
            throw new RuntimeException("Collect CE requires a Collection implementation as return type", cce);
        }
        catch (InstantiationException e) {
            throw new RuntimeException("Collect CE requires a non-argument constructor for the return type", e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Collect CE requires an accessible constructor for the return type", e);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Collect CE could not resolve return result class '" + this.resultPattern.getObjectType().getClassName() + "'", e);
        }
    }

    private String determineResultClassName(ClassObjectType objType) {
        String className = objType.getClassName();
        if (List.class.getName().equals(className)) {
            return ArrayList.class.getName();
        }
        if (Set.class.getName().equals(className)) {
            return HashSet.class.getName();
        }
        if (Collection.class.getName().equals(className)) {
            return ArrayList.class.getName();
        }
        return className;
    }

    @Override
    public Map<String, Declaration> getInnerDeclarations() {
        return this.sourcePattern.getInnerDeclarations();
    }

    @Override
    public Map<String, Declaration> getOuterDeclarations() {
        return Collections.EMPTY_MAP;
    }

    @Override
    public Declaration resolveDeclaration(String identifier) {
        return this.sourcePattern.getInnerDeclarations().get(identifier);
    }

    public List<Pattern> getNestedElements() {
        return Collections.singletonList(this.sourcePattern);
    }

    @Override
    public boolean isPatternScopeDelimiter() {
        return true;
    }

    @Override
    public boolean requiresLeftActivation() {
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Collect collect = (Collect)o;
        return Objects.equals(this.sourcePattern, collect.sourcePattern);
    }

    public int hashCode() {
        return Objects.hash(this.sourcePattern);
    }
}

