/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.util.index;

import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.HashCommon;
import it.unimi.dsi.fastutil.objects.ObjectOpenCustomHashSet;
import java.util.function.BiFunction;

public class FastUtilMergableHashSet<K>
extends ObjectOpenCustomHashSet<K> {
    public FastUtilMergableHashSet(Hash.Strategy strategy) {
        super(strategy);
    }

    public FastUtilMergableHashSet(int expected, Hash.Strategy strategy) {
        super(expected, strategy);
    }

    public K compute(K k, BiFunction<? super K, ? super K, ? extends K> remappingFunction) {
        Object[] key = this.key;
        K newKey = null;
        int pos = HashCommon.mix(this.strategy.hashCode(k)) & this.mask;
        Object curr = key[pos];
        if (curr == null || this.strategy.equals(k, curr)) {
            newKey = remappingFunction.apply(k, curr);
            key[pos] = newKey;
        }
        if (newKey == null) {
            while ((curr = key[pos = pos + 1 & this.mask]) != null && !this.strategy.equals(k, curr)) {
            }
            newKey = remappingFunction.apply(k, curr);
        }
        if (curr == null && newKey != null) {
            key[pos] = newKey;
            if (this.size++ >= this.maxFill) {
                this.rehash(HashCommon.arraySize(this.size + 1, this.f));
            }
        } else if (curr != null && newKey == null) {
            this.removeEntry(pos);
        }
        return newKey;
    }

    private boolean removeEntry(int pos) {
        --this.size;
        this.shiftKeys(pos);
        if (this.n > this.minN && this.size < this.maxFill / 4 && this.n > 16) {
            this.rehash(this.n / 2);
        }
        return true;
    }
}

