/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.facttemplates;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.SortedMap;
import java.util.TreeMap;
import org.drools.core.definitions.InternalKnowledgePackage;
import org.drools.core.facttemplates.Fact;
import org.drools.core.facttemplates.FactImpl;
import org.drools.core.facttemplates.FactTemplate;
import org.drools.core.facttemplates.FieldTemplate;

public class FactTemplateImpl
implements FactTemplate {
    private InternalKnowledgePackage pkg;
    private String name;
    private SortedMap<String, FieldTemplate> fields = new TreeMap<String, FieldTemplate>();

    public FactTemplateImpl() {
    }

    public FactTemplateImpl(InternalKnowledgePackage pkg, String name, FieldTemplate ... fields) {
        this.pkg = pkg;
        this.name = name;
        this.pkg.addFactTemplate(this);
        if (fields != null && fields.length > 0) {
            this.fields = new TreeMap<String, FieldTemplate>();
            for (FieldTemplate field : fields) {
                this.fields.put(field.getName(), field);
            }
        } else {
            this.fields = Collections.emptySortedMap();
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.pkg = (InternalKnowledgePackage)in.readObject();
        this.name = (String)in.readObject();
        this.fields = (SortedMap)in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.pkg);
        out.writeObject(this.name);
        out.writeObject(this.fields);
    }

    @Override
    public InternalKnowledgePackage getPackage() {
        return this.pkg;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getNumberOfFields() {
        return this.fields.size();
    }

    @Override
    public Collection<String> getFieldNames() {
        return this.fields.keySet();
    }

    @Override
    public FieldTemplate getFieldTemplate(String name) {
        return (FieldTemplate)this.fields.get(name);
    }

    @Override
    public int getFieldTemplateIndex(String name) {
        int i = 0;
        for (String field : this.fields.keySet()) {
            if (field.equals(name)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    @Override
    public Fact createFact() {
        return new FactImpl(this);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("(" + this.name + " ");
        buf.append(")");
        return buf.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FactTemplateImpl that = (FactTemplateImpl)o;
        return this.pkg.getName().equals(that.pkg.getName()) && this.name.equals(that.name) && this.fields.equals(that.fields);
    }

    public int hashCode() {
        return Objects.hash(this.pkg.getName(), this.name, this.fields);
    }
}

