/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.reteoo;

import org.drools.core.common.BetaConstraints;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.ReteEvaluator;
import org.drools.core.common.TupleSets;
import org.drools.core.phreak.AddRemoveRule;
import org.drools.core.phreak.RuleNetworkEvaluator;
import org.drools.core.reteoo.BaseLeftTuple;
import org.drools.core.reteoo.BetaMemory;
import org.drools.core.reteoo.BetaNode;
import org.drools.core.reteoo.LeftTuple;
import org.drools.core.reteoo.LeftTupleSource;
import org.drools.core.reteoo.NotNodeLeftTuple;
import org.drools.core.reteoo.ObjectSource;
import org.drools.core.reteoo.ObjectTypeNode;
import org.drools.core.reteoo.ReteooBuilder;
import org.drools.core.reteoo.RightTuple;
import org.drools.core.reteoo.RuleRemovalContext;
import org.drools.core.reteoo.Sink;
import org.drools.core.reteoo.builder.BuildContext;
import org.drools.core.spi.PropagationContext;

public class NotNode
extends BetaNode {
    private static final long serialVersionUID = 510L;
    private boolean emptyBetaConstraints;

    public NotNode() {
    }

    public NotNode(int id, LeftTupleSource leftInput, ObjectSource rightInput, BetaConstraints joinNodeBinder, BuildContext context) {
        super(id, leftInput, rightInput, joinNodeBinder, context);
        this.tupleMemoryEnabled = context.isTupleMemoryEnabled();
        this.setObjectCount(leftInput.getObjectCount());
        this.emptyBetaConstraints = joinNodeBinder.getConstraints().length == 0 || context.isEmptyForAllBetaConstraints();
    }

    @Override
    protected void reorderRightTuple(ReteEvaluator reteEvaluator, RightTuple rightTuple) {
        RuleNetworkEvaluator.doExistentialUpdatesReorderChildLeftTuple(reteEvaluator, this, rightTuple);
    }

    public boolean isEmptyBetaConstraints() {
        return this.emptyBetaConstraints;
    }

    public void setEmptyBetaConstraints(boolean emptyBetaConstraints) {
        this.emptyBetaConstraints = emptyBetaConstraints;
    }

    @Override
    public short getType() {
        return 191;
    }

    @Override
    public LeftTuple createPeer(LeftTuple original) {
        NotNodeLeftTuple peer = new NotNodeLeftTuple();
        peer.initPeer((BaseLeftTuple)original, this);
        original.setPeer(peer);
        return peer;
    }

    @Override
    public LeftTuple createLeftTuple(InternalFactHandle factHandle, boolean leftTupleMemoryEnabled) {
        return new NotNodeLeftTuple(factHandle, this, leftTupleMemoryEnabled);
    }

    @Override
    public LeftTuple createLeftTuple(InternalFactHandle factHandle, LeftTuple leftTuple, Sink sink) {
        return new NotNodeLeftTuple(factHandle, leftTuple, sink);
    }

    @Override
    public LeftTuple createLeftTuple(LeftTuple leftTuple, Sink sink, PropagationContext pctx, boolean leftTupleMemoryEnabled) {
        return new NotNodeLeftTuple(leftTuple, sink, pctx, leftTupleMemoryEnabled);
    }

    @Override
    public LeftTuple createLeftTuple(LeftTuple leftTuple, RightTuple rightTuple, Sink sink) {
        return new NotNodeLeftTuple(leftTuple, rightTuple, sink);
    }

    @Override
    public LeftTuple createLeftTuple(LeftTuple leftTuple, RightTuple rightTuple, LeftTuple currentLeftChild, LeftTuple currentRightChild, Sink sink, boolean leftTupleMemoryEnabled) {
        return new NotNodeLeftTuple(leftTuple, rightTuple, currentLeftChild, currentRightChild, sink, leftTupleMemoryEnabled);
    }

    @Override
    public String toString() {
        ObjectTypeNode source = this.getObjectTypeNode();
        return "[NotNode(" + this.getId() + ") - " + (source != null ? source.getObjectType() : "<source from a subnetwork>") + "]";
    }

    @Override
    public void assertObject(InternalFactHandle factHandle, PropagationContext pctx, ReteEvaluator reteEvaluator) {
        BetaMemory memory = NotNode.getBetaMemoryFromRightInput(this, reteEvaluator);
        RightTuple rightTuple = this.createRightTuple(factHandle, this, pctx);
        rightTuple.setPropagationContext(pctx);
        boolean stagedInsertWasEmpty = memory.getStagedRightTuples().addInsert(rightTuple);
        if (memory.getAndIncCounter() == 0 && this.isEmptyBetaConstraints()) {
            if (stagedInsertWasEmpty) {
                memory.setNodeDirtyWithoutNotify();
            }
            memory.linkNode(this, reteEvaluator);
        } else if (stagedInsertWasEmpty) {
            memory.setNodeDirty(this, reteEvaluator);
        }
        AddRemoveRule.flushLeftTupleIfNecessary(reteEvaluator, memory.getOrCreateSegmentMemory(this, reteEvaluator), this.isStreamMode());
    }

    @Override
    public void retractRightTuple(RightTuple rightTuple, PropagationContext pctx, ReteEvaluator reteEvaluator) {
        BetaMemory memory = (BetaMemory)reteEvaluator.getNodeMemory(this);
        rightTuple.setPropagationContext(pctx);
        this.doDeleteRightTuple(rightTuple, reteEvaluator, memory);
    }

    @Override
    public void doDeleteRightTuple(RightTuple rightTuple, ReteEvaluator reteEvaluator, BetaMemory memory) {
        TupleSets<RightTuple> stagedRightTuples = memory.getStagedRightTuples();
        boolean stagedDeleteWasEmpty = stagedRightTuples.addDelete(rightTuple);
        if (memory.getAndDecCounter() == 1 && this.isEmptyBetaConstraints()) {
            if (stagedDeleteWasEmpty) {
                memory.setNodeDirtyWithoutNotify();
            }
            memory.linkNode(this, reteEvaluator);
        } else if (stagedDeleteWasEmpty) {
            memory.setNodeDirty(this, reteEvaluator);
        }
        AddRemoveRule.flushLeftTupleIfNecessary(reteEvaluator, memory.getOrCreateSegmentMemory(this, reteEvaluator), this.isStreamMode());
    }

    @Override
    public void modifyRightTuple(RightTuple rightTuple, PropagationContext context, ReteEvaluator reteEvaluator) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean doRemove(RuleRemovalContext context, ReteooBuilder builder) {
        if (!this.isInUse()) {
            this.getLeftTupleSource().removeTupleSink(this);
            this.getRightInput().removeObjectSink(this);
            return true;
        }
        return false;
    }

    public boolean isLeftUpdateOptimizationAllowed() {
        return this.getRawConstraints().isLeftUpdateOptimizationAllowed();
    }
}

