/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.facttemplates;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Method;
import org.drools.core.base.ValueType;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.common.ReteEvaluator;
import org.drools.core.facttemplates.Fact;
import org.drools.core.facttemplates.FactTemplate;
import org.drools.core.spi.InternalReadAccessor;
import org.drools.core.util.ClassUtils;

public class FactTemplateFieldExtractor
implements Externalizable,
InternalReadAccessor {
    private static final long serialVersionUID = 510L;
    private FactTemplate factTemplate;
    private String fieldName;
    private int fieldIndex;

    public FactTemplateFieldExtractor() {
    }

    public FactTemplateFieldExtractor(FactTemplate factTemplate, String fieldName) {
        this.factTemplate = factTemplate;
        this.fieldName = fieldName;
        this.fieldIndex = factTemplate.getFieldTemplateIndex(fieldName);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.factTemplate = (FactTemplate)in.readObject();
        this.fieldName = in.readUTF();
        this.fieldIndex = in.readInt();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.factTemplate);
        out.writeUTF(this.fieldName);
        out.writeInt(this.fieldIndex);
    }

    @Override
    public ValueType getValueType() {
        return this.factTemplate.getFieldTemplate(this.fieldName).getValueType();
    }

    @Override
    public Object getValue(ReteEvaluator reteEvaluator, Object object) {
        return ((Fact)object).get(this.fieldName);
    }

    @Override
    public int getIndex() {
        return this.fieldIndex;
    }

    public Class getExtractToClass() {
        return this.factTemplate.getFieldTemplate(this.fieldName).getValueType().getClassType();
    }

    @Override
    public String getExtractToClassName() {
        return ClassUtils.canonicalName(this.getExtractToClass());
    }

    @Override
    public boolean getBooleanValue(ReteEvaluator reteEvaluator, Object object) {
        return (Boolean)((Fact)object).get(this.fieldName);
    }

    @Override
    public byte getByteValue(ReteEvaluator reteEvaluator, Object object) {
        return ((Number)((Fact)object).get(this.fieldName)).byteValue();
    }

    @Override
    public char getCharValue(ReteEvaluator reteEvaluator, Object object) {
        return ((Character)((Fact)object).get(this.fieldName)).charValue();
    }

    @Override
    public double getDoubleValue(ReteEvaluator reteEvaluator, Object object) {
        return ((Number)((Fact)object).get(this.fieldName)).doubleValue();
    }

    @Override
    public float getFloatValue(ReteEvaluator reteEvaluator, Object object) {
        return ((Number)((Fact)object).get(this.fieldName)).floatValue();
    }

    @Override
    public int getIntValue(ReteEvaluator reteEvaluator, Object object) {
        return ((Number)((Fact)object).get(this.fieldName)).intValue();
    }

    @Override
    public long getLongValue(ReteEvaluator reteEvaluator, Object object) {
        return ((Number)((Fact)object).get(this.fieldName)).longValue();
    }

    @Override
    public short getShortValue(ReteEvaluator reteEvaluator, Object object) {
        return ((Number)((Fact)object).get(this.fieldName)).shortValue();
    }

    @Override
    public Method getNativeReadMethod() {
        try {
            return this.getClass().getDeclaredMethod("getValue", InternalWorkingMemory.class, Object.class);
        }
        catch (Exception e) {
            throw new RuntimeException("This is a bug. Please report to development team: " + e.getMessage(), e);
        }
    }

    @Override
    public String getNativeReadMethodName() {
        return "getValue";
    }

    @Override
    public int getHashCode(ReteEvaluator reteEvaluator, Object object) {
        return this.getValue(reteEvaluator, object).hashCode();
    }

    @Override
    public boolean isGlobal() {
        return false;
    }

    @Override
    public boolean isSelfReference() {
        return false;
    }

    @Override
    public boolean isNullValue(ReteEvaluator reteEvaluator, Object object) {
        return ((Fact)object).get(this.fieldName) == null;
    }

    @Override
    public int getHashCode(Object object) {
        return this.getHashCode(null, object);
    }

    @Override
    public Object getValue(Object object) {
        return this.getValue(null, object);
    }

    @Override
    public boolean isNullValue(Object object) {
        return this.isNullValue(null, object);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.factTemplate == null ? 0 : this.factTemplate.hashCode());
        result = 31 * result + this.fieldIndex;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FactTemplateFieldExtractor other = (FactTemplateFieldExtractor)obj;
        if (this.factTemplate == null ? other.factTemplate != null : !this.factTemplate.equals(other.factTemplate)) {
            return false;
        }
        return this.fieldIndex == other.fieldIndex;
    }
}

