/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.reteoo;

import java.util.List;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.common.ReteEvaluator;
import org.drools.core.common.RuleBasePartitionId;
import org.drools.core.reteoo.ModifyPreviousTuples;
import org.drools.core.reteoo.ObjectSink;
import org.drools.core.reteoo.ObjectSinkNode;
import org.drools.core.reteoo.ObjectSource;
import org.drools.core.reteoo.builder.BuildContext;
import org.drools.core.spi.AlphaNodeFieldConstraint;
import org.drools.core.spi.PropagationContext;
import org.drools.core.util.bitmask.BitMask;
import org.kie.api.definition.rule.Rule;

public class AlphaNode
extends ObjectSource
implements ObjectSinkNode {
    private static final long serialVersionUID = 510L;
    protected AlphaNodeFieldConstraint constraint;
    private ObjectSinkNode previousRightTupleSinkNode;
    private ObjectSinkNode nextRightTupleSinkNode;

    public AlphaNode() {
    }

    public AlphaNode(int id, AlphaNodeFieldConstraint constraint, ObjectSource objectSource, BuildContext context) {
        super(id, context.getPartitionId(), context.getKnowledgeBase().getConfiguration().isMultithreadEvaluation(), objectSource, context.getKnowledgeBase().getConfiguration().getAlphaNodeHashingThreshold(), context.getKnowledgeBase().getConfiguration().getAlphaNodeRangeIndexThreshold());
        this.constraint = constraint.cloneIfInUse();
        this.constraint.registerEvaluationContext(context);
        this.initDeclaredMask(context);
        this.hashcode = this.calculateHashCode();
    }

    public AlphaNodeFieldConstraint getConstraint() {
        return this.constraint;
    }

    @Override
    public short getType() {
        return 40;
    }

    @Override
    public void doAttach(BuildContext context) {
        super.doAttach(context);
        this.source.addObjectSink(this);
    }

    @Override
    public void setPartitionId(BuildContext context, RuleBasePartitionId partitionId) {
        if (this.partitionId != null && this.partitionId != partitionId) {
            if (this.source instanceof AlphaNode) {
                this.source.setPartitionId(context, partitionId);
            }
            this.source.sink.changeSinkPartition(this, this.partitionId, partitionId, this.source.alphaNodeHashingThreshold, this.source.alphaNodeRangeIndexThreshold);
        }
        this.partitionId = partitionId;
    }

    @Override
    public void assertObject(InternalFactHandle factHandle, PropagationContext context, ReteEvaluator reteEvaluator) {
        if (this.constraint.isAllowed(factHandle, reteEvaluator)) {
            this.sink.propagateAssertObject(factHandle, context, reteEvaluator);
        }
    }

    @Override
    public void modifyObject(InternalFactHandle factHandle, ModifyPreviousTuples modifyPreviousTuples, PropagationContext context, ReteEvaluator reteEvaluator) {
        if (context.getModificationMask().intersects(this.inferredMask)) {
            if (this.constraint.isAllowed(factHandle, reteEvaluator)) {
                this.sink.propagateModifyObject(factHandle, modifyPreviousTuples, context, reteEvaluator);
            }
        } else {
            this.byPassModifyToBetaNode(factHandle, modifyPreviousTuples, context, reteEvaluator);
        }
    }

    @Override
    public void byPassModifyToBetaNode(InternalFactHandle factHandle, ModifyPreviousTuples modifyPreviousTuples, PropagationContext context, ReteEvaluator reteEvaluator) {
        this.sink.byPassModifyToBetaNode(factHandle, modifyPreviousTuples, context, reteEvaluator);
    }

    @Override
    public void updateSink(ObjectSink sink, PropagationContext context, InternalWorkingMemory workingMemory) {
        ObjectSinkUpdateAdapter adapter = new ObjectSinkUpdateAdapter(sink, this.constraint);
        this.source.updateSink(adapter, context, workingMemory);
    }

    @Override
    public String toString() {
        return "[AlphaNode(" + this.id + ") constraint=" + this.constraint + "]";
    }

    private int calculateHashCode() {
        return (this.source != null ? this.source.hashCode() : 0) * 37 + (this.constraint != null ? this.constraint.hashCode() : 0) * 31;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof AlphaNode) || this.hashCode() != object.hashCode()) {
            return false;
        }
        AlphaNode other = (AlphaNode)object;
        return this.source.getId() == other.source.getId() && this.constraint.equals(other.constraint, this.getKnowledgeBase());
    }

    @Override
    public ObjectSinkNode getNextObjectSinkNode() {
        return this.nextRightTupleSinkNode;
    }

    @Override
    public void setNextObjectSinkNode(ObjectSinkNode next) {
        this.nextRightTupleSinkNode = next;
    }

    @Override
    public ObjectSinkNode getPreviousObjectSinkNode() {
        return this.previousRightTupleSinkNode;
    }

    @Override
    public void setPreviousObjectSinkNode(ObjectSinkNode previous) {
        this.previousRightTupleSinkNode = previous;
    }

    @Override
    public BitMask calculateDeclaredMask(Class modifiedClass, List<String> settableProperties) {
        return this.constraint.getListenedPropertyMask(modifiedClass, settableProperties);
    }

    @Override
    public BitMask getDeclaredMask() {
        return this.declaredMask;
    }

    public BitMask getInferredMask() {
        return this.inferredMask;
    }

    private static class ObjectSinkUpdateAdapter
    implements ObjectSink {
        private final ObjectSink sink;
        private final AlphaNodeFieldConstraint constraint;

        public ObjectSinkUpdateAdapter(ObjectSink sink, AlphaNodeFieldConstraint constraint) {
            this.sink = sink;
            this.constraint = constraint;
        }

        @Override
        public void assertObject(InternalFactHandle handle, PropagationContext propagationContext, ReteEvaluator reteEvaluator) {
            block3: {
                try {
                    if (this.constraint.isAllowed(handle, reteEvaluator)) {
                        this.sink.assertObject(handle, propagationContext, reteEvaluator);
                    }
                }
                catch (RuntimeException e) {
                    if (e.getCause() instanceof ClassCastException) break block3;
                    throw e;
                }
            }
        }

        @Override
        public int getId() {
            return 0;
        }

        @Override
        public RuleBasePartitionId getPartitionId() {
            return this.sink.getPartitionId();
        }

        @Override
        public void modifyObject(InternalFactHandle factHandle, ModifyPreviousTuples modifyPreviousTuples, PropagationContext context, ReteEvaluator reteEvaluator) {
            throw new UnsupportedOperationException("This method should NEVER EVER be called");
        }

        @Override
        public void byPassModifyToBetaNode(InternalFactHandle factHandle, ModifyPreviousTuples modifyPreviousTuples, PropagationContext context, ReteEvaluator reteEvaluator) {
        }

        @Override
        public short getType() {
            return 40;
        }

        @Override
        public int getAssociationsSize() {
            return this.sink.getAssociationsSize();
        }

        @Override
        public int getAssociatedRuleSize() {
            return this.sink.getAssociatedRuleSize();
        }

        @Override
        public int getAssociationsSize(Rule rule) {
            return this.sink.getAssociationsSize(rule);
        }

        @Override
        public Rule[] getAssociatedRules() {
            return this.sink.getAssociatedRules();
        }

        @Override
        public boolean isAssociatedWith(Rule rule) {
            return this.sink.isAssociatedWith(rule);
        }
    }
}

