/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.phreak;

import org.drools.core.common.ActivationsManager;
import org.drools.core.common.AgendaItem;
import org.drools.core.common.InternalAgendaGroup;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.ReteEvaluator;
import org.drools.core.common.TupleSets;
import org.drools.core.definitions.rule.impl.RuleImpl;
import org.drools.core.phreak.RuleAgendaItem;
import org.drools.core.phreak.RuleExecutor;
import org.drools.core.reteoo.LeftTuple;
import org.drools.core.reteoo.ObjectTypeConf;
import org.drools.core.reteoo.RuleTerminalNodeLeftTuple;
import org.drools.core.reteoo.TerminalNode;
import org.drools.core.spi.PropagationContext;
import org.drools.core.spi.Salience;
import org.drools.core.spi.Tuple;
import org.kie.api.definition.rule.Rule;
import org.kie.api.event.rule.MatchCancelledCause;

public class PhreakRuleTerminalNode {
    public void doNode(TerminalNode rtnNode, ActivationsManager activationsManager, TupleSets<LeftTuple> srcLeftTuples, RuleExecutor executor) {
        if (srcLeftTuples.getDeleteFirst() != null) {
            this.doLeftDeletes(activationsManager, srcLeftTuples, executor);
        }
        if (srcLeftTuples.getUpdateFirst() != null) {
            this.doLeftUpdates(rtnNode, activationsManager, srcLeftTuples, executor);
        }
        if (srcLeftTuples.getInsertFirst() != null) {
            this.doLeftInserts(rtnNode, activationsManager, srcLeftTuples, executor);
        }
        srcLeftTuples.resetAll();
    }

    public void doLeftInserts(TerminalNode rtnNode, ActivationsManager activationsManager, TupleSets<LeftTuple> srcLeftTuples, RuleExecutor executor) {
        RuleAgendaItem ruleAgendaItem = executor.getRuleAgendaItem();
        if (rtnNode.getRule().getAutoFocus() && !ruleAgendaItem.getAgendaGroup().isActive()) {
            activationsManager.getAgendaGroupsManager().setFocus(ruleAgendaItem.getAgendaGroup());
        }
        LeftTuple leftTuple = srcLeftTuples.getInsertFirst();
        while (leftTuple != null) {
            LeftTuple next = (LeftTuple)leftTuple.getStagedNext();
            PhreakRuleTerminalNode.doLeftTupleInsert(rtnNode, executor, activationsManager, ruleAgendaItem, leftTuple);
            leftTuple.clearStaged();
            leftTuple = next;
        }
    }

    public static void doLeftTupleInsert(TerminalNode rtnNode, RuleExecutor executor, ActivationsManager activationsManager, RuleAgendaItem ruleAgendaItem, LeftTuple leftTuple) {
        ReteEvaluator reteEvaluator = activationsManager.getReteEvaluator();
        if (reteEvaluator.getSessionConfiguration().isDirectFiring()) {
            executor.addLeftTuple(leftTuple);
            return;
        }
        PropagationContext pctx = leftTuple.findMostRecentPropagationContext();
        if (rtnNode.getRule().isNoLoop() && rtnNode.equals(pctx.getTerminalNodeOrigin())) {
            return;
        }
        int salienceInt = PhreakRuleTerminalNode.getSalienceValue(rtnNode, ruleAgendaItem, (AgendaItem)((Object)leftTuple), reteEvaluator);
        RuleTerminalNodeLeftTuple rtnLeftTuple = (RuleTerminalNodeLeftTuple)leftTuple;
        activationsManager.createAgendaItem(rtnLeftTuple, salienceInt, pctx, ruleAgendaItem, ruleAgendaItem.getAgendaGroup());
        activationsManager.getAgendaEventSupport().fireActivationCreated(rtnLeftTuple, activationsManager.getReteEvaluator());
        if (rtnNode.getRule().isLockOnActive() && leftTuple.getPropagationContext().getType() != PropagationContext.Type.RULE_ADDITION) {
            InternalAgendaGroup agendaGroup = executor.getRuleAgendaItem().getAgendaGroup();
            if (PhreakRuleTerminalNode.blockedByLockOnActive(rtnNode.getRule(), pctx, agendaGroup)) {
                activationsManager.getAgendaEventSupport().fireActivationCancelled(rtnLeftTuple, reteEvaluator, MatchCancelledCause.FILTER);
                return;
            }
        }
        if (activationsManager.getActivationsFilter() != null && !activationsManager.getActivationsFilter().accept(rtnLeftTuple, reteEvaluator, rtnNode)) {
            return;
        }
        executor.addLeftTuple(leftTuple);
        leftTuple.increaseActivationCountForEvents();
        activationsManager.addItemToActivationGroup(rtnLeftTuple);
        if (!rtnNode.isFireDirect() && executor.isDeclarativeAgendaEnabled()) {
            PhreakRuleTerminalNode.insertAndStageActivation(reteEvaluator, rtnLeftTuple);
        }
    }

    private static void insertAndStageActivation(ReteEvaluator reteEvaluator, AgendaItem activation) {
        ObjectTypeConf activationObjectTypeConf = reteEvaluator.getDefaultEntryPoint().getObjectTypeConfigurationRegistry().getObjectTypeConf(activation);
        InternalFactHandle factHandle = reteEvaluator.getFactHandleFactory().newFactHandle(activation, activationObjectTypeConf, reteEvaluator, reteEvaluator.getDefaultEntryPoint());
        reteEvaluator.getDefaultEntryPoint().getEntryPointNode().assertActivation(factHandle, activation.getPropagationContext(), reteEvaluator);
        activation.setActivationFactHandle(factHandle);
    }

    private static int getSalienceValue(TerminalNode rtnNode, RuleAgendaItem ruleAgendaItem, AgendaItem leftTuple, ReteEvaluator reteEvaluator) {
        Salience salience = ruleAgendaItem.getRule().getSalience();
        return salience == null ? 0 : (salience.isDynamic() ? salience.getValue(leftTuple, (Rule)rtnNode.getRule(), reteEvaluator) : salience.getValue());
    }

    public void doLeftUpdates(TerminalNode rtnNode, ActivationsManager activationsManager, TupleSets<LeftTuple> srcLeftTuples, RuleExecutor executor) {
        RuleAgendaItem ruleAgendaItem = executor.getRuleAgendaItem();
        if (rtnNode.getRule().getAutoFocus() && !ruleAgendaItem.getAgendaGroup().isActive()) {
            activationsManager.getAgendaGroupsManager().setFocus(ruleAgendaItem.getAgendaGroup());
        }
        LeftTuple leftTuple = srcLeftTuples.getUpdateFirst();
        while (leftTuple != null) {
            LeftTuple next = (LeftTuple)leftTuple.getStagedNext();
            PhreakRuleTerminalNode.doLeftTupleUpdate(rtnNode, executor, activationsManager, leftTuple);
            leftTuple.clearStaged();
            leftTuple = next;
        }
    }

    public static void doLeftTupleUpdate(TerminalNode rtnNode, RuleExecutor executor, ActivationsManager activationsManager, LeftTuple leftTuple) {
        RuleTerminalNodeLeftTuple rtnLeftTuple = (RuleTerminalNodeLeftTuple)leftTuple;
        ReteEvaluator reteEvaluator = activationsManager.getReteEvaluator();
        if (reteEvaluator.getSessionConfiguration().isDirectFiring()) {
            if (!rtnLeftTuple.isQueued()) {
                executor.addLeftTuple(leftTuple);
                reteEvaluator.getRuleEventSupport().onUpdateMatch(rtnLeftTuple);
            }
            return;
        }
        PropagationContext pctx = leftTuple.findMostRecentPropagationContext();
        boolean blocked = false;
        if (executor.isDeclarativeAgendaEnabled()) {
            if (rtnLeftTuple.getBlockers() != null && !rtnLeftTuple.getBlockers().isEmpty()) {
                blocked = true;
            }
        } else {
            blocked = rtnNode.getRule().isNoLoop() && rtnNode.equals(pctx.getTerminalNodeOrigin());
        }
        int salienceInt = PhreakRuleTerminalNode.getSalienceValue(rtnNode, executor.getRuleAgendaItem(), (AgendaItem)((Object)leftTuple), reteEvaluator);
        if (activationsManager.getActivationsFilter() != null && !activationsManager.getActivationsFilter().accept(rtnLeftTuple, reteEvaluator, rtnNode)) {
            return;
        }
        if (!blocked) {
            boolean addToExector = true;
            if (rtnNode.getRule().isLockOnActive() && pctx.getType() != PropagationContext.Type.RULE_ADDITION) {
                InternalAgendaGroup agendaGroup = executor.getRuleAgendaItem().getAgendaGroup();
                if (PhreakRuleTerminalNode.blockedByLockOnActive(rtnNode.getRule(), pctx, agendaGroup)) {
                    addToExector = false;
                }
            }
            if (addToExector && !rtnLeftTuple.isQueued()) {
                activationsManager.getAgendaEventSupport().fireActivationCreated(rtnLeftTuple, reteEvaluator);
                rtnLeftTuple.update(salienceInt, pctx);
                executor.addLeftTuple(leftTuple);
                reteEvaluator.getRuleEventSupport().onUpdateMatch(rtnLeftTuple);
            }
        } else {
            rtnLeftTuple.update(salienceInt, pctx);
        }
        if (!rtnNode.isFireDirect() && executor.isDeclarativeAgendaEnabled()) {
            PhreakRuleTerminalNode.modifyActivation(reteEvaluator, rtnLeftTuple);
        }
    }

    private static void modifyActivation(ReteEvaluator reteEvaluator, AgendaItem activation) {
        InternalFactHandle factHandle = activation.getActivationFactHandle();
        if (factHandle != null) {
            reteEvaluator.getDefaultEntryPoint().getEntryPointNode().modifyActivation(factHandle, activation.getPropagationContext(), reteEvaluator);
        }
    }

    public void doLeftDeletes(ActivationsManager activationsManager, TupleSets<LeftTuple> srcLeftTuples, RuleExecutor executor) {
        LeftTuple leftTuple = srcLeftTuples.getDeleteFirst();
        while (leftTuple != null) {
            LeftTuple next = (LeftTuple)leftTuple.getStagedNext();
            PhreakRuleTerminalNode.doLeftDelete(activationsManager, executor, leftTuple);
            leftTuple.clearStaged();
            leftTuple = next;
        }
    }

    public static void doLeftDelete(ActivationsManager activationsManager, RuleExecutor executor, Tuple leftTuple) {
        RuleTerminalNodeLeftTuple rtnLt = (RuleTerminalNodeLeftTuple)leftTuple;
        rtnLt.setMatched(false);
        activationsManager.cancelActivation(rtnLt);
        if (leftTuple.getMemory() != null) {
            executor.removeLeftTuple(leftTuple);
        }
        leftTuple.setContextObject(null);
    }

    private static boolean blockedByLockOnActive(RuleImpl rule, PropagationContext pctx, InternalAgendaGroup agendaGroup) {
        if (rule.isLockOnActive()) {
            long handleRecency = pctx.getFactHandle().getRecency();
            boolean isActive = agendaGroup.isActive();
            long activatedForRecency = agendaGroup.getActivatedForRecency();
            long clearedForRecency = agendaGroup.getClearedForRecency();
            if (isActive && activatedForRecency < handleRecency && agendaGroup.getAutoFocusActivator() != pctx) {
                return true;
            }
            return clearedForRecency != -1L && clearedForRecency >= handleRecency;
        }
        return false;
    }
}

