/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.base.evaluators;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.drools.core.base.BaseEvaluator;
import org.drools.core.base.ValueType;
import org.drools.core.base.evaluators.EvaluatorCache;
import org.drools.core.base.evaluators.EvaluatorDefinition;
import org.drools.core.base.evaluators.Operator;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.ReteEvaluator;
import org.drools.core.rule.VariableRestriction;
import org.drools.core.spi.Evaluator;
import org.drools.core.spi.FieldValue;
import org.drools.core.spi.InternalReadAccessor;

public class SetEvaluatorsDefinition
implements EvaluatorDefinition {
    protected static final String containsOp = "contains";
    protected static final String excludesOp = "excludes";
    protected static final String memberOfOp = "memberOf";
    public static Operator CONTAINS;
    public static Operator NOT_CONTAINS;
    public static Operator EXCLUDES;
    public static Operator NOT_EXCLUDES;
    public static Operator MEMBEROF;
    public static Operator NOT_MEMBEROF;
    private static String[] SUPPORTED_IDS;
    private EvaluatorCache evaluators;
    private static ObjectArrayContainsEvaluator objectArrayEvaluator;
    private static Map<Class, ArrayContains> primitiveArrayEvaluator;

    public SetEvaluatorsDefinition() {
        SetEvaluatorsDefinition.init();
        this.evaluators = new EvaluatorCache(){
            private static final long serialVersionUID = 510L;
            {
                this.addEvaluator(ValueType.ARRAY_TYPE, CONTAINS, ArrayContainsEvaluator.INSTANCE);
                this.addEvaluator(ValueType.ARRAY_TYPE, NOT_CONTAINS, ArrayExcludesEvaluator.INSTANCE);
                this.addEvaluator(ValueType.ARRAY_TYPE, EXCLUDES, ArrayExcludesEvaluator.INSTANCE);
                this.addEvaluator(ValueType.ARRAY_TYPE, NOT_EXCLUDES, ArrayContainsEvaluator.INSTANCE);
                this.addEvaluator(ValueType.BIG_DECIMAL_TYPE, MEMBEROF, BigDecimalMemberOfEvaluator.INSTANCE);
                this.addEvaluator(ValueType.BIG_DECIMAL_TYPE, NOT_MEMBEROF, BigDecimalNotMemberOfEvaluator.INSTANCE);
                this.addEvaluator(ValueType.BIG_INTEGER_TYPE, MEMBEROF, BigIntegerMemberOfEvaluator.INSTANCE);
                this.addEvaluator(ValueType.BIG_INTEGER_TYPE, NOT_MEMBEROF, BigIntegerNotMemberOfEvaluator.INSTANCE);
                this.addEvaluator(ValueType.BOOLEAN_TYPE, MEMBEROF, BooleanMemberOfEvaluator.INSTANCE);
                this.addEvaluator(ValueType.BOOLEAN_TYPE, NOT_MEMBEROF, BooleanNotMemberOfEvaluator.INSTANCE);
                this.addEvaluator(ValueType.PBOOLEAN_TYPE, MEMBEROF, BooleanMemberOfEvaluator.INSTANCE);
                this.addEvaluator(ValueType.PBOOLEAN_TYPE, NOT_MEMBEROF, BooleanNotMemberOfEvaluator.INSTANCE);
                this.addEvaluator(ValueType.BYTE_TYPE, MEMBEROF, ByteMemberOfEvaluator.INSTANCE);
                this.addEvaluator(ValueType.BYTE_TYPE, NOT_MEMBEROF, ByteNotMemberOfEvaluator.INSTANCE);
                this.addEvaluator(ValueType.PBYTE_TYPE, MEMBEROF, ByteMemberOfEvaluator.INSTANCE);
                this.addEvaluator(ValueType.PBYTE_TYPE, NOT_MEMBEROF, ByteNotMemberOfEvaluator.INSTANCE);
                this.addEvaluator(ValueType.CHAR_TYPE, MEMBEROF, CharacterMemberOfEvaluator.INSTANCE);
                this.addEvaluator(ValueType.CHAR_TYPE, NOT_MEMBEROF, CharacterNotMemberOfEvaluator.INSTANCE);
                this.addEvaluator(ValueType.PCHAR_TYPE, MEMBEROF, CharacterMemberOfEvaluator.INSTANCE);
                this.addEvaluator(ValueType.PCHAR_TYPE, NOT_MEMBEROF, CharacterNotMemberOfEvaluator.INSTANCE);
                this.addEvaluator(ValueType.DATE_TYPE, MEMBEROF, DateMemberOfEvaluator.INSTANCE);
                this.addEvaluator(ValueType.DATE_TYPE, NOT_MEMBEROF, DateNotMemberOfEvaluator.INSTANCE);
                this.addEvaluator(ValueType.DOUBLE_TYPE, MEMBEROF, DoubleMemberOfEvaluator.INSTANCE);
                this.addEvaluator(ValueType.DOUBLE_TYPE, NOT_MEMBEROF, DoubleNotMemberOfEvaluator.INSTANCE);
                this.addEvaluator(ValueType.PDOUBLE_TYPE, MEMBEROF, DoubleMemberOfEvaluator.INSTANCE);
                this.addEvaluator(ValueType.PDOUBLE_TYPE, NOT_MEMBEROF, DoubleNotMemberOfEvaluator.INSTANCE);
                this.addEvaluator(ValueType.FLOAT_TYPE, MEMBEROF, FloatMemberOfEvaluator.INSTANCE);
                this.addEvaluator(ValueType.FLOAT_TYPE, NOT_MEMBEROF, FloatNotMemberOfEvaluator.INSTANCE);
                this.addEvaluator(ValueType.PFLOAT_TYPE, MEMBEROF, FloatMemberOfEvaluator.INSTANCE);
                this.addEvaluator(ValueType.PFLOAT_TYPE, NOT_MEMBEROF, FloatNotMemberOfEvaluator.INSTANCE);
                this.addEvaluator(ValueType.INTEGER_TYPE, MEMBEROF, IntegerMemberOfEvaluator.INSTANCE);
                this.addEvaluator(ValueType.INTEGER_TYPE, NOT_MEMBEROF, IntegerNotMemberOfEvaluator.INSTANCE);
                this.addEvaluator(ValueType.PINTEGER_TYPE, MEMBEROF, IntegerMemberOfEvaluator.INSTANCE);
                this.addEvaluator(ValueType.PINTEGER_TYPE, NOT_MEMBEROF, IntegerNotMemberOfEvaluator.INSTANCE);
                this.addEvaluator(ValueType.LONG_TYPE, MEMBEROF, LongMemberOfEvaluator.INSTANCE);
                this.addEvaluator(ValueType.LONG_TYPE, NOT_MEMBEROF, LongNotMemberOfEvaluator.INSTANCE);
                this.addEvaluator(ValueType.PLONG_TYPE, MEMBEROF, LongMemberOfEvaluator.INSTANCE);
                this.addEvaluator(ValueType.PLONG_TYPE, NOT_MEMBEROF, LongNotMemberOfEvaluator.INSTANCE);
                this.addEvaluator(ValueType.OBJECT_TYPE, CONTAINS, ObjectContainsEvaluator.INSTANCE);
                this.addEvaluator(ValueType.OBJECT_TYPE, NOT_CONTAINS, ObjectExcludesEvaluator.INSTANCE);
                this.addEvaluator(ValueType.OBJECT_TYPE, EXCLUDES, ObjectExcludesEvaluator.INSTANCE);
                this.addEvaluator(ValueType.OBJECT_TYPE, NOT_EXCLUDES, ObjectContainsEvaluator.INSTANCE);
                this.addEvaluator(ValueType.OBJECT_TYPE, MEMBEROF, ObjectMemberOfEvaluator.INSTANCE);
                this.addEvaluator(ValueType.OBJECT_TYPE, NOT_MEMBEROF, ObjectNotMemberOfEvaluator.INSTANCE);
                this.addEvaluator(ValueType.SHORT_TYPE, MEMBEROF, ShortMemberOfEvaluator.INSTANCE);
                this.addEvaluator(ValueType.SHORT_TYPE, NOT_MEMBEROF, ShortNotMemberOfEvaluator.INSTANCE);
                this.addEvaluator(ValueType.PSHORT_TYPE, MEMBEROF, ShortMemberOfEvaluator.INSTANCE);
                this.addEvaluator(ValueType.PSHORT_TYPE, NOT_MEMBEROF, ShortNotMemberOfEvaluator.INSTANCE);
                this.addEvaluator(ValueType.STRING_TYPE, MEMBEROF, StringMemberOfEvaluator.INSTANCE);
                this.addEvaluator(ValueType.STRING_TYPE, NOT_MEMBEROF, StringNotMemberOfEvaluator.INSTANCE);
            }
        };
    }

    static void init() {
        if (Operator.determineOperator(containsOp, false) == null) {
            CONTAINS = Operator.addOperatorToRegistry(containsOp, false);
            NOT_CONTAINS = Operator.addOperatorToRegistry(containsOp, true);
        }
        if (Operator.determineOperator(excludesOp, false) == null) {
            EXCLUDES = Operator.addOperatorToRegistry(excludesOp, false);
            NOT_EXCLUDES = Operator.addOperatorToRegistry(excludesOp, true);
        }
        if (Operator.determineOperator(memberOfOp, false) == null) {
            MEMBEROF = Operator.addOperatorToRegistry(memberOfOp, false);
            NOT_MEMBEROF = Operator.addOperatorToRegistry(memberOfOp, true);
        }
        if (SUPPORTED_IDS == null) {
            SUPPORTED_IDS = new String[]{memberOfOp, containsOp, excludesOp};
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.evaluators = (EvaluatorCache)in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.evaluators);
    }

    @Override
    public Evaluator getEvaluator(ValueType type, Operator operator) {
        return this.evaluators.getEvaluator(type, operator);
    }

    @Override
    public Evaluator getEvaluator(ValueType type, Operator operator, String parameterText) {
        return this.evaluators.getEvaluator(type, operator);
    }

    @Override
    public Evaluator getEvaluator(ValueType type, String operatorId, boolean isNegated, String parameterText) {
        return this.getEvaluator(type, operatorId, isNegated, parameterText, EvaluatorDefinition.Target.FACT, EvaluatorDefinition.Target.FACT);
    }

    @Override
    public Evaluator getEvaluator(ValueType type, String operatorId, boolean isNegated, String parameterText, EvaluatorDefinition.Target left, EvaluatorDefinition.Target right) {
        return this.evaluators.getEvaluator(type, Operator.determineOperator(operatorId, isNegated));
    }

    @Override
    public String[] getEvaluatorIds() {
        return SUPPORTED_IDS;
    }

    @Override
    public boolean isNegatable() {
        return true;
    }

    @Override
    public EvaluatorDefinition.Target getTarget() {
        return EvaluatorDefinition.Target.FACT;
    }

    @Override
    public boolean supportsType(ValueType type) {
        return this.evaluators.supportsType(type);
    }

    public static ArrayContains getArrayContains(Class cls) {
        ArrayContains eval = primitiveArrayEvaluator.get(cls);
        if (eval == null) {
            eval = objectArrayEvaluator;
        }
        return eval;
    }

    private static boolean contains(Object[] array, Object value) {
        for (int i = 0; i < array.length; ++i) {
            if ((array[i] != null || value != null) && (array[i] == null || !array[i].equals(value))) continue;
            return true;
        }
        return false;
    }

    static {
        objectArrayEvaluator = new ObjectArrayContainsEvaluator();
        primitiveArrayEvaluator = new HashMap(){
            {
                this.put(boolean[].class, new BooleanArrayContainsEvaluator());
                this.put(byte[].class, new ByteArrayContainsEvaluator());
                this.put(short[].class, new ShortArrayContainsEvaluator());
                this.put(char[].class, new CharArrayContainsEvaluator());
                this.put(int[].class, new IntegerArrayContainsEvaluator());
                this.put(long[].class, new LongArrayContainsEvaluator());
                this.put(float[].class, new FloatArrayContainsEvaluator());
                this.put(double[].class, new DoubleArrayContainsEvaluator());
            }
        };
    }

    public static class ObjectArrayContainsEvaluator
    implements ArrayContains {
        @Override
        public boolean contains(Object array, FieldValue fieldValue) {
            return this.contains((Object[])array, fieldValue.getValue());
        }

        @Override
        public boolean contains(Object array, ReteEvaluator reteEvaluator, InternalReadAccessor accessor, Object object) {
            return this.contains((Object[])array, accessor.getValue(reteEvaluator, object));
        }

        private boolean contains(Object[] array, Object value) {
            int length = array.length;
            for (int i = 0; i < length; ++i) {
                if (!array[i].equals(value)) continue;
                return true;
            }
            return false;
        }

        @Override
        public Class getArrayType() {
            return Object[].class;
        }
    }

    public static class DoubleArrayContainsEvaluator
    implements ArrayContains {
        @Override
        public boolean contains(Object array, FieldValue fieldValue) {
            return this.contains((double[])array, fieldValue.getDoubleValue());
        }

        @Override
        public boolean contains(Object array, ReteEvaluator reteEvaluator, InternalReadAccessor accessor, Object object) {
            return this.contains((double[])array, accessor.getDoubleValue(reteEvaluator, object));
        }

        private boolean contains(double[] array, double value) {
            int length = array.length;
            for (int i = 0; i < length; ++i) {
                if (array[i] != value) continue;
                return true;
            }
            return false;
        }

        @Override
        public Class getArrayType() {
            return double[].class;
        }
    }

    public static class FloatArrayContainsEvaluator
    implements ArrayContains {
        @Override
        public boolean contains(Object array, FieldValue value) {
            return this.contains((float[])array, value.getFloatValue());
        }

        @Override
        public boolean contains(Object array, ReteEvaluator reteEvaluator, InternalReadAccessor accessor, Object object) {
            return this.contains((float[])array, accessor.getFloatValue(reteEvaluator, object));
        }

        private boolean contains(float[] array, float value) {
            int length = array.length;
            for (int i = 0; i < length; ++i) {
                if (array[i] != value) continue;
                return true;
            }
            return false;
        }

        @Override
        public Class getArrayType() {
            return float[].class;
        }
    }

    public static class LongArrayContainsEvaluator
    implements ArrayContains {
        @Override
        public boolean contains(Object array, FieldValue value) {
            return this.contains((long[])array, value.getLongValue());
        }

        @Override
        public boolean contains(Object array, ReteEvaluator reteEvaluator, InternalReadAccessor accessor, Object object) {
            return this.contains((long[])array, accessor.getLongValue(reteEvaluator, object));
        }

        private boolean contains(long[] array, long value) {
            int length = array.length;
            for (int i = 0; i < length; ++i) {
                if (array[i] != value) continue;
                return true;
            }
            return false;
        }

        @Override
        public Class getArrayType() {
            return long[].class;
        }
    }

    public static class IntegerArrayContainsEvaluator
    implements ArrayContains {
        @Override
        public boolean contains(Object array, FieldValue value) {
            return this.contains((int[])array, value.getIntValue());
        }

        @Override
        public boolean contains(Object array, ReteEvaluator reteEvaluator, InternalReadAccessor accessor, Object object) {
            return this.contains((int[])array, accessor.getIntValue(reteEvaluator, object));
        }

        private boolean contains(int[] array, int value) {
            int length = array.length;
            for (int i = 0; i < length; ++i) {
                if (array[i] != value) continue;
                return true;
            }
            return false;
        }

        @Override
        public Class getArrayType() {
            return int[].class;
        }
    }

    public static class CharArrayContainsEvaluator
    implements ArrayContains {
        @Override
        public boolean contains(Object array, FieldValue value) {
            return this.contains((char[])array, value.getCharValue());
        }

        @Override
        public boolean contains(Object array, ReteEvaluator reteEvaluator, InternalReadAccessor accessor, Object object) {
            return this.contains((char[])array, accessor.getCharValue(reteEvaluator, object));
        }

        private boolean contains(char[] array, char value) {
            int length = array.length;
            for (int i = 0; i < length; ++i) {
                if (array[i] != value) continue;
                return true;
            }
            return false;
        }

        @Override
        public Class getArrayType() {
            return char[].class;
        }
    }

    public static class ShortArrayContainsEvaluator
    implements ArrayContains {
        @Override
        public boolean contains(Object array, FieldValue value) {
            return this.contains((short[])array, value.getShortValue());
        }

        @Override
        public boolean contains(Object array, ReteEvaluator reteEvaluator, InternalReadAccessor accessor, Object object) {
            return this.contains((short[])array, accessor.getShortValue(reteEvaluator, object));
        }

        private boolean contains(short[] array, short value) {
            int length = array.length;
            for (int i = 0; i < length; ++i) {
                if (array[i] != value) continue;
                return true;
            }
            return false;
        }

        @Override
        public Class getArrayType() {
            return short[].class;
        }
    }

    public static class ByteArrayContainsEvaluator
    implements ArrayContains {
        @Override
        public boolean contains(Object array, FieldValue value) {
            return this.contains((byte[])array, value.getByteValue());
        }

        @Override
        public boolean contains(Object array, ReteEvaluator reteEvaluator, InternalReadAccessor accessor, Object object) {
            return this.contains((byte[])array, accessor.getByteValue(reteEvaluator, object));
        }

        private boolean contains(byte[] array, byte value) {
            int length = array.length;
            for (int i = 0; i < length; ++i) {
                if (array[i] != value) continue;
                return true;
            }
            return false;
        }

        @Override
        public Class getArrayType() {
            return byte[].class;
        }
    }

    public static class BooleanArrayContainsEvaluator
    implements ArrayContains {
        @Override
        public boolean contains(Object array, FieldValue value) {
            boolean[] boolArray = (boolean[])array;
            int length = boolArray.length;
            for (int i = 0; i < length; ++i) {
                if (boolArray[i] != value.getBooleanValue()) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean contains(Object array, ReteEvaluator reteEvaluator, InternalReadAccessor accessor, Object object) {
            boolean[] boolArray = (boolean[])array;
            int length = boolArray.length;
            for (int i = 0; i < length; ++i) {
                if (boolArray[i] != accessor.getBooleanValue(reteEvaluator, object)) continue;
                return true;
            }
            return false;
        }

        private boolean contains(byte[] array, byte value, boolean negate) {
            int length = array.length;
            for (int i = 0; i < length; ++i) {
                if (array[i] != value) continue;
                return true;
            }
            return false;
        }

        @Override
        public Class getArrayType() {
            return boolean[].class;
        }
    }

    public static interface ArrayContains {
        public Class getArrayType();

        public boolean contains(Object var1, FieldValue var2);

        public boolean contains(Object var1, ReteEvaluator var2, InternalReadAccessor var3, Object var4);
    }

    public static class StringNotMemberOfEvaluator
    extends BaseNotMemberOfEvaluator {
        private static final long serialVersionUID = 510L;
        public static final Evaluator INSTANCE = new StringNotMemberOfEvaluator();

        public StringNotMemberOfEvaluator() {
            super(ValueType.STRING_TYPE, NOT_MEMBEROF);
            SetEvaluatorsDefinition.init();
        }

        @Override
        public String toString() {
            return "String not memberOf";
        }
    }

    public static class StringMemberOfEvaluator
    extends BaseMemberOfEvaluator {
        private static final long serialVersionUID = 510L;
        public static final Evaluator INSTANCE = new StringMemberOfEvaluator();

        public StringMemberOfEvaluator() {
            super(ValueType.STRING_TYPE, MEMBEROF);
            SetEvaluatorsDefinition.init();
        }

        @Override
        public String toString() {
            return "String memberOf";
        }
    }

    public static class ShortNotMemberOfEvaluator
    extends BaseNotMemberOfEvaluator {
        private static final long serialVersionUID = 510L;
        public static final Evaluator INSTANCE = new ShortNotMemberOfEvaluator();

        public ShortNotMemberOfEvaluator() {
            super(ValueType.PSHORT_TYPE, NOT_MEMBEROF);
            SetEvaluatorsDefinition.init();
        }

        @Override
        public String toString() {
            return "Short not memberOf";
        }
    }

    public static class ShortMemberOfEvaluator
    extends BaseMemberOfEvaluator {
        private static final long serialVersionUID = 510L;
        public static final Evaluator INSTANCE = new ShortMemberOfEvaluator();

        public ShortMemberOfEvaluator() {
            super(ValueType.PSHORT_TYPE, MEMBEROF);
            SetEvaluatorsDefinition.init();
        }

        @Override
        public String toString() {
            return "Short memberOf";
        }
    }

    public static class ObjectNotMemberOfEvaluator
    extends BaseNotMemberOfEvaluator {
        private static final long serialVersionUID = 510L;
        public static final Evaluator INSTANCE = new ObjectNotMemberOfEvaluator();

        public ObjectNotMemberOfEvaluator() {
            super(ValueType.OBJECT_TYPE, NOT_MEMBEROF);
            SetEvaluatorsDefinition.init();
        }

        @Override
        public String toString() {
            return "Object not memberOf";
        }
    }

    public static class ObjectMemberOfEvaluator
    extends BaseMemberOfEvaluator {
        private static final long serialVersionUID = 510L;
        public static final Evaluator INSTANCE = new ObjectMemberOfEvaluator();

        public ObjectMemberOfEvaluator() {
            super(ValueType.OBJECT_TYPE, MEMBEROF);
            SetEvaluatorsDefinition.init();
        }

        @Override
        public String toString() {
            return "Object memberOf";
        }
    }

    public static class ObjectExcludesEvaluator
    extends BaseEvaluator {
        private static final long serialVersionUID = 510L;
        public static final Evaluator INSTANCE = new ObjectExcludesEvaluator();

        public ObjectExcludesEvaluator() {
            super(ValueType.OBJECT_TYPE, EXCLUDES);
            SetEvaluatorsDefinition.init();
        }

        @Override
        public boolean evaluate(ReteEvaluator reteEvaluator, InternalReadAccessor extractor, InternalFactHandle handle1, FieldValue fieldValue) {
            Object value = fieldValue.getValue();
            Collection col = (Collection)extractor.getValue(reteEvaluator, handle1.getObject());
            return col == null ? true : !col.contains(value);
        }

        @Override
        public boolean evaluateCachedRight(ReteEvaluator reteEvaluator, VariableRestriction.VariableContextEntry context, InternalFactHandle left) {
            Object value = context.declaration.getExtractor().getValue(reteEvaluator, left.getObject());
            Collection col = (Collection)((VariableRestriction.ObjectVariableContextEntry)context).right;
            return col == null ? true : !col.contains(value);
        }

        @Override
        public boolean evaluateCachedLeft(ReteEvaluator reteEvaluator, VariableRestriction.VariableContextEntry context, InternalFactHandle right) {
            Object value = ((VariableRestriction.ObjectVariableContextEntry)context).left;
            Collection col = (Collection)context.extractor.getValue(reteEvaluator, right.getObject());
            return col == null ? true : !col.contains(value);
        }

        @Override
        public boolean evaluate(ReteEvaluator reteEvaluator, InternalReadAccessor extractor1, InternalFactHandle handle1, InternalReadAccessor extractor2, InternalFactHandle handle2) {
            Object value = extractor2.getValue(reteEvaluator, handle2.getObject());
            Collection col = (Collection)extractor1.getValue(reteEvaluator, handle1.getObject());
            return col == null ? true : !col.contains(value);
        }

        @Override
        public String toString() {
            return "Object excludes";
        }
    }

    public static class ObjectContainsEvaluator
    extends BaseEvaluator {
        private static final long serialVersionUID = 510L;
        public static final Evaluator INSTANCE = new ObjectContainsEvaluator();

        public ObjectContainsEvaluator() {
            super(ValueType.OBJECT_TYPE, CONTAINS);
            SetEvaluatorsDefinition.init();
        }

        @Override
        public boolean evaluate(ReteEvaluator reteEvaluator, InternalReadAccessor extractor, InternalFactHandle handle1, FieldValue fieldValue) {
            Object value = fieldValue.getValue();
            Collection col = (Collection)extractor.getValue(reteEvaluator, handle1.getObject());
            return col == null ? false : col.contains(value);
        }

        @Override
        public boolean evaluateCachedRight(ReteEvaluator reteEvaluator, VariableRestriction.VariableContextEntry context, InternalFactHandle left) {
            Object value = context.declaration.getExtractor().getValue(reteEvaluator, left.getObject());
            Collection col = (Collection)((VariableRestriction.ObjectVariableContextEntry)context).right;
            return col == null ? false : col.contains(value);
        }

        @Override
        public boolean evaluateCachedLeft(ReteEvaluator reteEvaluator, VariableRestriction.VariableContextEntry context, InternalFactHandle right) {
            Object value = ((VariableRestriction.ObjectVariableContextEntry)context).left;
            Collection col = (Collection)context.extractor.getValue(reteEvaluator, right.getObject());
            return col == null ? false : col.contains(value);
        }

        @Override
        public boolean evaluate(ReteEvaluator reteEvaluator, InternalReadAccessor extractor1, InternalFactHandle handle1, InternalReadAccessor extractor2, InternalFactHandle handle2) {
            Object value = extractor2.getValue(reteEvaluator, handle2.getObject());
            Collection col = (Collection)extractor1.getValue(reteEvaluator, handle1.getObject());
            return col == null ? false : col.contains(value);
        }

        @Override
        public String toString() {
            return "Object contains";
        }
    }

    public static class LongNotMemberOfEvaluator
    extends BaseNotMemberOfEvaluator {
        private static final long serialVersionUID = 510L;
        public static final Evaluator INSTANCE = new LongNotMemberOfEvaluator();

        public LongNotMemberOfEvaluator() {
            super(ValueType.PLONG_TYPE, NOT_MEMBEROF);
            SetEvaluatorsDefinition.init();
        }

        @Override
        public String toString() {
            return "Long not memberOf";
        }
    }

    public static class LongMemberOfEvaluator
    extends BaseMemberOfEvaluator {
        private static final long serialVersionUID = 510L;
        public static final Evaluator INSTANCE = new LongMemberOfEvaluator();

        public LongMemberOfEvaluator() {
            super(ValueType.PLONG_TYPE, MEMBEROF);
            SetEvaluatorsDefinition.init();
        }

        @Override
        public String toString() {
            return "Long memberOf";
        }
    }

    public static class IntegerNotMemberOfEvaluator
    extends BaseNotMemberOfEvaluator {
        private static final long serialVersionUID = 510L;
        public static final Evaluator INSTANCE = new IntegerNotMemberOfEvaluator();

        public IntegerNotMemberOfEvaluator() {
            super(ValueType.PINTEGER_TYPE, NOT_MEMBEROF);
            SetEvaluatorsDefinition.init();
        }

        @Override
        public String toString() {
            return "Integer not memberOf";
        }
    }

    public static class IntegerMemberOfEvaluator
    extends BaseMemberOfEvaluator {
        private static final long serialVersionUID = 510L;
        public static final Evaluator INSTANCE = new IntegerMemberOfEvaluator();

        public IntegerMemberOfEvaluator() {
            super(ValueType.PINTEGER_TYPE, MEMBEROF);
            SetEvaluatorsDefinition.init();
        }

        @Override
        public String toString() {
            return "Integer memberOf";
        }
    }

    public static class FloatNotMemberOfEvaluator
    extends BaseNotMemberOfEvaluator {
        private static final long serialVersionUID = 510L;
        public static final Evaluator INSTANCE = new FloatNotMemberOfEvaluator();

        public FloatNotMemberOfEvaluator() {
            super(ValueType.PFLOAT_TYPE, NOT_MEMBEROF);
            SetEvaluatorsDefinition.init();
        }

        @Override
        public String toString() {
            return "Float not memberOf";
        }
    }

    public static class FloatMemberOfEvaluator
    extends BaseMemberOfEvaluator {
        private static final long serialVersionUID = 510L;
        public static final Evaluator INSTANCE = new FloatMemberOfEvaluator();

        public FloatMemberOfEvaluator() {
            super(ValueType.PFLOAT_TYPE, MEMBEROF);
            SetEvaluatorsDefinition.init();
        }

        @Override
        public String toString() {
            return "Float memberOf";
        }
    }

    public static class DoubleNotMemberOfEvaluator
    extends BaseNotMemberOfEvaluator {
        private static final long serialVersionUID = 510L;
        public static final Evaluator INSTANCE = new DoubleNotMemberOfEvaluator();

        public DoubleNotMemberOfEvaluator() {
            super(ValueType.PDOUBLE_TYPE, NOT_MEMBEROF);
            SetEvaluatorsDefinition.init();
        }

        @Override
        public String toString() {
            return "Double not memberOf";
        }
    }

    public static class DoubleMemberOfEvaluator
    extends BaseMemberOfEvaluator {
        private static final long serialVersionUID = 510L;
        public static final Evaluator INSTANCE = new DoubleMemberOfEvaluator();

        public DoubleMemberOfEvaluator() {
            super(ValueType.PDOUBLE_TYPE, MEMBEROF);
            SetEvaluatorsDefinition.init();
        }

        @Override
        public String toString() {
            return "Double memberOf";
        }
    }

    public static class DateNotMemberOfEvaluator
    extends BaseNotMemberOfEvaluator {
        private static final long serialVersionUID = 510L;
        public static final Evaluator INSTANCE = new DateNotMemberOfEvaluator();

        public DateNotMemberOfEvaluator() {
            super(ValueType.DATE_TYPE, NOT_MEMBEROF);
            SetEvaluatorsDefinition.init();
        }

        @Override
        public String toString() {
            return "Date not memberOf";
        }
    }

    public static class DateMemberOfEvaluator
    extends BaseMemberOfEvaluator {
        private static final long serialVersionUID = 510L;
        public static final Evaluator INSTANCE = new DateMemberOfEvaluator();

        public DateMemberOfEvaluator() {
            super(ValueType.DATE_TYPE, MEMBEROF);
            SetEvaluatorsDefinition.init();
        }

        @Override
        public String toString() {
            return "Date memberOf";
        }
    }

    public static class CharacterNotMemberOfEvaluator
    extends BaseNotMemberOfEvaluator {
        private static final long serialVersionUID = 510L;
        public static final Evaluator INSTANCE = new CharacterNotMemberOfEvaluator();

        public CharacterNotMemberOfEvaluator() {
            super(ValueType.PCHAR_TYPE, NOT_MEMBEROF);
            SetEvaluatorsDefinition.init();
        }

        @Override
        public String toString() {
            return "Character not memberOf";
        }
    }

    public static class CharacterMemberOfEvaluator
    extends BaseMemberOfEvaluator {
        private static final long serialVersionUID = 510L;
        public static final Evaluator INSTANCE = new CharacterMemberOfEvaluator();

        public CharacterMemberOfEvaluator() {
            super(ValueType.PCHAR_TYPE, MEMBEROF);
            SetEvaluatorsDefinition.init();
        }

        @Override
        public String toString() {
            return "Character memberOf";
        }
    }

    public static class ByteNotMemberOfEvaluator
    extends BaseNotMemberOfEvaluator {
        private static final long serialVersionUID = 510L;
        public static final Evaluator INSTANCE = new ByteNotMemberOfEvaluator();

        public ByteNotMemberOfEvaluator() {
            super(ValueType.PBYTE_TYPE, NOT_MEMBEROF);
            SetEvaluatorsDefinition.init();
        }

        @Override
        public String toString() {
            return "Byte not memberOf";
        }
    }

    public static class ByteMemberOfEvaluator
    extends BaseMemberOfEvaluator {
        private static final long serialVersionUID = 510L;
        public static final Evaluator INSTANCE = new ByteMemberOfEvaluator();

        public ByteMemberOfEvaluator() {
            super(ValueType.PBYTE_TYPE, MEMBEROF);
            SetEvaluatorsDefinition.init();
        }

        @Override
        public String toString() {
            return "Byte memberOf";
        }
    }

    public static class BooleanNotMemberOfEvaluator
    extends BaseNotMemberOfEvaluator {
        private static final long serialVersionUID = 510L;
        public static final Evaluator INSTANCE = new BooleanNotMemberOfEvaluator();

        public BooleanNotMemberOfEvaluator() {
            super(ValueType.PBOOLEAN_TYPE, NOT_MEMBEROF);
            SetEvaluatorsDefinition.init();
        }

        @Override
        public String toString() {
            return "Boolean not memberOf";
        }
    }

    public static class BooleanMemberOfEvaluator
    extends BaseMemberOfEvaluator {
        private static final long serialVersionUID = 510L;
        public static final Evaluator INSTANCE = new BooleanMemberOfEvaluator();

        public BooleanMemberOfEvaluator() {
            super(ValueType.PBOOLEAN_TYPE, MEMBEROF);
            SetEvaluatorsDefinition.init();
        }

        @Override
        public String toString() {
            return "Boolean memberOf";
        }
    }

    public static class BigIntegerNotMemberOfEvaluator
    extends BaseNotMemberOfEvaluator {
        private static final long serialVersionUID = 510L;
        public static final Evaluator INSTANCE = new BigIntegerNotMemberOfEvaluator();

        public BigIntegerNotMemberOfEvaluator() {
            super(ValueType.BIG_INTEGER_TYPE, NOT_MEMBEROF);
            SetEvaluatorsDefinition.init();
        }

        @Override
        public String toString() {
            return "BigInteger not memberOf";
        }
    }

    public static class BigIntegerMemberOfEvaluator
    extends BaseMemberOfEvaluator {
        private static final long serialVersionUID = 510L;
        public static final Evaluator INSTANCE = new BigIntegerMemberOfEvaluator();

        public BigIntegerMemberOfEvaluator() {
            super(ValueType.BIG_INTEGER_TYPE, MEMBEROF);
            SetEvaluatorsDefinition.init();
        }

        @Override
        public String toString() {
            return "BigInteger memberOf";
        }
    }

    public static class BigDecimalNotMemberOfEvaluator
    extends BaseNotMemberOfEvaluator {
        private static final long serialVersionUID = 510L;
        public static final Evaluator INSTANCE = new BigDecimalNotMemberOfEvaluator();

        public BigDecimalNotMemberOfEvaluator() {
            super(ValueType.BIG_DECIMAL_TYPE, NOT_MEMBEROF);
            SetEvaluatorsDefinition.init();
        }

        @Override
        public String toString() {
            return "BigDecimal not memberOf";
        }
    }

    public static class BigDecimalMemberOfEvaluator
    extends BaseMemberOfEvaluator {
        private static final long serialVersionUID = 510L;
        public static final Evaluator INSTANCE = new BigDecimalMemberOfEvaluator();

        public BigDecimalMemberOfEvaluator() {
            super(ValueType.BIG_DECIMAL_TYPE, MEMBEROF);
            SetEvaluatorsDefinition.init();
        }

        @Override
        public String toString() {
            return "BigDecimal memberOf";
        }
    }

    public static abstract class BaseNotMemberOfEvaluator
    extends BaseEvaluator {
        private static final long serialVersionUID = 510L;

        public BaseNotMemberOfEvaluator(ValueType type, Operator operator) {
            super(type, operator);
        }

        public BaseNotMemberOfEvaluator() {
        }

        @Override
        public ValueType getCoercedValueType() {
            return ValueType.OBJECT_TYPE;
        }

        @Override
        public boolean evaluate(ReteEvaluator reteEvaluator, InternalReadAccessor extractor, InternalFactHandle handle1, FieldValue fieldValue) {
            if (fieldValue.isNull()) {
                return false;
            }
            if (fieldValue.isCollectionField()) {
                Object value;
                Collection col = (Collection)fieldValue.getValue();
                return !col.contains(value = extractor.getValue(reteEvaluator, handle1.getObject()));
            }
            if (fieldValue.getValue().getClass().isArray()) {
                return !SetEvaluatorsDefinition.getArrayContains(fieldValue.getValue().getClass()).contains(fieldValue.getValue(), reteEvaluator, extractor, handle1.getObject());
            }
            throw new ClassCastException("Can't check if an attribute is not member of an object of class " + fieldValue.getValue().getClass());
        }

        @Override
        public boolean evaluateCachedRight(ReteEvaluator reteEvaluator, VariableRestriction.VariableContextEntry context, InternalFactHandle left) {
            Object object = context.declaration.getExtractor().getValue(reteEvaluator, left.getObject());
            if (object == null) {
                return false;
            }
            if (object instanceof Collection) {
                Collection col = (Collection)object;
                Object value = ((VariableRestriction.ObjectVariableContextEntry)context).right;
                return !col.contains(value);
            }
            if (object.getClass().isArray()) {
                return !SetEvaluatorsDefinition.getArrayContains(object.getClass()).contains(object, reteEvaluator, context.extractor, context.object);
            }
            throw new ClassCastException("Can't check if an attribute is not member of an object of class " + object.getClass());
        }

        @Override
        public boolean evaluateCachedLeft(ReteEvaluator reteEvaluator, VariableRestriction.VariableContextEntry context, InternalFactHandle right) {
            Object object = ((VariableRestriction.ObjectVariableContextEntry)context).left;
            if (object == null) {
                return false;
            }
            if (object instanceof Collection) {
                Collection col = (Collection)object;
                Object value = context.extractor.getValue(reteEvaluator, right.getObject());
                return !col.contains(value);
            }
            if (object.getClass().isArray()) {
                return !SetEvaluatorsDefinition.getArrayContains(object.getClass()).contains(object, reteEvaluator, context.extractor, right.getObject());
            }
            throw new ClassCastException("Can't check if an attribute is not member of an object of class " + object.getClass());
        }

        @Override
        public boolean evaluate(ReteEvaluator reteEvaluator, InternalReadAccessor extractor1, InternalFactHandle handle1, InternalReadAccessor extractor2, InternalFactHandle handle2) {
            Object object = extractor2.getValue(reteEvaluator, handle2.getObject());
            if (object == null) {
                return false;
            }
            if (object instanceof Collection) {
                Collection col = (Collection)object;
                Object value = extractor1.getValue(reteEvaluator, handle1.getObject());
                return !col.contains(value);
            }
            if (object.getClass().isArray()) {
                return !SetEvaluatorsDefinition.getArrayContains(object.getClass()).contains(object, reteEvaluator, extractor1, handle1.getObject());
            }
            throw new ClassCastException("Can't check if an attribute is not member of an object of class " + object.getClass());
        }

        @Override
        public abstract String toString();
    }

    public static abstract class BaseMemberOfEvaluator
    extends BaseEvaluator {
        private static final long serialVersionUID = 510L;

        public BaseMemberOfEvaluator() {
            super(null, null);
        }

        public BaseMemberOfEvaluator(ValueType type, Operator operator) {
            super(type, operator);
        }

        @Override
        public ValueType getCoercedValueType() {
            return ValueType.OBJECT_TYPE;
        }

        @Override
        public boolean evaluate(ReteEvaluator reteEvaluator, InternalReadAccessor extractor, InternalFactHandle handle1, FieldValue fieldValue) {
            if (fieldValue.isNull()) {
                return false;
            }
            if (fieldValue.isCollectionField()) {
                Collection col = (Collection)fieldValue.getValue();
                Object value = extractor.getValue(reteEvaluator, handle1.getObject());
                return col.contains(value);
            }
            if (fieldValue.getValue().getClass().isArray()) {
                return SetEvaluatorsDefinition.getArrayContains(fieldValue.getValue().getClass()).contains(fieldValue.getValue(), reteEvaluator, extractor, handle1.getObject());
            }
            throw new ClassCastException("Can't check if an attribute is member of an object of class " + fieldValue.getValue().getClass());
        }

        @Override
        public boolean evaluateCachedRight(ReteEvaluator reteEvaluator, VariableRestriction.VariableContextEntry context, InternalFactHandle left) {
            Object object = context.declaration.getExtractor().getValue(reteEvaluator, left.getObject());
            if (object == null) {
                return false;
            }
            if (object instanceof Collection) {
                Collection col = (Collection)object;
                Object value = ((VariableRestriction.ObjectVariableContextEntry)context).right;
                return col.contains(value);
            }
            if (object.getClass().isArray()) {
                return SetEvaluatorsDefinition.getArrayContains(object.getClass()).contains(object, reteEvaluator, context.extractor, context.object);
            }
            throw new ClassCastException("Can't check if an attribute is member of an object of class " + object.getClass());
        }

        @Override
        public boolean evaluateCachedLeft(ReteEvaluator reteEvaluator, VariableRestriction.VariableContextEntry context, InternalFactHandle right) {
            Object object = ((VariableRestriction.ObjectVariableContextEntry)context).left;
            if (object == null) {
                return false;
            }
            if (object instanceof Collection) {
                Collection col = (Collection)object;
                Object value = context.extractor.getValue(reteEvaluator, right.getObject());
                return col.contains(value);
            }
            if (object.getClass().isArray()) {
                return SetEvaluatorsDefinition.getArrayContains(object.getClass()).contains(object, reteEvaluator, context.extractor, right.getObject());
            }
            throw new ClassCastException("Can't check if an attribute is member of an object of class " + object.getClass());
        }

        @Override
        public boolean evaluate(ReteEvaluator reteEvaluator, InternalReadAccessor extractor1, InternalFactHandle handle1, InternalReadAccessor extractor2, InternalFactHandle handle2) {
            Object object = extractor2.getValue(reteEvaluator, handle2.getObject());
            if (object == null) {
                return false;
            }
            if (object instanceof Collection) {
                Collection col = (Collection)object;
                Object value = extractor1.getValue(reteEvaluator, handle1.getObject());
                return col.contains(value);
            }
            if (object.getClass().isArray()) {
                return SetEvaluatorsDefinition.getArrayContains(object.getClass()).contains(object, reteEvaluator, extractor1, handle1.getObject());
            }
            throw new ClassCastException("Can't check if an attribute is member of an object of class " + object.getClass());
        }

        @Override
        public abstract String toString();
    }

    public static class ArrayExcludesEvaluator
    extends BaseEvaluator {
        private static final long serialVersionUID = 510L;
        public static final Evaluator INSTANCE = new ArrayExcludesEvaluator();

        public ArrayExcludesEvaluator() {
            super(ValueType.ARRAY_TYPE, EXCLUDES);
            SetEvaluatorsDefinition.init();
        }

        @Override
        public boolean evaluate(ReteEvaluator reteEvaluator, InternalReadAccessor extractor, InternalFactHandle handle1, FieldValue fieldValue) {
            Object array = extractor.getValue(reteEvaluator, handle1.getObject());
            if (array == null) {
                return false;
            }
            return !SetEvaluatorsDefinition.getArrayContains(array.getClass()).contains(array, fieldValue);
        }

        @Override
        public boolean evaluateCachedRight(ReteEvaluator reteEvaluator, VariableRestriction.VariableContextEntry context, InternalFactHandle left) {
            Object array = ((VariableRestriction.ObjectVariableContextEntry)context).right;
            if (array == null) {
                return false;
            }
            return !SetEvaluatorsDefinition.getArrayContains(array.getClass()).contains(array, reteEvaluator, context.declaration.getExtractor(), left.getObject());
        }

        @Override
        public boolean evaluateCachedLeft(ReteEvaluator reteEvaluator, VariableRestriction.VariableContextEntry context, InternalFactHandle right) {
            Object array = context.extractor.getValue(reteEvaluator, right.getObject());
            if (array == null) {
                return false;
            }
            return !SetEvaluatorsDefinition.getArrayContains(array.getClass()).contains(array, reteEvaluator, context.declaration.getExtractor(), context.getTuple().getObject(context.getVariableDeclaration()));
        }

        @Override
        public boolean evaluate(ReteEvaluator reteEvaluator, InternalReadAccessor extractor1, InternalFactHandle handle1, InternalReadAccessor extractor2, InternalFactHandle handle2) {
            Object array = extractor1.getValue(reteEvaluator, handle1.getObject());
            if (array == null) {
                return false;
            }
            return !SetEvaluatorsDefinition.getArrayContains(array.getClass()).contains(array, reteEvaluator, extractor2, handle2.getObject());
        }

        @Override
        public String toString() {
            return "Array not contains";
        }
    }

    public static class ArrayContainsEvaluator
    extends BaseEvaluator {
        private static final long serialVersionUID = 510L;
        public static final Evaluator INSTANCE = new ArrayContainsEvaluator();

        public ArrayContainsEvaluator() {
            super(ValueType.ARRAY_TYPE, CONTAINS);
            SetEvaluatorsDefinition.init();
        }

        @Override
        public boolean evaluate(ReteEvaluator reteEvaluator, InternalReadAccessor extractor, InternalFactHandle handle1, FieldValue fieldValue) {
            Object array = extractor.getValue(reteEvaluator, handle1.getObject());
            if (array == null) {
                return false;
            }
            return SetEvaluatorsDefinition.getArrayContains(array.getClass()).contains(array, fieldValue);
        }

        @Override
        public boolean evaluateCachedRight(ReteEvaluator reteEvaluator, VariableRestriction.VariableContextEntry context, InternalFactHandle left) {
            Object array = ((VariableRestriction.ObjectVariableContextEntry)context).right;
            if (array == null) {
                return false;
            }
            return SetEvaluatorsDefinition.getArrayContains(array.getClass()).contains(array, reteEvaluator, context.declaration.getExtractor(), left.getObject());
        }

        @Override
        public boolean evaluateCachedLeft(ReteEvaluator reteEvaluator, VariableRestriction.VariableContextEntry context, InternalFactHandle right) {
            Object array = context.extractor.getValue(reteEvaluator, right.getObject());
            if (array == null) {
                return false;
            }
            return SetEvaluatorsDefinition.getArrayContains(array.getClass()).contains(array, reteEvaluator, context.declaration.getExtractor(), context.tuple.getObject(context.declaration));
        }

        @Override
        public boolean evaluate(ReteEvaluator reteEvaluator, InternalReadAccessor extractor1, InternalFactHandle handle1, InternalReadAccessor extractor2, InternalFactHandle handle2) {
            Object array = extractor1.getValue(reteEvaluator, handle1.getObject());
            if (array == null) {
                return false;
            }
            return SetEvaluatorsDefinition.getArrayContains(array.getClass()).contains(array, reteEvaluator, extractor2, handle2.getObject());
        }

        @Override
        public String toString() {
            return "Array contains";
        }
    }
}

