/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Externalizable;
import java.io.File;
import java.io.IOException;
import java.lang.constant.Constable;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.security.AccessController;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.stream.Stream;
import org.drools.core.common.DroolsObjectInputStream;
import org.drools.core.common.DroolsObjectOutputStream;
import org.drools.core.util.MethodUtils;
import org.drools.core.util.StringUtils;
import org.kie.api.definition.type.Modifies;
import org.kie.internal.utils.ClassLoaderUtil;

public final class ClassUtils {
    private static final ProtectionDomain PROTECTION_DOMAIN;
    public static final boolean IS_ANDROID;
    private static final Map<String, Class<?>> classes;
    private static final Map<String, Constructor<?>> constructors;
    private static final String STAR = "*";
    private static final Map<String, String> abbreviationMap;
    private static final Map<String, Class<?>> primitiveNameToType;

    public static boolean areNullSafeEquals(Object obj1, Object obj2) {
        return obj1 == null ? obj2 == null : obj1.equals(obj2);
    }

    public static String convertResourceToClassName(String pResourceName) {
        return ClassUtils.stripExtension(pResourceName).replace('/', '.');
    }

    public static String convertClassToResourcePath(Class cls) {
        return ClassUtils.convertClassToResourcePath(cls.getName());
    }

    public static String convertClassToResourcePath(String pName) {
        return pName.replace('.', '/') + ".class";
    }

    public static String stripExtension(String pResourceName) {
        int i = pResourceName.lastIndexOf(46);
        return pResourceName.substring(0, i);
    }

    public static String toJavaCasing(String pName) {
        char[] name = pName.toLowerCase().toCharArray();
        name[0] = Character.toUpperCase(name[0]);
        return new String(name);
    }

    public static String clazzName(File base, File file) {
        int rootLength = base.getAbsolutePath().length();
        String absFileName = file.getAbsolutePath();
        int p = absFileName.lastIndexOf(46);
        String relFileName = absFileName.substring(rootLength + 1, p);
        return relFileName.replace(File.separatorChar, '.');
    }

    public static String relative(File base, File file) {
        int rootLength = base.getAbsolutePath().length();
        String absFileName = file.getAbsolutePath();
        return absFileName.substring(rootLength + 1);
    }

    public static String canonicalName(Class clazz) {
        StringBuilder name = new StringBuilder();
        if (clazz.isArray()) {
            name.append(ClassUtils.canonicalName(clazz.getComponentType()));
            name.append("[]");
        } else if (clazz.getDeclaringClass() == null) {
            name.append(clazz.getName());
        } else {
            name.append(ClassUtils.canonicalName(clazz.getDeclaringClass()));
            name.append(".");
            name.append(clazz.getName().substring(clazz.getDeclaringClass().getName().length() + 1));
        }
        return name.toString();
    }

    public static Class<?> loadClass(String className, ClassLoader classLoader) {
        Class<?> cls = classes.get(className);
        if (cls == null) {
            try {
                cls = Class.forName(className);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (cls == null && classLoader != null) {
                try {
                    cls = classLoader.loadClass(className);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (cls == null) {
                try {
                    cls = ClassUtils.class.getClassLoader().loadClass(className);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (cls == null) {
                try {
                    cls = Thread.currentThread().getContextClassLoader().loadClass(className);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (cls == null) {
                try {
                    cls = ClassLoader.getSystemClassLoader().loadClass(className);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (cls != null) {
                classes.put(className, cls);
            } else {
                throw new RuntimeException("Unable to load class '" + className + "'");
            }
        }
        return cls;
    }

    public static Object instantiateObject(String className) {
        return ClassUtils.instantiateObject(className, null);
    }

    public static Object instantiateObject(String className, ClassLoader classLoader) {
        Object object;
        try {
            object = ClassUtils.loadClass(className, classLoader).newInstance();
        }
        catch (Throwable e) {
            throw new RuntimeException("Unable to instantiate object for class '" + className + "'", e);
        }
        return object;
    }

    public static Object instantiateObject(String className, ClassLoader classLoader, Object ... args) {
        Object object;
        Constructor c = constructors.computeIfAbsent(className, n -> ClassUtils.loadClass(n, classLoader).getConstructors()[0]);
        try {
            object = c.newInstance(args);
        }
        catch (Throwable e) {
            throw new RuntimeException("Unable to instantiate object for class '" + className + "' with constructor " + c, e);
        }
        return object;
    }

    public static Object instantiateObject(String className, Object ... args) {
        return ClassUtils.instantiateObject(className, null, args);
    }

    public static void addImportStylePatterns(Map<String, Object> patterns, String str) {
        String[] items;
        if (str == null || "".equals(str.trim())) {
            return;
        }
        for (String item : items = str.split(" ")) {
            ArrayList<String> list;
            String qualifiedNamespace = item.substring(0, item.lastIndexOf(46)).trim();
            String name = item.substring(item.lastIndexOf(46) + 1).trim();
            Object object = patterns.get(qualifiedNamespace);
            if (object == null) {
                if (STAR.equals(name)) {
                    patterns.put(qualifiedNamespace, STAR);
                    continue;
                }
                list = new ArrayList<String>();
                list.add(name);
                patterns.put(qualifiedNamespace, list);
                continue;
            }
            if (name.equals(STAR)) {
                patterns.put(qualifiedNamespace, STAR);
                continue;
            }
            list = (ArrayList<String>)object;
            if (list.contains(name)) continue;
            list.add(name);
        }
    }

    public static boolean isMatched(Map<String, Object> patterns, String className) {
        String qualifiedNamespace = className;
        String name = className;
        if (className.indexOf(46) > 0) {
            qualifiedNamespace = className.substring(0, className.lastIndexOf(46)).trim();
            name = className.substring(className.lastIndexOf(46) + 1).trim();
        } else if (className.indexOf(91) == 0) {
            qualifiedNamespace = className.substring(0, className.lastIndexOf(91));
        }
        Object object = patterns.get(qualifiedNamespace);
        if (object == null) {
            return true;
        }
        if (STAR.equals(object)) {
            return false;
        }
        if (patterns.containsKey(STAR)) {
            return true;
        }
        List list = (List)object;
        return !list.contains(name);
    }

    public static String getPackage(Class<?> cls) {
        Package pkg;
        Package package_ = pkg = cls.isArray() ? cls.getComponentType().getPackage() : cls.getPackage();
        if (pkg == null) {
            int dolPos = cls.getName().indexOf(36);
            int dotPos = dolPos > 0 ? cls.getName().substring(0, dolPos).lastIndexOf(46) : cls.getName().lastIndexOf(46);
            if (dotPos > 0) {
                return cls.getName().substring(0, dotPos);
            }
            return "";
        }
        return pkg.getName();
    }

    public static Class<?> findClass(String name, Collection<String> availableImports, ClassLoader cl) {
        Class<?> clazz = null;
        for (String imp : availableImports) {
            String className;
            if (imp.endsWith(".*")) {
                imp = imp.substring(0, imp.length() - 2);
            }
            if ((clazz = ClassUtils.findClass(className = imp.endsWith(name) ? imp : imp + "." + name, cl)) == null) continue;
            break;
        }
        return clazz;
    }

    public static Class<?> findClass(String className, ClassLoader cl) {
        try {
            return Class.forName(className, false, cl);
        }
        catch (ClassNotFoundException e) {
            int lastDot = className.lastIndexOf(46);
            className = className.substring(0, lastDot) + "$" + className.substring(lastDot + 1);
            try {
                return Class.forName(className, false, cl);
            }
            catch (ClassNotFoundException classNotFoundException) {
                return null;
            }
        }
    }

    public static List<String> getAccessibleProperties(Class<?> clazz) {
        TreeSet<PropertyInClass> props = new TreeSet<PropertyInClass>();
        for (Method method : clazz.getMethods()) {
            String propName;
            if (method.getParameterTypes().length == 0 && (propName = ClassUtils.getter2property(method.getName())) != null && !propName.equals("class")) {
                props.add(new PropertyInClass(propName, method.getDeclaringClass()));
            }
            ClassUtils.processModifiesAnnotation(clazz, props, method);
        }
        for (AccessibleObject accessibleObject : clazz.getFields()) {
            if (!Modifier.isPublic(((Field)accessibleObject).getModifiers()) || Modifier.isStatic(((Field)accessibleObject).getModifiers())) continue;
            props.add(new PropertyInClass(((Field)accessibleObject).getName(), ((Field)accessibleObject).getDeclaringClass()));
        }
        ArrayList<String> accessibleProperties = new ArrayList<String>();
        for (PropertyInClass setter : props) {
            accessibleProperties.add(setter.setter);
        }
        return accessibleProperties;
    }

    public static Field getField(Class<?> clazz, String field) {
        try {
            return clazz.getDeclaredField(field);
        }
        catch (NoSuchFieldException e) {
            return clazz.getSuperclass() != null ? ClassUtils.getField(clazz.getSuperclass(), field) : null;
        }
    }

    public static Method getAccessor(Class<?> clazz, String field) {
        return Stream.of(() -> "get" + StringUtils.ucFirst(field), () -> field, () -> "is" + StringUtils.ucFirst(field), () -> "get" + field, () -> "is" + field).map(f -> MethodUtils.getMethod(clazz, (String)f.get(), new Class[0])).filter(Optional::isPresent).findFirst().flatMap(Function.identity()).orElse(null);
    }

    public static Method getSetter(Class<?> clazz, String field, Class<?> parameterType) {
        return Stream.of(() -> "set" + StringUtils.ucFirst(field), () -> field, () -> "set" + field).map(f -> MethodUtils.getMethod(clazz, (String)f.get(), parameterType)).filter(Optional::isPresent).findFirst().flatMap(Function.identity()).orElse(parameterType.isPrimitive() ? ClassUtils.getSetter(clazz, field, ClassUtils.convertFromPrimitiveType(parameterType)) : null);
    }

    public static Member getFieldOrAccessor(Class clazz, String property) {
        for (Field f : clazz.getFields()) {
            if (!property.equals(f.getName())) continue;
            if ((f.getModifiers() & 1) == 0) break;
            return f;
        }
        return ClassUtils.getGetter(clazz, property);
    }

    public static Method getGetter(Class clazz, String property) {
        String simple = "get" + property;
        String simpleIsGet = "is" + property;
        String isGet = ClassUtils.getIsGetter(property);
        String getter = ClassUtils.getGetter(property);
        Method candidate = null;
        if (Collection.class.isAssignableFrom(clazz) && "isEmpty".equals(isGet)) {
            try {
                return Collection.class.getMethod("isEmpty", new Class[0]);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        for (Method meth : clazz.getMethods()) {
            if ((meth.getModifiers() & 1) == 0 || (meth.getModifiers() & 8) != 0 || meth.getParameterTypes().length != 0 || !getter.equals(meth.getName()) && !property.equals(meth.getName()) && (!isGet.equals(meth.getName()) && !simpleIsGet.equals(meth.getName()) || meth.getReturnType() != Boolean.TYPE) && !simple.equals(meth.getName()) || candidate != null && !candidate.getReturnType().isAssignableFrom(meth.getReturnType())) continue;
            candidate = meth;
        }
        return candidate;
    }

    public static String getGetter(String s) {
        char[] c = s.toCharArray();
        char[] chars = new char[c.length + 3];
        chars[0] = 103;
        chars[1] = 101;
        chars[2] = 116;
        chars[3] = Character.toUpperCase(c[0]);
        System.arraycopy(c, 1, chars, 4, c.length - 1);
        return new String(chars);
    }

    private static String getIsGetter(String s) {
        char[] c = s.toCharArray();
        char[] chars = new char[c.length + 2];
        chars[0] = 105;
        chars[1] = 115;
        chars[2] = Character.toUpperCase(c[0]);
        System.arraycopy(c, 1, chars, 3, c.length - 1);
        return new String(chars);
    }

    public static Class extractGenericType(Class<?> clazz, String methodName) {
        ParameterizedType type;
        Type[] typeArguments;
        Method method = ClassUtils.getAccessor(clazz, methodName);
        if (method == null) {
            throw new RuntimeException(String.format("Unknown accessor %s on %s", methodName, clazz));
        }
        Type returnType = method.getGenericReturnType();
        if (returnType instanceof ParameterizedType && (typeArguments = (type = (ParameterizedType)returnType).getActualTypeArguments()).length > 0) {
            return typeArguments[0] instanceof ParameterizedType ? (Class)((ParameterizedType)typeArguments[0]).getRawType() : (Class)typeArguments[0];
        }
        throw new RuntimeException("No generic type");
    }

    private static void processModifiesAnnotation(Class<?> clazz, Set<PropertyInClass> props, Method m) {
        Modifies modifies = m.getAnnotation(Modifies.class);
        if (modifies != null) {
            for (String prop : modifies.value()) {
                prop = prop.trim();
                try {
                    Field field = clazz.getField(prop);
                    props.add(new PropertyInClass(field.getName(), field.getDeclaringClass()));
                }
                catch (NoSuchFieldException e) {
                    String getter = "get" + prop.substring(0, 1).toUpperCase() + prop.substring(1);
                    try {
                        Method method = clazz.getMethod(getter, new Class[0]);
                        props.add(new PropertyInClass(prop, method.getDeclaringClass()));
                    }
                    catch (NoSuchMethodException e1) {
                        getter = "is" + prop.substring(0, 1).toUpperCase() + prop.substring(1);
                        try {
                            Method method = clazz.getMethod(getter, new Class[0]);
                            props.add(new PropertyInClass(prop, method.getDeclaringClass()));
                        }
                        catch (NoSuchMethodException e2) {
                            throw new RuntimeException(e2);
                        }
                    }
                }
            }
        }
    }

    public static boolean isTypeCompatibleWithArgumentType(Class<?> actual, Class<?> formal) {
        if (actual.isPrimitive() && formal.isPrimitive()) {
            return ClassUtils.isConvertible(actual, formal);
        }
        if (actual.isPrimitive()) {
            return ClassUtils.isConvertible(actual, ClassUtils.convertToPrimitiveType(formal));
        }
        if (formal.isPrimitive()) {
            return ClassUtils.isConvertible(ClassUtils.convertToPrimitiveType(actual), formal);
        }
        return formal.isAssignableFrom(actual);
    }

    public static boolean isAssignable(Class<?> type, Object obj) {
        return type.isInstance(obj) || type.isPrimitive() && ClassUtils.convertFromPrimitiveType(type).isInstance(obj);
    }

    public static boolean isConvertible(Class<?> srcPrimitive, Class<?> tgtPrimitive) {
        if (Boolean.TYPE.equals(srcPrimitive)) {
            return Boolean.TYPE.equals(tgtPrimitive);
        }
        if (Byte.TYPE.equals(srcPrimitive)) {
            return Byte.TYPE.equals(tgtPrimitive) || Short.TYPE.equals(tgtPrimitive) || Integer.TYPE.equals(tgtPrimitive) || Long.TYPE.equals(tgtPrimitive) || Float.TYPE.equals(tgtPrimitive) || Double.TYPE.equals(tgtPrimitive);
        }
        if (Character.TYPE.equals(srcPrimitive)) {
            return Character.TYPE.equals(tgtPrimitive) || Integer.TYPE.equals(tgtPrimitive) || Long.TYPE.equals(tgtPrimitive) || Float.TYPE.equals(tgtPrimitive) || Double.TYPE.equals(tgtPrimitive);
        }
        if (Double.TYPE.equals(srcPrimitive)) {
            return Double.TYPE.equals(tgtPrimitive);
        }
        if (Float.TYPE.equals(srcPrimitive)) {
            return Float.TYPE.equals(tgtPrimitive) || Double.TYPE.equals(tgtPrimitive);
        }
        if (Integer.TYPE.equals(srcPrimitive)) {
            return Integer.TYPE.equals(tgtPrimitive) || Long.TYPE.equals(tgtPrimitive) || Float.TYPE.equals(tgtPrimitive) || Double.TYPE.equals(tgtPrimitive);
        }
        if (Long.TYPE.equals(srcPrimitive)) {
            return Long.TYPE.equals(tgtPrimitive) || Float.TYPE.equals(tgtPrimitive) || Double.TYPE.equals(tgtPrimitive);
        }
        if (Short.TYPE.equals(srcPrimitive)) {
            return Short.TYPE.equals(tgtPrimitive) || Integer.TYPE.equals(tgtPrimitive) || Long.TYPE.equals(tgtPrimitive) || Float.TYPE.equals(tgtPrimitive) || Double.TYPE.equals(tgtPrimitive);
        }
        return false;
    }

    public static boolean isFinal(Class<?> clazz) {
        return Modifier.isFinal(clazz.getModifiers());
    }

    public static boolean isInterface(Class<?> clazz) {
        return Modifier.isInterface(clazz.getModifiers());
    }

    public static String getter2property(String methodName) {
        if (methodName.startsWith("get") && methodName.length() > 3) {
            if (methodName.length() > 4 && Character.isUpperCase(methodName.charAt(4))) {
                return methodName.substring(3);
            }
            return Character.toLowerCase(methodName.charAt(3)) + methodName.substring(4);
        }
        if (methodName.startsWith("is") && methodName.length() > 2) {
            if (methodName.length() > 3 && Character.isUpperCase(methodName.charAt(3))) {
                return methodName.substring(2);
            }
            return Character.toLowerCase(methodName.charAt(2)) + methodName.substring(3);
        }
        return null;
    }

    public static String setter2property(String methodName) {
        if (!methodName.startsWith("set") || methodName.length() < 4) {
            return null;
        }
        if (methodName.length() > 4 && Character.isUpperCase(methodName.charAt(4))) {
            return methodName.substring(3);
        }
        return Character.toLowerCase(methodName.charAt(3)) + methodName.substring(4);
    }

    public static boolean isGetter(String methodName) {
        return methodName.startsWith("get") && methodName.length() > 3 || methodName.startsWith("is") && methodName.length() > 2;
    }

    public static boolean isSetter(String methodName) {
        return methodName.startsWith("set") && methodName.length() > 3;
    }

    public static <T extends Externalizable> T deepClone(T origin) {
        return origin == null ? null : (T)ClassUtils.deepClone(origin, origin.getClass().getClassLoader());
    }

    public static <T extends Externalizable> T deepClone(T origin, ClassLoader classLoader) {
        return ClassUtils.deepClone(origin, classLoader, Collections.emptyMap());
    }

    public static <T extends Externalizable> T deepClone(T origin, ClassLoader classLoader, Map<String, Object> cloningResources) {
        if (origin == null) {
            return null;
        }
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DroolsObjectOutputStream oos = new DroolsObjectOutputStream(baos, true);
            if (cloningResources != null) {
                cloningResources.forEach((k, v) -> oos.addCustomExtensions((String)k, v));
            }
            oos.writeObject(origin);
            ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
            DroolsObjectInputStream ois = new DroolsObjectInputStream(bais, classLoader, oos.getClonedByIdentity());
            if (cloningResources != null) {
                cloningResources.forEach((k, v) -> ois.addCustomExtensions((String)k, v));
            }
            Object deepCopy = ois.readObject();
            return (T)((Externalizable)deepCopy);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        catch (ClassNotFoundException cnfe) {
            throw new RuntimeException(cnfe);
        }
    }

    public static Class<?> convertFromPrimitiveType(Class<?> type) {
        if (!type.isPrimitive()) {
            return type;
        }
        if (type == Integer.TYPE) {
            return Integer.class;
        }
        if (type == Long.TYPE) {
            return Long.class;
        }
        if (type == Float.TYPE) {
            return Float.class;
        }
        if (type == Double.TYPE) {
            return Double.class;
        }
        if (type == Short.TYPE) {
            return Short.class;
        }
        if (type == Byte.TYPE) {
            return Byte.class;
        }
        if (type == Character.TYPE) {
            return Character.class;
        }
        if (type == Boolean.TYPE) {
            return Boolean.class;
        }
        throw new RuntimeException("Class not convertible from primitive: " + type.getName());
    }

    public static Class<?> convertToPrimitiveType(Class<?> type) {
        if (type.isPrimitive()) {
            return type;
        }
        if (type == Integer.class) {
            return Integer.TYPE;
        }
        if (type == Long.class) {
            return Long.TYPE;
        }
        if (type == Float.class) {
            return Float.TYPE;
        }
        if (type == Double.class) {
            return Double.TYPE;
        }
        if (type == Short.class) {
            return Short.TYPE;
        }
        if (type == Byte.class) {
            return Byte.TYPE;
        }
        if (type == Character.class) {
            return Character.TYPE;
        }
        if (type == Boolean.class) {
            return Boolean.TYPE;
        }
        if (type == BigInteger.class) {
            return Long.TYPE;
        }
        if (type == BigDecimal.class) {
            return Double.TYPE;
        }
        if (type == Number.class) {
            return Double.TYPE;
        }
        throw new RuntimeException("Class not convertible to primitive: " + type.getName());
    }

    public static Class<?> convertPrimitiveNameToType(String typeName) {
        return primitiveNameToType.get(typeName);
    }

    public static Set<Class<?>> getAllImplementedInterfaceNames(Class<?> klass) {
        HashSet interfaces = new HashSet();
        while (klass != null) {
            Class<?>[] localInterfaces;
            for (Class<?> intf : localInterfaces = klass.getInterfaces()) {
                interfaces.add(intf);
                ClassUtils.exploreSuperInterfaces(intf, interfaces);
            }
            klass = klass.getSuperclass();
        }
        return interfaces;
    }

    private static void exploreSuperInterfaces(Class<?> intf, Set<Class<?>> traitInterfaces) {
        for (Class<?> sup : intf.getInterfaces()) {
            traitInterfaces.add(sup);
            ClassUtils.exploreSuperInterfaces(sup, traitInterfaces);
        }
    }

    public static Set<Class<?>> getMinimalImplementedInterfaceNames(Class<?> klass) {
        HashSet interfaces = new HashSet();
        while (klass != null) {
            Class<?>[] localInterfaces;
            for (Class<?> intf : localInterfaces = klass.getInterfaces()) {
                boolean subsumed = false;
                for (Class<?> i : new ArrayList(interfaces)) {
                    if (intf.isAssignableFrom(i)) {
                        subsumed = true;
                        break;
                    }
                    if (!i.isAssignableFrom(intf)) continue;
                    interfaces.remove(i);
                }
                if (subsumed) continue;
                interfaces.add(intf);
            }
            klass = klass.getSuperclass();
        }
        return interfaces;
    }

    public static boolean isCaseSenstiveOS() {
        String os = System.getProperty("os.name").toUpperCase();
        return os.contains("WINDOWS") || os.contains("MAC OS X");
    }

    public static boolean isWindows() {
        String os = System.getProperty("os.name");
        return os.toUpperCase().contains("WINDOWS");
    }

    public static boolean isOSX() {
        String os = System.getProperty("os.name");
        return os.toUpperCase().contains("MAC OS X");
    }

    public static boolean isJboss() {
        return System.getProperty("jboss.server.name") != null;
    }

    public static boolean isAndroid() {
        return IS_ANDROID;
    }

    public static Class<?> findCommonSuperClass(Class<?> c1, Class<?> c2) {
        if (c1 == null) {
            return c2;
        }
        if (c2 == null) {
            return c1;
        }
        if (c1.isAssignableFrom(c2)) {
            return c1;
        }
        if (c2.isAssignableFrom(c1)) {
            return c2;
        }
        for (Class<?> parent = c1.getSuperclass(); parent != null; parent = parent.getSuperclass()) {
            if (!parent.isAssignableFrom(c2)) continue;
            return parent;
        }
        return c1;
    }

    public static Class<?> getClassFromName(String className) throws ClassNotFoundException {
        return ClassUtils.getClassFromName(className, true, ClassUtils.class.getClassLoader());
    }

    public static Class<?> getClassFromName(String className, boolean initialize, ClassLoader classLoader) throws ClassNotFoundException {
        try {
            Class<?> clazz;
            if (abbreviationMap.containsKey(className)) {
                String clsName = "[" + abbreviationMap.get(className);
                clazz = Class.forName(clsName, initialize, classLoader).getComponentType();
            } else {
                clazz = Class.forName(ClassUtils.toCanonicalName(className), initialize, classLoader);
            }
            return clazz;
        }
        catch (ClassNotFoundException ex) {
            int lastDotIndex = className.lastIndexOf(46);
            if (lastDotIndex != -1) {
                try {
                    return ClassUtils.getClassFromName(className.substring(0, lastDotIndex) + '$' + className.substring(lastDotIndex + 1), initialize, classLoader);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
            throw ex;
        }
    }

    private static String toCanonicalName(String className) {
        if (className == null) {
            throw new NullPointerException("className must not be null.");
        }
        if (className.endsWith("[]")) {
            StringBuilder classNameBuffer = new StringBuilder();
            while (className.endsWith("[]")) {
                className = className.substring(0, className.length() - 2);
                classNameBuffer.append("[");
            }
            String abbreviation = abbreviationMap.get(className);
            if (abbreviation != null) {
                classNameBuffer.append(abbreviation);
            } else {
                classNameBuffer.append("L").append(className).append(";");
            }
            className = classNameBuffer.toString();
        }
        return className;
    }

    public static Class<?> safeLoadClass(ClassLoader cl, String name) {
        try {
            return cl.loadClass(name);
        }
        catch (ClassNotFoundException | NoClassDefFoundError throwable) {
            return null;
        }
    }

    public static String getSimpleName(Class<?> c) {
        return ClassUtils.getCanonicalSimpleName(c, '$');
    }

    public static String getCanonicalSimpleName(Class<?> c) {
        return ClassUtils.getCanonicalSimpleName(c, '.');
    }

    public static String getCanonicalSimpleName(Class<?> c, char separator) {
        Class<?> enclosingClass = c.getEnclosingClass();
        return enclosingClass != null ? ClassUtils.getCanonicalSimpleName(enclosingClass) + separator + c.getSimpleName() : c.getSimpleName();
    }

    static {
        boolean isAndroid;
        classes = Collections.synchronizedMap(new HashMap());
        constructors = Collections.synchronizedMap(new HashMap());
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("int", "I");
        m.put("boolean", "Z");
        m.put("float", "F");
        m.put("long", "J");
        m.put("short", "S");
        m.put("byte", "B");
        m.put("double", "D");
        m.put("char", "C");
        m.put("void", "V");
        HashMap r = new HashMap();
        for (Map.Entry e : m.entrySet()) {
            r.put(e.getValue(), e.getKey());
        }
        abbreviationMap = Collections.unmodifiableMap(m);
        HashMap<String, Class<Constable>> m2 = new HashMap<String, Class<Constable>>();
        m2.put("int", Integer.TYPE);
        m2.put("boolean", Boolean.TYPE);
        m2.put("float", Float.TYPE);
        m2.put("long", Long.TYPE);
        m2.put("short", Short.TYPE);
        m2.put("byte", Byte.TYPE);
        m2.put("double", Double.TYPE);
        m2.put("char", Character.TYPE);
        primitiveNameToType = Collections.unmodifiableMap(m2);
        PROTECTION_DOMAIN = (ProtectionDomain)AccessController.doPrivileged(ClassLoaderUtil.class::getProtectionDomain);
        try {
            isAndroid = ClassUtils.loadClass("org.drools.android.DroolsAndroidContext", null) != null && ClassUtils.loadClass("android.os.Build", null) != null && ClassUtils.loadClass("dalvik.system.DexPathList", null) != null;
        }
        catch (Exception e) {
            isAndroid = false;
        }
        IS_ANDROID = isAndroid;
    }

    private static class PropertyInClass
    implements Comparable {
        private final String setter;
        private final Class<?> clazz;

        private PropertyInClass(String setter, Class<?> clazz) {
            this.setter = setter;
            this.clazz = clazz;
        }

        public int compareTo(Object o) {
            PropertyInClass other = (PropertyInClass)o;
            if (this.clazz == other.clazz) {
                return this.setter.compareTo(other.setter);
            }
            return this.clazz.isAssignableFrom(other.clazz) ? -1 : 1;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof PropertyInClass)) {
                return false;
            }
            PropertyInClass other = (PropertyInClass)obj;
            return this.clazz == other.clazz && this.setter.equals(other.setter);
        }

        public int hashCode() {
            return 29 * this.clazz.hashCode() + 31 * this.setter.hashCode();
        }
    }
}

