/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.command.runtime.rule;

import java.util.Arrays;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSchemaType;
import org.drools.core.common.DisconnectedFactHandle;
import org.kie.api.command.ExecutableCommand;
import org.kie.api.runtime.Context;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.rule.EntryPoint;
import org.kie.api.runtime.rule.FactHandle;
import org.kie.internal.command.RegistryContext;

@XmlRootElement(name="update-command")
@XmlAccessorType(value=XmlAccessType.NONE)
public class UpdateCommand
implements ExecutableCommand<Void> {
    private static final long serialVersionUID = 3255044102543531497L;
    private DisconnectedFactHandle handle;
    @XmlElement
    private Object object;
    @XmlElement
    @XmlSchemaType(name="string")
    private String entryPoint = "DEFAULT";
    @XmlElement
    private String[] modifiedProperties;

    public UpdateCommand() {
    }

    public UpdateCommand(FactHandle handle, Object object) {
        this.handle = DisconnectedFactHandle.newFrom(handle);
        this.object = object;
    }

    public UpdateCommand(FactHandle handle, Object object, String[] modifiedProperties) {
        this(handle, object);
        this.modifiedProperties = modifiedProperties;
    }

    public String getEntryPoint() {
        return this.entryPoint;
    }

    public void setEntryPoint(String entryPoint) {
        if (entryPoint == null) {
            entryPoint = "DEFAULT";
        }
        this.entryPoint = entryPoint;
    }

    public Object getObject() {
        return this.object;
    }

    public DisconnectedFactHandle getHandle() {
        return this.handle;
    }

    @XmlElement(name="fact-handle", required=true)
    public void setFactHandleFromString(String factHandleId) {
        this.handle = new DisconnectedFactHandle(factHandleId);
    }

    public String getFactHandleFromString() {
        return this.handle.toExternalForm();
    }

    public Void execute(Context context) {
        KieSession ksession = (KieSession)((RegistryContext)context).lookup(KieSession.class);
        EntryPoint ep = ksession.getEntryPoint(this.handle.getEntryPointName());
        if (this.modifiedProperties != null) {
            ep.update((FactHandle)this.handle, this.object, this.modifiedProperties);
        } else {
            ep.update((FactHandle)this.handle, this.object);
        }
        return null;
    }

    public String toString() {
        return "session.update( " + this.handle + ", " + this.object + (this.modifiedProperties != null ? ", " + Arrays.toString(this.modifiedProperties) : "") + " );";
    }
}

