/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.reteoo;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import java.util.stream.Stream;
import org.drools.core.common.BaseNode;
import org.drools.core.common.CompositeDefaultAgenda;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.common.RuleBasePartitionId;
import org.drools.core.phreak.PropagationEntry;
import org.drools.core.reteoo.AlphaNode;
import org.drools.core.reteoo.CompositeObjectSinkAdapter;
import org.drools.core.reteoo.EmptyObjectSinkAdapter;
import org.drools.core.reteoo.ModifyPreviousTuples;
import org.drools.core.reteoo.ObjectSink;
import org.drools.core.reteoo.ObjectSinkPropagator;
import org.drools.core.rule.IndexableConstraint;
import org.drools.core.spi.InternalReadAccessor;
import org.drools.core.spi.PropagationContext;
import org.drools.core.util.ObjectHashMap;

public class CompositePartitionAwareObjectSinkAdapter
implements ObjectSinkPropagator {
    private final ObjectSinkPropagator[] partitionedPropagators = new ObjectSinkPropagator[RuleBasePartitionId.PARALLEL_PARTITIONS_NUMBER];
    private boolean hashed = true;
    private CompositeObjectSinkAdapter.FieldIndex fieldIndex;
    private ObjectHashMap hashedSinkMap;

    public CompositePartitionAwareObjectSinkAdapter() {
        Arrays.fill(this.partitionedPropagators, EmptyObjectSinkAdapter.getInstance());
    }

    public boolean isHashed() {
        return this.hashed;
    }

    @Override
    public ObjectSinkPropagator addObjectSink(ObjectSink sink, int alphaNodeHashingThreshold) {
        this.hashed &= this.hashSink(sink);
        int partition = sink.getPartitionId().getParallelEvaluationSlot();
        this.partitionedPropagators[partition] = this.partitionedPropagators[partition].addObjectSink(sink, alphaNodeHashingThreshold);
        return this;
    }

    private boolean hashSink(ObjectSink sink) {
        InternalReadAccessor readAccessor = this.getHashableAccessor(sink);
        if (readAccessor != null) {
            int index = readAccessor.getIndex();
            if (this.fieldIndex == null) {
                this.fieldIndex = new CompositeObjectSinkAdapter.FieldIndex(index, readAccessor);
                this.hashedSinkMap = new ObjectHashMap();
            }
            if (this.fieldIndex.getIndex() == index) {
                AlphaNode alpha = (AlphaNode)sink;
                this.hashedSinkMap.put(new CompositeObjectSinkAdapter.HashKey(index, ((IndexableConstraint)((Object)alpha.getConstraint())).getField(), this.fieldIndex.getFieldExtractor()), alpha, false);
                return true;
            }
        }
        this.fieldIndex = null;
        this.hashedSinkMap = null;
        return false;
    }

    private InternalReadAccessor getHashableAccessor(ObjectSink sink) {
        if (sink.getType() == 40) {
            AlphaNode alphaNode = (AlphaNode)sink;
            return CompositeObjectSinkAdapter.getHashableAccessor(alphaNode);
        }
        return null;
    }

    @Override
    public ObjectSinkPropagator removeObjectSink(ObjectSink sink) {
        int partition = sink.getPartitionId().getParallelEvaluationSlot();
        this.partitionedPropagators[partition] = this.partitionedPropagators[partition].removeObjectSink(sink);
        return this;
    }

    @Override
    public void changeSinkPartition(ObjectSink sink, RuleBasePartitionId oldPartition, RuleBasePartitionId newPartition, int alphaNodeHashingThreshold) {
        int oldP = oldPartition.getParallelEvaluationSlot();
        this.partitionedPropagators[oldP] = this.partitionedPropagators[oldP].removeObjectSink(sink);
        int newP = newPartition.getParallelEvaluationSlot();
        this.partitionedPropagators[newP] = this.partitionedPropagators[newP].addObjectSink(sink, alphaNodeHashingThreshold);
    }

    @Override
    public void propagateAssertObject(InternalFactHandle factHandle, PropagationContext context, InternalWorkingMemory workingMemory) {
        CompositeDefaultAgenda compositeAgenda = (CompositeDefaultAgenda)workingMemory.getAgenda();
        if (this.hashed) {
            AlphaNode sink = (AlphaNode)this.hashedSinkMap.get(new CompositeObjectSinkAdapter.HashKey(this.fieldIndex, factHandle.getObject()));
            if (sink != null) {
                compositeAgenda.getPartitionedAgenda(sink.getPartitionId().getParallelEvaluationSlot()).addPropagation(new HashedInsert(sink, factHandle, context));
            }
        } else {
            for (int i = 0; i < this.partitionedPropagators.length; ++i) {
                if (this.partitionedPropagators[i].isEmpty()) continue;
                compositeAgenda.getPartitionedAgenda(i).addPropagation(new Insert(this.partitionedPropagators[i], factHandle, context));
            }
        }
    }

    @Override
    public BaseNode getMatchingNode(BaseNode candidate) {
        return Stream.of(this.partitionedPropagators).map(p -> p.getMatchingNode(candidate)).filter(node -> node != null).findFirst().orElse(null);
    }

    @Override
    public ObjectSink[] getSinks() {
        return (ObjectSink[])Stream.of(this.partitionedPropagators).flatMap(p -> Stream.of(p.getSinks())).toArray(ObjectSink[]::new);
    }

    @Override
    public int size() {
        return Stream.of(this.partitionedPropagators).mapToInt(ObjectSinkPropagator::size).sum();
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    public ObjectSinkPropagator[] getPartitionedPropagators() {
        return this.partitionedPropagators;
    }

    @Override
    public void propagateModifyObject(InternalFactHandle factHandle, ModifyPreviousTuples modifyPreviousTuples, PropagationContext context, InternalWorkingMemory workingMemory) {
        throw new UnsupportedOperationException("propagateModifyObject has to be executed by partitions");
    }

    public void propagateModifyObjectForPartition(InternalFactHandle handle, ModifyPreviousTuples modifyPreviousTuples, PropagationContext context, InternalWorkingMemory wm, int partition) {
        this.partitionedPropagators[partition].propagateModifyObject(handle, modifyPreviousTuples, context, wm);
    }

    @Override
    public void byPassModifyToBetaNode(InternalFactHandle factHandle, ModifyPreviousTuples modifyPreviousTuples, PropagationContext context, InternalWorkingMemory workingMemory) {
        throw new UnsupportedOperationException("This sink is only used for OTNs, it cannot be the sink for a beta");
    }

    @Override
    public void doLinkRiaNode(InternalWorkingMemory wm) {
        throw new UnsupportedOperationException("This sink is only used for OTNs, it cannot be the sink for a RIA");
    }

    @Override
    public void doUnlinkRiaNode(InternalWorkingMemory wm) {
        throw new UnsupportedOperationException("This sink is only used for OTNs, it cannot be the sink for a RIA");
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeBoolean(this.hashed);
        out.writeObject(this.fieldIndex);
        out.writeObject(this.hashedSinkMap);
        for (ObjectSinkPropagator partitionedPropagator : this.partitionedPropagators) {
            out.writeObject(partitionedPropagator);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.hashed = in.readBoolean();
        this.fieldIndex = (CompositeObjectSinkAdapter.FieldIndex)in.readObject();
        this.hashedSinkMap = (ObjectHashMap)in.readObject();
        for (int i = 0; i < this.partitionedPropagators.length; ++i) {
            this.partitionedPropagators[i] = (ObjectSinkPropagator)in.readObject();
        }
    }

    public ObjectSinkPropagator asNonPartitionedSinkPropagator(int alphaNodeHashingThreshold) {
        ObjectSinkPropagator sinkPropagator = new EmptyObjectSinkAdapter();
        for (int i = 0; i < this.partitionedPropagators.length; ++i) {
            for (ObjectSink sink : this.partitionedPropagators[i].getSinks()) {
                sinkPropagator = sinkPropagator.addObjectSink(sink, alphaNodeHashingThreshold);
            }
        }
        return sinkPropagator;
    }

    public int getUsedPartitionsCount() {
        int partitions = 0;
        for (int i = 0; i < this.partitionedPropagators.length; ++i) {
            if (this.partitionedPropagators[i].size() <= 0) continue;
            ++partitions;
        }
        return partitions;
    }

    public static class HashedInsert
    extends PropagationEntry.AbstractPropagationEntry {
        private final AlphaNode sink;
        private final InternalFactHandle factHandle;
        private final PropagationContext context;

        public HashedInsert(AlphaNode sink, InternalFactHandle factHandle, PropagationContext context) {
            this.sink = sink;
            this.factHandle = factHandle;
            this.context = context;
        }

        @Override
        public void execute(InternalWorkingMemory wm) {
            this.sink.getObjectSinkPropagator().propagateAssertObject(this.factHandle, this.context, wm);
        }

        public String toString() {
            return "Hashed insert of " + this.factHandle.getObject();
        }
    }

    public static class Insert
    extends PropagationEntry.AbstractPropagationEntry {
        private final ObjectSinkPropagator propagator;
        private final InternalFactHandle factHandle;
        private final PropagationContext context;

        public Insert(ObjectSinkPropagator propagator, InternalFactHandle factHandle, PropagationContext context) {
            this.propagator = propagator;
            this.factHandle = factHandle;
            this.context = context;
        }

        @Override
        public void execute(InternalWorkingMemory wm) {
            this.propagator.propagateAssertObject(this.factHandle, this.context, wm);
        }

        public String toString() {
            return "Insert of " + this.factHandle.getObject();
        }
    }
}

