/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.phreak;

import java.util.Collection;
import org.drools.core.common.BetaConstraints;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.phreak.PhreakFromNode;
import org.drools.core.phreak.PropagationEntry;
import org.drools.core.phreak.ReactiveObject;
import org.drools.core.phreak.RuleNetworkEvaluator;
import org.drools.core.reteoo.LeftTuple;
import org.drools.core.reteoo.LeftTupleSinkNode;
import org.drools.core.reteoo.ReactiveFromNode;
import org.drools.core.reteoo.ReactiveFromNodeLeftTuple;
import org.drools.core.reteoo.RightTupleImpl;
import org.drools.core.rule.ContextEntry;
import org.drools.core.spi.PropagationContext;
import org.drools.core.spi.Tuple;

public class ReactiveObjectUtil {
    public static void notifyModification(ReactiveObject reactiveObject) {
        ReactiveObjectUtil.notifyModification(reactiveObject, reactiveObject.getLeftTuples(), ModificationType.MODIFY);
    }

    public static void notifyModification(Object object, Collection<Tuple> leftTuples, ModificationType type) {
        for (Tuple leftTuple : leftTuples) {
            if (!((ReactiveFromNodeLeftTuple)leftTuple).updateModificationState(type)) continue;
            PropagationContext propagationContext = leftTuple.getPropagationContext();
            ReactiveFromNode node = (ReactiveFromNode)leftTuple.getTupleSink();
            LeftTupleSinkNode sink = node.getSinkPropagator().getFirstLeftTupleSink();
            InternalWorkingMemory wm = ReactiveObjectUtil.getInternalWorkingMemory(propagationContext);
            wm.addPropagation(new ReactivePropagation(object, (ReactiveFromNodeLeftTuple)leftTuple, propagationContext, node, sink, type));
        }
    }

    private static InternalWorkingMemory getInternalWorkingMemory(PropagationContext propagationContext) {
        InternalFactHandle fh = propagationContext.getFactHandle();
        return fh.getEntryPoint().getInternalWorkingMemory();
    }

    static class ReactivePropagation
    extends PropagationEntry.AbstractPropagationEntry {
        private final Object object;
        private final ReactiveFromNodeLeftTuple leftTuple;
        private final PropagationContext propagationContext;
        private final ReactiveFromNode node;
        private final LeftTupleSinkNode sink;
        private final ModificationType type;

        ReactivePropagation(Object object, ReactiveFromNodeLeftTuple leftTuple, PropagationContext propagationContext, ReactiveFromNode node, LeftTupleSinkNode sink, ModificationType type) {
            this.object = object;
            this.leftTuple = leftTuple;
            this.propagationContext = propagationContext;
            this.node = node;
            this.sink = sink;
            this.type = type;
        }

        @Override
        public void execute(InternalWorkingMemory wm) {
            if (this.leftTuple.getModificationType() == ModificationType.NONE) {
                return;
            }
            ReactiveFromNode.ReactiveFromMemory mem = wm.getNodeMemory(this.node);
            InternalFactHandle factHandle = this.node.createFactHandle(this.leftTuple, this.propagationContext, wm, this.object);
            if (this.type != ModificationType.REMOVE && PhreakFromNode.isAllowed(factHandle, this.node.getAlphaConstraints(), wm, mem)) {
                ContextEntry[] context = mem.getBetaMemory().getContext();
                BetaConstraints betaConstraints = this.node.getBetaConstraints();
                betaConstraints.updateFromTuple(context, wm, this.leftTuple);
                PhreakFromNode.propagate(this.sink, this.leftTuple, new RightTupleImpl(factHandle), betaConstraints, this.propagationContext, context, RuleNetworkEvaluator.useLeftMemory(this.node, this.leftTuple), mem.getStagedLeftTuples(), null);
            } else {
                LeftTuple childLeftTuple = this.leftTuple.getFirstChild();
                while (childLeftTuple != null) {
                    LeftTuple next = (LeftTuple)childLeftTuple.getHandleNext();
                    if (this.object == childLeftTuple.getFactHandle().getObject()) {
                        PhreakFromNode.deleteChildLeftTuple(this.propagationContext, mem.getStagedLeftTuples(), null, childLeftTuple);
                    }
                    childLeftTuple = next;
                }
            }
            mem.getBetaMemory().setNodeDirty(wm);
            this.leftTuple.resetModificationState();
        }
    }

    public static enum ModificationType {
        NONE,
        MODIFY,
        ADD,
        REMOVE;

    }
}

