/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.reteoo;

import org.drools.core.base.mvel.MVELSalienceExpression;
import org.drools.core.common.ActivationsFilter;
import org.drools.core.common.InternalAgendaGroup;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.common.Memory;
import org.drools.core.definitions.rule.impl.RuleImpl;
import org.drools.core.phreak.RuleAgendaItem;
import org.drools.core.reteoo.NodeTypeEnums;
import org.drools.core.reteoo.PathEndNode;
import org.drools.core.reteoo.SegmentMemory;
import org.drools.core.reteoo.TerminalNode;
import org.drools.core.util.AbstractBaseLinkedListNode;
import org.drools.core.util.AtomicBitwiseLong;
import org.kie.api.definition.rule.Rule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PathMemory
extends AbstractBaseLinkedListNode<Memory>
implements Memory {
    protected static final Logger log = LoggerFactory.getLogger(PathMemory.class);
    protected static final boolean isLogTraceEnabled = log.isTraceEnabled();
    private AtomicBitwiseLong linkedSegmentMask;
    private long allLinkedMaskTest;
    private PathEndNode pathEndNode;
    private volatile RuleAgendaItem agendaItem;
    private SegmentMemory[] segmentMemories;
    private SegmentMemory segmentMemory;

    public PathMemory(PathEndNode pathEndNode) {
        this.pathEndNode = pathEndNode;
        this.linkedSegmentMask = new AtomicBitwiseLong();
    }

    public PathEndNode getPathEndNode() {
        return this.pathEndNode;
    }

    public RuleImpl getRule() {
        return this.pathEndNode instanceof TerminalNode ? ((TerminalNode)((Object)this.pathEndNode)).getRule() : null;
    }

    public RuleAgendaItem getRuleAgendaItem() {
        return this.agendaItem;
    }

    public void setlinkedSegmentMask(long mask) {
        this.linkedSegmentMask.set(mask);
    }

    public long getLinkedSegmentMask() {
        return this.linkedSegmentMask.get();
    }

    public long getAllLinkedMaskTest() {
        return this.allLinkedMaskTest;
    }

    public void setAllLinkedMaskTest(long allLinkedTestMask) {
        this.allLinkedMaskTest = allLinkedTestMask;
    }

    public void linkNodeWithoutRuleNotify(long mask) {
        this.linkedSegmentMask.getAndBitwiseOr(mask);
    }

    public void linkSegment(long mask, InternalWorkingMemory wm) {
        this.linkedSegmentMask.getAndBitwiseOr(mask);
        if (isLogTraceEnabled) {
            if (NodeTypeEnums.isTerminalNode(this.getPathEndNode())) {
                TerminalNode rtn = (TerminalNode)((Object)this.getPathEndNode());
                log.trace("  LinkSegment smask={} rmask={} name={}", new Object[]{mask, this.linkedSegmentMask, rtn.getRule().getName()});
            } else {
                log.trace("  LinkSegment smask={} rmask={} name={}", (Object)mask, (Object)"RiaNode");
            }
        }
        if (this.isRuleLinked()) {
            this.doLinkRule(wm);
        }
    }

    public RuleAgendaItem getOrCreateRuleAgendaItem(InternalWorkingMemory wm) {
        this.ensureAgendaItemCreated(wm);
        return this.agendaItem;
    }

    private TerminalNode ensureAgendaItemCreated(InternalWorkingMemory wm) {
        TerminalNode rtn = (TerminalNode)((Object)this.getPathEndNode());
        if (this.agendaItem == null) {
            int salience = rtn.getRule().getSalience() instanceof MVELSalienceExpression ? 0 : rtn.getRule().getSalience().getValue(null, (Rule)rtn.getRule(), wm);
            this.agendaItem = wm.getAgenda().createRuleAgendaItem(salience, this, rtn);
        }
        return rtn;
    }

    public void doLinkRule(InternalWorkingMemory wm) {
        TerminalNode rtn = this.ensureAgendaItemCreated(wm);
        if (isLogTraceEnabled) {
            log.trace(" LinkRule name={}", (Object)rtn.getRule().getName());
        }
        this.queueRuleAgendaItem(wm);
    }

    public void doUnlinkRule(InternalWorkingMemory wm) {
        TerminalNode rtn = this.ensureAgendaItemCreated(wm);
        if (isLogTraceEnabled) {
            log.trace("    UnlinkRule name={}", (Object)rtn.getRule().getName());
        }
        this.agendaItem.getRuleExecutor().setDirty(true);
        if (!this.agendaItem.isQueued()) {
            if (isLogTraceEnabled) {
                log.trace("Queue RuleAgendaItem {}", (Object)this.agendaItem);
            }
            InternalAgendaGroup ag = this.agendaItem.getAgendaGroup();
            ag.add(this.agendaItem);
        }
    }

    public void queueRuleAgendaItem(InternalWorkingMemory wm) {
        this.agendaItem.getRuleExecutor().setDirty(true);
        ActivationsFilter activationFilter = wm.getAgenda().getActivationsFilter();
        if (activationFilter != null && !activationFilter.accept(this.agendaItem, wm, this.agendaItem.getTerminalNode())) {
            return;
        }
        if (!this.agendaItem.isQueued()) {
            if (isLogTraceEnabled) {
                log.trace("Queue RuleAgendaItem {}", (Object)this.agendaItem);
            }
            InternalAgendaGroup ag = this.agendaItem.getAgendaGroup();
            ag.add(this.agendaItem);
        }
        if (this.agendaItem.getRule().isQuery()) {
            wm.getAgenda().addQueryAgendaItem(this.agendaItem);
        } else if (this.agendaItem.getRule().isEager()) {
            wm.getAgenda().addEagerRuleAgendaItem(this.agendaItem);
        }
    }

    public void unlinkedSegment(long mask, InternalWorkingMemory wm) {
        boolean linkedRule = this.isRuleLinked();
        this.linkedSegmentMask.getAndBitwiseXor(mask);
        if (isLogTraceEnabled) {
            log.trace("  UnlinkSegment smask={} rmask={} name={}", new Object[]{mask, this.linkedSegmentMask, this});
        }
        if (linkedRule && !this.isRuleLinked()) {
            this.doUnlinkRule(wm);
        }
    }

    public boolean isRuleLinked() {
        return (this.linkedSegmentMask.get() & this.allLinkedMaskTest) == this.allLinkedMaskTest;
    }

    public boolean isDataDriven() {
        RuleImpl rule = this.getRule();
        return rule != null && rule.isDataDriven();
    }

    @Override
    public short getNodeType() {
        return 101;
    }

    public SegmentMemory[] getSegmentMemories() {
        return this.segmentMemories;
    }

    public void setSegmentMemory(int index, SegmentMemory sm) {
        this.segmentMemories[index] = sm;
    }

    public void setSegmentMemories(SegmentMemory[] segmentMemories) {
        this.segmentMemories = segmentMemories;
    }

    @Override
    public SegmentMemory getSegmentMemory() {
        return this.segmentMemory;
    }

    @Override
    public void setSegmentMemory(SegmentMemory sm) {
        this.segmentMemory = sm;
    }

    public String toString() {
        return "[RuleMem " + this.getRule().getName() + "]";
    }

    @Override
    public void reset() {
        this.linkedSegmentMask.set(0L);
    }
}

