/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.common;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.drools.core.RuleBaseConfiguration;
import org.drools.core.beliefsystem.ModedAssertion;
import org.drools.core.common.ActivationGroupImpl;
import org.drools.core.common.ActivationGroupNode;
import org.drools.core.common.ActivationsFilter;
import org.drools.core.common.AgendaGroupFactory;
import org.drools.core.common.AgendaItem;
import org.drools.core.common.EventFactHandle;
import org.drools.core.common.EventSupport;
import org.drools.core.common.InternalAgenda;
import org.drools.core.common.InternalAgendaGroup;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.InternalRuleFlowGroup;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.common.InternalWorkingMemoryEntryPoint;
import org.drools.core.common.ScheduledAgendaItem;
import org.drools.core.common.TruthMaintenanceSystemHelper;
import org.drools.core.definitions.rule.impl.RuleImpl;
import org.drools.core.impl.InternalKnowledgeBase;
import org.drools.core.phreak.ExecutableEntry;
import org.drools.core.phreak.PropagationEntry;
import org.drools.core.phreak.RuleAgendaItem;
import org.drools.core.phreak.RuleExecutor;
import org.drools.core.reteoo.LeftTuple;
import org.drools.core.reteoo.ObjectTypeConf;
import org.drools.core.reteoo.PathMemory;
import org.drools.core.reteoo.RuleTerminalNodeLeftTuple;
import org.drools.core.reteoo.TerminalNode;
import org.drools.core.rule.Declaration;
import org.drools.core.rule.EntryPointId;
import org.drools.core.rule.QueryImpl;
import org.drools.core.spi.Activation;
import org.drools.core.spi.AgendaGroup;
import org.drools.core.spi.Consequence;
import org.drools.core.spi.ConsequenceException;
import org.drools.core.spi.ConsequenceExceptionHandler;
import org.drools.core.spi.InternalActivationGroup;
import org.drools.core.spi.KnowledgeHelper;
import org.drools.core.spi.PropagationContext;
import org.drools.core.spi.RuleFlowGroup;
import org.drools.core.spi.Tuple;
import org.drools.core.util.ClassUtils;
import org.drools.core.util.LinkedList;
import org.drools.core.util.StringUtils;
import org.drools.core.util.index.TupleList;
import org.kie.api.definition.rule.Rule;
import org.kie.api.event.rule.MatchCancelledCause;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.runtime.rule.AgendaFilter;
import org.kie.api.runtime.rule.FactHandle;
import org.kie.api.runtime.rule.Match;
import org.kie.api.runtime.rule.RuleRuntime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultAgenda
implements Externalizable,
InternalAgenda {
    public static final String ON_BEFORE_ALL_FIRES_CONSEQUENCE_NAME = "$onBeforeAllFire$";
    public static final String ON_AFTER_ALL_FIRES_CONSEQUENCE_NAME = "$onAfterAllFire$";
    public static final String ON_DELETE_MATCH_CONSEQUENCE_NAME = "$onDeleteMatch$";
    protected static final transient Logger log = LoggerFactory.getLogger(DefaultAgenda.class);
    private static final long serialVersionUID = 510L;
    protected InternalWorkingMemory workingMemory;
    private Map<String, InternalAgendaGroup> agendaGroups;
    private Map<String, InternalActivationGroup> activationGroups;
    private java.util.LinkedList<AgendaGroup> focusStack;
    private InternalAgendaGroup main;
    private final LinkedList<RuleAgendaItem> eager = new LinkedList();
    private final Map<QueryImpl, RuleAgendaItem> queries = new HashMap<QueryImpl, RuleAgendaItem>();
    private AgendaGroupFactory agendaGroupFactory;
    protected KnowledgeHelper knowledgeHelper;
    private ConsequenceExceptionHandler legacyConsequenceExceptionHandler;
    private org.kie.api.runtime.rule.ConsequenceExceptionHandler consequenceExceptionHandler;
    protected int activationCounter;
    private boolean declarativeAgenda;
    private boolean sequential;
    private ObjectTypeConf activationObjectTypeConf;
    private ActivationsFilter activationsFilter;
    private volatile ExecutionState currentState = ExecutionState.INACTIVE;
    private final Object stateMachineLock = new Object();

    public DefaultAgenda() {
    }

    public DefaultAgenda(InternalKnowledgeBase kBase) {
        this(kBase, true);
    }

    public DefaultAgenda(InternalKnowledgeBase kBase, boolean initMain) {
        Object object;
        this.agendaGroups = new HashMap<String, InternalAgendaGroup>();
        this.activationGroups = new HashMap<String, InternalActivationGroup>();
        this.focusStack = new java.util.LinkedList();
        this.agendaGroupFactory = kBase.getConfiguration().getAgendaGroupFactory();
        if (initMain) {
            this.main = this.agendaGroupFactory.createAgendaGroup("MAIN", kBase);
            this.agendaGroups.put("MAIN", this.main);
            this.focusStack.add(this.main);
        }
        if ((object = ClassUtils.instantiateObject(kBase.getConfiguration().getConsequenceExceptionHandler(), kBase.getConfiguration().getClassLoader())) instanceof ConsequenceExceptionHandler) {
            this.legacyConsequenceExceptionHandler = (ConsequenceExceptionHandler)object;
        } else {
            this.consequenceExceptionHandler = (org.kie.api.runtime.rule.ConsequenceExceptionHandler)object;
        }
        this.declarativeAgenda = kBase.getConfiguration().isDeclarativeAgenda();
        this.sequential = kBase.getConfiguration().isSequential();
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.workingMemory = (InternalWorkingMemory)in.readObject();
        this.agendaGroups = (Map)in.readObject();
        this.activationGroups = (Map)in.readObject();
        this.focusStack = (java.util.LinkedList)in.readObject();
        this.main = (InternalAgendaGroup)in.readObject();
        this.agendaGroupFactory = (AgendaGroupFactory)in.readObject();
        this.knowledgeHelper = (KnowledgeHelper)in.readObject();
        this.legacyConsequenceExceptionHandler = (ConsequenceExceptionHandler)in.readObject();
        this.declarativeAgenda = in.readBoolean();
        this.sequential = in.readBoolean();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.workingMemory);
        out.writeObject(this.agendaGroups);
        out.writeObject(this.activationGroups);
        out.writeObject(this.focusStack);
        out.writeObject(this.main);
        out.writeObject(this.agendaGroupFactory);
        out.writeObject(this.knowledgeHelper);
        out.writeObject(this.legacyConsequenceExceptionHandler);
        out.writeBoolean(this.declarativeAgenda);
        out.writeBoolean(this.sequential);
    }

    @Override
    public RuleAgendaItem createRuleAgendaItem(int salience, PathMemory rs, TerminalNode rtn) {
        String agendaGroupName = rtn.getRule().getAgendaGroup();
        String ruleFlowGroupName = rtn.getRule().getRuleFlowGroup();
        RuleAgendaItem lazyAgendaItem = !StringUtils.isEmpty(ruleFlowGroupName) ? new RuleAgendaItem(this.activationCounter++, null, salience, null, rs, rtn, this.isDeclarativeAgenda(), (InternalAgendaGroup)this.getAgendaGroup(ruleFlowGroupName)) : new RuleAgendaItem(this.activationCounter++, null, salience, null, rs, rtn, this.isDeclarativeAgenda(), (InternalAgendaGroup)((Object)this.getRuleFlowGroup(agendaGroupName)));
        return lazyAgendaItem;
    }

    @Override
    public AgendaItem createAgendaItem(RuleTerminalNodeLeftTuple rtnLeftTuple, int salience, PropagationContext context, RuleAgendaItem ruleAgendaItem, InternalAgendaGroup agendaGroup) {
        rtnLeftTuple.init(this.activationCounter++, salience, context, ruleAgendaItem, agendaGroup);
        rtnLeftTuple.setContextObject(rtnLeftTuple);
        return rtnLeftTuple;
    }

    @Override
    public void setWorkingMemory(InternalWorkingMemory workingMemory) {
        this.workingMemory = workingMemory;
        RuleBaseConfiguration rbc = this.workingMemory.getKnowledgeBase().getConfiguration();
        this.knowledgeHelper = rbc.getComponentFactory().getKnowledgeHelperFactory().newStatefulKnowledgeHelper(this.workingMemory);
    }

    @Override
    public InternalWorkingMemory getWorkingMemory() {
        return this.workingMemory;
    }

    @Override
    public void addEagerRuleAgendaItem(RuleAgendaItem item) {
        if (this.sequential) {
            return;
        }
        if (this.workingMemory.getSessionConfiguration().getForceEagerActivationFilter().accept((Rule)item.getRule())) {
            item.getRuleExecutor().evaluateNetwork(this.workingMemory);
            return;
        }
        if (item.isInList()) {
            return;
        }
        if (log.isTraceEnabled()) {
            log.trace("Added {} to eager evaluation list.", (Object)item.getRule().getName());
        }
        this.eager.add(item);
    }

    @Override
    public void removeEagerRuleAgendaItem(RuleAgendaItem item) {
        if (!item.isInList()) {
            return;
        }
        if (log.isTraceEnabled()) {
            log.trace("Removed {} from eager evaluation list.", (Object)item.getRule().getName());
        }
        this.eager.remove(item);
    }

    @Override
    public void addQueryAgendaItem(RuleAgendaItem item) {
        this.queries.put((QueryImpl)item.getRule(), item);
        if (log.isTraceEnabled()) {
            log.trace("Added {} to query evaluation list.", (Object)item.getRule().getName());
        }
    }

    @Override
    public void removeQueryAgendaItem(RuleAgendaItem item) {
        this.queries.remove(item.getRule());
        if (log.isTraceEnabled()) {
            log.trace("Removed {} from query evaluation list.", (Object)item.getRule().getName());
        }
    }

    @Override
    public void scheduleItem(ScheduledAgendaItem item, InternalWorkingMemory wm) {
        throw new UnsupportedOperationException("rete only");
    }

    @Override
    public void addItemToActivationGroup(AgendaItem item) {
        if (item.isRuleAgendaItem()) {
            throw new UnsupportedOperationException("defensive programming, making sure this isn't called, before removing");
        }
        String group = item.getRule().getActivationGroup();
        if (group != null && group.length() > 0) {
            InternalActivationGroup actgroup = this.getActivationGroup(group);
            if (actgroup.getTriggeredForRecency() != 0L && actgroup.getTriggeredForRecency() >= ((InternalFactHandle)item.getPropagationContext().getFactHandle()).getRecency()) {
                return;
            }
            actgroup.addActivation(item);
        }
    }

    public InternalActivationGroup getStageActivationsGroup() {
        throw new UnsupportedOperationException("rete only");
    }

    @Override
    public void insertAndStageActivation(AgendaItem activation) {
        if (this.activationObjectTypeConf == null) {
            EntryPointId ep = this.workingMemory.getEntryPoint();
            this.activationObjectTypeConf = ((InternalWorkingMemoryEntryPoint)((Object)this.workingMemory.getWorkingMemoryEntryPoint(ep.getEntryPointId()))).getObjectTypeConfigurationRegistry().getObjectTypeConf(ep, activation);
        }
        InternalFactHandle factHandle = this.workingMemory.getFactHandleFactory().newFactHandle(activation, this.activationObjectTypeConf, this.workingMemory, this.workingMemory);
        this.workingMemory.getEntryPointNode().assertActivation(factHandle, activation.getPropagationContext(), this.workingMemory);
        activation.setActivationFactHandle(factHandle);
    }

    @Override
    public boolean addActivation(AgendaItem activation) {
        throw new UnsupportedOperationException("Defensive, rete only");
    }

    @Override
    public boolean isDeclarativeAgenda() {
        return this.declarativeAgenda;
    }

    @Override
    public void removeActivation(AgendaItem activation) {
        throw new UnsupportedOperationException("Defensive, rete only");
    }

    @Override
    public void modifyActivation(AgendaItem activation, boolean previouslyActive) {
        InternalFactHandle factHandle = activation.getActivationFactHandle();
        if (factHandle != null) {
            this.workingMemory.getEntryPointNode().modifyActivation(factHandle, activation.getPropagationContext(), this.workingMemory);
        }
    }

    public void clearAndCancelStagedActivations() {
        throw new UnsupportedOperationException("rete only");
    }

    @Override
    public int unstageActivations() {
        return 0;
    }

    @Override
    public void addAgendaItemToGroup(AgendaItem item) {
        throw new UnsupportedOperationException("Defensive");
    }

    @Override
    public void removeScheduleItem(ScheduledAgendaItem item) {
        throw new UnsupportedOperationException("rete only");
    }

    @Override
    public void addAgendaGroup(AgendaGroup agendaGroup) {
        this.agendaGroups.put(agendaGroup.getName(), (InternalAgendaGroup)agendaGroup);
    }

    @Override
    public boolean createActivation(Tuple tuple, PropagationContext context, InternalWorkingMemory workingMemory, TerminalNode rtn) {
        throw new UnsupportedOperationException("defensive programming, making sure this isn't called, before removing");
    }

    @Override
    public boolean createPostponedActivation(LeftTuple tuple, PropagationContext context, InternalWorkingMemory workingMemory, TerminalNode rtn) {
        throw new UnsupportedOperationException("rete only");
    }

    @Override
    public boolean isRuleActiveInRuleFlowGroup(String ruleflowGroupName, String ruleName, long processInstanceId) {
        return this.isRuleInstanceAgendaItem(ruleflowGroupName, ruleName, processInstanceId);
    }

    @Override
    public void cancelActivation(Tuple leftTuple, PropagationContext context, InternalWorkingMemory workingMemory, Activation activation, TerminalNode rtn) {
        AgendaItem item = (AgendaItem)activation;
        item.removeAllBlockersAndBlocked(this);
        if (this.isDeclarativeAgenda() && activation.getActivationFactHandle() == null) {
            return;
        }
        if (this.isDeclarativeAgenda()) {
            workingMemory.getEntryPointNode().retractActivation(activation.getActivationFactHandle(), activation.getPropagationContext(), workingMemory);
            if (activation.getActivationGroupNode() != null) {
                activation.getActivationGroupNode().getActivationGroup().removeActivation(activation);
            }
        }
        if (activation.isQueued() && (context.getType() != 5 || context.getFactHandle() == null)) {
            if (activation.getActivationGroupNode() != null) {
                activation.getActivationGroupNode().getActivationGroup().removeActivation(activation);
            }
            leftTuple.decreaseActivationCountForEvents();
            ((EventSupport)((Object)workingMemory)).getAgendaEventSupport().fireActivationCancelled(activation, workingMemory, MatchCancelledCause.WME_MODIFY);
        }
        this.fireConsequenceEvent(item, ON_DELETE_MATCH_CONSEQUENCE_NAME);
        if (item.getActivationUnMatchListener() != null) {
            item.getActivationUnMatchListener().unMatch((RuleRuntime)workingMemory.getKnowledgeRuntime(), (Match)item);
        }
        TruthMaintenanceSystemHelper.removeLogicalDependencies(activation, context, rtn.getRule());
        workingMemory.executeQueuedActionsForRete();
    }

    @Override
    public boolean setFocus(AgendaGroup agendaGroup) {
        if (this.focusStack.getLast() != agendaGroup) {
            ((InternalAgendaGroup)this.focusStack.getLast()).setActive(false);
            this.focusStack.add(agendaGroup);
            InternalAgendaGroup igroup = (InternalAgendaGroup)agendaGroup;
            igroup.setActive(true);
            igroup.setActivatedForRecency(this.workingMemory.getFactHandleFactory().getRecency());
            EventSupport eventsupport = (EventSupport)((Object)this.workingMemory);
            eventsupport.getAgendaEventSupport().fireAgendaGroupPushed(agendaGroup, this.workingMemory);
            return true;
        }
        return false;
    }

    @Override
    public void setFocus(String name) {
        this.setFocus(null, name);
    }

    public void setFocus(PropagationContext ctx, String name) {
        AgendaGroup agendaGroup = this.getAgendaGroup(name);
        agendaGroup.setAutoFocusActivator(ctx);
        this.setFocus(agendaGroup);
    }

    @Override
    public AgendaGroup getFocus() {
        return this.focusStack.getLast();
    }

    @Override
    public InternalAgendaGroup getNextFocus() {
        InternalAgendaGroup agendaGroup;
        if (this.focusStack.isEmpty()) {
            return null;
        }
        while ((agendaGroup = (InternalAgendaGroup)this.focusStack.getLast()).isAutoDeactivate()) {
            boolean empty = agendaGroup.isEmpty();
            if (empty && this.focusStack.size() > 1) {
                agendaGroup.setActive(false);
                this.removeLast();
                if (agendaGroup.isAutoDeactivate() && !agendaGroup.getNodeInstances().isEmpty()) {
                    ((EventSupport)((Object)this.workingMemory)).getAgendaEventSupport().fireBeforeRuleFlowGroupDeactivated((InternalRuleFlowGroup)agendaGroup, this.workingMemory);
                    this.innerDeactiveRuleFlowGroup((InternalRuleFlowGroup)agendaGroup);
                    ((EventSupport)((Object)this.workingMemory)).getAgendaEventSupport().fireAfterRuleFlowGroupDeactivated((InternalRuleFlowGroup)agendaGroup, this.workingMemory);
                }
                EventSupport eventsupport = (EventSupport)((Object)this.workingMemory);
                eventsupport.getAgendaEventSupport().fireAgendaGroupPopped(agendaGroup, this.workingMemory);
                continue;
            }
            agendaGroup = empty ? null : agendaGroup;
            break;
        }
        if (agendaGroup != null && !agendaGroup.isActive()) {
            agendaGroup.setActivatedForRecency(this.workingMemory.getFactHandleFactory().getRecency());
            agendaGroup.setActive(true);
        }
        return agendaGroup;
    }

    private InternalAgendaGroup removeLast() {
        InternalAgendaGroup group = (InternalAgendaGroup)this.focusStack.removeLast();
        group.visited();
        return group;
    }

    private boolean removeGroup(InternalAgendaGroup group) {
        boolean existed = this.focusStack.remove(group);
        group.visited();
        return existed;
    }

    private void clearFocusStack() {
        InternalAgendaGroup[] groups;
        for (InternalAgendaGroup group : groups = this.focusStack.toArray(new InternalAgendaGroup[this.focusStack.size()])) {
            group.visited();
        }
        this.focusStack.clear();
    }

    @Override
    public RuleAgendaItem peekNextRule() {
        return (RuleAgendaItem)((InternalAgendaGroup)this.focusStack.peekLast()).peek();
    }

    @Override
    public AgendaGroup getAgendaGroup(String name) {
        return this.getAgendaGroup(name, this.workingMemory == null ? null : this.workingMemory.getKnowledgeBase());
    }

    @Override
    public AgendaGroup getAgendaGroup(String name, InternalKnowledgeBase kBase) {
        String groupName = name == null || name.length() == 0 ? "MAIN" : name;
        InternalAgendaGroup agendaGroup = this.agendaGroups.get(groupName);
        if (agendaGroup == null) {
            agendaGroup = this.agendaGroupFactory.createAgendaGroup(name, kBase);
            this.addAgendaGroup(agendaGroup);
        }
        agendaGroup.setWorkingMemory(this.getWorkingMemory());
        return agendaGroup;
    }

    @Override
    public AgendaGroup[] getAgendaGroups() {
        return this.agendaGroups.values().toArray(new AgendaGroup[this.agendaGroups.size()]);
    }

    @Override
    public Map<String, InternalAgendaGroup> getAgendaGroupsMap() {
        return this.agendaGroups;
    }

    public InternalAgendaGroup getMainAgendaGroup() {
        if (this.main == null) {
            this.main = (InternalAgendaGroup)this.getAgendaGroup("MAIN");
        }
        return this.main;
    }

    @Override
    public AgendaGroup[] getStack() {
        return this.focusStack.toArray(new AgendaGroup[this.focusStack.size()]);
    }

    @Override
    public java.util.LinkedList<AgendaGroup> getStackList() {
        return this.focusStack;
    }

    @Override
    public void addAgendaGroupOnStack(AgendaGroup agendaGroup) {
        if (this.focusStack.isEmpty() || this.focusStack.getLast() != agendaGroup) {
            this.focusStack.add(agendaGroup);
        }
    }

    @Override
    public Map<String, InternalActivationGroup> getActivationGroupsMap() {
        return this.activationGroups;
    }

    @Override
    public InternalActivationGroup getActivationGroup(String name) {
        ActivationGroupImpl activationGroup = (ActivationGroupImpl)this.activationGroups.get(name);
        if (activationGroup == null) {
            activationGroup = new ActivationGroupImpl(this, name);
            this.activationGroups.put(name, activationGroup);
        }
        return activationGroup;
    }

    @Override
    public RuleFlowGroup getRuleFlowGroup(String name) {
        return (RuleFlowGroup)((Object)this.getAgendaGroup(name));
    }

    @Override
    public void activateRuleFlowGroup(String name) {
        InternalRuleFlowGroup group = (InternalRuleFlowGroup)this.getRuleFlowGroup(name);
        this.activateRuleFlowGroup(group, -1L, null);
    }

    @Override
    public void activateRuleFlowGroup(String name, long processInstanceId, String nodeInstanceId) {
        InternalRuleFlowGroup ruleFlowGroup = (InternalRuleFlowGroup)this.getRuleFlowGroup(name);
        this.activateRuleFlowGroup(ruleFlowGroup, processInstanceId, nodeInstanceId);
    }

    public void activateRuleFlowGroup(InternalRuleFlowGroup group, long processInstanceId, String nodeInstanceId) {
        ((EventSupport)((Object)this.workingMemory)).getAgendaEventSupport().fireBeforeRuleFlowGroupActivated(group, this.workingMemory);
        group.setActive(true);
        group.hasRuleFlowListener(true);
        if (!StringUtils.isEmpty(nodeInstanceId)) {
            group.addNodeInstance(processInstanceId, nodeInstanceId);
            group.setActive(true);
        }
        this.setFocus(group);
        ((EventSupport)((Object)this.workingMemory)).getAgendaEventSupport().fireAfterRuleFlowGroupActivated(group, this.workingMemory);
        this.workingMemory.notifyWaitOnRest();
    }

    @Override
    public void deactivateRuleFlowGroup(String name) {
        this.deactivateRuleFlowGroup((InternalRuleFlowGroup)this.getRuleFlowGroup(name));
    }

    public void deactivateRuleFlowGroup(InternalRuleFlowGroup group) {
        if (!group.isRuleFlowListener()) {
            return;
        }
        ((EventSupport)((Object)this.workingMemory)).getAgendaEventSupport().fireBeforeRuleFlowGroupDeactivated(group, this.workingMemory);
        while (this.removeGroup(group)) {
        }
        group.setActive(false);
        this.innerDeactiveRuleFlowGroup(group);
        ((EventSupport)((Object)this.workingMemory)).getAgendaEventSupport().fireAfterRuleFlowGroupDeactivated(group, this.workingMemory);
    }

    private void innerDeactiveRuleFlowGroup(InternalRuleFlowGroup group) {
        group.hasRuleFlowListener(false);
        group.getNodeInstances().clear();
    }

    @Override
    public int focusStackSize() {
        int size = 0;
        for (AgendaGroup group : this.focusStack) {
            size += group.size();
        }
        return size;
    }

    @Override
    public int agendaSize() {
        int size = 0;
        for (InternalAgendaGroup internalAgendaGroup : this.agendaGroups.values()) {
            size += internalAgendaGroup.size();
        }
        return size;
    }

    @Override
    public Activation[] getActivations() {
        ArrayList<Activation> list = new ArrayList<Activation>();
        for (InternalAgendaGroup group : this.agendaGroups.values()) {
            for (Activation activation : group.getActivations()) {
                list.add(activation);
            }
        }
        return list.toArray(new Activation[list.size()]);
    }

    @Override
    public Activation[] getScheduledActivations() {
        throw new UnsupportedOperationException("rete only");
    }

    public <M extends ModedAssertion<M>> LinkedList<ScheduledAgendaItem<M>> getScheduledActivationsLinkedList() {
        throw new UnsupportedOperationException("rete only");
    }

    public void clear() {
        this.clearFocusStack();
        this.focusStack.add(this.getMainAgendaGroup());
        for (InternalAgendaGroup internalAgendaGroup : this.agendaGroups.values()) {
            internalAgendaGroup.setClearedForRecency(this.workingMemory.getFactHandleFactory().getRecency());
            internalAgendaGroup.reset();
        }
        for (InternalActivationGroup internalActivationGroup : this.activationGroups.values()) {
            internalActivationGroup.setTriggeredForRecency(this.workingMemory.getFactHandleFactory().getRecency());
            internalActivationGroup.reset();
        }
    }

    public void reset() {
        this.clearFocusStack();
        this.focusStack.add(this.getMainAgendaGroup());
        for (InternalAgendaGroup internalAgendaGroup : this.agendaGroups.values()) {
            internalAgendaGroup.reset();
        }
        for (InternalActivationGroup internalActivationGroup : this.activationGroups.values()) {
            internalActivationGroup.setTriggeredForRecency(this.workingMemory.getFactHandleFactory().getRecency());
            internalActivationGroup.reset();
        }
        this.eager.clear();
        this.activationCounter = 0;
    }

    @Override
    public void clearAndCancel() {
        for (InternalAgendaGroup internalAgendaGroup : this.agendaGroups.values()) {
            this.clearAndCancelAgendaGroup(internalAgendaGroup);
        }
        this.clearAndCancelStagedActivations();
        for (InternalActivationGroup group : this.activationGroups.values()) {
            this.clearAndCancelActivationGroup(group);
        }
    }

    @Override
    public void clearAndCancelAgendaGroup(String name) {
        InternalAgendaGroup agendaGroup = this.agendaGroups.get(name);
        if (agendaGroup != null) {
            this.clearAndCancelAgendaGroup(agendaGroup);
        }
    }

    @Override
    public void clearAndCancelAgendaGroup(InternalAgendaGroup agendaGroup) {
        for (Activation activation : agendaGroup.getActivations()) {
            ((RuleAgendaItem)activation).getRuleExecutor().reEvaluateNetwork(this.workingMemory);
        }
        EventSupport eventsupport = (EventSupport)((Object)this.workingMemory);
        agendaGroup.setClearedForRecency(this.workingMemory.getFactHandleFactory().getRecency());
        ArrayList<RuleAgendaItem> lazyItems = new ArrayList<RuleAgendaItem>();
        for (Activation aQueueable : agendaGroup.getAndClear()) {
            AgendaItem item = (AgendaItem)aQueueable;
            if (item.isRuleAgendaItem()) {
                lazyItems.add((RuleAgendaItem)item);
                ((RuleAgendaItem)item).getRuleExecutor().cancel(this.workingMemory, eventsupport);
                continue;
            }
            item.setQueued(false);
            if (item.getActivationGroupNode() != null) {
                item.getActivationGroupNode().getActivationGroup().removeActivation(item);
            }
            eventsupport.getAgendaEventSupport().fireActivationCancelled(item, this.workingMemory, MatchCancelledCause.CLEAR);
        }
        for (RuleAgendaItem lazyItem : lazyItems) {
            agendaGroup.add(lazyItem);
        }
    }

    @Override
    public void clearAndCancelActivationGroup(String name) {
        InternalActivationGroup activationGroup = this.activationGroups.get(name);
        if (activationGroup != null) {
            this.clearAndCancelActivationGroup(activationGroup);
        }
    }

    @Override
    public void clearAndCancelActivationGroup(InternalActivationGroup activationGroup) {
        EventSupport eventsupport = (EventSupport)((Object)this.workingMemory);
        activationGroup.setTriggeredForRecency(this.workingMemory.getFactHandleFactory().getRecency());
        Iterator it = activationGroup.iterator();
        while (it.hasNext()) {
            ActivationGroupNode node = (ActivationGroupNode)it.next();
            Activation activation = node.getActivation();
            activation.setActivationGroupNode(null);
            if (!activation.isQueued()) continue;
            activation.setQueued(false);
            activation.remove();
            RuleExecutor ruleExec = ((RuleTerminalNodeLeftTuple)activation).getRuleAgendaItem().getRuleExecutor();
            ruleExec.removeLeftTuple((LeftTuple)((Object)activation));
            eventsupport.getAgendaEventSupport().fireActivationCancelled(activation, this.workingMemory, MatchCancelledCause.CLEAR);
        }
        activationGroup.reset();
    }

    @Override
    public void clearAndCancelRuleFlowGroup(String name) {
        this.clearAndCancelAgendaGroup(this.agendaGroups.get(name));
    }

    @Override
    public void clearAndCancelAndCancel(RuleFlowGroup ruleFlowGroup) {
        this.clearAndCancelAgendaGroup((InternalAgendaGroup)((Object)ruleFlowGroup));
    }

    @Override
    public int fireNextItem(AgendaFilter filter, int fireCount, int fireLimit) throws ConsequenceException {
        boolean tryagain;
        int localFireCount = 0;
        do {
            tryagain = false;
            this.evaluateEagerList();
            InternalAgendaGroup group = this.getNextFocus();
            if (group == null || (localFireCount = this.fireNextItem(filter, fireCount, fireLimit, group)) != 0) continue;
            tryagain = true;
            this.workingMemory.flushPropagations();
        } while (tryagain);
        return localFireCount;
    }

    private int fireNextItem(AgendaFilter filter, int fireCount, int fireLimit, InternalAgendaGroup group) throws ConsequenceException {
        RuleAgendaItem item;
        int localFireCount = 0;
        if (this.workingMemory.getKnowledgeBase().getConfiguration().isSequential()) {
            item = (RuleAgendaItem)group.remove();
            item.setBlocked(true);
        } else {
            item = (RuleAgendaItem)group.peek();
        }
        if (item != null) {
            this.evaluateQueriesForRule(item);
            localFireCount = item.getRuleExecutor().evaluateNetworkAndFire(this.workingMemory, filter, fireCount, fireLimit);
        }
        return localFireCount;
    }

    @Override
    public void evaluateEagerList() {
        while (!this.eager.isEmpty()) {
            RuleAgendaItem item = this.eager.removeFirst();
            if (!item.isRuleInUse()) continue;
            this.evaluateQueriesForRule(item);
            RuleExecutor ruleExecutor = item.getRuleExecutor();
            ruleExecutor.evaluateNetwork(this.workingMemory);
        }
    }

    private void evaluateQueriesForRule(RuleAgendaItem item) {
        RuleImpl rule = item.getRule();
        if (!rule.isQuery()) {
            for (QueryImpl query : rule.getDependingQueries()) {
                RuleAgendaItem queryAgendaItem = this.queries.remove(query);
                if (queryAgendaItem == null) continue;
                RuleExecutor ruleExecutor = queryAgendaItem.getRuleExecutor();
                ruleExecutor.evaluateNetwork(this.workingMemory);
            }
        }
    }

    @Override
    public int sizeOfRuleFlowGroup(String name) {
        InternalAgendaGroup group = this.agendaGroups.get(name);
        if (group == null) {
            return 0;
        }
        int count = 0;
        for (Activation item : group.getActivations()) {
            if (((RuleAgendaItem)item).getRuleExecutor().getLeftTupleList().isEmpty()) continue;
            count += ((RuleAgendaItem)item).getRuleExecutor().getLeftTupleList().size();
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fireActivation(Activation activation) throws ConsequenceException {
        this.workingMemory.startOperation();
        try {
            EventSupport eventsupport = (EventSupport)((Object)this.workingMemory);
            eventsupport.getAgendaEventSupport().fireBeforeActivationFired(activation, this.workingMemory);
            if (activation.getActivationGroupNode() != null) {
                InternalActivationGroup activationGroup = activation.getActivationGroupNode().getActivationGroup();
                activationGroup.removeActivation(activation);
                this.clearAndCancelActivationGroup(activationGroup);
            }
            activation.setQueued(false);
            try {
                this.knowledgeHelper.setActivation(activation);
                if (log.isTraceEnabled()) {
                    log.trace("Fire \"{}\" \n{}", (Object)activation.getRule().getName(), (Object)activation.getTuple());
                }
                activation.getConsequence().evaluate(this.knowledgeHelper, this.workingMemory);
                activation.setActive(false);
                this.knowledgeHelper.cancelRemainingPreviousLogicalDependencies();
                this.knowledgeHelper.reset();
            }
            catch (Exception e) {
                if (this.legacyConsequenceExceptionHandler != null) {
                    this.legacyConsequenceExceptionHandler.handleException(activation, this.workingMemory, e);
                }
                if (this.consequenceExceptionHandler != null) {
                    this.consequenceExceptionHandler.handleException((Match)activation, (RuleRuntime)this.workingMemory.getKnowledgeRuntime(), e);
                }
                throw new RuntimeException(e);
            }
            finally {
                if (activation.getActivationFactHandle() != null) {
                    InternalFactHandle factHandle = activation.getActivationFactHandle();
                    this.workingMemory.getEntryPointNode().modifyActivation(factHandle, activation.getPropagationContext(), this.workingMemory);
                    activation.getPropagationContext().evaluateActionQueue(this.workingMemory);
                }
                for (Tuple tuple = activation.getTuple(); tuple != null; tuple = tuple.getParent()) {
                    if (tuple.getFactHandle() == null || !tuple.getFactHandle().isEvent()) continue;
                    EventFactHandle handle = (EventFactHandle)tuple.getFactHandle();
                    handle.decreaseActivationsCount();
                    if (!handle.isExpired() || handle.getActivationsCount() > 0L) continue;
                    handle.getEntryPoint().delete((FactHandle)handle);
                }
            }
            eventsupport.getAgendaEventSupport().fireAfterActivationFired(activation, this.workingMemory);
            this.unstageActivations();
        }
        finally {
            this.workingMemory.endOperation();
        }
    }

    @Override
    public void fireConsequenceEvent(Activation activation, String consequenceName) {
        Consequence consequence = activation.getRule().getNamedConsequence(consequenceName);
        if (consequence != null) {
            this.fireActivationEvent(activation, consequence);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireActivationEvent(Activation activation, Consequence event) throws ConsequenceException {
        block12: {
            this.workingMemory.startOperation();
            try {
                try {
                    this.knowledgeHelper.setActivation(activation);
                    if (log.isTraceEnabled()) {
                        log.trace("Fire event {} for rule \"{}\" \n{}", new Object[]{event.getName(), activation.getRule().getName(), activation.getTuple()});
                    }
                    event.evaluate(this.knowledgeHelper, this.workingMemory);
                    this.knowledgeHelper.cancelRemainingPreviousLogicalDependencies();
                    this.knowledgeHelper.reset();
                }
                catch (Exception e) {
                    if (this.legacyConsequenceExceptionHandler != null) {
                        this.legacyConsequenceExceptionHandler.handleException(activation, this.workingMemory, e);
                        break block12;
                    }
                    if (this.consequenceExceptionHandler != null) {
                        this.consequenceExceptionHandler.handleException((Match)activation, (RuleRuntime)this.workingMemory.getKnowledgeRuntime(), e);
                        break block12;
                    }
                    throw new RuntimeException(e);
                }
                finally {
                    if (activation.getActivationFactHandle() != null) {
                        InternalFactHandle factHandle = activation.getActivationFactHandle();
                        this.workingMemory.getEntryPointNode().modifyActivation(factHandle, activation.getPropagationContext(), this.workingMemory);
                        activation.getPropagationContext().evaluateActionQueue(this.workingMemory);
                    }
                }
            }
            finally {
                this.workingMemory.endOperation();
            }
        }
    }

    @Override
    public boolean fireTimedActivation(Activation activation) throws ConsequenceException {
        throw new UnsupportedOperationException("rete only");
    }

    @Override
    public boolean isRuleInstanceAgendaItem(String ruleflowGroupName, String ruleName, long processInstanceId) {
        Activation[] matches;
        RuleFlowGroup systemRuleFlowGroup = this.getRuleFlowGroup(ruleflowGroupName);
        for (Activation match : matches = ((InternalAgendaGroup)((Object)systemRuleFlowGroup)).getActivations()) {
            Activation act = match;
            if (act.isRuleAgendaItem()) {
                RuleAgendaItem ruleAgendaItem = (RuleAgendaItem)act;
                ruleAgendaItem.getRuleExecutor().evaluateNetwork(this.workingMemory);
                this.workingMemory.flushPropagations();
                TupleList list = ruleAgendaItem.getRuleExecutor().getLeftTupleList();
                for (RuleTerminalNodeLeftTuple lt = (RuleTerminalNodeLeftTuple)list.getFirst(); lt != null; lt = (RuleTerminalNodeLeftTuple)lt.getNext()) {
                    if (!ruleName.equals(lt.getRule().getName()) || !this.checkProcessInstance(lt, processInstanceId)) continue;
                    return true;
                }
                continue;
            }
            if (!ruleName.equals(act.getRule().getName()) || !this.checkProcessInstance(act, processInstanceId)) continue;
            return true;
        }
        return false;
    }

    private boolean checkProcessInstance(Activation activation, long processInstanceId) {
        Map<String, Declaration> declarations = activation.getSubRule().getOuterDeclarations();
        for (Declaration declaration : declarations.values()) {
            Object value;
            if (!"processInstance".equals(declaration.getIdentifier()) || !((value = declaration.getValue(this.workingMemory, activation.getTuple().get(declaration).getObject())) instanceof ProcessInstance)) continue;
            return ((ProcessInstance)value).getId() == processInstanceId;
        }
        return true;
    }

    @Override
    public String getFocusName() {
        return this.getFocus().getName();
    }

    @Override
    public void stageLeftTuple(RuleAgendaItem ruleAgendaItem, AgendaItem justified) {
        if (!ruleAgendaItem.isQueued()) {
            ruleAgendaItem.getRuleExecutor().getPathMemory().queueRuleAgendaItem(this.workingMemory);
        }
        ruleAgendaItem.getRuleExecutor().addLeftTuple(justified.getTuple());
    }

    @Override
    public void fireUntilHalt() {
        this.fireUntilHalt(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fireUntilHalt(AgendaFilter agendaFilter) {
        Object object = this.stateMachineLock;
        synchronized (object) {
            if (this.currentState == ExecutionState.FIRING_UNTIL_HALT) {
                return;
            }
            this.waitAndEnterExecutionState(ExecutionState.FIRING_UNTIL_HALT);
        }
        if (log.isTraceEnabled()) {
            log.trace("Starting Fire Until Halt");
        }
        this.fireLoop(agendaFilter, -1, RestHandler.FIRE_UNTIL_HALT);
        if (log.isTraceEnabled()) {
            log.trace("Ending Fire Until Halt");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int fireAllRules(AgendaFilter agendaFilter, int fireLimit) {
        Object object = this.stateMachineLock;
        synchronized (object) {
            if (this.currentState.isFiring()) {
                return 0;
            }
            this.waitAndEnterExecutionState(ExecutionState.FIRING_ALL_RULES);
        }
        if (log.isTraceEnabled()) {
            log.trace("Starting Fire All Rules");
        }
        int fireCount = this.fireLoop(agendaFilter, fireLimit, RestHandler.FIRE_ALL_RULES);
        if (log.isTraceEnabled()) {
            log.trace("Ending Fire All Rules");
        }
        return fireCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int fireLoop(AgendaFilter agendaFilter, int fireLimit, RestHandler restHandler) {
        int fireCount = 0;
        try {
            boolean limitReached;
            PropagationEntry head = this.workingMemory.takeAllPropagations();
            int returnedFireCount = 0;
            boolean bl = limitReached = fireLimit == 0;
            while (this.isFiring()) {
                log.debug("Fire Loop");
                if (head != null) {
                    this.workingMemory.flushPropagations(head);
                    head = null;
                }
                if (!this.isFiring()) break;
                this.evaluateEagerList();
                InternalAgendaGroup group = this.getNextFocus();
                if (group != null && !limitReached) {
                    returnedFireCount = this.fireNextItem(agendaFilter, fireCount, fireLimit, group);
                    limitReached = fireLimit > 0 && (fireCount += returnedFireCount) >= fireLimit;
                    head = this.workingMemory.takeAllPropagations();
                } else {
                    returnedFireCount = 0;
                    group = null;
                }
                if (returnedFireCount != 0 || head != null || group != null && group.isAutoDeactivate()) continue;
                head = restHandler.handleRest(this.workingMemory, this);
            }
            if (this.focusStack.size() == 1 && this.getMainAgendaGroup().isEmpty()) {
                this.getMainAgendaGroup().setActive(false);
            }
        }
        finally {
            this.immediateHalt();
        }
        return fireCount;
    }

    private void waitAndEnterExecutionState(ExecutionState newState) {
        while (this.currentState != ExecutionState.INACTIVE) {
            try {
                this.stateMachineLock.wait();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
        this.setCurrentState(newState);
    }

    @Override
    public boolean isFiring() {
        return this.currentState.isFiring();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void executeTask(ExecutableEntry executable) {
        Object object = this.stateMachineLock;
        synchronized (object) {
            if (this.isFiring()) {
                executable.enqueue();
                return;
            }
            if (this.currentState != ExecutionState.EXECUTING_TASK) {
                this.waitAndEnterExecutionState(ExecutionState.EXECUTING_TASK);
            }
        }
        try {
            executable.execute();
        }
        finally {
            this.immediateHalt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void halt() {
        Object object = this.stateMachineLock;
        synchronized (object) {
            if (this.currentState.isFiring()) {
                this.setCurrentState(ExecutionState.HALTING);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void immediateHalt() {
        Object object = this.stateMachineLock;
        synchronized (object) {
            if (this.currentState != ExecutionState.INACTIVE) {
                this.setCurrentState(ExecutionState.INACTIVE);
                this.stateMachineLock.notify();
                this.workingMemory.notifyEngineInactive();
            }
        }
    }

    public void setCurrentState(ExecutionState state) {
        if (log.isDebugEnabled()) {
            log.debug("State was {} is nw {}", (Object)this.currentState, (Object)state);
        }
        this.currentState = state;
    }

    public ConsequenceExceptionHandler getConsequenceExceptionHandler() {
        return this.legacyConsequenceExceptionHandler;
    }

    @Override
    public void setActivationsFilter(ActivationsFilter filter) {
        this.activationsFilter = filter;
    }

    @Override
    public ActivationsFilter getActivationsFilter() {
        return this.activationsFilter;
    }

    public KnowledgeHelper getKnowledgeHelper() {
        return this.knowledgeHelper;
    }

    static interface RestHandler {
        public static final RestHandler FIRE_ALL_RULES = new FireAllRulesRestHandler();
        public static final RestHandler FIRE_UNTIL_HALT = new FireUntilHaltRestHandler();

        public PropagationEntry handleRest(InternalWorkingMemory var1, DefaultAgenda var2);

        public static class FireUntilHaltRestHandler
        implements RestHandler {
            @Override
            public PropagationEntry handleRest(InternalWorkingMemory wm, DefaultAgenda agenda) {
                return wm.handleRestOnFireUntilHalt(agenda.currentState);
            }
        }

        public static class FireAllRulesRestHandler
        implements RestHandler {
            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public PropagationEntry handleRest(InternalWorkingMemory wm, DefaultAgenda agenda) {
                Object object = agenda.stateMachineLock;
                synchronized (object) {
                    PropagationEntry head = wm.takeAllPropagations();
                    if (head == null) {
                        agenda.halt();
                    }
                    return head;
                }
            }
        }
    }

    public static enum ExecutionState {
        INACTIVE(false),
        FIRING_ALL_RULES(true),
        FIRING_UNTIL_HALT(true),
        HALTING(false),
        EXECUTING_TASK(false);

        private final boolean firing;

        private ExecutionState(boolean firing) {
            this.firing = firing;
        }

        public boolean isFiring() {
            return this.firing;
        }
    }
}

