/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.reteoo;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.BitSet;
import java.util.Collection;
import org.drools.core.base.ClassObjectType;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.factmodel.traits.Thing;
import org.drools.core.factmodel.traits.TraitProxy;
import org.drools.core.factmodel.traits.TraitType;
import org.drools.core.factmodel.traits.TraitTypeMap;
import org.drools.core.reteoo.EntryPointNode;
import org.drools.core.reteoo.ModifyPreviousTuples;
import org.drools.core.reteoo.ObjectTypeNode;
import org.drools.core.reteoo.builder.BuildContext;
import org.drools.core.spi.ObjectType;
import org.drools.core.spi.PropagationContext;
import org.drools.core.util.HierarchyEncoderImpl;
import org.drools.core.util.bitmask.AllSetBitMask;
import org.drools.core.util.bitmask.BitMask;

public class TraitObjectTypeNode
extends ObjectTypeNode {
    private BitSet typeMask;

    public TraitObjectTypeNode(int id, EntryPointNode source, ObjectType objectType, BuildContext context) {
        super(id, source, objectType, context);
        this.typeMask = context.getKnowledgeBase().getConfiguration().getComponentFactory().getTraitRegistry().getHierarchy().getCode(((ClassObjectType)objectType).getClassName());
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.typeMask = (BitSet)in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeObject(this.typeMask);
    }

    @Override
    public void propagateAssert(InternalFactHandle factHandle, PropagationContext context, InternalWorkingMemory workingMemory) {
        if (this.isAssertAllowed(factHandle)) {
            super.propagateAssert(factHandle, context, workingMemory);
        }
    }

    private boolean isAssertAllowed(InternalFactHandle factHandle) {
        if (factHandle.isTraiting()) {
            boolean allowed;
            TraitProxy proxy = (TraitProxy)factHandle.getObject();
            BitSet vetoMask = proxy.computeInsertionVetoMask();
            boolean vetoed = vetoMask != null && !this.typeMask.isEmpty() && HierarchyEncoderImpl.supersetOrEqualset(vetoMask, this.typeMask);
            boolean bl = allowed = !vetoed || this.sameAndNotCoveredByDescendants((TraitProxy)factHandle.getObject(), this.typeMask);
            if (allowed) {
                proxy.assignOtn(this.typeMask);
            }
            return allowed;
        }
        return true;
    }

    private boolean sameAndNotCoveredByDescendants(TraitProxy proxy, BitSet typeMask) {
        boolean isSameType = typeMask.equals(proxy.getTypeCode());
        if (isSameType) {
            TraitTypeMap ttm = (TraitTypeMap)proxy.getObject()._getTraitMap();
            Collection descs = ttm.lowerDescendants(typeMask);
            if (descs == null || descs.isEmpty()) {
                return true;
            }
            for (Thing sub : descs) {
                TraitType tt = (TraitType)((Object)sub);
                if (tt == proxy || !tt.hasTypeCode(typeMask)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private boolean isModifyAllowed(InternalFactHandle factHandle) {
        if (factHandle.isTraiting()) {
            TraitProxy proxy = (TraitProxy)factHandle.getObject();
            return proxy.listAssignedOtnTypeCodes().contains(this.typeMask);
        }
        return true;
    }

    @Override
    public void modifyObject(InternalFactHandle factHandle, ModifyPreviousTuples modifyPreviousTuples, PropagationContext context, InternalWorkingMemory workingMemory) {
        if (!this.isModifyAllowed(factHandle)) {
            return;
        }
        if (this.dirty) {
            this.resetIdGenerator();
            TraitObjectTypeNode.updateTupleSinkId(this, this);
            this.dirty = false;
        }
        context.setObjectType(this.objectType);
        if (this.compiledNetwork != null) {
            this.compiledNetwork.modifyObject(factHandle, modifyPreviousTuples, context.adaptModificationMaskForObjectType(this.objectType, workingMemory), workingMemory);
        } else if (factHandle.isTraiting()) {
            if (this.isModifyAllowed(factHandle)) {
                if (context.getModificationMask().isSet(0) && modifyPreviousTuples.peekLeftTuple() != null && modifyPreviousTuples.peekLeftTuple().getPropagationContext().getType() == 0) {
                    BitMask originalMask = context.getModificationMask();
                    context.setModificationMask(AllSetBitMask.get());
                    this.sink.propagateModifyObject(factHandle, modifyPreviousTuples, context.adaptModificationMaskForObjectType(this.objectType, workingMemory), workingMemory);
                    context.setModificationMask(originalMask);
                } else {
                    this.sink.propagateModifyObject(factHandle, modifyPreviousTuples, context.adaptModificationMaskForObjectType(this.objectType, workingMemory), workingMemory);
                }
            }
        } else {
            this.sink.propagateModifyObject(factHandle, modifyPreviousTuples, !context.getModificationMask().isSet(0) ? context.adaptModificationMaskForObjectType(this.objectType, workingMemory) : context, workingMemory);
        }
    }

    @Override
    public BitMask updateMask(BitMask mask) {
        BitMask returnMask = this.declaredMask.clone().setAll(mask);
        this.inferredMask = this.inferredMask.setAll(returnMask);
        return returnMask;
    }

    public BitSet getLocalTypeCode() {
        return this.typeMask;
    }
}

