/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.reteoo;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.List;
import java.util.Map;
import org.drools.core.RuleBaseConfiguration;
import org.drools.core.base.evaluators.IsAEvaluatorDefinition;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.common.Memory;
import org.drools.core.common.MemoryFactory;
import org.drools.core.common.RuleBasePartitionId;
import org.drools.core.reteoo.ModifyPreviousTuples;
import org.drools.core.reteoo.ObjectSink;
import org.drools.core.reteoo.ObjectSinkNode;
import org.drools.core.reteoo.ObjectSource;
import org.drools.core.reteoo.PropertySpecificUtil;
import org.drools.core.reteoo.SegmentMemory;
import org.drools.core.reteoo.builder.BuildContext;
import org.drools.core.rule.ContextEntry;
import org.drools.core.rule.constraint.EvaluatorConstraint;
import org.drools.core.rule.constraint.MvelConstraint;
import org.drools.core.spi.AlphaNodeFieldConstraint;
import org.drools.core.spi.PropagationContext;
import org.drools.core.spi.RuleComponent;
import org.drools.core.util.bitmask.AllSetBitMask;
import org.drools.core.util.bitmask.BitMask;
import org.kie.api.definition.rule.Rule;
import org.kie.api.runtime.rule.Operator;

public class AlphaNode
extends ObjectSource
implements ObjectSinkNode,
MemoryFactory {
    private static final long serialVersionUID = 510L;
    private AlphaNodeFieldConstraint constraint;
    private ObjectSinkNode previousRightTupleSinkNode;
    private ObjectSinkNode nextRightTupleSinkNode;
    private int hashcode;

    public AlphaNode() {
    }

    public AlphaNode(int id, AlphaNodeFieldConstraint constraint, ObjectSource objectSource, BuildContext context) {
        super(id, context.getPartitionId(), context.getKnowledgeBase().getConfiguration().isMultithreadEvaluation(), objectSource, context.getKnowledgeBase().getConfiguration().getAlphaNodeHashingThreshold());
        this.constraint = constraint.cloneIfInUse();
        if (this.constraint instanceof MvelConstraint) {
            ((MvelConstraint)this.constraint).registerEvaluationContext(context);
        }
        this.initDeclaredMask(context);
        this.hashcode = this.calculateHashCode();
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.constraint = (AlphaNodeFieldConstraint)in.readObject();
        this.declaredMask = (BitMask)in.readObject();
        this.inferredMask = (BitMask)in.readObject();
        this.hashcode = in.readInt();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeObject(this.constraint);
        out.writeObject(this.declaredMask);
        out.writeObject(this.inferredMask);
        out.writeInt(this.hashcode);
    }

    public AlphaNodeFieldConstraint getConstraint() {
        return this.constraint;
    }

    @Override
    public short getType() {
        return 40;
    }

    @Override
    public void attach(BuildContext context) {
        this.source.addObjectSink(this);
    }

    @Override
    public void assertObject(InternalFactHandle factHandle, PropagationContext context, InternalWorkingMemory workingMemory) {
        AlphaMemory memory = (AlphaMemory)workingMemory.getNodeMemory(this);
        if (this.constraint.isAllowed(factHandle, workingMemory, memory.context)) {
            this.sink.propagateAssertObject(factHandle, context, workingMemory);
        }
    }

    @Override
    public void modifyObject(InternalFactHandle factHandle, ModifyPreviousTuples modifyPreviousTuples, PropagationContext context, InternalWorkingMemory workingMemory) {
        if (context.getModificationMask().intersects(this.inferredMask)) {
            AlphaMemory memory = (AlphaMemory)workingMemory.getNodeMemory(this);
            if (this.constraint.isAllowed(factHandle, workingMemory, memory.context)) {
                this.sink.propagateModifyObject(factHandle, modifyPreviousTuples, context, workingMemory);
            }
        } else {
            this.byPassModifyToBetaNode(factHandle, modifyPreviousTuples, context, workingMemory);
        }
    }

    @Override
    public void byPassModifyToBetaNode(InternalFactHandle factHandle, ModifyPreviousTuples modifyPreviousTuples, PropagationContext context, InternalWorkingMemory workingMemory) {
        this.sink.byPassModifyToBetaNode(factHandle, modifyPreviousTuples, context, workingMemory);
    }

    @Override
    public void updateSink(ObjectSink sink, PropagationContext context, InternalWorkingMemory workingMemory) {
        AlphaMemory memory = (AlphaMemory)workingMemory.getNodeMemory(this);
        ObjectSinkUpdateAdapter adapter = new ObjectSinkUpdateAdapter(sink, this.constraint, memory.context);
        this.source.updateSink(adapter, context, workingMemory);
    }

    @Override
    public Memory createMemory(RuleBaseConfiguration config, InternalWorkingMemory wm) {
        AlphaMemory memory = new AlphaMemory();
        memory.context = this.constraint.createContextEntry();
        return memory;
    }

    @Override
    public String toString() {
        return "[AlphaNode(" + this.id + ") constraint=" + this.constraint + "]";
    }

    @Override
    public int hashCode() {
        return this.hashcode;
    }

    public int calculateHashCode() {
        return (this.source != null ? this.source.hashCode() : 0) * 37 + (this.constraint != null ? this.constraint.hashCode() : 0) * 31;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof AlphaNode) || this.hashCode() != object.hashCode()) {
            return false;
        }
        AlphaNode other = (AlphaNode)object;
        return this.source.equals(other.source) && this.constraint.equals(other.constraint);
    }

    @Override
    public ObjectSinkNode getNextObjectSinkNode() {
        return this.nextRightTupleSinkNode;
    }

    @Override
    public void setNextObjectSinkNode(ObjectSinkNode next) {
        this.nextRightTupleSinkNode = next;
    }

    @Override
    public ObjectSinkNode getPreviousObjectSinkNode() {
        return this.previousRightTupleSinkNode;
    }

    @Override
    public void setPreviousObjectSinkNode(ObjectSinkNode previous) {
        this.previousRightTupleSinkNode = previous;
    }

    @Override
    public BitMask calculateDeclaredMask(List<String> settableProperties) {
        Operator op;
        boolean typeBit = false;
        if (this.constraint instanceof EvaluatorConstraint && ((EvaluatorConstraint)this.constraint).isSelf() && ((op = ((EvaluatorConstraint)this.constraint).getEvaluator().getOperator()) == IsAEvaluatorDefinition.ISA || op == IsAEvaluatorDefinition.NOT_ISA)) {
            typeBit = true;
        }
        if (settableProperties == null || !(this.constraint instanceof MvelConstraint)) {
            return typeBit ? AllSetBitMask.get() : PropertySpecificUtil.allSetButTraitBitMask();
        }
        BitMask mask = ((MvelConstraint)this.constraint).getListenedPropertyMask(settableProperties);
        return typeBit ? mask.set(0) : mask;
    }

    @Override
    public BitMask getDeclaredMask() {
        return this.declaredMask;
    }

    public BitMask getInferredMask() {
        return this.inferredMask;
    }

    @Override
    public void addObjectSink(ObjectSink objectSink) {
        super.addObjectSink(objectSink);
    }

    private static class ObjectSinkUpdateAdapter
    implements ObjectSink {
        private final ObjectSink sink;
        private final AlphaNodeFieldConstraint constraint;
        private final ContextEntry contextEntry;

        public ObjectSinkUpdateAdapter(ObjectSink sink, AlphaNodeFieldConstraint constraint, ContextEntry contextEntry) {
            this.sink = sink;
            this.constraint = constraint;
            this.contextEntry = contextEntry;
        }

        @Override
        public void assertObject(InternalFactHandle handle, PropagationContext propagationContext, InternalWorkingMemory workingMemory) {
            if (this.constraint.isAllowed(handle, workingMemory, this.contextEntry)) {
                this.sink.assertObject(handle, propagationContext, workingMemory);
            }
        }

        @Override
        public int getId() {
            return 0;
        }

        @Override
        public RuleBasePartitionId getPartitionId() {
            return this.sink.getPartitionId();
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        }

        @Override
        public void modifyObject(InternalFactHandle factHandle, ModifyPreviousTuples modifyPreviousTuples, PropagationContext context, InternalWorkingMemory workingMemory) {
            throw new UnsupportedOperationException("This method should NEVER EVER be called");
        }

        @Override
        public void byPassModifyToBetaNode(InternalFactHandle factHandle, ModifyPreviousTuples modifyPreviousTuples, PropagationContext context, InternalWorkingMemory workingMemory) {
        }

        @Override
        public short getType() {
            return 40;
        }

        @Override
        public Map<Rule, RuleComponent> getAssociations() {
            return this.sink.getAssociations();
        }
    }

    public static class AlphaMemory
    implements Memory {
        private static final long serialVersionUID = 510L;
        public ContextEntry context;

        @Override
        public short getNodeType() {
            return 40;
        }

        @Override
        public SegmentMemory getSegmentMemory() {
            return null;
        }

        @Override
        public void setSegmentMemory(SegmentMemory segmentMemory) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Memory getPrevious() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setPrevious(Memory previous) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setNext(Memory next) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Memory getNext() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void nullPrevNext() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void reset() {
        }
    }
}

